/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.RelativeLayout;
import com.baidu.navisdk.ui.widget.IVisibility;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.HashMap;
import java.util.Map;

public class BNRelativeLayout
extends RelativeLayout
implements IVisibility {
    private static final String TAG = "BNRelativeLayout";
    private static final String DEFAULT_VISIBLE = "default_visible";
    private static final String ANIM_VISIBLE = "anim_visible";
    private Map<String, Boolean> mVisibleMap;

    public BNRelativeLayout(Context context) {
        super(context);
    }

    public BNRelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public BNRelativeLayout(Context context, AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
    }

    private Map<String, Boolean> getVisibleMap() {
        if (this.mVisibleMap == null) {
            HashMap<String, Boolean> hashMap;
            HashMap<String, Boolean> hashMap2 = hashMap;
            hashMap = new HashMap<String, Boolean>();
            this.mVisibleMap = hashMap2;
        }
        return this.mVisibleMap;
    }

    private boolean isVisibilityValid(int n5) {
        return n5 == 0 || n5 == 4 || n5 == 8;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onTouchEvent() --> event = " + motionEvent + ", BNRelativeLayout = " + this);
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "dispatchTouchEvent --> event = " + motionEvent + ", BNRelativeLayout = " + this);
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onInterceptTouchEvent --> event = " + motionEvent + ", BNRelativeLayout = " + this);
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    @Override
    public void setVisibleByAnim(boolean bl) {
        this.setVisible(ANIM_VISIBLE, bl);
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(DEFAULT_VISIBLE, bl);
    }

    @Override
    public void setVisible(String object, boolean bl) {
        BNRelativeLayout bNRelativeLayout = this;
        bNRelativeLayout.getVisibleMap().put((String)object, bl);
        if (!bNRelativeLayout.getVisibleMap().containsKey(DEFAULT_VISIBLE)) {
            BNRelativeLayout bNRelativeLayout2 = this;
            object = bNRelativeLayout2.getVisibleMap();
            String string2 = DEFAULT_VISIBLE;
            Boolean bl2 = bNRelativeLayout2.getVisibility() == 0;
            object.put(string2, bl2);
        }
        int n5 = 1;
        for (Boolean bl3 : this.getVisibleMap().values()) {
            if (n5 != 0 && bl3.booleanValue()) {
                n5 = 1;
                continue;
            }
            n5 = 0;
        }
        n5 = n5 != 0 ? 0 : 8;
        super.setVisibility(n5);
    }

    public void setVisibility(int n5) {
        Object object;
        CharSequence charSequence;
        Object object2;
        if (!this.isVisibilityValid(n5)) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "setVisibility --> visibility is illegal!!! visibility = " + n5);
                LogUtil.printException("BNRelativeLayout setVisibility visibility: " + n5 + ", invalid visibility!!!", new IllegalArgumentException());
            }
            return;
        }
        if (LogUtil.LOGGABLE) {
            object2 = TAG;
            charSequence = new StringBuilder().append("setVisibility --> tag = ");
            object = this.getTag() == null ? "null" : this.getTag().toString();
            LogUtil.e((String)object2, ((StringBuilder)charSequence).append((String)object).append(", visibility = ").append(n5).toString());
        }
        object2 = this.getVisibleMap();
        charSequence = DEFAULT_VISIBLE;
        object = n5 == 0;
        object2.put(charSequence, object);
        super.setVisibility(n5);
    }
}

