/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.util.common.i;

public class BNStrokeTextView
extends TextView {
    private static final String TAG = "BNStrokeTextView";
    private int strokeColor;
    private float strokeWidth;
    private TextPaint paint;
    private boolean isSupportStroke;
    private ColorStateList textColor;
    private boolean isDrawing;

    public BNStrokeTextView(Context context) {
        this(context, null);
    }

    public BNStrokeTextView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BNStrokeTextView(Context context, @Nullable AttributeSet attributeSet, int n5) {
        BNStrokeTextView bNStrokeTextView = this;
        super(context, attributeSet, n5);
        bNStrokeTextView.isSupportStroke = false;
        bNStrokeTextView.isDrawing = false;
        bNStrokeTextView.init(context, attributeSet);
    }

    public BNStrokeTextView(Context context, @Nullable AttributeSet attributeSet, int n5, int n6) {
        BNStrokeTextView bNStrokeTextView = this;
        super(context, attributeSet, n5, n6);
        bNStrokeTextView.isSupportStroke = false;
        bNStrokeTextView.isDrawing = false;
        bNStrokeTextView.init(context, attributeSet);
    }

    private void init(Context context, @Nullable AttributeSet attributeSet) {
        this.isSupportStroke = false;
        if (context != null && attributeSet != null) {
            if ((context = context.obtainStyledAttributes(attributeSet, R.styleable.BNStrokeTextView)).hasValue(R.styleable.BNStrokeTextView_bn_stroke_color)) {
                int n5 = R.styleable.BNStrokeTextView_bn_stroke_color;
                this.strokeColor = context.getColor(n5, this.getCurrentTextColor());
                this.paint = this.getPaint();
                this.isSupportStroke = true;
            }
            if (context.hasValue(R.styleable.BNStrokeTextView_bn_stroke_width)) {
                this.strokeWidth = context.getDimension(R.styleable.BNStrokeTextView_bn_stroke_width, 0.5f);
            }
            context.recycle();
        }
    }

    public void setStrokeColor(@ColorInt int n5) {
        this.strokeColor = n5;
    }

    public void invalidate() {
        if (this.isDrawing) {
            return;
        }
        super.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isSupportStroke && this.paint != null) {
            if (i.L.d()) {
                i.L.e(TAG, "onDraw: ");
            }
            BNStrokeTextView bNStrokeTextView = this;
            BNStrokeTextView bNStrokeTextView2 = this;
            bNStrokeTextView2.isDrawing = true;
            bNStrokeTextView2.textColor = bNStrokeTextView2.getTextColors();
            bNStrokeTextView2.paint.setStyle(Paint.Style.STROKE);
            bNStrokeTextView2.paint.setStrokeJoin(Paint.Join.ROUND);
            bNStrokeTextView2.setTextColor(bNStrokeTextView2.strokeColor);
            bNStrokeTextView2.paint.setStrokeWidth(this.strokeWidth);
            super.onDraw(canvas);
            bNStrokeTextView.paint.setStyle(Paint.Style.FILL);
            bNStrokeTextView.setTextColor(bNStrokeTextView.textColor);
            super.onDraw(canvas);
            this.isDrawing = false;
        } else {
            super.onDraw(canvas);
        }
    }
}

