/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.baidu.navisdk.embed.R;
import java.lang.reflect.Field;

public class CircleProgressBar
extends ProgressBar {
    private static final int LINE = 0;
    private static final int SOLID = 1;
    private static final int SOLID_LINE = 2;
    private static final int LINEAR = 0;
    private static final int RADIAL = 1;
    private static final int SWEEP = 2;
    private static final float DEFAULT_START_DEGREE = -90.0f;
    private static final int DEFAULT_LINE_COUNT = 45;
    private static final float DEFAULT_LINE_WIDTH = 4.0f;
    private static final float DEFAULT_PROGRESS_TEXT_SIZE = 11.0f;
    private static final float DEFAULT_PROGRESS_STROKE_WIDTH = 1.0f;
    private static final String COLOR_FFF2A670 = "#fff2a670";
    private static final String COLOR_FFD3D3D5 = "#ffe3e3e5";
    private static final String DEFAULT_PATTERN = "%d%%";
    private final RectF mProgressRectF;
    private final Rect mProgressTextRect;
    private final Paint mProgressPaint;
    private final Paint mBackgroundPaint;
    private final Paint mProgressTextPaint;
    private float mRadius;
    private float mCenterX;
    private float mCenterY;
    private int mLineCount;
    private float mLineWidth;
    private float mProgressStrokeWidth;
    private float mProgressTextSize;
    private int mProgressStartColor;
    private int mProgressEndColor;
    private int mProgressTextColor;
    private int mProgressBackgroundColor;
    private boolean mDrawProgressText;
    private String mProgressTextFormatPattern;
    private int mStyle;
    private int mShader;
    private Paint.Cap mCap;

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, AttributeSet attributeSet) {
        Paint paint;
        Paint paint2;
        Paint paint3;
        Rect rect;
        RectF rectF;
        CircleProgressBar circleProgressBar = circleProgressBar2;
        super(context, attributeSet);
        CircleProgressBar circleProgressBar2 = rectF;
        rectF = new RectF();
        circleProgressBar.mProgressRectF = circleProgressBar2;
        circleProgressBar2 = rect;
        rect = new Rect();
        circleProgressBar.mProgressTextRect = circleProgressBar2;
        circleProgressBar2 = paint3;
        paint3 = new Paint(1);
        circleProgressBar.mProgressPaint = circleProgressBar2;
        circleProgressBar2 = paint2;
        paint2 = new Paint(1);
        circleProgressBar.mBackgroundPaint = circleProgressBar2;
        circleProgressBar2 = paint;
        paint = new Paint(1);
        circleProgressBar.mProgressTextPaint = circleProgressBar2;
        circleProgressBar.adjustIndeterminate();
        circleProgressBar.initFromAttributes(context, attributeSet);
        circleProgressBar.initPaint();
    }

    private int dip2px(Context context, float f6) {
        return (int)(f6 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    private void initFromAttributes(Context context, AttributeSet object) {
        context = context.obtainStyledAttributes(object, R.styleable.BNCircleProgressBar);
        this.mDrawProgressText = context.getBoolean(R.styleable.BNCircleProgressBar_nsdk_bn_draw_progress_text, true);
        this.mLineCount = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_line_count, 45);
        object = context.hasValue(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_format_pattern) ? context.getString(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_format_pattern) : DEFAULT_PATTERN;
        this.mProgressTextFormatPattern = object;
        this.mStyle = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_style, 0);
        this.mShader = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_progress_shader, 0);
        object = context.hasValue(R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_cap) ? Paint.Cap.values()[context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_cap, 0)] : Paint.Cap.BUTT;
        CircleProgressBar circleProgressBar = this;
        CircleProgressBar circleProgressBar2 = this;
        CircleProgressBar circleProgressBar3 = this;
        circleProgressBar3.mCap = object;
        int n5 = R.styleable.BNCircleProgressBar_nsdk_bn_line_width;
        circleProgressBar2.mLineWidth = context.getDimensionPixelSize(n5, circleProgressBar3.dip2px(circleProgressBar3.getContext(), 4.0f));
        n5 = R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_size;
        circleProgressBar.mProgressTextSize = context.getDimensionPixelSize(n5, circleProgressBar2.dip2px(circleProgressBar2.getContext(), 11.0f));
        n5 = R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_width;
        this.mProgressStrokeWidth = context.getDimensionPixelSize(n5, circleProgressBar.dip2px(circleProgressBar.getContext(), 1.0f));
        this.mProgressStartColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_start_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressEndColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_end_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressTextColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressBackgroundColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_background_color, Color.parseColor((String)COLOR_FFD3D3D5));
        context.recycle();
    }

    private void initPaint() {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressTextPaint.setTextAlign(Paint.Align.CENTER);
        circleProgressBar.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        Paint paint = circleProgressBar.mProgressPaint;
        Paint.Style style2 = circleProgressBar.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar2 = this;
        paint.setStyle(style2);
        circleProgressBar2.mProgressPaint.setStrokeWidth(this.mProgressStrokeWidth);
        circleProgressBar2.mProgressPaint.setColor(this.mProgressStartColor);
        circleProgressBar2.mProgressPaint.setStrokeCap(this.mCap);
        paint = circleProgressBar2.mBackgroundPaint;
        style2 = circleProgressBar2.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar3 = this;
        paint.setStyle(style2);
        circleProgressBar3.mBackgroundPaint.setStrokeWidth(this.mProgressStrokeWidth);
        circleProgressBar3.mBackgroundPaint.setColor(this.mProgressBackgroundColor);
        circleProgressBar3.mBackgroundPaint.setStrokeCap(this.mCap);
    }

    private void updateProgressShader() {
        if (this.mProgressStartColor != this.mProgressEndColor) {
            LinearGradient linearGradient;
            Object var1_1 = null;
            int n5 = this.mShader;
            if (n5 != 0) {
                if (n5 != 1) {
                    if (n5 != 2) {
                        linearGradient = var1_1;
                    } else {
                        Matrix matrix;
                        SweepGradient sweepGradient;
                        CircleProgressBar circleProgressBar = this;
                        float f6 = (float)((double)circleProgressBar.mProgressStrokeWidth / Math.PI * 2.0 / (double)this.mRadius);
                        double d6 = -90.0;
                        double d7 = circleProgressBar.mCap == Paint.Cap.BUTT && this.mStyle == 2 ? 0.0 : Math.toDegrees(f6);
                        f6 = (float)(d6 - d7);
                        linearGradient = sweepGradient;
                        CircleProgressBar circleProgressBar2 = this;
                        float f7 = circleProgressBar2.mCenterX;
                        float f8 = circleProgressBar2.mCenterY;
                        int[] nArray = new int[2];
                        Object object = nArray;
                        object[0] = this.mProgressStartColor;
                        nArray[1] = this.mProgressEndColor;
                        float[] fArray = new float[2];
                        float[] fArray2 = fArray;
                        fArray[0] = 0.0f;
                        fArray[1] = 1.0f;
                        sweepGradient = new SweepGradient(f7, f8, object, fArray2);
                        object = matrix;
                        float f9 = f6;
                        CircleProgressBar circleProgressBar3 = this;
                        object();
                        f6 = circleProgressBar3.mCenterX;
                        matrix.postRotate(f9, f6, circleProgressBar3.mCenterY);
                        sweepGradient.setLocalMatrix(matrix);
                    }
                } else {
                    RadialGradient radialGradient;
                    linearGradient = radialGradient;
                    CircleProgressBar circleProgressBar = this;
                    float f10 = circleProgressBar.mCenterX;
                    float f11 = circleProgressBar.mCenterY;
                    float f12 = circleProgressBar.mRadius;
                    int n6 = circleProgressBar.mProgressStartColor;
                    int n7 = circleProgressBar.mProgressEndColor;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    radialGradient = new RadialGradient(f10, f11, f12, n6, n7, tileMode);
                }
            } else {
                LinearGradient linearGradient2;
                linearGradient = linearGradient2;
                CircleProgressBar circleProgressBar = this;
                RectF rectF = circleProgressBar.mProgressRectF;
                float f13 = rectF.left;
                float f14 = rectF.top;
                float f15 = rectF.bottom;
                int n8 = circleProgressBar.mProgressStartColor;
                int n9 = circleProgressBar.mProgressEndColor;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                linearGradient2 = new LinearGradient(f13, f14, f13, f15, n8, n9, tileMode);
            }
            this.mProgressPaint.setShader((Shader)linearGradient);
        } else {
            CircleProgressBar circleProgressBar = this;
            circleProgressBar.mProgressPaint.setShader(null);
            circleProgressBar.mProgressPaint.setColor(this.mProgressStartColor);
        }
    }

    private void adjustIndeterminate() {
        Field field = ProgressBar.class.getDeclaredField("mOnlyIndeterminate");
        field.setAccessible(true);
        field.set((Object)this, false);
        Field field2 = ProgressBar.class.getDeclaredField("mIndeterminate");
        field2.setAccessible(true);
        field2.set((Object)this, false);
        Field field3 = ProgressBar.class.getDeclaredField("mCurrentDrawable");
        try {
            field3.setAccessible(true);
            field3.set((Object)this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
    }

    private void drawProgressText(Canvas object) {
        if (!this.mDrawProgressText) {
            return;
        }
        Canvas canvas = object;
        CircleProgressBar circleProgressBar = this;
        object = String.format(circleProgressBar.mProgressTextFormatPattern, this.getProgress());
        circleProgressBar.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        circleProgressBar.mProgressTextPaint.setColor(this.mProgressTextColor);
        int n5 = ((String)object).length();
        Rect rect = this.mProgressTextRect;
        circleProgressBar.mProgressTextPaint.getTextBounds((String)object, 0, n5, rect);
        float f6 = circleProgressBar.mCenterX;
        float f7 = circleProgressBar.mCenterY + (float)(this.mProgressTextRect.height() / 2);
        rect = circleProgressBar.mProgressTextPaint;
        canvas.drawText((String)object, f6, f7, (Paint)rect);
    }

    private void drawProgress(Canvas canvas) {
        int n5 = this.mStyle;
        if (n5 != 1) {
            if (n5 != 2) {
                this.drawLineProgress(canvas);
            } else {
                this.drawSolidLineProgress(canvas);
            }
        } else {
            this.drawSolidProgress(canvas);
        }
    }

    private void drawLineProgress(Canvas canvas) {
        CircleProgressBar circleProgressBar = this;
        double d6 = circleProgressBar.mLineCount;
        float f6 = (float)(Math.PI * 2 / d6);
        float f7 = circleProgressBar.mRadius;
        float f8 = f7 - this.mLineWidth;
        int n5 = (int)((float)circleProgressBar.getProgress() / (float)this.getMax() * (float)this.mLineCount);
        for (int i5 = 0; i5 < this.mLineCount; ++i5) {
            Paint paint;
            CircleProgressBar circleProgressBar2 = this;
            float f9 = (float)i5 * f6;
            double d7 = f9;
            float f10 = circleProgressBar2.mCenterX + (float)Math.sin(d7) * f8;
            float f11 = circleProgressBar2.mCenterX - (float)Math.cos(d7) * f8;
            float f12 = circleProgressBar2.mCenterX + (float)Math.sin(d7) * f7;
            f9 = circleProgressBar2.mCenterX - (float)Math.cos(d7) * f7;
            if (i5 < n5) {
                paint = this.mProgressPaint;
                canvas.drawLine(f10, f11, f12, f9, paint);
                continue;
            }
            paint = this.mBackgroundPaint;
            canvas.drawLine(f10, f11, f12, f9, paint);
        }
    }

    private void drawSolidProgress(Canvas canvas) {
        Canvas canvas2 = canvas;
        CircleProgressBar circleProgressBar = this;
        Canvas canvas3 = canvas;
        CircleProgressBar circleProgressBar2 = this;
        canvas = circleProgressBar2.mProgressRectF;
        Paint paint = circleProgressBar2.mBackgroundPaint;
        canvas3.drawArc((RectF)canvas, -90.0f, 360.0f, false, paint);
        canvas = circleProgressBar.mProgressRectF;
        float f6 = (float)circleProgressBar.getProgress() * 360.0f / (float)this.getMax();
        paint = circleProgressBar.mProgressPaint;
        canvas2.drawArc((RectF)canvas, -90.0f, f6, true, paint);
    }

    private void drawSolidLineProgress(Canvas canvas) {
        Canvas canvas2 = canvas;
        CircleProgressBar circleProgressBar = this;
        Canvas canvas3 = canvas;
        CircleProgressBar circleProgressBar2 = this;
        canvas = circleProgressBar2.mProgressRectF;
        Paint paint = circleProgressBar2.mBackgroundPaint;
        canvas3.drawArc((RectF)canvas, -90.0f, 360.0f, false, paint);
        canvas = circleProgressBar.mProgressRectF;
        float f6 = (float)circleProgressBar.getProgress() * 360.0f / (float)this.getMax();
        paint = circleProgressBar.mProgressPaint;
        canvas2.drawArc((RectF)canvas, -90.0f, f6, false, paint);
    }

    protected synchronized void onDraw(Canvas canvas) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.drawProgress(canvas);
        circleProgressBar.drawProgressText(canvas);
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        float f6;
        CircleProgressBar circleProgressBar = this;
        super.onSizeChanged(n5, n6, n7, n8);
        float f7 = n5 / 2;
        this.mCenterX = f6 = f7;
        this.mCenterY = f6 = (float)(n6 / 2);
        circleProgressBar.mRadius = f6 = Math.min(f7, f6);
        RectF rectF = circleProgressBar.mProgressRectF;
        float f8 = this.mCenterY;
        rectF.top = f8 - f6;
        rectF.bottom = f8 + f6;
        f8 = this.mCenterX;
        rectF.left = f8 - f6;
        circleProgressBar.mProgressRectF.right = f8 + f6;
        circleProgressBar.updateProgressShader();
        float f9 = this.mProgressStrokeWidth;
        float f10 = f9 / 2.0f;
        circleProgressBar.mProgressRectF.inset(f10, f9 / 2.0f);
    }

    public void setProgressTextFormatPattern(String string2) {
        this.mProgressTextFormatPattern = string2;
        this.invalidate();
    }

    public String getProgressTextFormatPattern() {
        return this.mProgressTextFormatPattern;
    }

    public void setProgressStrokeWidth(float f6) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressStrokeWidth = f6;
        float f7 = f6;
        float f8 = f7 / 2.0f;
        circleProgressBar.mProgressRectF.inset(f8, f7 / 2.0f);
        circleProgressBar.invalidate();
    }

    public float getProgressStrokeWidth() {
        return this.mProgressStrokeWidth;
    }

    public void setProgressTextSize(float f6) {
        this.mProgressTextSize = f6;
        this.invalidate();
    }

    public float getProgressTextSize() {
        return this.mProgressTextSize;
    }

    public void setProgressStartColor(int n5) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressStartColor = n5;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public int getProgressStartColor() {
        return this.mProgressStartColor;
    }

    public void setProgressEndColor(int n5) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressEndColor = n5;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public int getProgressEndColor() {
        return this.mProgressEndColor;
    }

    public void setProgressTextColor(int n5) {
        this.mProgressTextColor = n5;
        this.invalidate();
    }

    public int getProgressTextColor() {
        return this.mProgressTextColor;
    }

    public void setProgressBackgroundColor(int n5) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressBackgroundColor = n5;
        circleProgressBar.mBackgroundPaint.setColor(n5);
        circleProgressBar.invalidate();
    }

    public int getProgressBackgroundColor() {
        return this.mProgressBackgroundColor;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public void setLineCount(int n5) {
        this.mLineCount = n5;
        this.invalidate();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineWidth(float f6) {
        this.mLineWidth = f6;
        this.invalidate();
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int n5) {
        this.mStyle = n5;
        Paint paint = this.mProgressPaint;
        Paint.Style style2 = n5 == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar = this;
        paint.setStyle(style2);
        paint = circleProgressBar.mBackgroundPaint;
        style2 = circleProgressBar.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        paint.setStyle(style2);
        this.invalidate();
    }

    public int getShader() {
        return this.mShader;
    }

    public void setShader(int n5) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mShader = n5;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public Paint.Cap getCap() {
        return this.mCap;
    }

    public void setCap(Paint.Cap cap) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mCap = cap;
        circleProgressBar.mProgressPaint.setStrokeCap(cap);
        circleProgressBar.mBackgroundPaint.setStrokeCap(cap);
        circleProgressBar.invalidate();
    }
}

