/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.util.b;

public class CrossShapeProgressBar
extends View {
    private float progress = 0.5f;
    private int crossColor = Color.parseColor((String)"#11141A");
    private int adjustmentColor = Color.parseColor((String)"#FFFFFF");
    private float cornerRadius = 20.0f;
    private Paint crossPaint;
    private Paint noCrossPaint;
    private Paint noCrossPaintSubtract;
    private Paint progressPaint;
    private Path horizontalPath;
    private Path verticalPath;
    private int mType = 1;
    private boolean progressClickAble = true;
    private boolean dayStyle;

    public CrossShapeProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public CrossShapeProgressBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public CrossShapeProgressBar(Context context, AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            if ((context = context.obtainStyledAttributes(attributeSet, R.styleable.CrossShapeProgressBar)).hasValue(R.styleable.CrossShapeProgressBar_nsdk_bn_volume_progress_type)) {
                this.mType = context.getInt(R.styleable.CrossShapeProgressBar_nsdk_bn_volume_progress_type, 0);
            }
            if (context.hasValue(R.styleable.BNVolumeSetView_nsdk_bn_volume_progress)) {
                this.progress = context.getInt(R.styleable.BNVolumeSetView_nsdk_bn_volume_progress, 0);
            }
            context.recycle();
        }
    }

    private void initPaint() {
        Paint paint;
        if (this.dayStyle != b.b()) {
            CrossShapeProgressBar crossShapeProgressBar = this;
            crossShapeProgressBar.dayStyle = b.b();
            crossShapeProgressBar.crossColor = b.b(R.color.nsdk_cross_shape_progress_cross_color);
            crossShapeProgressBar.crossPaint = null;
            crossShapeProgressBar.noCrossPaintSubtract = null;
        }
        if (this.crossPaint == null) {
            Paint paint2;
            Paint paint3 = paint = paint2;
            paint3();
            this.crossPaint = paint3;
            paint2.setColor(this.crossColor);
        }
        if (this.noCrossPaint == null) {
            Paint paint4;
            Paint paint5 = paint = paint4;
            paint5();
            this.noCrossPaint = paint5;
            paint4.setColor(this.adjustmentColor);
            this.noCrossPaint.setAlpha(45);
        }
        if (this.noCrossPaintSubtract == null) {
            Paint paint6;
            Paint paint7 = paint = paint6;
            paint7();
            this.noCrossPaintSubtract = paint7;
            paint6.setColor(this.crossColor);
            this.noCrossPaintSubtract.setAlpha(45);
        }
        if (this.progressPaint == null) {
            Paint paint8;
            Paint paint9 = paint = paint8;
            paint9();
            this.progressPaint = paint9;
            paint8.setColor(this.adjustmentColor);
        }
    }

    private void initPath() {
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        CrossShapeProgressBar crossShapeProgressBar = this;
        int n5 = Math.min(crossShapeProgressBar.getWidth(), this.getHeight());
        if (crossShapeProgressBar.verticalPath == null) {
            RectF rectF;
            RectF rectF2;
            RectF rectF3;
            RectF rectF4;
            CrossShapeProgressBar crossShapeProgressBar2 = this;
            this.verticalPath = new Path();
            float f11 = n5;
            float f12 = f11 / 6.2f;
            f10 = f11 * 0.5f;
            f9 = f10 - f12 * 0.5f;
            f10 = (float)crossShapeProgressBar2.getHeight() * 0.5f - f10;
            float f13 = f11;
            f11 = f9 + f12;
            f8 = f10 + f13;
            if (crossShapeProgressBar2.cornerRadius == 20.0f) {
                this.cornerRadius = f12 / 2.0f;
            }
            CrossShapeProgressBar crossShapeProgressBar3 = this;
            RectF rectF5 = rectF4;
            float f14 = this.cornerRadius;
            f7 = f9 + f14 * 2.0f;
            float f15 = f10 + f14 * 2.0f;
            rectF4 = new RectF(f9, f10, f7, f15);
            crossShapeProgressBar3.verticalPath.arcTo(rectF5, 180.0f, 90.0f);
            rectF5 = rectF3;
            float f16 = this.cornerRadius;
            f7 = f11 - f16 * 2.0f;
            f15 = f10 + f16 * 2.0f;
            rectF3 = new RectF(f7, f10, f11, f15);
            crossShapeProgressBar3.verticalPath.arcTo(rectF5, 270.0f, 90.0f);
            rectF5 = rectF2;
            float f17 = this.cornerRadius;
            f10 = f11 - f17 * 2.0f;
            rectF2 = new RectF(f10, f8 - f17 * 2.0f, f11, f8);
            crossShapeProgressBar3.verticalPath.arcTo(rectF5, 0.0f, 90.0f);
            RectF rectF6 = rectF;
            float f18 = f9;
            float f19 = this.cornerRadius;
            f6 = f8 - f19 * 2.0f;
            rectF = new RectF(f18, f6, f18 + f19 * 2.0f, f8);
            crossShapeProgressBar3.verticalPath.arcTo(rectF6, 90.0f, 90.0f);
            crossShapeProgressBar3.verticalPath.close();
        }
        if (this.horizontalPath == null) {
            RectF rectF;
            RectF rectF7;
            RectF rectF8;
            RectF rectF9;
            this.horizontalPath = new Path();
            float f20 = n5;
            float f21 = f20 / 6.2f;
            float f22 = (float)this.getHeight() * 0.5f - f21 * 0.5f;
            f6 = 0.0f;
            f10 = f22 + f21;
            f9 = f20 + f6;
            if (this.cornerRadius == 20.0f) {
                this.cornerRadius = f21 / 2.0f;
            }
            CrossShapeProgressBar crossShapeProgressBar4 = this;
            RectF rectF10 = rectF9;
            float f23 = this.cornerRadius;
            f8 = f6 + f23 * 2.0f;
            f7 = f22 + f23 * 2.0f;
            rectF9 = new RectF(f6, f22, f8, f7);
            crossShapeProgressBar4.horizontalPath.arcTo(rectF10, 180.0f, 90.0f);
            rectF10 = rectF8;
            float f24 = this.cornerRadius;
            f8 = f9 - f24 * 2.0f;
            f7 = f22 + f24 * 2.0f;
            rectF8 = new RectF(f8, f22, f9, f7);
            crossShapeProgressBar4.horizontalPath.arcTo(rectF10, 270.0f, 90.0f);
            rectF10 = rectF7;
            float f25 = this.cornerRadius;
            f22 = f9 - f25 * 2.0f;
            rectF7 = new RectF(f22, f10 - f25 * 2.0f, f9, f10);
            crossShapeProgressBar4.horizontalPath.arcTo(rectF10, 0.0f, 90.0f);
            rectF10 = rectF;
            float f26 = f6;
            float f27 = this.cornerRadius;
            float f28 = f10 - f27 * 2.0f;
            rectF = new RectF(f26, f28, f26 + f27 * 2.0f, f10);
            crossShapeProgressBar4.horizontalPath.arcTo(rectF10, 90.0f, 90.0f);
            crossShapeProgressBar4.horizontalPath.close();
        }
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onDraw(Canvas canvas) {
        CrossShapeProgressBar crossShapeProgressBar;
        CrossShapeProgressBar crossShapeProgressBar2 = crossShapeProgressBar;
        super.onDraw(canvas);
        crossShapeProgressBar2.initPaint();
        crossShapeProgressBar2.initPath();
        float f6 = Math.min(crossShapeProgressBar2.getWidth(), crossShapeProgressBar.getHeight());
        float f7 = f6 * crossShapeProgressBar.progress;
        if (!crossShapeProgressBar2.progressClickAble && crossShapeProgressBar.mType == 0) {
            CrossShapeProgressBar crossShapeProgressBar3 = crossShapeProgressBar;
            crossShapeProgressBar = crossShapeProgressBar3.horizontalPath;
            canvas.drawPath((Path)crossShapeProgressBar, crossShapeProgressBar3.noCrossPaintSubtract);
            return;
        }
        if (!crossShapeProgressBar.progressClickAble) {
            Canvas canvas2 = canvas;
            CrossShapeProgressBar crossShapeProgressBar4 = crossShapeProgressBar;
            CrossShapeProgressBar crossShapeProgressBar5 = crossShapeProgressBar;
            Canvas canvas3 = canvas;
            CrossShapeProgressBar crossShapeProgressBar6 = crossShapeProgressBar;
            CrossShapeProgressBar crossShapeProgressBar7 = crossShapeProgressBar;
            CrossShapeProgressBar crossShapeProgressBar8 = crossShapeProgressBar;
            canvas.save();
            crossShapeProgressBar = crossShapeProgressBar8.horizontalPath;
            canvas.drawPath((Path)crossShapeProgressBar, crossShapeProgressBar8.noCrossPaint);
            float f8 = crossShapeProgressBar7.getWidth();
            float f9 = f6 * 0.5f / 6.2f;
            f6 = (float)crossShapeProgressBar7.getHeight() * 0.5f - f9;
            canvas.clipRect(0.0f, 0.0f, f8, f6);
            Path path = crossShapeProgressBar6.verticalPath;
            canvas3.drawPath(path, crossShapeProgressBar6.noCrossPaint);
            canvas3.restore();
            canvas3.save();
            float f10 = (float)crossShapeProgressBar5.getHeight() * 0.5f + f9;
            f9 = crossShapeProgressBar5.getWidth();
            f6 = crossShapeProgressBar5.getHeight();
            canvas.clipRect(0.0f, f10, f9, f6);
            Path path2 = crossShapeProgressBar4.verticalPath;
            canvas2.drawPath(path2, crossShapeProgressBar4.noCrossPaint);
            canvas2.restore();
            return;
        }
        CrossShapeProgressBar crossShapeProgressBar9 = crossShapeProgressBar;
        Path path = crossShapeProgressBar9.horizontalPath;
        canvas.drawPath(path, crossShapeProgressBar9.crossPaint);
        if (crossShapeProgressBar.mType == 1) {
            CrossShapeProgressBar crossShapeProgressBar10 = crossShapeProgressBar;
            path = crossShapeProgressBar10.verticalPath;
            canvas.drawPath(path, crossShapeProgressBar10.crossPaint);
        }
        CrossShapeProgressBar crossShapeProgressBar11 = crossShapeProgressBar;
        CrossShapeProgressBar crossShapeProgressBar12 = crossShapeProgressBar;
        float f11 = (float)crossShapeProgressBar12.getHeight() * 0.5f - (f6 *= 0.5f);
        f6 = (float)crossShapeProgressBar12.getHeight() * 0.5f + f6;
        canvas.clipRect(0.0f, f11, f7, f6);
        Path path3 = crossShapeProgressBar11.horizontalPath;
        canvas.drawPath(path3, crossShapeProgressBar11.progressPaint);
        if (crossShapeProgressBar.mType == 1) {
            CrossShapeProgressBar crossShapeProgressBar13 = crossShapeProgressBar;
            crossShapeProgressBar = crossShapeProgressBar13.verticalPath;
            canvas.drawPath((Path)crossShapeProgressBar, crossShapeProgressBar13.progressPaint);
        }
    }

    public void setProgress(float f6) {
        this.progress = f6;
        this.invalidate();
    }

    public void setCrossColor(int n5) {
        CrossShapeProgressBar crossShapeProgressBar = this;
        crossShapeProgressBar.crossColor = n5;
        crossShapeProgressBar.initPaint();
        crossShapeProgressBar.invalidate();
    }

    public void setAdjustmentColor(int n5) {
        CrossShapeProgressBar crossShapeProgressBar = this;
        crossShapeProgressBar.adjustmentColor = n5;
        crossShapeProgressBar.initPaint();
        crossShapeProgressBar.invalidate();
    }

    public void setCornerRadius(float f6) {
        this.cornerRadius = f6;
        this.invalidate();
    }

    public void setProgressClickAble(boolean bl) {
        this.progressClickAble = bl;
        this.invalidate();
    }
}

