/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.Iterator;

public class DivideGridItemDecoration
extends RecyclerView.ItemDecoration {
    private final DivideParams mDivideParams;
    private final Drawable mDivideDrawable;
    private int childCount;
    int spanCount;

    public DivideGridItemDecoration(DivideParams divideParams, Drawable drawable2) {
        this.mDivideParams = divideParams;
        this.mDivideDrawable = drawable2;
    }

    private void drawDivide(Canvas canvas, RecyclerView recyclerView) {
        for (int i5 = 0; i5 < this.childCount; ++i5) {
            DivideGridItemDecoration divideGridItemDecoration = this;
            View view = recyclerView.getChildAt(i5);
            SpecialDivideResult specialDivideResult = divideGridItemDecoration.isSpecialDivide(i5);
            divideGridItemDecoration.drawHorizontalDivide(canvas, view, specialDivideResult);
            divideGridItemDecoration.drawVerticalDivide(canvas, view, specialDivideResult);
        }
    }

    private void drawHorizontalDivide(Canvas canvas, View view, SpecialDivideResult object) {
        int n5;
        int n6;
        if (object != null && ((SpecialDivideResult)object).isSpecialDivide && (object = ((SpecialDivideResult)object).mSpecialDivideParams) != null) {
            Object object2 = object;
            n6 = ((DivideParams.SpecialDivideParams)object2).dividePaddingItemLeft;
            n5 = ((DivideParams.SpecialDivideParams)object2).dividePaddingItemRight;
        } else {
            DivideParams divideParams = this.mDivideParams;
            n6 = divideParams.dividePaddingItemLeft;
            n5 = divideParams.dividePaddingItemRight;
        }
        View view2 = view;
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view2.getLayoutParams();
        n6 = view2.getLeft() - layoutParams.leftMargin + n6;
        n5 = view.getRight() + layoutParams.rightMargin + this.mDivideDrawable.getIntrinsicWidth() - n5;
        int n7 = view.getBottom() + layoutParams.bottomMargin;
        int n8 = n7 + this.mDivideDrawable.getIntrinsicHeight();
        if (n6 < n5 && this.mDivideParams.isShowHorizontalDivide) {
            DivideGridItemDecoration divideGridItemDecoration = this;
            divideGridItemDecoration.mDivideDrawable.setBounds(n6, n7, n5, n8);
            divideGridItemDecoration.mDivideDrawable.draw(canvas);
            return;
        }
        this.mDivideParams.isShowHorizontalDivide = false;
    }

    private void drawVerticalDivide(Canvas canvas, View view, SpecialDivideResult object) {
        int n5;
        int n6;
        if (object != null && ((SpecialDivideResult)object).isSpecialDivide && (object = ((SpecialDivideResult)object).mSpecialDivideParams) != null) {
            Object object2 = object;
            n6 = ((DivideParams.SpecialDivideParams)object2).dividePaddingItemTop;
            n5 = ((DivideParams.SpecialDivideParams)object2).dividePaddingItemBottom;
        } else {
            DivideParams divideParams = this.mDivideParams;
            n6 = divideParams.dividePaddingItemTop;
            n5 = divideParams.dividePaddingItemBottom;
        }
        View view2 = view;
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view2.getLayoutParams();
        n6 = view2.getTop() - layoutParams.topMargin + n6;
        n5 = view.getBottom() + layoutParams.bottomMargin - n5;
        int n7 = view.getRight() + layoutParams.rightMargin;
        int n8 = n7 + this.mDivideDrawable.getIntrinsicWidth();
        if (n6 < n5 && this.mDivideParams.isShowVerticalDivide) {
            DivideGridItemDecoration divideGridItemDecoration = this;
            divideGridItemDecoration.mDivideDrawable.setBounds(n7, n6, n8, n5);
            divideGridItemDecoration.mDivideDrawable.draw(canvas);
            return;
        }
        this.mDivideParams.isShowVerticalDivide = false;
    }

    private SpecialDivideResult isSpecialDivide(int n5) {
        Iterator<DivideParams.SpecialDivideParams> iterator;
        SpecialDivideResult specialDivideResult;
        SpecialDivideResult specialDivideResult2 = specialDivideResult;
        new SpecialDivideResult().isSpecialDivide = false;
        if (this.childCount > 0 && (iterator = this.mDivideParams) != null && (iterator = ((DivideParams)((Object)iterator)).mSpecialDivideParams) != null && !((ArrayList)((Object)iterator)).isEmpty()) {
            for (DivideParams.SpecialDivideParams specialDivideParams : this.mDivideParams.mSpecialDivideParams) {
                int n6;
                int n7;
                if (specialDivideParams.rowNum < 0 && (n7 = specialDivideParams.columNum) >= 0) {
                    if (n5 % this.spanCount != n7) continue;
                    specialDivideResult2.isSpecialDivide = true;
                    specialDivideResult2.mSpecialDivideParams = specialDivideParams;
                    return specialDivideResult2;
                }
                n7 = specialDivideParams.rowNum;
                if (n7 >= 0 && specialDivideParams.columNum < 0) {
                    n6 = this.spanCount;
                    if (n5 < n6 * n7 || n5 >= n6 * (n7 + 1)) continue;
                    specialDivideResult2.isSpecialDivide = true;
                    specialDivideResult2.mSpecialDivideParams = specialDivideParams;
                    return specialDivideResult2;
                }
                n7 = specialDivideParams.rowNum;
                if (n7 >= 0 && (n6 = specialDivideParams.columNum) >= 0) {
                    if (n5 != this.spanCount * n7 + n6) continue;
                    specialDivideResult2.isSpecialDivide = true;
                    specialDivideResult2.mSpecialDivideParams = specialDivideParams;
                    return specialDivideResult2;
                }
                specialDivideResult2.isSpecialDivide = true;
                specialDivideResult2.mSpecialDivideParams = specialDivideParams;
                return specialDivideResult2;
            }
            return specialDivideResult2;
        }
        return specialDivideResult2;
    }

    private int getSpanCount(RecyclerView recyclerView) {
        int n5 = -1;
        if ((recyclerView = recyclerView.getLayoutManager()) instanceof GridLayoutManager) {
            n5 = ((GridLayoutManager)recyclerView).getSpanCount();
        } else if (recyclerView instanceof StaggeredGridLayoutManager) {
            n5 = ((StaggeredGridLayoutManager)recyclerView).getSpanCount();
        }
        return n5;
    }

    private boolean isLastRaw(RecyclerView recyclerView, int n5, int n6, int n7) {
        DivideGridItemDecoration divideGridItemDecoration = recyclerView.getLayoutManager();
        if (divideGridItemDecoration instanceof GridLayoutManager) {
            int n8 = n7 - 1;
            return n5 >= n8 - n8 % n6;
        }
        if (divideGridItemDecoration instanceof StaggeredGridLayoutManager) {
            if (((StaggeredGridLayoutManager)divideGridItemDecoration).getOrientation() == 1) {
                int n9 = n7 - 1;
                return n5 >= n9 - n9 % n6;
            }
            return (n5 + 1) % n6 == 0;
        }
        return false;
    }

    private boolean isFirstRaw(RecyclerView recyclerView, int n5, int n6, int n7) {
        DivideGridItemDecoration divideGridItemDecoration = recyclerView.getLayoutManager();
        if (divideGridItemDecoration instanceof GridLayoutManager) {
            return n5 < n6;
        }
        if (divideGridItemDecoration instanceof StaggeredGridLayoutManager) {
            return n5 < n6;
        }
        return false;
    }

    private boolean isLastColum(RecyclerView recyclerView, int n5, int n6, int n7) {
        DivideGridItemDecoration divideGridItemDecoration = recyclerView.getLayoutManager();
        if (divideGridItemDecoration instanceof GridLayoutManager) {
            return (n5 + 1) % n6 == 0;
        }
        if (divideGridItemDecoration instanceof StaggeredGridLayoutManager) {
            if (((StaggeredGridLayoutManager)divideGridItemDecoration).getOrientation() == 1) {
                return (n5 + 1) % n6 == 0;
            }
            int n8 = n7;
            return n5 >= n8 - n8 % n6;
        }
        return false;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        if (this.mDivideParams != null && this.mDivideDrawable != null) {
            this.childCount = recyclerView.getChildCount();
            this.spanCount = this.getSpanCount(recyclerView);
            this.drawDivide(canvas, recyclerView);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        if (this.mDivideParams == null) return;
        if (this.mDivideDrawable == null) {
            return;
        }
        this.spanCount = this.getSpanCount(recyclerView);
        int n5 = recyclerView.getAdapter().getItemCount();
        int n6 = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition();
        if (this.isLastRaw(recyclerView, n6, this.spanCount, n5) && !this.mDivideParams.isShowBottomDivideInLastRow) {
            int n7 = this.mDivideDrawable.getIntrinsicWidth();
            rect.set(0, 0, n7, 0);
            return;
        }
        if (this.isLastColum(recyclerView, n6, this.spanCount, n5) && !this.mDivideParams.isShowRightDivideInLastColumn) {
            int n8 = this.mDivideDrawable.getIntrinsicHeight();
            rect.set(0, 0, 0, n8);
            return;
        }
        if (this.isFirstRaw(recyclerView, n6, this.spanCount, n5)) {
            DivideParams divideParams = this.mDivideParams;
            if (divideParams.isShowTopDivideInFirstColumn) {
                int n9 = 0;
                int n10 = divideParams.isShowVerticalDivide ? this.mDivideDrawable.getIntrinsicHeight() : 0;
                n6 = this.mDivideParams.isShowHorizontalDivide ? this.mDivideDrawable.getIntrinsicWidth() : 0;
                int n11 = this.mDivideParams.isShowVerticalDivide ? this.mDivideDrawable.getIntrinsicHeight() : 0;
                rect.set(n9, n10, n6, n11);
                return;
            }
        }
        int n12 = 0;
        int n13 = 0;
        n6 = this.mDivideParams.isShowHorizontalDivide ? this.mDivideDrawable.getIntrinsicWidth() : 0;
        int n14 = this.mDivideParams.isShowVerticalDivide ? this.mDivideDrawable.getIntrinsicHeight() : 0;
        rect.set(n12, n13, n6, n14);
    }

    private static final class SpecialDivideResult {
        boolean isSpecialDivide;
        DivideParams.SpecialDivideParams mSpecialDivideParams;

        private SpecialDivideResult() {
        }
    }

    public static final class DivideParams {
        int dividePaddingItemLeft;
        int dividePaddingItemRight;
        int dividePaddingItemTop;
        int dividePaddingItemBottom;
        public boolean isShowHorizontalDivide = true;
        public boolean isShowVerticalDivide = true;
        public boolean isShowBottomDivideInLastRow = false;
        public boolean isShowRightDivideInLastColumn = false;
        public boolean isShowTopDivideInFirstColumn = false;
        public ArrayList<SpecialDivideParams> mSpecialDivideParams;

        public DivideParams(int n5, int n6) {
            int n7 = n5 < 0 ? 0 : n5;
            this.dividePaddingItemLeft = n7;
            if (n5 < 0) {
                n5 = 0;
            }
            this.dividePaddingItemRight = n5;
            n5 = n6 < 0 ? 0 : n6;
            this.dividePaddingItemTop = n5;
            if (n6 < 0) {
                n6 = 0;
            }
            this.dividePaddingItemBottom = n6;
        }

        public DivideParams(int n5, int n6, int n7, int n8) {
            if (n5 < 0) {
                n5 = 0;
            }
            this.dividePaddingItemLeft = n5;
            if (n6 < 0) {
                n6 = 0;
            }
            this.dividePaddingItemRight = n6;
            if (n7 < 0) {
                n7 = 0;
            }
            this.dividePaddingItemTop = n7;
            if (n8 < 0) {
                n8 = 0;
            }
            this.dividePaddingItemBottom = n8;
        }

        public static final class SpecialDivideParams {
            public int rowNum;
            public int columNum;
            public int dividePaddingItemLeft;
            public int dividePaddingItemRight;
            public int dividePaddingItemTop;
            public int dividePaddingItemBottom;
        }
    }
}

