/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class GlideRoundTransform
extends BitmapTransformation {
    private float mRadius = 0.0f;

    public GlideRoundTransform(Context context) {
        this(context, 4);
    }

    public GlideRoundTransform(Context context, int n5) {
        this.mRadius = Resources.getSystem().getDisplayMetrics().density * (float)n5;
    }

    private Bitmap roundCrop(BitmapPool bitmapPool, Bitmap bitmap) {
        RectF rectF;
        Paint paint;
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        int n5 = bitmap2.getWidth();
        int n6 = bitmap2.getHeight();
        Bitmap bitmap3 = bitmapPool.get(n5, n6, Bitmap.Config.ARGB_8888);
        Bitmap bitmap4 = bitmap3;
        Canvas canvas = new Canvas(bitmap4);
        GlideRoundTransform glideRoundTransform = paint;
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        new Paint().setShader((Shader)new BitmapShader(bitmap, tileMode, tileMode));
        glideRoundTransform.setAntiAlias(true);
        bitmap4 = rectF;
        Bitmap bitmap5 = bitmap;
        float f6 = bitmap5.getWidth();
        float f7 = bitmap5.getHeight();
        rectF = new RectF(0.0f, 0.0f, f6, f7);
        float f8 = glideRoundTransform.mRadius;
        canvas.drawRoundRect((RectF)bitmap4, f8, f8, (Paint)glideRoundTransform);
        return bitmap3;
    }

    public GlideRoundTransform setRadius(float f6) {
        this.mRadius = f6;
        return this;
    }

    protected Bitmap transform(@NonNull BitmapPool bitmapPool, @NonNull Bitmap bitmap, int n5, int n6) {
        return this.roundCrop(bitmapPool, bitmap);
    }

    public String getId() {
        return GlideRoundTransform.class.getName() + Math.round(this.mRadius);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
    }
}

