/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class MatrixImageView
extends ImageView {
    private static final String TAG = "MatrixImageView";
    private GestureDetector mGestureDetector;
    private Matrix mMatrix;
    public float mImageWidth;
    public float mImageHeight;

    public MatrixImageView(Context context, AttributeSet attributeSet) {
        MatrixImageView matrixImageView = this;
        super(context, attributeSet);
        matrixImageView.mMatrix = new Matrix();
        matrixImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    public void setImageBitmap(Bitmap bitmap) {
        MatrixImageView matrixImageView = object;
        super.setImageBitmap(bitmap);
        matrixImageView.mMatrix.set(object.getImageMatrix());
        Object object = new float[9];
        matrixImageView.mMatrix.getValues((float[])object);
        matrixImageView.mImageWidth /= object[0];
        matrixImageView.mImageHeight = (matrixImageView.mImageHeight - object[5] * 2.0f) / object[4];
    }

    public void start(float f6, float f7, float f8) {
        GestureListener gestureListener;
        GestureDetector gestureDetector2;
        MatrixTouchListener matrixTouchListener;
        MatrixTouchListener matrixTouchListener2 = matrixTouchListener;
        (MatrixImageView)this.new MatrixTouchListener().mMaxScale = f6;
        (MatrixImageView)this.new MatrixTouchListener().mDobleClickScale = f8;
        (MatrixImageView)this.new MatrixTouchListener().mMinScale = f7;
        this.setOnTouchListener(matrixTouchListener2);
        GestureDetector gestureDetector3 = gestureDetector2;
        Context context = this.getContext();
        GestureListener gestureListener2 = gestureListener;
        gestureListener = new GestureListener(matrixTouchListener2);
        gestureDetector2 = new GestureDetector(context, (GestureDetector.OnGestureListener)gestureListener2);
        this.mGestureDetector = gestureDetector3;
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final MatrixTouchListener listener;

        public GestureListener(MatrixTouchListener matrixTouchListener) {
            this.listener = matrixTouchListener;
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onDoubleTap(MotionEvent motionEvent) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return super.onSingleTapUp(motionEvent);
        }

        public void onLongPress(MotionEvent motionEvent) {
            super.onLongPress(motionEvent);
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f6, float f7) {
            return super.onScroll(motionEvent, motionEvent2, f6, f7);
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f6, float f7) {
            return super.onFling(motionEvent, motionEvent2, f6, f7);
        }

        public void onShowPress(MotionEvent motionEvent) {
            super.onShowPress(motionEvent);
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return super.onDoubleTapEvent(motionEvent);
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return super.onSingleTapConfirmed(motionEvent);
        }
    }

    public class MatrixTouchListener
    implements View.OnTouchListener {
        private static final int MODE_DRAG = 1;
        private static final int MODE_ZOOM = 2;
        private static final int MODE_UNABLE = 3;
        float mMaxScale = 6.0f;
        float mDobleClickScale = 2.0f;
        float mMinScale = 1.0f;
        private int mMode = 0;
        private float mStartDis;
        private Matrix mCurrentMatrix;
        private PointF startPoint;

        public MatrixTouchListener() {
            PointF pointF;
            Matrix matrix;
            MatrixTouchListener matrixTouchListener = matrix;
            matrix = new Matrix();
            v1.mCurrentMatrix = matrixTouchListener;
            matrixTouchListener = pointF;
            pointF = new PointF();
            v1.startPoint = matrixTouchListener;
        }

        private boolean isZoomChanged() {
            float[] fArray = new float[9];
            MatrixImageView.this.getImageMatrix().getValues(fArray);
            float f6 = fArray[0];
            MatrixImageView.this.mMatrix.getValues(fArray);
            return f6 != fArray[0];
        }

        private float checkDyBound(float[] fArray, float f6) {
            float f7;
            MatrixTouchListener matrixTouchListener = this;
            float f8 = matrixTouchListener.MatrixImageView.this.getHeight();
            float f9 = matrixTouchListener.MatrixImageView.this.mImageHeight;
            if (f7 * fArray[4] < f8) {
                return 0.0f;
            }
            if (fArray[5] + f6 > 0.0f) {
                f6 = -fArray[5];
            } else if (fArray[5] + f6 < -(f9 * fArray[4] - f8)) {
                f6 = -(f9 * fArray[4] - f8) - fArray[5];
            }
            return f6;
        }

        private float checkDxBound(float[] fArray, float f6) {
            float f7;
            MatrixTouchListener matrixTouchListener = this;
            float f8 = matrixTouchListener.MatrixImageView.this.getWidth();
            float f9 = matrixTouchListener.MatrixImageView.this.mImageWidth;
            if (f7 * fArray[0] < f8) {
                return 0.0f;
            }
            if (fArray[2] + f6 > 0.0f) {
                f6 = -fArray[2];
            } else if (fArray[2] + f6 < -(f9 * fArray[0] - f8)) {
                f6 = -(f9 * fArray[0] - f8) - fArray[2];
            }
            return f6;
        }

        private void setZoomMatrix(MotionEvent motionEvent) {
            float f6;
            if (motionEvent.getPointerCount() < 2) {
                return;
            }
            float f7 = this.distance(motionEvent);
            if (f6 > 10.0f) {
                MatrixTouchListener matrixTouchListener = this;
                float f8 = f7;
                f7 = f8 / this.mStartDis;
                matrixTouchListener.mStartDis = f8;
                MatrixTouchListener matrixTouchListener2 = this;
                matrixTouchListener2.mCurrentMatrix.set(MatrixImageView.this.getImageMatrix());
                float[] fArray = new float[9];
                matrixTouchListener2.mCurrentMatrix.getValues(fArray);
                matrixTouchListener.checkMaxScale(f7, fArray);
                matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
                matrixTouchListener.center(true, true);
            }
        }

        private float checkMaxScale(float f6, float[] fArray) {
            float f7;
            float f8 = this.mMaxScale;
            if (f6 * fArray[0] > f7) {
                f6 = f8 / fArray[0];
            } else {
                float f9;
                f8 = this.mMinScale;
                if (f6 * fArray[0] < f9) {
                    float f10 = f8 / fArray[0];
                    float f11 = f8;
                    this.mCurrentMatrix.setScale(f11, f11);
                    return f10;
                }
            }
            MatrixTouchListener matrixTouchListener = this;
            float f12 = matrixTouchListener.MatrixImageView.this.getWidth() / 2;
            float f13 = matrixTouchListener.MatrixImageView.this.getHeight() / 2;
            this.mCurrentMatrix.postScale(f6, f6, f12, f13);
            return f6;
        }

        private void reSetMatrix() {
            if (this.checkRest()) {
                MatrixTouchListener matrixTouchListener = this;
                matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.mMatrix);
                matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
            }
        }

        private boolean checkRest() {
            float[] fArray = new float[9];
            MatrixImageView.this.getImageMatrix().getValues(fArray);
            float f6 = fArray[0];
            MatrixImageView.this.mMatrix.getValues(fArray);
            return f6 < fArray[0];
        }

        private void isMatrixEnable() {
            if (MatrixImageView.this.getScaleType() != ImageView.ScaleType.CENTER) {
                MatrixImageView.this.setScaleType(ImageView.ScaleType.MATRIX);
            } else {
                this.mMode = 3;
            }
        }

        private float distance(MotionEvent motionEvent) {
            float f6;
            float f7 = motionEvent.getX(1) - motionEvent.getX(0);
            float f8 = f6 = motionEvent.getY(1) - motionEvent.getY(0);
            return (float)Math.sqrt(f7 * f7 + f8 * f8);
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                default: {
                    break;
                }
                case 5: {
                    if (this.mMode == 3) {
                        return true;
                    }
                    this.mMode = 2;
                    this.mStartDis = this.distance(motionEvent);
                    break;
                }
                case 2: {
                    int n5 = this.mMode;
                    if (n5 == 2) {
                        this.setZoomMatrix(motionEvent);
                        break;
                    }
                    if (n5 != 1) break;
                    this.setDragMatrix(motionEvent);
                    break;
                }
                case 1: 
                case 3: {
                    this.reSetMatrix();
                    break;
                }
                case 0: {
                    MatrixTouchListener matrixTouchListener = this;
                    matrixTouchListener.mMode = 1;
                    MotionEvent motionEvent2 = motionEvent;
                    float f6 = motionEvent2.getX();
                    matrixTouchListener.startPoint.set(f6, motionEvent2.getY());
                    matrixTouchListener.isMatrixEnable();
                }
            }
            return MatrixImageView.this.mGestureDetector.onTouchEvent(motionEvent);
        }

        protected void center(boolean bl, boolean bl2) {
            RectF rectF;
            RectF rectF2;
            Matrix matrix;
            Matrix matrix2 = matrix;
            matrix2();
            matrix.set(this.mCurrentMatrix);
            RectF rectF3 = rectF2 = rectF;
            MatrixImageView matrixImageView = MatrixImageView.this;
            float f6 = matrixImageView.mImageWidth;
            float f7 = matrixImageView.mImageHeight;
            rectF3(0.0f, 0.0f, f6, f7);
            matrix2.mapRect(rectF3);
            f6 = rectF.height();
            f7 = rectF.width();
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (bl2) {
                float f10;
                float f11 = MatrixImageView.this.getHeight();
                if (f6 < f10) {
                    f9 = (f11 - f6) / 2.0f - rectF2.top;
                } else {
                    float f12;
                    f6 = rectF2.top;
                    if (f12 > 0.0f) {
                        f9 = -f6;
                    } else {
                        float f13;
                        f6 = rectF2.bottom;
                        if (f13 < f11) {
                            f9 = f11 - f6;
                        }
                    }
                }
            }
            if (bl) {
                float f14;
                float f15 = MatrixImageView.this.getWidth();
                if (f7 < f14) {
                    f8 = (f15 - f7) / 2.0f - rectF2.left;
                } else {
                    float f16;
                    f6 = rectF2.left;
                    if (f16 > 0.0f) {
                        f8 = -f6;
                    } else {
                        float f17;
                        f6 = rectF2.right;
                        if (f17 < f15) {
                            f8 = f15 - f6;
                        }
                    }
                }
            }
            MatrixTouchListener matrixTouchListener = this;
            matrixTouchListener.mCurrentMatrix.postTranslate(f8, f9);
            matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
        }

        public void setDragMatrix(MotionEvent motionEvent) {
            if (this.isZoomChanged()) {
                float f6;
                float f7;
                float f8 = motionEvent.getX() - this.startPoint.x;
                float f9 = f7 = motionEvent.getY() - this.startPoint.y;
                if (Math.sqrt(f6 * f6 + f9 * f9) > 10.0) {
                    MatrixTouchListener matrixTouchListener = this;
                    MotionEvent motionEvent2 = motionEvent;
                    float f10 = motionEvent2.getX();
                    matrixTouchListener.startPoint.set(f10, motionEvent2.getY());
                    matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.getImageMatrix());
                    float[] fArray = new float[9];
                    this.mCurrentMatrix.getValues(fArray);
                    f8 = matrixTouchListener.checkDxBound(fArray, f8);
                    float f11 = matrixTouchListener.checkDyBound(fArray, f7);
                    matrixTouchListener.mCurrentMatrix.postTranslate(f8, f11);
                    matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
                }
            }
        }

        public void onDoubleClick() {
            float f6 = this.isZoomChanged() ? 1.0f : this.mDobleClickScale;
            MatrixTouchListener matrixTouchListener = this;
            matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.mMatrix);
            MatrixTouchListener matrixTouchListener2 = this;
            float f7 = matrixTouchListener2.MatrixImageView.this.getWidth() / 2;
            float f8 = matrixTouchListener2.MatrixImageView.this.getHeight() / 2;
            matrixTouchListener.mCurrentMatrix.postScale(f6, f6, f7, f8);
            matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
        }
    }
}

