/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.util.jar.JarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NavMultiSeekBar
extends View {
    private static final int mTrackHeight = JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_2dp);
    private AccessibilityNodeProvider mAccessibilityNodeProvider;
    private OnThumbValueChangeListener mOnThumbValueChangeListener;
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mScaleMin;
    private int mScaleMax;
    private int mStep;
    private int mStepsThumbsApart;
    private boolean mDrawThumbsApart;
    private Drawable mTrack;
    boolean mMirrorForRtl;
    private final LinkedList<Thumb> mThumbs;
    private int mKeyProgressIncrement;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private final List<Thumb> mDraggingThumbs;
    LinkedList<Thumb> exactTouched;
    private Drawable defThumbDrawable;
    private int defThumbColor;
    private Drawable defRangeDrawable;
    private int defRangeColor;
    private final TypedArray a;

    public NavMultiSeekBar(Context context) {
        this(context, null);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet) {
        int n5 = R.attr.nsdk_multiSeekBarStyle;
        this(context, attributeSet, n5);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet, int n5) {
        this(context, attributeSet, n5, 0);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet, int n5, int n6) {
        NavMultiSeekBar navMultiSeekBar = this;
        super(context, attributeSet, n5);
        this.mMirrorForRtl = true;
        this.mThumbs = new LinkedList();
        this.mKeyProgressIncrement = 1;
        this.mDraggingThumbs = new LinkedList<Thumb>();
        this.exactTouched = null;
        this.defThumbColor = 0;
        this.defRangeColor = 0;
        this.a = context.obtainStyledAttributes(attributeSet, R.styleable.NavMultiSeekBar, n5, n6);
        navMultiSeekBar.initMultiSlider(this.a.getInt(R.styleable.NavMultiSeekBar_nsdk_thumbNumber, 2));
        attributeSet = navMultiSeekBar.a.getDrawable(R.styleable.NavMultiSeekBar_android_track);
        if (attributeSet == null) {
            attributeSet = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.bnav_common_seekbar_track_bg);
        }
        NavMultiSeekBar navMultiSeekBar2 = this;
        navMultiSeekBar2.setTrackDrawable(navMultiSeekBar2.getTintedDrawable((Drawable)attributeSet, this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_trackColor, 0)));
        int n7 = R.styleable.NavMultiSeekBar_nsdk_scaleStep;
        navMultiSeekBar2.setStep(navMultiSeekBar2.a.getInt(n7, this.mStep));
        n7 = R.styleable.NavMultiSeekBar_nsdk_stepsThumbsApart;
        navMultiSeekBar2.setStepsThumbsApart(navMultiSeekBar2.a.getInt(n7, this.mStepsThumbsApart));
        n7 = R.styleable.NavMultiSeekBar_nsdk_drawThumbsApart;
        navMultiSeekBar2.setDrawThumbsApart(navMultiSeekBar2.a.getBoolean(n7, this.mDrawThumbsApart));
        n7 = R.styleable.NavMultiSeekBar_nsdk_scaleMax;
        navMultiSeekBar2.setMax(navMultiSeekBar2.a.getInt(n7, this.mScaleMax), true);
        n7 = R.styleable.NavMultiSeekBar_nsdk_scaleMin;
        navMultiSeekBar2.setMin(navMultiSeekBar2.a.getInt(n7, this.mScaleMin), true);
        n7 = R.styleable.NavMultiSeekBar_nsdk_mirrorForRTL;
        navMultiSeekBar2.mMirrorForRtl = navMultiSeekBar2.a.getBoolean(n7, this.mMirrorForRtl);
        this.defThumbDrawable = navMultiSeekBar2.a.getDrawable(R.styleable.NavMultiSeekBar_android_thumb);
        if (this.defThumbDrawable == null) {
            this.defThumbDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.nsdk_drawable_seekbar_thumb);
        }
        if ((this.defRangeDrawable = this.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range)) == null) {
            this.defRangeDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.bnav_common_seekbar_track_bg);
        }
        Context context2 = context;
        NavMultiSeekBar navMultiSeekBar3 = this;
        context = navMultiSeekBar3.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range1);
        Drawable drawable2 = navMultiSeekBar3.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range2);
        navMultiSeekBar3.defRangeColor = navMultiSeekBar3.a.getColor(R.styleable.NavMultiSeekBar_nsdk_rangeColor, 0);
        navMultiSeekBar3.defThumbColor = navMultiSeekBar3.a.getColor(R.styleable.NavMultiSeekBar_nsdk_thumbColor, 0);
        Drawable drawable3 = navMultiSeekBar3.defThumbDrawable;
        navMultiSeekBar3.setThumbDrawables(drawable3, navMultiSeekBar3.defRangeDrawable, (Drawable)context, drawable2);
        navMultiSeekBar3.setThumbOffset(navMultiSeekBar3.a.getDimensionPixelOffset(R.styleable.NavMultiSeekBar_android_thumbOffset, this.defThumbDrawable.getIntrinsicWidth() / 2));
        navMultiSeekBar3.repositionThumbs();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context2).getScaledTouchSlop();
        this.a.recycle();
    }

    private void initMultiSlider(int n5) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mStep = 1;
        navMultiSeekBar.mStepsThumbsApart = 0;
        navMultiSeekBar.mDrawThumbsApart = false;
        navMultiSeekBar.mScaleMin = 0;
        navMultiSeekBar.mScaleMax = 100;
        navMultiSeekBar.mMinWidth = 24;
        navMultiSeekBar.mMaxWidth = 48;
        navMultiSeekBar.mMinHeight = 24;
        navMultiSeekBar.mMaxHeight = 48;
        for (int i5 = 0; i5 < n5; ++i5) {
            this.mThumbs.add(new Thumb(this).setMin(this.mScaleMin).setMax(this.mScaleMax).setTag("thumb " + i5));
        }
    }

    private int optThumbValue(Thumb thumb, int n5) {
        if (thumb != null && thumb.getThumb() != null) {
            int n6;
            NavMultiSeekBar navMultiSeekBar = this;
            int n7 = navMultiSeekBar.mThumbs.indexOf(thumb);
            int n8 = n7 + 1;
            if (navMultiSeekBar.mThumbs.size() > n8 && n5 > this.mThumbs.get(n8).getValue() - this.mStepsThumbsApart * this.mStep) {
                n5 = this.mThumbs.get(n8).getValue() - this.mStepsThumbsApart * this.mStep;
            }
            if (n7 > 0 && n5 < this.mThumbs.get(--n7).getValue() + this.mStepsThumbsApart * this.mStep) {
                n5 = this.mThumbs.get(n7).getValue() + this.mStepsThumbsApart * this.mStep;
            }
            if ((n5 - (n7 = this.mScaleMin)) % (n6 = this.mStep) != 0) {
                n5 += n6 - (n5 - n7) % n6;
            }
            if (n5 < thumb.getMin()) {
                n5 = thumb.getMin();
            }
            if (n5 > thumb.getMax()) {
                n5 = thumb.getMax();
            }
            return n5;
        }
        return n5;
    }

    private synchronized void setThumbValue(Thumb thumb, int n5, boolean bl) {
        if (thumb != null && thumb.getThumb() != null) {
            if ((n5 = this.optThumbValue(thumb, n5)) != thumb.getValue()) {
                thumb.value = n5;
            }
            if (this.hasOnThumbValueChangeListener()) {
                n5 = this.mThumbs.indexOf(thumb);
                int n6 = thumb.getValue();
                this.mOnThumbValueChangeListener.onValueChanged(this, thumb, n5, n6);
            }
            NavMultiSeekBar navMultiSeekBar = this;
            int n6 = navMultiSeekBar.getWidth() - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2;
            this.updateThumb(thumb, n6, navMultiSeekBar.getHeight());
            return;
        }
    }

    private synchronized void setThumbValue(int n5, int n6, boolean bl) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.setThumbValue(navMultiSeekBar.mThumbs.get(n5), n6, bl);
    }

    private void updateTrackBounds(int n5, int n6) {
        n5 -= this.getPaddingRight() + this.getPaddingLeft();
        int n7 = n6 - (this.getPaddingTop() + this.getPaddingBottom());
        Drawable drawable2 = this.mTrack;
        if (drawable2 != null) {
            int n8 = n7 / 2;
            n7 = mTrackHeight;
            int n9 = n8 - n7;
            n7 = n8 + n7;
            drawable2.setBounds(0, n9, n5, n7);
        }
    }

    private void updateTrackState() {
        NavMultiSeekBar navMultiSeekBar = this;
        int[] nArray = navMultiSeekBar.getDrawableState();
        Drawable drawable2 = navMultiSeekBar.mTrack;
        if (drawable2 != null && drawable2.isStateful()) {
            this.mTrack.setState(nArray);
        }
    }

    private void setThumbDrawables(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        for (Thumb thumb : this.mThumbs) {
            Drawable drawable6;
            int n7;
            ++n5;
            if (thumb.getThumb() != null && drawable2 != thumb.getThumb()) {
                thumb.getThumb().setCallback(null);
            }
            if (n5 == 1 && drawable4 != null) {
                n7 = this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_range1Color, 0);
                drawable6 = drawable4;
            } else if (n5 == 2 && drawable5 != null) {
                n7 = this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_range2Color, 0);
                drawable6 = drawable5;
            } else {
                n7 = this.defRangeColor;
                drawable6 = drawable3;
            }
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.setRangeDrawable(thumb, drawable6, n7);
            this.setThumbDrawable(thumb, drawable2, navMultiSeekBar.defThumbColor);
            n6 = Math.max(n6, thumb.getThumbOffset());
        }
        NavMultiSeekBar navMultiSeekBar = this;
        int n8 = navMultiSeekBar.getPaddingTop();
        int n9 = navMultiSeekBar.getPaddingBottom();
        navMultiSeekBar.setPadding(n6, n8, n6, n9);
    }

    private void setThumbDrawable(Thumb thumb, Drawable drawable2, int n5) {
        Thumb thumb2 = thumb;
        Drawable drawable3 = drawable2;
        drawable2 = this.getTintedDrawable(drawable2.getConstantState().newDrawable(), n5);
        drawable2.setCallback((Drawable.Callback)this);
        thumb2.setThumbOffset(drawable3.getIntrinsicWidth() / 2);
        if (thumb2.getThumb() != null && (drawable2.getIntrinsicWidth() != thumb.getThumb().getIntrinsicWidth() || drawable2.getIntrinsicHeight() != thumb.getThumb().getIntrinsicHeight())) {
            this.requestLayout();
        }
        thumb.setThumb(drawable2);
        this.invalidate();
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    private void setRangeDrawable(Thumb thumb, Drawable drawable2, int n5) {
        thumb.setRange(this.getTintedDrawable(drawable2, n5));
    }

    private void updateThumb(Thumb thumb, int n5, int n6) {
        Drawable drawable2;
        Drawable drawable3;
        if (thumb == null) {
            return;
        }
        int n7 = thumb.getThumb().getIntrinsicHeight();
        int n8 = n6 - this.getPaddingTop() - this.getPaddingBottom();
        float f6 = this.getScaleSize() > 0 ? (float)thumb.getValue() / (float)this.getScaleSize() : 0.0f;
        Drawable drawable4 = null;
        int n9 = this.mThumbs.indexOf(thumb);
        if (n9 > 0) {
            drawable4 = this.mThumbs.get(n9 - 1).getThumb();
        }
        if (n7 > n8) {
            if (thumb != null) {
                NavMultiSeekBar navMultiSeekBar = this;
                Thumb thumb2 = thumb;
                drawable3 = thumb2.getThumb();
                drawable2 = thumb2.getRange();
                int n10 = navMultiSeekBar.getThumbOptOffset(thumb);
                navMultiSeekBar.setThumbPos(n5, n6, drawable3, drawable4, drawable2, f6, 0, n10);
            }
            int cfr_ignored_0 = (n7 - n8) / 2;
            thumb = this.mTrack;
            if (thumb != null) {
                int n11 = n6 / 2;
                int n12 = mTrackHeight;
                int n13 = n11 - n12;
                n12 = n11 + n12;
                thumb.setBounds(0, n13, n5, n12);
            }
        } else {
            Drawable drawable5 = this.mTrack;
            if (drawable5 != null) {
                int n14 = n6 / 2;
                int n15 = mTrackHeight;
                int n16 = n14 - n15;
                n15 = n14 + n15;
                drawable5.setBounds(0, n16, n5, n15);
            }
            int n17 = (n8 - n7) / 2;
            if (thumb != null) {
                NavMultiSeekBar navMultiSeekBar = this;
                Thumb thumb3 = thumb;
                drawable2 = thumb3.getThumb();
                Drawable drawable6 = thumb3.getRange();
                int n18 = navMultiSeekBar.getThumbOptOffset(thumb);
                navMultiSeekBar.setThumbPos(n5, n6, drawable2, drawable4, drawable6, f6, n17, n18);
            }
        }
        for (int i5 = n9 + 1; i5 < this.mThumbs.size(); ++i5) {
            int n19 = (n8 - n7) / 2;
            float f7 = this.getScaleSize() > 0 ? (float)this.mThumbs.get(i5).getValue() / (float)this.getScaleSize() : 0.0f;
            NavMultiSeekBar navMultiSeekBar = this;
            Drawable drawable7 = navMultiSeekBar.mThumbs.get(i5).getThumb();
            drawable3 = navMultiSeekBar.mThumbs.get(i5 - 1).getThumb();
            drawable2 = navMultiSeekBar.mThumbs.get(i5).getRange();
            int n20 = navMultiSeekBar.getThumbOptOffset(navMultiSeekBar.mThumbs.get(i5));
            this.setThumbPos(n5, n6, drawable7, drawable3, drawable2, f7, n19, n20);
        }
    }

    private void setThumbPos(int n5, int n6, Drawable drawable2, Drawable drawable3, Drawable drawable4, float f6, int n7, int n8) {
        Drawable drawable5 = drawable2;
        n5 = this.getAvailable();
        int n9 = drawable5.getIntrinsicWidth();
        int n10 = drawable5.getIntrinsicHeight();
        float f7 = this.getScaleSize() > 0 ? (float)this.mScaleMin / (float)this.getScaleSize() : 0.0f;
        float f8 = f6;
        f6 = n5;
        int n11 = (int)(f8 * f6 - f7 * f6 + 0.5f);
        if (n7 == Integer.MIN_VALUE) {
            Rect rect = drawable2.getBounds();
            n7 = rect.top;
            n10 = rect.bottom;
        } else {
            n10 = n7 + n10;
        }
        n11 = this.isLayoutRtl() && this.mMirrorForRtl ? n5 - n11 + n8 : (n11 += n8);
        NavMultiSeekBar navMultiSeekBar = this;
        int n12 = n11;
        drawable2.setBounds(n12, n7, n12 + n9, n10);
        navMultiSeekBar.getPaddingTop();
        navMultiSeekBar.getPaddingBottom();
        int n13 = 0;
        if (navMultiSeekBar.isLayoutRtl() && this.mMirrorForRtl) {
            n13 = n5;
        }
        if (drawable3 != null) {
            n13 = drawable3.getBounds().left;
        }
        if (drawable4 != null) {
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                int n14 = n6 / 2;
                n5 = mTrackHeight;
                n6 = n14 - n5;
                n5 = n14 + n5;
                drawable4.setBounds(n11, n6, n13 += n8, n5);
            } else {
                int n15 = n6 / 2;
                n5 = mTrackHeight;
                n6 = n15 - n5;
                n5 = n15 + n5;
                drawable4.setBounds(n13, n6, n11, n5);
            }
        }
        this.invalidate();
    }

    private int getAvailable() {
        NavMultiSeekBar navMultiSeekBar = this;
        int n5 = navMultiSeekBar.getWidth() - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2;
        LinkedList<Thumb> linkedList = navMultiSeekBar.mThumbs;
        if (linkedList != null && linkedList.size() > 0) {
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                NavMultiSeekBar navMultiSeekBar2 = this;
                n5 -= navMultiSeekBar2.getThumbOptOffset(navMultiSeekBar2.mThumbs.getFirst());
            } else {
                NavMultiSeekBar navMultiSeekBar3 = this;
                n5 -= navMultiSeekBar3.getThumbOptOffset(navMultiSeekBar3.mThumbs.getLast());
            }
        }
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<Thumb> getClosestThumb(int var1_1) {
        v0 = this;
        var2_2 = v1;
        v1 = new LinkedList<Thumb>();
        var3_3 = null;
        var4_4 = v0.getAvailable() + 1;
        for (Thumb var6_6 : v0.mThumbs) {
            block6: {
                block5: {
                    block4: {
                        if (var6_6.getThumb() == null || !var6_6.isEnabled() || this.mDraggingThumbs.contains(var6_6)) continue;
                        var7_7 = var1_1 - var6_6.getThumb().getIntrinsicWidth();
                        var8_8 = var1_1 + var6_6.getThumb().getIntrinsicWidth();
                        if (var6_6.getThumb().getBounds().centerX() < var7_7 || var6_6.getThumb().getBounds().centerX() > var8_8) break block4;
                        var2_2.add(var6_6);
                        ** GOTO lbl-1000
                    }
                    if (Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1) > var4_4) ** GOTO lbl-1000
                    if (Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1) != var4_4) break block5;
                    if (var1_1 <= this.getWidth() / 2) ** GOTO lbl-1000
                    break block6;
                }
                if (var6_6.getThumb() != null) {
                    var4_4 = Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1);
                } else lbl-1000:
                // 4 sources

                {
                    var6_6 = var3_3;
                }
            }
            var3_3 = var6_6;
        }
        if (var2_2.isEmpty() && var3_3 != null) {
            var2_2.add(var3_3);
        }
        return var2_2;
    }

    private Thumb getMostMovable(LinkedList<Thumb> linkedList, MotionEvent motionEvent) {
        Thumb thumb = null;
        int n5 = 0;
        if (linkedList != null && !linkedList.isEmpty()) {
            if (linkedList.getFirst().getValue() == this.getValue(motionEvent, linkedList.getFirst())) {
                return null;
            }
            for (Thumb thumb2 : linkedList) {
                if (thumb2.getThumb() == null || !thumb2.isEnabled() || this.mDraggingThumbs.contains(thumb2)) continue;
                int n6 = this.getValue(motionEvent, linkedList.getFirst()) > thumb2.getValue() ? this.mScaleMax : this.mScaleMin;
                n6 = Math.abs(thumb2.getValue() - this.optThumbValue(thumb2, n6));
                if (n6 <= n5) {
                    n6 = n5;
                    thumb2 = thumb;
                }
                n5 = n6;
                thumb = thumb2;
            }
        }
        return thumb;
    }

    private Thumb getMostMovableThumb(MotionEvent motionEvent) {
        LinkedList<Thumb> linkedList = this.exactTouched;
        if (linkedList != null && linkedList.size() >= 1) {
            if (this.exactTouched.size() == 1) {
                return this.exactTouched.getFirst();
            }
            NavMultiSeekBar navMultiSeekBar = this;
            return navMultiSeekBar.getMostMovable(navMultiSeekBar.exactTouched, motionEvent);
        }
        return null;
    }

    private int getValue(MotionEvent motionEvent, Thumb thumb) {
        MotionEvent motionEvent2 = motionEvent;
        return this.getValue(motionEvent2, motionEvent2.getActionIndex(), thumb);
    }

    private void setHotspot(float f6, float f7, Thumb thumb) {
        if (thumb != null && thumb.getThumb() != null) {
            Drawable drawable2 = this.getBackground();
            if (Build.VERSION.SDK_INT >= 21 && drawable2 != null) {
                drawable2.setHotspot(f6, f7);
                Rect rect = thumb.getThumb().getBounds();
                int n5 = this.getPaddingTop();
                int n6 = rect.left;
                int n7 = rect.top + n5;
                int n8 = rect.right;
                n5 = rect.bottom + n5;
                drawable2.setHotspotBounds(n6, n7, n8, n5);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getValue(MotionEvent motionEvent, int n5, Thumb thumb) {
        float f6;
        float f7;
        block8: {
            int n6;
            int n7;
            int n8;
            block9: {
                block7: {
                    block6: {
                        NavMultiSeekBar navMultiSeekBar = this;
                        int n9 = n5;
                        NavMultiSeekBar navMultiSeekBar2 = this;
                        n8 = navMultiSeekBar2.getWidth();
                        n5 = navMultiSeekBar2.getAvailable();
                        n7 = this.getThumbOptOffset(thumb);
                        n6 = (int)motionEvent.getX(n9);
                        f7 = navMultiSeekBar.mScaleMin;
                        if (!navMultiSeekBar.isLayoutRtl() || !this.mMirrorForRtl) break block6;
                        if (n6 > n8 - this.getPaddingRight()) break block7;
                        if (n6 >= this.getPaddingLeft()) {
                            f6 = (float)(n5 - n6 + this.getPaddingLeft() + n7) / (float)n5;
                            f7 = this.mScaleMin;
                            return Math.round(f7 + f6 * (float)this.getScaleSize());
                        }
                        break block8;
                    }
                    if (n6 >= this.getPaddingLeft()) break block9;
                }
                f6 = 0.0f;
                return Math.round(f7 + f6 * (float)this.getScaleSize());
            }
            if (n6 <= n8 - this.getPaddingRight()) {
                f6 = (float)(n6 - this.getPaddingLeft() - n7) / (float)n5;
                f7 = this.mScaleMin;
                return Math.round(f7 + f6 * (float)this.getScaleSize());
            }
        }
        f6 = 1.0f;
        return Math.round(f7 + f6 * (float)this.getScaleSize());
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    private boolean hasOnThumbValueChangeListener() {
        return this.mOnThumbValueChangeListener != null;
    }

    private Drawable getTintedDrawable(Drawable drawable2, int n5) {
        if (drawable2 != null && n5 != 0) {
            Drawable drawable3 = DrawableCompat.wrap((Drawable)drawable2.mutate());
            DrawableCompat.setTint((Drawable)drawable3, (int)n5);
            return drawable3;
        }
        return drawable2;
    }

    public int getStepsThumbsApart() {
        return this.mStepsThumbsApart;
    }

    public void setStepsThumbsApart(int n5) {
        if (n5 < 0) {
            n5 = 0;
        }
        this.mStepsThumbsApart = n5;
    }

    public int getStep() {
        return this.mStep;
    }

    public void setStep(int n5) {
        this.mStep = n5;
    }

    public int getScaleSize() {
        return this.mScaleMax - this.mScaleMin;
    }

    public void repositionThumbs() {
        LinkedList<Thumb> linkedList = this.mThumbs;
        if (linkedList != null && !linkedList.isEmpty()) {
            if (this.mThumbs.size() > 0) {
                this.mThumbs.getFirst().setValue(this.mScaleMin);
            }
            if (this.mThumbs.size() > 1) {
                this.mThumbs.getLast().setValue(this.mScaleMax);
            }
            if (this.mThumbs.size() > 2) {
                NavMultiSeekBar navMultiSeekBar = this;
                int n5 = (navMultiSeekBar.mScaleMax - this.mScaleMin) / (this.mThumbs.size() - 1);
                int n6 = navMultiSeekBar.mScaleMax - n5;
                for (int i5 = (v627318).mThumbs.size() - 2; i5 > 0; --i5) {
                    this.mThumbs.get(i5).setValue(n6);
                    n6 -= n5;
                }
            }
            return;
        }
    }

    public void setOnThumbValueChangeListener(OnThumbValueChangeListener onThumbValueChangeListener) {
        this.mOnThumbValueChangeListener = onThumbValueChangeListener;
    }

    public boolean isDrawThumbsApart() {
        return this.mDrawThumbsApart;
    }

    public void setDrawThumbsApart(boolean bl) {
        this.mDrawThumbsApart = bl;
    }

    public NavMultiSeekBar setNumberOfThumbs(int n5) {
        return this.setNumberOfThumbs(n5, true);
    }

    public NavMultiSeekBar setNumberOfThumbs(int n5, boolean bl) {
        this.clearThumbs();
        for (int i5 = 0; i5 < n5; ++i5) {
            this.addThumb(0);
        }
        if (bl) {
            this.repositionThumbs();
        }
        return this;
    }

    public boolean addThumb(Thumb thumb) {
        return this.addThumbOnPos(thumb, this.mThumbs.size());
    }

    public boolean addThumbOnPos(Thumb thumb, int n5) {
        int n6;
        if (this.mThumbs.contains(thumb)) {
            return false;
        }
        if (thumb.getThumb() == null) {
            NavMultiSeekBar navMultiSeekBar = this;
            Drawable drawable2 = navMultiSeekBar.defThumbDrawable;
            n6 = navMultiSeekBar.defThumbColor;
            navMultiSeekBar.setThumbDrawable(thumb, drawable2, n6);
        }
        NavMultiSeekBar navMultiSeekBar = this;
        int n7 = Math.max(navMultiSeekBar.getPaddingLeft(), thumb.getThumbOffset());
        n6 = Math.max(navMultiSeekBar.getPaddingRight(), thumb.getThumbOffset());
        int n8 = navMultiSeekBar.getPaddingTop();
        int n9 = navMultiSeekBar.getPaddingBottom();
        navMultiSeekBar.setPadding(n7, n8, n6, n9);
        if (thumb.getRange() == null) {
            NavMultiSeekBar navMultiSeekBar2 = this;
            Drawable drawable3 = navMultiSeekBar2.defRangeDrawable;
            n6 = navMultiSeekBar2.defRangeColor;
            navMultiSeekBar2.setRangeDrawable(thumb, drawable3, n6);
        }
        Thumb thumb2 = thumb;
        this.mThumbs.add(n5, thumb);
        this.setThumbValue(thumb2, thumb2.value, false);
        return true;
    }

    public Thumb addThumb(int n5) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumb(thumb2);
        thumb.setValue(n5);
        return thumb;
    }

    public Thumb addThumb() {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumb(thumb2);
        return thumb;
    }

    public Thumb addThumbOnPos(int n5, int n6) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumbOnPos(thumb2, n5);
        thumb.setValue(n6);
        return thumb;
    }

    public Thumb addThumbOnPos(int n5) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumbOnPos(thumb2, n5);
        return thumb;
    }

    public boolean removeThumb(Thumb thumb) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mDraggingThumbs.remove(thumb);
        boolean bl = navMultiSeekBar.mThumbs.remove(thumb);
        this.invalidate();
        return bl;
    }

    public Thumb removeThumb(int n5) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mDraggingThumbs.remove(this.mThumbs.get(n5));
        navMultiSeekBar.invalidate();
        this.invalidate();
        return navMultiSeekBar.mThumbs.remove(n5);
    }

    public void clearThumbs() {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mThumbs.clear();
        navMultiSeekBar.mDraggingThumbs.clear();
        navMultiSeekBar.invalidate();
    }

    public void setThumbOffset(int n5) {
        Iterator iterator = this.mThumbs.iterator();
        while (iterator.hasNext()) {
            ((Thumb)iterator.next()).setThumbOffset(n5);
        }
        this.invalidate();
    }

    public void setTrackDrawable(Drawable drawable2) {
        boolean bl;
        Drawable drawable3 = this.mTrack;
        if (drawable3 != null && drawable2 != drawable3) {
            drawable3.setCallback(null);
            bl = true;
        } else {
            bl = false;
        }
        if (drawable2 != null) {
            Drawable drawable4 = drawable2;
            drawable4.setCallback((Drawable.Callback)this);
            int n5 = drawable4.getMinimumHeight();
            if (this.mMaxHeight < n5) {
                this.mMaxHeight = n5;
                this.requestLayout();
            }
        }
        this.mTrack = drawable2;
        if (bl) {
            NavMultiSeekBar navMultiSeekBar = this;
            int n6 = navMultiSeekBar.getWidth();
            navMultiSeekBar.updateTrackBounds(n6, navMultiSeekBar.getHeight());
            navMultiSeekBar.updateTrackState();
        }
    }

    public Thumb getThumb(int n5) {
        return this.mThumbs.get(n5);
    }

    public void setKeyProgressIncrement(int n5) {
        if (n5 < 0) {
            n5 = -n5;
        }
        this.mKeyProgressIncrement = n5;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public synchronized void setMax(int n5) {
        this.setMax(n5, true, false);
    }

    public synchronized void setMax(int n5, boolean bl) {
        this.setMax(n5, bl, false);
    }

    public synchronized void setMax(int n5, boolean bl, boolean bl2) {
        if (n5 >= this.mScaleMin) {
            if (n5 != this.mScaleMax) {
                this.mScaleMax = n5;
                for (Thumb thumb : this.mThumbs) {
                    if (bl) {
                        thumb.setMax(n5);
                    } else if (thumb.getMax() > n5) {
                        thumb.setMax(n5);
                    }
                    if (thumb.getValue() <= n5) continue;
                    this.setThumbValue(thumb, n5, false);
                }
                if (bl2) {
                    this.repositionThumbs();
                }
                this.postInvalidate();
            }
            if ((n5 = this.mKeyProgressIncrement) == 0 || this.mScaleMax / n5 > 20) {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.setKeyProgressIncrement(Math.max(1, Math.round((float)navMultiSeekBar.mScaleMax / 20.0f)));
            }
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n5;
        objectArray[1] = this.mScaleMin;
        throw new IllegalArgumentException(String.format("setMax(%d) < Min(%d)", objectArray2));
    }

    public int getMax() {
        return this.mScaleMax;
    }

    public synchronized void setMin(int n5) {
        this.setMin(n5, true, false);
    }

    public synchronized void setMin(int n5, boolean bl) {
        this.setMin(n5, bl, false);
    }

    public synchronized void setMin(int n5, boolean bl, boolean bl2) {
        if (n5 <= this.mScaleMax) {
            if (n5 != this.mScaleMin) {
                this.mScaleMin = n5;
                for (Thumb thumb : this.mThumbs) {
                    if (bl) {
                        thumb.setMin(n5);
                    } else if (thumb.getMin() < n5) {
                        thumb.setMin(n5);
                    }
                    if (thumb.getValue() >= n5) continue;
                    this.setThumbValue(thumb, n5, false);
                }
                if (bl2) {
                    this.repositionThumbs();
                }
                this.postInvalidate();
            }
            if ((n5 = this.mKeyProgressIncrement) == 0 || this.mScaleMax / n5 > 20) {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.setKeyProgressIncrement(Math.max(1, Math.round((float)navMultiSeekBar.mScaleMax / 20.0f)));
            }
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n5;
        objectArray[1] = this.mScaleMax;
        throw new IllegalArgumentException(String.format("setMin(%d) > Max(%d)", objectArray2));
    }

    public int getMin() {
        return this.mScaleMin;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || drawable2 != thumb.getThumb()) continue;
            return true;
        }
        return drawable2 == this.mTrack || super.verifyDrawable(drawable2);
    }

    public void jumpDrawablesToCurrentState() {
        NavMultiSeekBar navMultiSeekBar = this;
        super.jumpDrawablesToCurrentState();
        for (Thumb thumb : navMultiSeekBar.mThumbs) {
            if (thumb.getThumb() == null) continue;
            thumb.getThumb().jumpToCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void drawableStateChanged() {
        v0 = this;
        var1_1 = v0.mDraggingThumbs;
        synchronized (var1_1) {
            if (v0.mDraggingThumbs.isEmpty()) ** GOTO lbl46
            v1 = this;
            v2 = v1;
            var2_2 = v1.getDrawableState();
            var3_4 = v2.mDraggingThumbs.iterator();
            while (true) {
                if (!var3_4.hasNext()) break;
                var4_6 = var3_4.next();
                if (var4_6.getThumb() == null) continue;
                var4_6.getThumb().setState((int[])var2_2);
            }
            var2_2 = this.mThumbs.iterator();
            block26: while (true) {
                if (!var2_2.hasNext()) ** GOTO lbl65
                v3 = this;
                var3_4 = (Thumb)var2_2.next();
                if (v3.mDraggingThumbs.contains(var3_4)) continue;
                if (var3_4.getThumb() == null) continue;
                if (!var3_4.getThumb().isStateful()) continue;
                if (!var3_4.isEnabled()) break;
                v4 = var3_4.getThumb().setState(new int[]{16842910, -16842919});
lbl41:
                // 2 sources

                continue block26;
                break;
            }
            v4 = var3_4.getThumb().setState(new int[]{-16842910});
            ** continue;
lbl46:
            // 1 sources

            var2_3 = this.mThumbs.iterator();
            block28: while (true) {
                if (!var2_3.hasNext()) ** GOTO lbl65
                var3_5 = (Thumb)var2_3.next();
                if (var3_5.getThumb() == null) continue;
                if (!var3_5.getThumb().isStateful()) continue;
                if (!var3_5.isEnabled()) break;
                v5 = var3_5.getThumb().setState(new int[]{16842910, -16842919});
lbl60:
                // 2 sources

                continue block28;
                break;
            }
            v5 = var3_5.getThumb().setState(new int[]{-16842910});
            ** continue;
lbl65:
            // 2 sources

            // MONITOREXIT @DISABLED, blocks:[22, 23] lbl65 : MonitorExitStatement: MONITOREXIT : var1_1
            super.drawableStateChanged();
            return;
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        NavMultiSeekBar navMultiSeekBar = this;
        super.onDraw(canvas);
        int n5 = JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp);
        if (navMultiSeekBar.mTrack != null) {
            canvas.save();
            canvas.translate((float)n5, (float)this.getPaddingTop());
            this.mTrack.draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getRange() == null) continue;
            canvas.save();
            canvas.translate((float)n5, (float)(this.getPaddingTop() - this.getPaddingBottom()));
            thumb.getRange().draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || thumb.isInvisibleThumb()) continue;
            canvas.save();
            canvas.translate((float)(n5 - thumb.getThumbOffset()), (float)this.getPaddingTop());
            thumb.getThumb().draw(canvas);
            canvas.restore();
        }
    }

    protected synchronized void onMeasure(int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null) continue;
            Thumb thumb2 = thumb;
            n7 = Math.max(thumb2.getThumb().getIntrinsicHeight(), n7);
            n8 = Math.max(thumb2.getThumb().getIntrinsicHeight(), n8);
        }
        int n9 = 0;
        int n10 = 0;
        Drawable drawable2 = this.mTrack;
        if (drawable2 != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            n9 = Math.max(navMultiSeekBar.mMinWidth, Math.min(this.mMaxWidth, drawable2.getIntrinsicWidth()));
            n10 = Math.max(n7, Math.max(n8, Math.max(navMultiSeekBar.mMinHeight, Math.min(this.mMaxHeight, this.mTrack.getIntrinsicHeight()))));
        }
        n7 = n9 + (this.getPaddingLeft() + this.getPaddingRight());
        int n11 = View.resolveSizeAndState((int)n7, (int)n5, (int)0);
        this.setMeasuredDimension(n11, View.resolveSizeAndState((int)(n10 + (this.getPaddingTop() + this.getPaddingBottom())), (int)n6, (int)0));
    }

    public boolean isInScrollingContainer() {
        for (NavMultiSeekBar navMultiSeekBar = navMultiSeekBar.getParent(); navMultiSeekBar != null && navMultiSeekBar instanceof ViewGroup; navMultiSeekBar = navMultiSeekBar.getParent()) {
            if (!((ViewGroup)navMultiSeekBar).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        LinkedList<Thumb> linkedList;
        if (!this.isEnabled()) {
            return false;
        }
        MotionEvent motionEvent2 = motionEvent;
        int n5 = Math.round(motionEvent2.getX());
        int n6 = Math.round(motionEvent2.getY());
        int n7 = motionEvent2.getActionIndex();
        Thumb thumb = null;
        if (motionEvent2.getActionMasked() != 0 && motionEvent.getActionMasked() != 5) {
            if (motionEvent.getActionMasked() == 2) {
                linkedList = this.exactTouched;
                if (linkedList != null && !linkedList.isEmpty()) {
                    thumb = this.getMostMovableThumb(motionEvent);
                } else if (this.mDraggingThumbs.size() > n7) {
                    thumb = this.mDraggingThumbs.get(n7);
                }
            } else if (motionEvent.getActionMasked() == 1 || motionEvent.getActionMasked() == 6) {
                if (this.mDraggingThumbs.size() > n7) {
                    thumb = this.mDraggingThumbs.get(n7);
                } else {
                    linkedList = this.exactTouched;
                    if (linkedList != null && linkedList.size() > 0) {
                        thumb = this.getMostMovableThumb(motionEvent);
                        this.exactTouched = null;
                    }
                }
            }
        } else {
            LinkedList<Thumb> linkedList2;
            NavMultiSeekBar navMultiSeekBar = this;
            linkedList = navMultiSeekBar.getClosestThumb((int)motionEvent.getX(n7));
            if (navMultiSeekBar.isInScrollingContainer() && this.mDraggingThumbs.size() == 0 && (linkedList2 = this.exactTouched) != null && n7 > 0) {
                this.onStartTrackingTouch(linkedList2.getFirst());
                this.exactTouched = null;
            }
            if (linkedList != null && !linkedList.isEmpty()) {
                if (linkedList.size() == 1) {
                    thumb = linkedList.getFirst();
                    if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                        this.exactTouched = linkedList;
                    }
                } else {
                    this.exactTouched = linkedList;
                }
            }
        }
        switch (motionEvent.getActionMasked()) {
            default: {
                break;
            }
            case 3: {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStopTrackingTouch();
                navMultiSeekBar.invalidate();
                break;
            }
            case 2: {
                if (this.mDraggingThumbs.contains(thumb)) {
                    for (n7 = 0; n7 < this.mDraggingThumbs.size(); ++n7) {
                        if (this.mDraggingThumbs.get(n7) != null && this.mDraggingThumbs.get(n7).getThumb() != null) {
                            NavMultiSeekBar navMultiSeekBar = this;
                            navMultiSeekBar.invalidate(navMultiSeekBar.mDraggingThumbs.get(n7).getThumb().getBounds());
                        }
                        NavMultiSeekBar navMultiSeekBar = this;
                        NavMultiSeekBar navMultiSeekBar2 = this;
                        linkedList = navMultiSeekBar2.mDraggingThumbs.get(n7);
                        navMultiSeekBar.setThumbValue((Thumb)((Object)linkedList), navMultiSeekBar.getValue(motionEvent, n7, navMultiSeekBar2.mDraggingThumbs.get(n7)), true);
                    }
                    float f6 = n5;
                    this.setHotspot(f6, n6, thumb);
                    break;
                }
                if (!(Math.abs(motionEvent.getX(n7) - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStartTrackingTouch(thumb);
                navMultiSeekBar.exactTouched = null;
                navMultiSeekBar.setThumbValue(thumb, navMultiSeekBar.getValue(motionEvent, thumb), true);
                float f7 = n5;
                this.setHotspot(f7, n6, thumb);
                break;
            }
            case 1: 
            case 6: {
                if (thumb != null) {
                    NavMultiSeekBar navMultiSeekBar = this;
                    this.setThumbValue(thumb, this.getValue(motionEvent, thumb), true);
                    float f8 = n5;
                    navMultiSeekBar.setHotspot(f8, n6, thumb);
                    if (!navMultiSeekBar.isPressed()) {
                        this.setPressed(true);
                    }
                    this.onStopTrackingTouch(thumb);
                }
                this.invalidate();
                break;
            }
            case 0: 
            case 5: {
                if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                    this.mTouchDownX = motionEvent.getX(n7);
                    break;
                }
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStartTrackingTouch(thumb);
                navMultiSeekBar.setThumbValue(thumb, navMultiSeekBar.getValue(motionEvent, thumb), true);
                float f9 = n5;
                this.setHotspot(f9, n6, thumb);
            }
        }
        return true;
    }

    int getThumbOptOffset(Thumb thumb) {
        if (!this.mDrawThumbsApart) {
            return 0;
        }
        if (thumb != null && thumb.getThumb() != null) {
            int n5;
            NavMultiSeekBar navMultiSeekBar = this;
            int n6 = navMultiSeekBar.mThumbs.indexOf(thumb);
            if (navMultiSeekBar.isLayoutRtl() && this.mMirrorForRtl) {
                int n7;
                if (n6 == this.mThumbs.size() - 1) {
                    n7 = 0;
                } else {
                    NavMultiSeekBar navMultiSeekBar2 = this;
                    n7 = navMultiSeekBar2.getThumbOptOffset(navMultiSeekBar2.mThumbs.get(n6 + 1)) + thumb.getThumb().getIntrinsicWidth();
                }
                return n7;
            }
            if (n6 == 0) {
                n5 = 0;
            } else {
                NavMultiSeekBar navMultiSeekBar3 = this;
                n5 = navMultiSeekBar3.getThumbOptOffset(navMultiSeekBar3.mThumbs.get(n6 - 1)) + thumb.getThumb().getIntrinsicWidth();
            }
            return n5;
        }
        return 0;
    }

    void onStartTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.mDraggingThumbs.add(thumb);
            if (navMultiSeekBar.isPressed()) {
                this.drawableStateChanged();
            } else {
                this.setPressed(true);
            }
            if (thumb.getThumb() != null) {
                this.invalidate(thumb.getThumb().getBounds());
            }
            this.attemptClaimDrag();
        }
    }

    void onStopTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.mDraggingThumbs.remove(thumb);
            if (navMultiSeekBar.mDraggingThumbs.size() == 0) {
                this.setPressed(false);
            } else {
                this.drawableStateChanged();
            }
        }
    }

    void onStopTrackingTouch() {
        for (Thumb thumb : this.mDraggingThumbs) {
            this.mDraggingThumbs.remove(thumb);
        }
        this.setPressed(false);
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider == null) {
            VirtualTreeProvider virtualTreeProvider;
            VirtualTreeProvider virtualTreeProvider2 = virtualTreeProvider;
            virtualTreeProvider = new VirtualTreeProvider();
            this.mAccessibilityNodeProvider = virtualTreeProvider2;
        }
        return this.mAccessibilityNodeProvider;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)NavMultiSeekBar.class.getName());
    }

    public void onRtlPropertiesChanged(int n5) {
        if (Build.VERSION.SDK_INT >= 17) {
            NavMultiSeekBar navMultiSeekBar = this;
            super.onRtlPropertiesChanged(n5);
            navMultiSeekBar.invalidate();
        }
    }

    public boolean isLayoutRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.getLayoutDirection() == 1;
        }
        return false;
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.updateTrackBounds(n5, n6);
        for (Thumb thumb : navMultiSeekBar.mThumbs) {
            this.updateThumb(thumb, n5 - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2, n6);
        }
    }

    @TargetApi(value=16)
    class VirtualTreeProvider
    extends AccessibilityNodeProvider {
        static final int ACT_SET_PROGRESS = 16908349;
        final AccessibilityNodeInfo.AccessibilityAction ACTION_SET_PROGRESS;

        public VirtualTreeProvider() {
            if (Build.VERSION.SDK_INT >= 21) {
                AccessibilityNodeInfo.AccessibilityAction accessibilityAction;
                VirtualTreeProvider virtualTreeProvider = virtualTreeProvider2;
                VirtualTreeProvider virtualTreeProvider2 = accessibilityAction;
                accessibilityAction = new AccessibilityNodeInfo.AccessibilityAction(16908349, null);
                virtualTreeProvider.ACTION_SET_PROGRESS = virtualTreeProvider2;
            } else {
                virtualTreeProvider2.ACTION_SET_PROGRESS = null;
            }
        }

        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n5) {
            AccessibilityNodeInfo accessibilityNodeInfo;
            if (n5 == -1) {
                VirtualTreeProvider virtualTreeProvider = object;
                AccessibilityNodeInfo accessibilityNodeInfo2 = AccessibilityNodeInfo.obtain((View)virtualTreeProvider.NavMultiSeekBar.this);
                virtualTreeProvider.NavMultiSeekBar.this.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo2);
                int n6 = virtualTreeProvider.NavMultiSeekBar.this.mThumbs.size();
                for (int i5 = 0; i5 < n6; ++i5) {
                    accessibilityNodeInfo2.addChild((View)object.NavMultiSeekBar.this, i5);
                }
                if (object.NavMultiSeekBar.this.mThumbs.size() == 1) {
                    accessibilityNodeInfo2.setScrollable(true);
                    if (Build.VERSION.SDK_INT >= 21) {
                        AccessibilityNodeInfo accessibilityNodeInfo3 = accessibilityNodeInfo2;
                        accessibilityNodeInfo3.addAction(object.ACTION_SET_PROGRESS);
                        accessibilityNodeInfo3.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                        accessibilityNodeInfo3.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    } else {
                        AccessibilityNodeInfo accessibilityNodeInfo4 = accessibilityNodeInfo2;
                        accessibilityNodeInfo4.addAction(8192);
                        accessibilityNodeInfo4.addAction(4096);
                    }
                }
                accessibilityNodeInfo = accessibilityNodeInfo2;
            } else {
                Thumb thumb = (Thumb)object.NavMultiSeekBar.this.mThumbs.get(n5);
                if (thumb == null) {
                    return null;
                }
                accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)object.NavMultiSeekBar.this, (int)n5);
                accessibilityNodeInfo.setClassName((CharSequence)thumb.getClass().getName());
                accessibilityNodeInfo.setParent((View)object.NavMultiSeekBar.this);
                accessibilityNodeInfo.setSource((View)object.NavMultiSeekBar.this, n5);
                accessibilityNodeInfo.setContentDescription((CharSequence)("Multi-Slider thumb no:" + n5));
                if (Build.VERSION.SDK_INT >= 21) {
                    accessibilityNodeInfo.addAction(object.ACTION_SET_PROGRESS);
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    }
                } else {
                    if (thumb.getPossibleMin() > thumb.value) {
                        accessibilityNodeInfo.addAction(8192);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(4096);
                    }
                }
                if (thumb.getThumb() != null) {
                    VirtualTreeProvider virtualTreeProvider = object;
                    Object object = new int[2];
                    virtualTreeProvider.NavMultiSeekBar.this.getLocationOnScreen((int[])object);
                    Rect rect = thumb.getThumb().copyBounds();
                    rect.top += object[1];
                    rect.left += object[0];
                    rect.right += object[0];
                    rect.bottom += object[1];
                    accessibilityNodeInfo.setBoundsInScreen(rect);
                }
                accessibilityNodeInfo.setText((CharSequence)(thumb.tag + ": " + thumb.value));
                accessibilityNodeInfo.setEnabled(thumb.isEnabled());
                if (Build.VERSION.SDK_INT >= 24) {
                    accessibilityNodeInfo.setImportantForAccessibility(true);
                }
                AccessibilityNodeInfo accessibilityNodeInfo5 = accessibilityNodeInfo;
                accessibilityNodeInfo5.setVisibleToUser(true);
                accessibilityNodeInfo5.setScrollable(true);
            }
            return accessibilityNodeInfo;
        }

        public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2, int n5) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return Collections.emptyList();
            }
            string2 = string2.toLowerCase();
            ArrayList<AccessibilityNodeInfo> arrayList = null;
            if (n5 == -1) {
                n5 = NavMultiSeekBar.this.mThumbs.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    if (!((Thumb)((NavMultiSeekBar)NavMultiSeekBar.this).mThumbs.get((int)i5)).tag.toLowerCase().contains(string2)) continue;
                    if (arrayList == null) {
                        ArrayList<AccessibilityNodeInfo> arrayList2;
                        arrayList = arrayList2;
                        arrayList2 = new ArrayList<AccessibilityNodeInfo>();
                    }
                    arrayList.add(this.createAccessibilityNodeInfo(i5));
                }
            } else {
                Thumb thumb = (Thumb)NavMultiSeekBar.this.mThumbs.get(n5);
                if (thumb != null && thumb.tag.toLowerCase().contains(string2)) {
                    ArrayList<AccessibilityNodeInfo> arrayList3;
                    arrayList = arrayList3;
                    arrayList();
                    arrayList3.add(this.createAccessibilityNodeInfo(n5));
                }
            }
            if (arrayList == null) {
                return Collections.emptyList();
            }
            return arrayList;
        }

        public AccessibilityNodeInfo findFocus(int n5) {
            return super.findFocus(n5);
        }

        public boolean performAction(int n5, int n6, Bundle bundle) {
            if (n5 == -1) {
                return false;
            }
            if (n5 >= NavMultiSeekBar.this.mThumbs.size()) {
                return false;
            }
            Thumb thumb = (Thumb)NavMultiSeekBar.this.mThumbs.get(n5);
            if (thumb == null) {
                return false;
            }
            if (n6 != 4096) {
                if (n6 != 8192) {
                    if (n6 != 16908349) {
                        return false;
                    }
                    thumb.setValue(bundle.getInt("value"));
                    return true;
                }
                Thumb thumb2 = thumb;
                thumb2.setValue(thumb2.value - NavMultiSeekBar.this.getStep());
                return true;
            }
            Thumb thumb3 = thumb;
            thumb3.setValue(thumb3.value + NavMultiSeekBar.this.getStep());
            return true;
        }
    }

    public static class SimpleChangeListener
    implements OnThumbValueChangeListener {
        @Override
        public void onValueChanged(NavMultiSeekBar navMultiSeekBar, Thumb thumb, int n5, int n6) {
        }
    }

    public class Thumb {
        int min;
        int max;
        int value;
        String tag;
        Drawable thumb;
        Drawable range;
        int thumbOffset;
        private boolean isInvisible;
        private boolean isEnabled;
        final /* synthetic */ NavMultiSeekBar this$0;

        public Thumb(NavMultiSeekBar navMultiSeekBar) {
            int n5;
            Thumb thumb = this;
            this.this$0 = navMultiSeekBar;
            this.tag = "thumb";
            this.isInvisible = false;
            this.isEnabled = true;
            this.min = navMultiSeekBar.mScaleMin;
            thumb.max = n5 = navMultiSeekBar.mScaleMax;
            thumb.value = n5;
        }

        public Drawable getRange() {
            return this.range;
        }

        public final Thumb setRange(Drawable drawable2) {
            this.range = drawable2;
            return this;
        }

        public boolean isEnabled() {
            return !this.isInvisibleThumb() && this.isEnabled;
        }

        public Thumb setEnabled(boolean bl) {
            this.isEnabled = bl;
            if (this.getThumb() != null) {
                if (this.isEnabled()) {
                    this.getThumb().setState(new int[]{16842910});
                } else {
                    this.getThumb().setState(new int[]{-16842910});
                }
            }
            return this;
        }

        public boolean isInvisibleThumb() {
            return this.isInvisible;
        }

        public void setInvisibleThumb(boolean bl) {
            this.isInvisible = bl;
        }

        public int getPossibleMin() {
            return this.min + this.this$0.mThumbs.indexOf(this) * this.this$0.mStepsThumbsApart;
        }

        public int getPossibleMax() {
            return this.max - (this.this$0.mThumbs.size() - 1 - this.this$0.mThumbs.indexOf(this)) * this.this$0.mStepsThumbsApart;
        }

        public int getMin() {
            return this.min;
        }

        public Thumb setMin(int n5) {
            int n6 = this.max;
            if (n5 <= n6) {
                n6 = n5;
            }
            if (n6 < this.this$0.mScaleMin) {
                n6 = this.this$0.mScaleMin;
            }
            if (this.min != n6) {
                this.min = n6;
                if (this.value < n6) {
                    this.value = n6;
                    this.this$0.invalidate();
                }
            }
            return this;
        }

        public int getMax() {
            return this.max;
        }

        public Thumb setMax(int n5) {
            int n6 = this.min;
            if (n5 >= n6) {
                n6 = n5;
            }
            if (n6 > this.this$0.mScaleMax) {
                n6 = this.this$0.mScaleMax;
            }
            if (this.max != n6) {
                this.max = n6;
                if (this.value > n6) {
                    this.value = n6;
                    this.this$0.invalidate();
                }
            }
            return this;
        }

        public int getValue() {
            return this.value;
        }

        public Thumb setValue(int n5) {
            if (this.this$0.mThumbs.contains(this)) {
                this.this$0.setThumbValue(this, n5, false);
            } else {
                this.value = n5;
            }
            return this;
        }

        public String getTag() {
            return this.tag;
        }

        public Thumb setTag(String string2) {
            this.tag = string2;
            return this;
        }

        public Drawable getThumb() {
            return this.thumb;
        }

        public Thumb setThumb(Drawable drawable2) {
            this.thumb = drawable2;
            return this;
        }

        public int getThumbOffset() {
            return this.thumbOffset;
        }

        public Thumb setThumbOffset(int n5) {
            this.thumbOffset = n5;
            return this;
        }
    }

    public static interface OnThumbValueChangeListener {
        public void onValueChanged(NavMultiSeekBar var1, Thumb var2, int var3, int var4);
    }
}

