/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.k;
import com.baidu.navisdk.model.datastruct.r;
import com.baidu.navisdk.ui.util.b;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RoadCondBar
extends View {
    private static final String TAG = "RoadCondBar";
    private float colorBarEdgeWidth = 16.0f;
    private float colorBarMarginTop = 13.34f;
    private float carPointSize = 54.6f;
    private float carPointEdgeWidth = 0.0f;
    private float carPointPlaintEdge = 6.0f;
    private double mCurCarProgress = 0.0;
    private List<r> mRoadConditionItems = new ArrayList<r>();
    private int mItemTotalIndex = 0;
    private Paint mBGPaint = null;
    private Paint[] mPaints = new Paint[5];
    private Paint mPassPaint = null;
    private Bitmap mCacheBitmap = null;
    private Canvas mCacheCanvas = null;
    private int mLastW = 0;
    private int mLastH = 0;
    private int height = 0;
    private int width = 0;
    private NinePatchDrawable bgBitmap = null;
    private Bitmap carPointBitmap = null;
    private boolean hasSetData = false;

    public RoadCondBar(Context context) {
        super(context);
        this.init(context);
    }

    public RoadCondBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    private void init(Context context) {
        RoadCondBar roadCondBar = this;
        this.initPaints();
        roadCondBar.initSize(context);
        roadCondBar.bgBitmap = (NinePatchDrawable)b.f(R.drawable.nsdk_drawable_roadcondition_fg);
        roadCondBar.carPointBitmap = b.a(R.drawable.nsdk_drawable_roadcondition_carpoint);
        roadCondBar.setBackgroundDrawable(null);
        Log.e((String)TAG, (String)("graphics.Bitmap \u521d\u59cb\u5316 -> viewHash= " + ((Object)((Object)this)).hashCode() + ",BitmapHash = " + this.carPointBitmap.hashCode()));
    }

    private void initSize(Context context) {
        this.colorBarEdgeWidth = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_8dp);
        this.carPointSize = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_27dp);
        this.colorBarMarginTop = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_7dp);
        this.carPointPlaintEdge = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_3dp);
    }

    private void initPaints() {
        Paint paint;
        Paint paint2;
        Paint paint3;
        Paint paint4;
        Paint paint5;
        RoadCondBar roadCondBar = roadCondBar2;
        roadCondBar2.mBGPaint = new Paint();
        roadCondBar2.mBGPaint.setAntiAlias(true);
        roadCondBar2.mPassPaint = new Paint();
        roadCondBar2.mPassPaint.setColor(-3158065);
        RoadCondBar roadCondBar2 = paint5;
        paint5 = new Paint();
        roadCondBar.mPaints[0] = roadCondBar2;
        roadCondBar.mPaints[0].setColor(r.b(0));
        roadCondBar2 = paint4;
        paint4 = new Paint();
        roadCondBar.mPaints[1] = roadCondBar2;
        roadCondBar.mPaints[1].setColor(r.b(1));
        roadCondBar2 = paint3;
        paint3 = new Paint();
        roadCondBar.mPaints[2] = roadCondBar2;
        roadCondBar.mPaints[2].setColor(r.b(2));
        roadCondBar2 = paint2;
        paint2 = new Paint();
        roadCondBar.mPaints[3] = roadCondBar2;
        roadCondBar.mPaints[3].setColor(r.b(3));
        roadCondBar2 = paint;
        paint = new Paint();
        roadCondBar.mPaints[4] = roadCondBar2;
        roadCondBar.mPaints[4].setColor(r.b(4));
    }

    private boolean isDataValid() {
        List<r> list = ((RoadCondBar)((Object)list)).mRoadConditionItems;
        return list != null && list.size() > 0;
    }

    private float getRoadConditionItemDrawHeight(int n5, int n6, int n7) {
        int n8 = this.mItemTotalIndex;
        if (n8 <= 0) {
            return 0.0f;
        }
        return (float)((double)((float)n7 - this.colorBarMarginTop) * 1.0 * (double)(n6 - n5) * 1.0 / (double)n8);
    }

    protected void onMeasure(int n5, int n6) {
        RoadCondBar roadCondBar = this;
        super.onMeasure(n5, n6);
        long l5 = roadCondBar.getMeasuredHeight();
        long l6 = this.getMeasuredWidth();
        long l7 = l5 * l6 * 16L;
        if (l5 <= 10000L && l6 <= 10000L && l7 <= Integer.MAX_VALUE) {
            int n7;
            RoadCondBar roadCondBar2 = this;
            this.width = n7 = (int)l6;
            roadCondBar2.height = (int)l5;
            roadCondBar2.carPointEdgeWidth = (int)(((float)n7 - this.carPointSize) / 2.0f);
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "---> BNRoadConditionView: cacheBitmapSize is " + l7 + ", cacheBitmapSize exceeds 32 bits ");
        }
    }

    protected void onDraw(Canvas canvas) {
        block44: {
            block45: {
                block43: {
                    RectF rectF;
                    float f6;
                    float f7;
                    block42: {
                        RectF rectF2;
                        Paint paint;
                        Rect rect;
                        int n5;
                        RoadCondBar roadCondBar = this;
                        super.onDraw(canvas);
                        int n6 = roadCondBar.width;
                        if (n6 <= 0 || (n5 = this.height) <= 0) break block44;
                        if (!this.hasSetData) {
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "onDraw-> hasSetData false");
                            }
                            return;
                        }
                        if (this.mCacheBitmap == null || this.mCacheCanvas == null || n6 != this.mLastW || n5 != this.mLastH) {
                            Bitmap bitmap;
                            if (k.a && (bitmap = this.mCacheBitmap) != null && !bitmap.isRecycled()) {
                                this.mCacheBitmap.recycle();
                            }
                            this.mCacheBitmap = null;
                            int n7 = this.width;
                            this.mLastW = n6 = n7;
                            this.mLastH = n6 = this.height;
                            this.mCacheBitmap = Bitmap.createBitmap((int)n7, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                            this.mCacheBitmap.eraseColor(0);
                            this.mCacheCanvas = new Canvas(this.mCacheBitmap);
                        }
                        if (this.mCacheBitmap == null || this.mCacheCanvas == null) break block45;
                        RoadCondBar roadCondBar2 = this;
                        RoadCondBar roadCondBar3 = this;
                        float f8 = (float)roadCondBar3.height - this.carPointSize;
                        n5 = 0;
                        Rect rect2 = rect;
                        RoadCondBar roadCondBar4 = this;
                        int n8 = roadCondBar4.width;
                        int n9 = (int)((float)roadCondBar4.height - this.carPointSize + this.colorBarMarginTop);
                        rect = new Rect(0, 0, n8, n9);
                        roadCondBar3.bgBitmap.setBounds(rect2);
                        roadCondBar3.bgBitmap.draw(canvas);
                        float f9 = roadCondBar3.width;
                        float f10 = roadCondBar3.height;
                        Paint paint2 = roadCondBar3.mBGPaint;
                        canvas.saveLayer(0.0f, 0.0f, f9, f10, paint2, 31);
                        RoadCondBar roadCondBar5 = this;
                        f9 = roadCondBar5.colorBarEdgeWidth;
                        f10 = roadCondBar5.colorBarMarginTop;
                        float f11 = f9;
                        RoadCondBar roadCondBar6 = this;
                        f9 = (float)roadCondBar6.width - f9;
                        paint2 = roadCondBar6.mPaints[0];
                        roadCondBar2.mCacheCanvas.drawRect(f11, f10, f9, f8, paint2);
                        if (roadCondBar2.isDataValid()) {
                            for (int i5 = 0; i5 < this.mRoadConditionItems.size(); ++i5) {
                                float f12;
                                RoadCondBar roadCondBar7 = this;
                                r r5 = roadCondBar7.mRoadConditionItems.get(i5);
                                int n10 = r5.c;
                                f10 = f8 - this.getRoadConditionItemDrawHeight(n5, n10, (int)((float)roadCondBar7.height - this.carPointSize));
                                if (this.mRoadConditionItems.size() != 1) {
                                    float f13 = this.colorBarEdgeWidth;
                                    f12 = f13;
                                    RoadCondBar roadCondBar8 = this;
                                    f12 = (float)roadCondBar8.width - f12;
                                    paint = roadCondBar8.mPaints[r5.b];
                                    this.mCacheCanvas.drawRect(f13, f10, f12, f8, paint);
                                } else {
                                    RoadCondBar roadCondBar9 = this;
                                    f12 = roadCondBar9.colorBarEdgeWidth;
                                    float f14 = roadCondBar9.colorBarMarginTop;
                                    float f15 = f12;
                                    RoadCondBar roadCondBar10 = this;
                                    f12 = (float)roadCondBar10.width - f12;
                                    Paint paint3 = roadCondBar10.mPaints[r5.b];
                                    this.mCacheCanvas.drawRect(f15, f14, f12, f8, paint3);
                                }
                                n5 = r5.c;
                                f8 = f10;
                            }
                        }
                        f8 = this.colorBarMarginTop;
                        double d6 = this.mCurCarProgress;
                        int n11 = (int)((double)((float)this.height - this.carPointSize - f8) * (1.0 - d6) + (double)f8);
                        if (LogUtil.LOGGABLE) {
                            LogUtil.e(TAG, "onDraw-> mCurCarProgress=" + this.mCurCarProgress + ", curCarPointH=" + n11);
                        }
                        RoadCondBar roadCondBar11 = this;
                        RoadCondBar roadCondBar12 = this;
                        RoadCondBar roadCondBar13 = this;
                        RoadCondBar roadCondBar14 = this;
                        float f16 = this.colorBarEdgeWidth;
                        f7 = n11;
                        f6 = (float)roadCondBar14.width - f16;
                        f10 = (float)roadCondBar14.height - this.carPointSize;
                        Paint paint4 = roadCondBar14.mPassPaint;
                        roadCondBar13.mCacheCanvas.drawRect(f16, f7, f6, f10, paint4);
                        RectF rectF3 = rectF2;
                        RoadCondBar roadCondBar15 = this;
                        RoadCondBar roadCondBar16 = roadCondBar15;
                        f6 = roadCondBar15.colorBarEdgeWidth;
                        float f17 = roadCondBar16.colorBarMarginTop;
                        float f18 = f6;
                        RoadCondBar roadCondBar17 = this;
                        RoadCondBar roadCondBar18 = roadCondBar17;
                        float f19 = roadCondBar17.width;
                        f6 = f19 - this.colorBarEdgeWidth;
                        float f20 = roadCondBar18.height;
                        float f21 = f20 - this.carPointSize;
                        rectF2 = new RectF(f18, f17, f6, f21);
                        float f22 = roadCondBar13.width;
                        f6 = 2.0f;
                        f6 = (f22 - this.colorBarEdgeWidth * f6) / 2.0f;
                        float f23 = roadCondBar13.width;
                        f10 = 2.0f;
                        f10 = (f23 - this.colorBarEdgeWidth * f10) / 2.0f;
                        paint4 = roadCondBar13.mBGPaint;
                        canvas.drawRoundRect(rectF3, f6, f10, paint4);
                        roadCondBar12.mBGPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                        rectF3 = roadCondBar12.mCacheBitmap;
                        f6 = 0.0f;
                        f10 = 0.0f;
                        paint4 = roadCondBar12.mBGPaint;
                        canvas.drawBitmap((Bitmap)rectF3, f6, f10, paint4);
                        roadCondBar11.mBGPaint.setXfermode(null);
                        float f24 = 0.0f;
                        f6 = 0.0f;
                        f10 = roadCondBar11.width;
                        float f25 = roadCondBar11.height;
                        paint = roadCondBar11.mBGPaint;
                        try {
                            canvas.saveLayer(f24, f6, f10, f25, paint, 31);
                        }
                        catch (Exception exception) {
                            if (!LogUtil.LOGGABLE) break block42;
                            LogUtil.printException("RoadCondBar_onDraw", exception);
                        }
                    }
                    Canvas canvas2 = canvas;
                    Canvas canvas3 = canvas2;
                    Canvas canvas4 = canvas2;
                    RoadCondBar roadCondBar = this;
                    RoadCondBar roadCondBar19 = roadCondBar;
                    RoadCondBar roadCondBar20 = roadCondBar;
                    canvas = rectF;
                    float f26 = f7;
                    RoadCondBar roadCondBar21 = this;
                    RoadCondBar roadCondBar22 = roadCondBar21;
                    RoadCondBar roadCondBar23 = roadCondBar21;
                    float f27 = f7;
                    RoadCondBar roadCondBar24 = this;
                    RoadCondBar roadCondBar25 = roadCondBar24;
                    float f28 = roadCondBar24.carPointEdgeWidth;
                    f7 = f27 - roadCondBar25.carPointPlaintEdge;
                    float f29 = roadCondBar22.width;
                    f6 = f29 - this.carPointEdgeWidth;
                    float f30 = f26 + roadCondBar23.carPointSize;
                    float f31 = f30 - this.carPointPlaintEdge;
                    rectF = new RectF(f28, f7, f6, f31);
                    Bitmap bitmap = roadCondBar19.carPointBitmap;
                    Rect rect = null;
                    Paint paint = roadCondBar20.mBGPaint;
                    try {
                        canvas3.drawBitmap(bitmap, rect, (RectF)canvas, paint);
                        canvas4.restore();
                    }
                    catch (Exception exception) {
                        if (!LogUtil.LOGGABLE) break block43;
                        LogUtil.printException("RoadCondBar_onDraw", exception);
                    }
                }
                return;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onDraw-> mCacheBitmap= " + this.mCacheBitmap + ", mCacheCanvas= " + this.mCacheCanvas);
            }
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onDraw-> width= " + this.width + ", height= " + this.height);
        }
    }

    public void updateProgress(double d6) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateProgress-> carProgress=" + d6);
        }
        this.mCurCarProgress = d6;
        this.invalidate();
    }

    public void resetData() {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "resetData-> ");
        }
        if ((this = ((RoadCondBar)((Object)this)).mRoadConditionItems) != null) {
            this.clear();
        }
    }

    public void updateData(List<r> list) {
        List<r> list2;
        this.hasSetData = true;
        if (LogUtil.LOGGABLE) {
            StringBuilder stringBuilder;
            list2 = stringBuilder;
            stringBuilder = new StringBuilder("data:");
            if (list != null) {
                if (list.size() <= 0) {
                    LogUtil.e(TAG, "updateData data is empty");
                } else {
                    Iterator<r> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        List<r> list3 = list2;
                        r r5 = iterator.next();
                        ((StringBuilder)((Object)list3)).append("\n\t----");
                        ((StringBuilder)((Object)list3)).append(r5.toString());
                    }
                    LogUtil.e(TAG, "updateData->" + ((StringBuilder)((Object)list2)).toString());
                }
            } else {
                LogUtil.e(TAG, "updateData data is null");
            }
        }
        if (list != null && list.size() != 0) {
            list2 = this.mRoadConditionItems;
            if (list2 != null) {
                list2.clear();
            }
            RoadCondBar roadCondBar = this;
            roadCondBar.mRoadConditionItems.addAll(list);
            List<r> list4 = roadCondBar.mRoadConditionItems;
            roadCondBar.mItemTotalIndex = list4.get((int)(list4.size() - 1)).c;
            return;
        }
    }

    public void recycle() {
        Object object;
        if (LogUtil.LOGGABLE) {
            Log.e((String)TAG, (String)"recycle ->");
        }
        if ((object = this.mCacheBitmap) != null) {
            if (k.a && Build.VERSION.SDK_INT < 28) {
                object.recycle();
            }
            this.mCacheBitmap = null;
        }
        if (this.bgBitmap != null) {
            this.bgBitmap = null;
        }
        if (LogUtil.LOGGABLE) {
            object = TAG;
            StringBuilder stringBuilder = new StringBuilder().append("graphics.Bitmap recycle -> viewHash= ").append(((Object)((Object)this)).hashCode()).append(",BitmapHash = ");
            Object object2 = this.carPointBitmap;
            object2 = object2 == null ? "null" : Integer.valueOf(object2.hashCode());
            Log.e((String)object, (String)stringBuilder.append(object2).toString());
        }
        if ((object = this.carPointBitmap) != null) {
            if (k.a && Build.VERSION.SDK_INT < 28) {
                object.recycle();
            }
            this.carPointBitmap = null;
        }
    }

    public void dispose() {
        if (LogUtil.LOGGABLE) {
            Log.e((String)TAG, (String)"dispose ->");
        }
        RoadCondBar roadCondBar = this;
        roadCondBar.recycle();
        List<r> list = roadCondBar.mRoadConditionItems;
        if (list != null) {
            list.clear();
        }
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    }
}

