/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.baidu.navisdk.embed.R;

public class RoundImageView
extends ImageView {
    private Path mClipPath;
    private float mRadio = 1.0f;
    private float mRadius = 0.0f;

    public RoundImageView(Context context) {
        this(context, null);
    }

    public RoundImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RoundImageView(Context context, AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        if (attributeSet != null) {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.RoundedImageView);
            int n6 = R.styleable.RoundedImageView_roundedImageViewSizeRadio;
            this.mRadio = context.getFloat(n6, this.mRadio);
            this.mRadius = context.getDimensionPixelSize(R.styleable.RoundedImageView_roundedImageViewCornerRadius, (int)this.mRadius);
            context.recycle();
        }
    }

    public void setRadio(float f6) {
        this.mRadio = f6;
    }

    public void setRadius(float f6) {
        this.mRadius = f6;
    }

    protected void onMeasure(int n5, int n6) {
        if (this.mRadio <= 0.0f) {
            super.onMeasure(n5, n6);
        } else {
            n5 = View.MeasureSpec.getSize((int)n5);
            int n7 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
            super.onMeasure(n7, View.MeasureSpec.makeMeasureSpec((int)((int)((float)n5 / this.mRadio)), (int)0x40000000));
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mClipPath == null) {
            this.mClipPath = new Path();
            RoundImageView roundImageView = this;
            float f6 = roundImageView.getWidth();
            float f7 = roundImageView.getHeight();
            RectF rectF = new RectF(0.0f, 0.0f, f6, f7);
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = f7 = this.mRadius;
            fArray[1] = f7;
            fArray[2] = f7;
            fArray[3] = f7;
            fArray[4] = f7;
            fArray[5] = f7;
            fArray[6] = f7;
            fArray[7] = f7;
            this.mClipPath.addRoundRect(rectF, fArray2, Path.Direction.CW);
        }
        Canvas canvas2 = canvas;
        canvas2.clipPath(this.mClipPath);
        super.onDraw(canvas2);
    }

    public static final class Size {
        public final float width;
        public final float height;

        public Size(float f6, float f7) {
            this.width = f6;
            this.height = f7;
        }
    }
}

