/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.util.b;

public final class SettingSwitchWidget
extends RelativeLayout {
    private static final String TAG = "SettingSwitchWidget";
    private ImageView switchView;
    private boolean isDay;
    private boolean isChecked;
    private SwitchItemOnCheckedListener mCheckedListener;
    private TextView titleView;
    private TextView subTitleView;
    private TextView tipsView;
    private boolean isShowTitle;
    private boolean isShowSubTitle;
    private boolean isShowTips;
    private boolean isShowSwitch;
    private boolean isShowSelect;
    private boolean isShowJump;
    private String title;
    private String subTitle;
    private String tips;
    private Context mContext;

    public SettingSwitchWidget(Context context) {
        this(context, null);
    }

    public SettingSwitchWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SettingSwitchWidget(Context context, AttributeSet attributeSet, int n5) {
        Context context2 = context;
        Context context3 = context;
        super(context, attributeSet, n5);
        this.isDay = true;
        this.isChecked = false;
        context = context3.obtainStyledAttributes(attributeSet, R.styleable.SettingSwitchWidget);
        this.isShowTitle = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show_title, true);
        this.isShowSubTitle = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show_subtitle, false);
        this.isShowSwitch = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show, false);
        this.isShowSelect = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show_select, false);
        this.isShowJump = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show_jump, false);
        this.isShowTips = context.getBoolean(R.styleable.SettingSwitchWidget_nsdk_setting_switch_show_tips, false);
        this.title = context.getString(R.styleable.SettingSwitchWidget_nsdk_setting_switch_title);
        this.subTitle = context.getString(R.styleable.SettingSwitchWidget_nsdk_setting_switch_subtitle);
        this.tips = context.getString(R.styleable.SettingSwitchWidget_nsdk_setting_switch_tips);
        context.recycle();
        this.mContext = context3;
        this.initAndLoadView(context2);
    }

    private void updateWindow() {
        SettingSwitchWidget settingSwitchWidget = this;
        RelativeLayout relativeLayout = (RelativeLayout)settingSwitchWidget.findViewById(R.id.switch_container);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)relativeLayout.getLayoutParams();
        if (settingSwitchWidget.isShowSubTitle) {
            SettingSwitchWidget settingSwitchWidget2 = this;
            layoutParams.height = settingSwitchWidget2.dip2px(settingSwitchWidget2.mContext, 70.0f);
        } else {
            SettingSwitchWidget settingSwitchWidget3 = this;
            layoutParams.height = settingSwitchWidget3.dip2px(settingSwitchWidget3.mContext, 40.0f);
        }
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void updateSwitchState() {
        this.setChecked(false);
    }

    public void initAndLoadView(Context context) {
        if (context == null) {
            return;
        }
        SettingSwitchWidget settingSwitchWidget = this;
        LayoutInflater.from((Context)context).inflate(R.layout.bnav_layout_switch_item, (ViewGroup)this, true);
        settingSwitchWidget.titleView = (TextView)settingSwitchWidget.findViewById(R.id.setting_switch_item_title);
        settingSwitchWidget.subTitleView = (TextView)settingSwitchWidget.findViewById(R.id.setting_switch_item_subtitle);
        settingSwitchWidget.tipsView = (TextView)settingSwitchWidget.findViewById(R.id.setting_switch_item_tips);
        settingSwitchWidget.switchView = (ImageView)settingSwitchWidget.findViewById(R.id.setting_switch_item_image);
        if (settingSwitchWidget.isShowSubTitle && !TextUtils.isEmpty((CharSequence)this.subTitle)) {
            SettingSwitchWidget settingSwitchWidget2 = this;
            settingSwitchWidget2.subTitleView.setVisibility(0);
            settingSwitchWidget2.subTitleView.setText((CharSequence)this.subTitle);
        } else {
            this.subTitleView.setVisibility(8);
        }
        if (this.isShowTitle && !TextUtils.isEmpty((CharSequence)this.title)) {
            SettingSwitchWidget settingSwitchWidget3 = this;
            settingSwitchWidget3.titleView.setVisibility(0);
            settingSwitchWidget3.titleView.setText((CharSequence)this.title);
        } else {
            this.titleView.setVisibility(8);
        }
        if (this.isShowTips && !TextUtils.isEmpty((CharSequence)this.tips)) {
            SettingSwitchWidget settingSwitchWidget4 = this;
            settingSwitchWidget4.tipsView.setVisibility(0);
            settingSwitchWidget4.tipsView.setText((CharSequence)this.tips);
        } else {
            this.tipsView.setVisibility(8);
        }
        SettingSwitchWidget settingSwitchWidget5 = this;
        settingSwitchWidget5.updateSwitchState();
        settingSwitchWidget5.updateWindow();
    }

    public void updateStyle(boolean bl) {
        if (this.isDay == bl) {
            return;
        }
        this.isDay = bl;
        TextView textView = this.titleView;
        if (textView != null) {
            textView.setTextColor(b.a(R.color.nsdk_cl_text_a, bl));
        }
        if ((this = this.subTitleView) != null) {
            this.setTextColor(b.a(R.color.nsdk_cl_text_f, bl));
        }
    }

    public void setSubTitleViewVisible(int n5) {
        SettingSwitchWidget settingSwitchWidget = settingSwitchWidget.subTitleView;
        if (settingSwitchWidget != null) {
            settingSwitchWidget.setVisibility(n5);
        }
    }

    public void setChecked(boolean bl) {
        this.isChecked = bl;
        ImageView imageView = this.switchView;
        if (imageView != null) {
            imageView.setSelected(bl);
            if (bl) {
                if (this.isShowSwitch) {
                    this.switchView.setImageResource(R.drawable.nsdk_set_checkin_icon);
                } else if (this.isShowSelect) {
                    this.switchView.setImageResource(R.drawable.nsdk_rg_bluetooth_panel_checkbox_checked);
                } else if (this.isShowJump) {
                    this.switchView.setImageResource(R.drawable.nsdk_drawable_plate_list_right_arrow);
                }
            } else if (this.isShowSwitch) {
                this.switchView.setImageResource(R.drawable.nsdk_set_checkout_icon);
            } else if (this.isShowSelect) {
                this.switchView.setImageResource(R.drawable.nsdk_rg_bluetooth_panel_checkbox_unchecked);
            } else if (this.isShowJump) {
                this.switchView.setImageResource(R.drawable.nsdk_drawable_plate_list_right_arrow);
            }
        }
    }

    public void setOnCheckedListener(SwitchItemOnCheckedListener object) {
        this.mCheckedListener = object;
        if (object != null) {
            View.OnClickListener onClickListener;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    1 v02 = this;
                    boolean bl = v02.SettingSwitchWidget.this.isChecked ^ true;
                    boolean bl2 = false;
                    if (v02.SettingSwitchWidget.this.mCheckedListener != null) {
                        bl2 = SettingSwitchWidget.this.mCheckedListener.onChecked(SettingSwitchWidget.this.getId(), bl);
                    }
                    Log.d((String)SettingSwitchWidget.TAG, (String)("onClick: checkedSuccess " + bl2));
                    if (bl2) {
                        SettingSwitchWidget.this.setChecked(bl);
                    }
                }
            };
            this.setOnClickListener((View.OnClickListener)object);
        } else {
            this.setOnClickListener(null);
        }
    }

    public int dip2px(Context context, float f6) {
        return (int)(f6 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static interface SwitchItemOnCheckedListener {
        public boolean onChecked(int var1, boolean var2);
    }
}

