/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import com.baidu.navisdk.util.common.ScreenUtil;
import java.util.ArrayList;
import java.util.List;

public class SoftKeyboardStateHelper
implements ViewTreeObserver.OnGlobalLayoutListener {
    public static final int SOFT_KEYBOARD_HEIGHT_MIN = 200;
    private boolean hasNavigationBar;
    private int mPreviousHeight;
    private final List<SoftKeyboardStateListener> listeners = new ArrayList<SoftKeyboardStateListener>(4);
    private final View viewRoot;
    private int windowHeight = 0;
    private int lastSoftKeyboardHeightInPx;
    private boolean isSoftKeyboardOpened;
    private Activity mActivity;
    private Rect mRect = new Rect();

    public SoftKeyboardStateHelper(Activity activity, View view) {
        this(activity, view, false);
    }

    public SoftKeyboardStateHelper(Activity activity, View view, boolean bl) {
        this.viewRoot = view;
        this.isSoftKeyboardOpened = bl;
        this.mActivity = activity;
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private void notifyOnSoftKeyboardOpened(int n5) {
        ((SoftKeyboardStateHelper)this).lastSoftKeyboardHeightInPx = n5;
        for (SoftKeyboardStateListener softKeyboardStateListener : ((SoftKeyboardStateHelper)this).listeners) {
            if (softKeyboardStateListener == null) continue;
            softKeyboardStateListener.onSoftKeyboardOpened(n5);
        }
    }

    private void notifyOnSoftKeyboardClosed() {
        for (SoftKeyboardStateListener softKeyboardStateListener : ((SoftKeyboardStateHelper)this).listeners) {
            if (softKeyboardStateListener == null) continue;
            softKeyboardStateListener.onSoftKeyboardClosed();
        }
    }

    public void onGlobalLayout() {
        Activity activity = this.mActivity;
        if (activity != null && this.viewRoot != null) {
            int n5;
            if (this.windowHeight <= 0) {
                this.windowHeight = activity.getWindow().getDecorView().getRootView().getHeight();
            }
            SoftKeyboardStateHelper softKeyboardStateHelper = this;
            softKeyboardStateHelper.mRect.setEmpty();
            softKeyboardStateHelper.viewRoot.getWindowVisibleDisplayFrame(this.mRect);
            int n6 = softKeyboardStateHelper.windowHeight - this.mRect.bottom;
            int n7 = ScreenUtil.getBottomBarHeight(this.mActivity.getApplicationContext());
            if (n6 != n7 && Math.abs(n6 - n7) > 1 && n6 - (n5 = this.mPreviousHeight) != n7) {
                if (n6 == 0 || n6 - n5 == -n7) {
                    this.hasNavigationBar = false;
                }
            } else {
                this.hasNavigationBar = true;
            }
            if (this.hasNavigationBar) {
                n6 -= n7;
            }
            if (!this.isSoftKeyboardOpened && n6 > 200) {
                this.isSoftKeyboardOpened = true;
                this.notifyOnSoftKeyboardOpened(n6);
            } else if (this.isSoftKeyboardOpened && n6 < 200) {
                this.isSoftKeyboardOpened = false;
                this.notifyOnSoftKeyboardClosed();
            }
            this.mPreviousHeight = n6;
            return;
        }
    }

    public void setIsSoftKeyboardOpened(boolean bl) {
        this.isSoftKeyboardOpened = bl;
    }

    public boolean isSoftKeyboardOpened() {
        return this.isSoftKeyboardOpened;
    }

    public int getLastSoftKeyboardHeightInPx() {
        return this.lastSoftKeyboardHeightInPx;
    }

    public void addSoftKeyboardStateListener(SoftKeyboardStateListener softKeyboardStateListener) {
        this.listeners.add(softKeyboardStateListener);
    }

    public void removeSoftKeyboardStateListener(SoftKeyboardStateListener softKeyboardStateListener) {
        this.listeners.remove(softKeyboardStateListener);
    }

    public void onDestroy() {
        this.mActivity = null;
        View view = this.viewRoot;
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        this.listeners.clear();
        this.mRect = null;
    }

    public static interface SoftKeyboardStateListener {
        public void onSoftKeyboardOpened(int var1);

        public void onSoftKeyboardClosed();
    }
}

