/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Scroller;
import com.baidu.navisdk.util.common.i;

public class TwoStateScrollView
extends LinearLayout {
    private static final String TAG = TwoStateScrollView.class.getName();
    protected boolean isNotInterruptBlankTouchEvent;
    public int mScrollStart;
    private int mScrollEnd;
    public int mLastY;
    public Scroller mScroller;
    public boolean isScrolling;
    private VelocityTracker mVelocityTracker;
    private OnStatusChangeListener mOnStatusChangeListener;
    private OnUpdateStatusValueListener mOnUpdateStatusValueListener;
    private View mTitleContainer;
    private View mViewBg;
    private View mBottomView;
    public int foldableHeight = 0;
    public int persistantHeight;
    public int blankSpaceHeight;
    private int mTitleAnimHeight;
    private int mBottomAnimHeight;
    private int mBottomViewHeight;
    private boolean heightsInited = false;
    boolean statusChange = false;
    public boolean needScroll = false;
    boolean hasMoveScroll = false;
    boolean enableTitleAnim = false;
    boolean enableBg = false;
    boolean enableBottomAnim = false;
    private boolean gotoFlag = false;
    private boolean needStatusChangeAlways = false;
    public boolean hasActionDown = false;
    public int topMargin = 0;
    public int bottomMargin = 0;
    public DragState status = DragState.TOP;
    private EventCatchListener mEventCatchListener = null;

    public TwoStateScrollView(Context context) {
        twoStateScrollView(context, null);
        Scroller scroller;
        TwoStateScrollView twoStateScrollView = scroller;
        scroller = new Scroller(context);
        v1.mScroller = twoStateScrollView;
    }

    public TwoStateScrollView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mScroller = new Scroller(context);
    }

    public TwoStateScrollView(Context context, AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        this.mScroller = new Scroller(context);
    }

    private void checkTitleAnimHeight() {
        int n5 = this.blankSpaceHeight;
        if (this.mTitleAnimHeight > n5) {
            this.mTitleAnimHeight = n5;
        }
    }

    private void checkBottomAnimHeight() {
        int n5 = this.blankSpaceHeight;
        if (this.mBottomAnimHeight > n5) {
            this.mBottomAnimHeight = n5;
        }
    }

    private void onScrollChanged(int n5) {
        int n6;
        OnUpdateStatusValueListener onUpdateStatusValueListener;
        if (i.p.d()) {
            i.p.e(TAG, "onScrollChanged: currScrollY --> " + n5);
        }
        if ((onUpdateStatusValueListener = this.mOnUpdateStatusValueListener) != null) {
            int n7 = this.foldableHeight;
            onUpdateStatusValueListener.onUpdateStatusValue((int)((double)(n7 + n5) * 1.0 / (double)n7 * 100.0));
        }
        n5 = n5 <= 0 ? -n5 : 0;
        if (this.enableTitleAnim && this.mTitleContainer != null && (n6 = this.mTitleAnimHeight) > 0) {
            double d6 = (double)n5 * 1.0 / (double)n6;
            d6 = 1.0 - d6;
            if (i.p.d()) {
                i.p.e(TAG, "onScrollChanged: remainingPercentage --> " + d6);
            }
            if (d6 < 0.0) {
                d6 = 0.0;
            }
            if (Build.VERSION.SDK_INT >= 11) {
                TwoStateScrollView twoStateScrollView = this;
                twoStateScrollView.mTitleContainer.setAlpha((float)d6);
                twoStateScrollView.mTitleContainer.invalidate();
            }
        }
        if (this.enableBg && (onUpdateStatusValueListener = this.mViewBg) != null) {
            onUpdateStatusValueListener = onUpdateStatusValueListener.getLayoutParams();
            v1.height = this.getMeasuredHeight() - n5;
            this.mViewBg.setLayoutParams((ViewGroup.LayoutParams)onUpdateStatusValueListener);
        }
        if (this.enableBottomAnim && (onUpdateStatusValueListener = this.mBottomView) != null && this.mBottomViewHeight > 0) {
            ViewGroup.LayoutParams layoutParams;
            onUpdateStatusValueListener.setVisibility(0);
            double d7 = (double)n5 * 1.0 / (double)this.mBottomAnimHeight;
            d7 = 1.0 - d7;
            if (i.p.d()) {
                i.p.e(TAG, "onScrollChanged: remainingPercentage2 --> " + d7);
            }
            if (d7 < 0.0) {
                d7 = 0.0;
            }
            n5 = (int)(d7 * (double)this.mBottomViewHeight);
            if (i.p.d()) {
                i.p.e(TAG, "onScrollChanged: marginBottom --> " + n5 + ", bottomBarMarginB: " + (this.mBottomViewHeight - n5));
            }
            if ((layoutParams = this.mBottomView.getLayoutParams()) != null && layoutParams instanceof ViewGroup.MarginLayoutParams) {
                TwoStateScrollView twoStateScrollView = this;
                TwoStateScrollView twoStateScrollView2 = this;
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                int n8 = marginLayoutParams.leftMargin;
                int n9 = marginLayoutParams.topMargin;
                int n10 = marginLayoutParams.rightMargin;
                int n11 = -(this.mBottomViewHeight - n5);
                marginLayoutParams.setMargins(n8, n9, n10, n11);
                twoStateScrollView2.mBottomView.setLayoutParams(layoutParams);
                twoStateScrollView2.mBottomView.invalidate();
                twoStateScrollView.setBottomMargin(n5);
                twoStateScrollView.invalidate();
            }
        }
    }

    private int getVelocity() {
        TwoStateScrollView twoStateScrollView = this;
        twoStateScrollView.mVelocityTracker.computeCurrentVelocity(1000);
        return (int)twoStateScrollView.mVelocityTracker.getYVelocity();
    }

    private void recycleVelocity() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void onMeasure(int n5, int n6) {
        super.onMeasure(n5, n6);
    }

    protected void onLayout(boolean bl, int n5, int n6, int n7, int n8) {
        super.onLayout(bl, n5, n6, n7, n8);
    }

    public void setTitleView(View view, int n5) {
        this.mTitleContainer = view;
        this.mTitleAnimHeight = n5;
        if (this.heightsInited) {
            this.checkTitleAnimHeight();
        }
    }

    public void setHeights(int n5, int n6) {
        TwoStateScrollView twoStateScrollView = this;
        this.persistantHeight = n5;
        twoStateScrollView.blankSpaceHeight = n6 -= n5;
        twoStateScrollView.foldableHeight = n6;
        twoStateScrollView.checkTitleAnimHeight();
        twoStateScrollView.checkBottomAnimHeight();
        twoStateScrollView.heightsInited = true;
        if (i.p.d()) {
            i.p.e(TAG, "setHeights: --> foldableHeight: " + this.foldableHeight + ", persistantHeight: " + n5 + ", blankSpaceHeight: " + this.blankSpaceHeight);
        }
    }

    public void setTitleAnimEnabled(boolean bl) {
        this.enableTitleAnim = bl;
    }

    public void setViewBg(View view) {
        this.mViewBg = view;
    }

    public void setEnableBg(boolean bl) {
        this.enableBg = bl;
    }

    public void setBottomView(View view, int n5, int n6) {
        this.mBottomView = view;
        this.mBottomViewHeight = n5;
        this.mBottomAnimHeight = n6;
        if (this.heightsInited) {
            this.checkBottomAnimHeight();
        }
    }

    public void setEnableBottomAnim(boolean bl) {
        this.enableBottomAnim = bl;
    }

    public void setScrollSupport(boolean bl) {
        this.needScroll = bl;
        if (i.p.d()) {
            i.p.e(TAG, "setScrollSupport : needScroll --> " + bl);
        }
    }

    public void setTopMargin(int n5) {
        this.topMargin = n5;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            int n6 = marginLayoutParams.leftMargin;
            int n7 = marginLayoutParams.rightMargin;
            int n8 = marginLayoutParams.bottomMargin;
            marginLayoutParams.setMargins(n6, n5, n7, n8);
            this.setLayoutParams(layoutParams);
        }
    }

    public void setBottomMargin(int n5) {
        this.bottomMargin = n5;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            int n6 = marginLayoutParams.leftMargin;
            int n7 = marginLayoutParams.topMargin;
            int n8 = marginLayoutParams.rightMargin;
            marginLayoutParams.setMargins(n6, n7, n8, n5);
            this.setLayoutParams(layoutParams);
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public boolean goToTop() {
        return this.goToTop(250);
    }

    public boolean goToTop(int n5) {
        if (i.p.d()) {
            i.p.e(TAG, "goToTop: " + n5);
        }
        if (!this.heightsInited) {
            if (i.p.d()) {
                i.p.e(TAG, "gotoTop: heightsInited --> " + this.heightsInited);
            }
            return false;
        }
        if (this.status == DragState.TOP) {
            if (i.p.d()) {
                i.p.e(TAG, "gotoTop: status already --> " + (Object)((Object)this.status));
            }
            return false;
        }
        Scroller scroller = this.mScroller;
        if (scroller != null) {
            TwoStateScrollView twoStateScrollView = this;
            int n6 = twoStateScrollView.getScrollY();
            int n7 = twoStateScrollView.foldableHeight;
            scroller.startScroll(0, n6, 0, n7, n5);
            this.statusChange = true;
            this.isScrolling = true;
            this.gotoFlag = true;
            this.hasMoveScroll = true;
            this.postInvalidate();
        }
        return true;
    }

    public boolean goToBottom() {
        return this.goToBottom(250);
    }

    public boolean goToBottom(int n5) {
        if (i.p.d()) {
            i.p.e(TAG, "goToBottom: " + n5);
        }
        if (!this.heightsInited) {
            if (i.p.d()) {
                i.p.e(TAG, "goToBottom: heightsInited --> " + this.heightsInited);
            }
            return false;
        }
        if (this.status == DragState.BOTTOM) {
            if (i.p.d()) {
                i.p.e(TAG, "goToBottom: status already --> " + (Object)((Object)this.status));
            }
            return false;
        }
        Scroller scroller = this.mScroller;
        if (scroller != null) {
            TwoStateScrollView twoStateScrollView = this;
            int n6 = twoStateScrollView.getScrollY();
            int n7 = -twoStateScrollView.foldableHeight;
            scroller.startScroll(0, n6, 0, n7, n5);
            this.statusChange = true;
            this.isScrolling = true;
            this.gotoFlag = true;
            this.hasMoveScroll = true;
            this.postInvalidate();
        }
        return true;
    }

    public DragState getCurStatus() {
        return this.status;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.needScroll) {
            return super.onTouchEvent(motionEvent);
        }
        if (this.isScrolling) {
            super.onTouchEvent(motionEvent);
            if (i.p.d()) {
                i.p.e(TAG, "onTouchEvent: isScrolling --> " + this.isScrolling);
            }
            return true;
        }
        MotionEvent motionEvent2 = motionEvent;
        int n5 = (int)motionEvent2.getY();
        int n6 = motionEvent2.getAction();
        this.obtainVelocity(motionEvent);
        if (n6 != 0) {
            if (n6 != 1) {
                if (n6 == 2) {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    TwoStateScrollView twoStateScrollView = this;
                    int n7 = twoStateScrollView.mLastY - n5;
                    n6 = twoStateScrollView.getScrollY();
                    if (i.p.d()) {
                        i.p.e(TAG, "onTouchEvent: --> ACTION_MOVE: dy:" + n7 + ", scrollY " + n6);
                    }
                    if (n7 > 0 && n7 + n6 > 0) {
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: --> break ACTION_MOVE 1: dy: " + n7 + ", scrollY: " + n6);
                        }
                    } else if (-n6 - n7 > this.foldableHeight) {
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: --> break ACTION_MOVE 2: dy: " + n7 + ", scrollY: " + n6);
                        }
                    } else {
                        TwoStateScrollView twoStateScrollView2 = this;
                        twoStateScrollView2.onScrollChanged(n6);
                        twoStateScrollView2.scrollBy(0, n7);
                        twoStateScrollView2.mLastY = n5;
                    }
                }
            } else if (this.hasActionDown) {
                int n8;
                this.hasActionDown = false;
                this.mScrollEnd = n8 = this.getScrollY();
                n8 -= this.mScrollStart;
                if (i.p.d()) {
                    i.p.e(TAG, "onTouchEvent: --> ACTION_UP: mScrollEnd: " + this.mScrollEnd + ", mScrollStart: " + this.mScrollStart + ", dScrollY: " + n8);
                }
                if (this.status == DragState.TOP) {
                    n5 = this.foldableHeight;
                    if (-(this.mScrollEnd - this.mScrollStart) > n5 / 3) {
                        n8 = -(n5 + n8);
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: startScroll 1 --> from: " + this.getScrollY() + ", scrollDistance: " + n8);
                        }
                        if (n8 != 0) {
                            TwoStateScrollView twoStateScrollView = this;
                            twoStateScrollView.mScroller.startScroll(0, this.getScrollY(), 0, n8);
                            twoStateScrollView.status = DragState.BOTTOM;
                            twoStateScrollView.statusChange = true;
                            twoStateScrollView.hasMoveScroll = true;
                            twoStateScrollView.isScrolling = true;
                            twoStateScrollView.postInvalidate();
                            twoStateScrollView.recycleVelocity();
                        }
                    } else {
                        n8 = -n8;
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: startScroll 2 --> from: " + this.getScrollY() + ", scrollDistance: " + n8);
                        }
                        if (n8 != 0) {
                            TwoStateScrollView twoStateScrollView = this;
                            twoStateScrollView.mScroller.startScroll(0, this.getScrollY(), 0, n8);
                            twoStateScrollView.hasMoveScroll = true;
                            twoStateScrollView.isScrolling = true;
                            twoStateScrollView.postInvalidate();
                            twoStateScrollView.recycleVelocity();
                        }
                    }
                } else {
                    n5 = this.foldableHeight;
                    if (this.mScrollEnd - this.mScrollStart > n5 / 3) {
                        n8 = n5 - n8;
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: startScroll 3 --> from: " + this.getScrollY() + ", scrollDistance: " + n8);
                        }
                        if (n8 != 0) {
                            TwoStateScrollView twoStateScrollView = this;
                            twoStateScrollView.status = DragState.TOP;
                            twoStateScrollView.statusChange = true;
                            twoStateScrollView.hasMoveScroll = true;
                            twoStateScrollView.mScroller.startScroll(0, this.getScrollY(), 0, n8);
                            twoStateScrollView.isScrolling = true;
                            twoStateScrollView.postInvalidate();
                            twoStateScrollView.recycleVelocity();
                        }
                    } else {
                        n8 = -n8;
                        if (i.p.d()) {
                            i.p.e(TAG, "onTouchEvent: startScroll 4 --> from: " + this.getScrollY() + ", scrollDistance: " + n8);
                        }
                        if (n8 != 0) {
                            TwoStateScrollView twoStateScrollView = this;
                            twoStateScrollView.mScroller.startScroll(0, this.getScrollY(), 0, n8);
                            twoStateScrollView.hasMoveScroll = true;
                            twoStateScrollView.isScrolling = true;
                            twoStateScrollView.postInvalidate();
                            twoStateScrollView.recycleVelocity();
                        }
                    }
                }
            }
        } else {
            this.mScrollStart = n6 = this.getScrollY();
            this.status = n6 < -this.foldableHeight / 2 ? DragState.BOTTOM : DragState.TOP;
            if (i.p.d()) {
                i.p.e(TAG, "onTouchEvent: --> ACTION_DOWN: status:" + (Object)((Object)this.status) + ", mScrollStart " + this.mScrollStart);
            }
            if (this.status == DragState.BOTTOM) {
                if (n5 < this.blankSpaceHeight) {
                    if (this.isNotInterruptBlankTouchEvent) {
                        return super.onTouchEvent(motionEvent);
                    }
                    if (i.p.d()) {
                        i.p.e(TAG, "onTouchEvent: --> return status_bottom: " + n5);
                    }
                    return false;
                }
            } else if (n5 < this.getMeasuredHeight() - this.persistantHeight - this.foldableHeight) {
                if (i.p.d()) {
                    i.p.e(TAG, "onTouchEvent: --> return status_top: " + n5);
                }
                return false;
            }
            TwoStateScrollView twoStateScrollView = this;
            twoStateScrollView.hasActionDown = true;
            twoStateScrollView.mLastY = n5;
        }
        return true;
    }

    public void computeScroll() {
        TwoStateScrollView twoStateScrollView = this;
        super.computeScroll();
        if (twoStateScrollView.mScroller.computeScrollOffset()) {
            TwoStateScrollView twoStateScrollView2 = this;
            int n5 = twoStateScrollView2.mScroller.getCurrY();
            twoStateScrollView2.scrollTo(0, n5);
            if (i.p.d()) {
                i.p.e(TAG, "computeScroll: scrollTo: y --> " + n5);
            }
            TwoStateScrollView twoStateScrollView3 = this;
            twoStateScrollView3.invalidate();
            twoStateScrollView3.onScrollChanged(n5);
        } else {
            if (this.statusChange) {
                if (this.getScrollY() < -this.foldableHeight / 2) {
                    OnStatusChangeListener onStatusChangeListener = this.mOnStatusChangeListener;
                    if (onStatusChangeListener != null && !this.gotoFlag) {
                        onStatusChangeListener.onStatusChange(DragState.BOTTOM);
                    }
                    this.status = DragState.BOTTOM;
                } else {
                    OnStatusChangeListener onStatusChangeListener = this.mOnStatusChangeListener;
                    if (onStatusChangeListener != null && !this.gotoFlag) {
                        onStatusChangeListener.onStatusChange(DragState.TOP);
                    }
                    this.status = DragState.TOP;
                }
                if (i.p.d()) {
                    i.p.e(TAG, "computeScroll: onStatusChange --> status: " + (Object)((Object)this.status) + ", gotoFlag: " + this.gotoFlag + ", scrollY: " + this.getScrollY());
                }
                this.statusChange = false;
            }
            this.isScrolling = false;
            if (this.hasMoveScroll) {
                if (i.p.d()) {
                    i.p.e(TAG, "computeScroll: hasMoveScroll --> " + this.hasMoveScroll + ", status: " + (Object)((Object)this.status));
                }
                if (this.status == DragState.BOTTOM) {
                    TwoStateScrollView twoStateScrollView4 = this;
                    twoStateScrollView4.scrollTo(0, -twoStateScrollView4.foldableHeight);
                    twoStateScrollView4.onScrollChanged(-twoStateScrollView4.foldableHeight);
                } else {
                    TwoStateScrollView twoStateScrollView5 = this;
                    twoStateScrollView5.scrollTo(0, 0);
                    twoStateScrollView5.onScrollChanged(0);
                }
                this.hasMoveScroll = false;
                if (this.needStatusChangeAlways) {
                    this.statusChange = true;
                }
            }
            this.gotoFlag = false;
        }
    }

    public void obtainVelocity(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
    }

    public void setOnStatusChangeListener(OnStatusChangeListener onStatusChangeListener) {
        this.mOnStatusChangeListener = onStatusChangeListener;
    }

    public void setOnUpdateStatusValueListener(OnUpdateStatusValueListener onUpdateStatusValueListener) {
        this.mOnUpdateStatusValueListener = onUpdateStatusValueListener;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        TwoStateScrollView twoStateScrollView = this;
        super.dispatchTouchEvent(motionEvent);
        EventCatchListener eventCatchListener = twoStateScrollView.mEventCatchListener;
        if (eventCatchListener != null) {
            eventCatchListener.onEventCatch(motionEvent);
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public void setOnEventCatchListener(EventCatchListener eventCatchListener) {
        this.mEventCatchListener = eventCatchListener;
    }

    public void setNeedStatusChangeAlways(boolean bl) {
        this.needStatusChangeAlways = bl;
    }

    public int getFoldableHeight() {
        return this.foldableHeight;
    }

    public void setNotInterruptBlankTouchEvent(boolean bl) {
        this.isNotInterruptBlankTouchEvent = bl;
    }

    public static interface EventCatchListener {
        public void onEventCatch(MotionEvent var1);
    }

    public static interface OnUpdateStatusValueListener {
        public void onUpdateStatusValue(int var1);
    }

    public static interface OnStatusChangeListener {
        public void onStatusChange(DragState var1);
    }

    public static final class DragState
    extends Enum<DragState> {
        public static final /* enum */ DragState TOP;
        public static final /* enum */ DragState BOTTOM;
        private static final /* synthetic */ DragState[] $VALUES;

        public static DragState[] values() {
            return (DragState[])$VALUES.clone();
        }

        public static DragState valueOf(String string2) {
            return Enum.valueOf(DragState.class, string2);
        }

        static {
            DragState dragState;
            TOP = new DragState();
            DragState dragState2 = dragState;
            BOTTOM = new DragState();
            $VALUES = new DragState[]{TOP, dragState2};
        }
    }
}

