/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.dragbtn;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.baidu.baidumaps.common.util.ScreenUtils;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.widget.BNFrameLayout;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;

public class DraggingButton
extends BNFrameLayout {
    private static final String TAG = "DraggingButton";
    private ImageView mImageBtn;
    private ImageView mCloseBtn;
    private float mLastRawX;
    private float mLastRawY;
    private boolean isDragging;
    private boolean isDragged;
    private int mRootMeasuredWidth;
    private int mRootMeasuredHeight;
    private int mRootTopY;
    private boolean attachable;
    private boolean draggable;
    private int attachMarginLeft;
    private int attachMarginRight;
    private int attachMarginTop;
    private int attachMarginBottom;

    public DraggingButton(Context context) {
        this(context, null);
    }

    public DraggingButton(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DraggingButton(Context context, @Nullable AttributeSet attributeSet, int n5) {
        DraggingButton draggingButton = this;
        super(context, attributeSet, n5);
        draggingButton.isDragging = false;
        draggingButton.isDragged = false;
        draggingButton.mRootMeasuredWidth = 0;
        draggingButton.mRootMeasuredHeight = 0;
        draggingButton.mRootTopY = 0;
        draggingButton.initAttrs(context, attributeSet);
    }

    private void initAttrs(Context context, AttributeSet attributeSet) {
        DraggingButton draggingButton = this;
        LayoutInflater.from((Context)context).inflate(R.layout.nsdk_layout_dragging_button_layout, (ViewGroup)this);
        draggingButton.mCloseBtn = (ImageView)draggingButton.findViewById(R.id.close_btn);
        draggingButton.mImageBtn = (ImageView)draggingButton.findViewById(R.id.dragging_image);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.DraggingButton);
        this.attachable = context.getBoolean(R.styleable.DraggingButton_nsdk_attachable, true);
        this.draggable = context.getBoolean(R.styleable.DraggingButton_nsdk_draggable, true);
        this.attachMarginLeft = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_left, 0);
        this.attachMarginRight = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_right, 0);
        this.attachMarginTop = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_top, 0);
        this.attachMarginBottom = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_bottom, 0);
        context.recycle();
    }

    private void autoLeft() {
        this.animate().setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(100L).x((float)this.attachMarginLeft).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (DraggingButton.this.mCloseBtn != null) {
                    1 v02 = this;
                    v02.DraggingButton.this.mCloseBtn.setVisibility(0);
                    v02.DraggingButton.this.mCloseBtn.setRotation(180.0f);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).removeRule(11);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).addRule(9);
                    v02.DraggingButton.this.mCloseBtn.requestLayout();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void autoRight() {
        this.animate().setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(100L).x((float)(this.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight)).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (DraggingButton.this.mCloseBtn != null) {
                    2 v02 = this;
                    v02.DraggingButton.this.mCloseBtn.setVisibility(0);
                    v02.DraggingButton.this.mCloseBtn.setRotation(0.0f);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).removeRule(9);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).addRule(11);
                    v02.DraggingButton.this.mCloseBtn.requestLayout();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private boolean isBtnAttachLeft() {
        return this.getX() - (float)this.attachMarginLeft < (float)(this.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight) - this.getX();
    }

    private void initParentView() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        if (viewGroup != null) {
            int[] nArray = new int[2];
            ViewGroup viewGroup2 = viewGroup;
            viewGroup2.getLocationInWindow(nArray);
            this.mRootMeasuredHeight = viewGroup2.getMeasuredHeight();
            this.mRootMeasuredWidth = viewGroup.getMeasuredWidth();
            this.mRootTopY = nArray[1];
        }
    }

    private int getDraggingtMarginLeft() {
        return this.getPageStartMargin() + this.getPageWidth() + ScreenUtil.getInstance().dip2px(20);
    }

    private int getPageStartMargin() {
        return ScreenUtils.getPageStartMargin();
    }

    private int getPageWidth() {
        return ScreenUtils.getPageWidth();
    }

    public ImageView getDraggingImageView() {
        return this.mImageBtn;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        super.dispatchTouchEvent(motionEvent);
        return true;
    }

    public void setOnCloseClickListener(View.OnClickListener onClickListener) {
        DraggingButton draggingButton = draggingButton.mCloseBtn;
        if (draggingButton != null) {
            draggingButton.setOnClickListener(onClickListener);
        }
    }

    public void updateCloseBtnImg(Drawable drawable2) {
        DraggingButton draggingButton = draggingButton.mCloseBtn;
        if (draggingButton != null && drawable2 != null) {
            draggingButton.setImageDrawable(drawable2);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.draggable) {
            float f6 = this.isCarSystem() ? motionEvent.getRawX() - (float)this.getDraggingtMarginLeft() : motionEvent.getRawX();
            MotionEvent motionEvent2 = motionEvent;
            float f7 = motionEvent2.getRawY();
            int n5 = motionEvent2.getAction();
            if (n5 != 0) {
                if (n5 != 1) {
                    if (n5 == 2 && f6 >= 0.0f && f6 <= (float)this.mRootMeasuredWidth) {
                        int n6;
                        n5 = this.mRootTopY;
                        if (f7 >= (float)n6 && f7 <= (float)(this.mRootMeasuredHeight + n5)) {
                            int n7;
                            int n8;
                            float f8 = f6 - this.mLastRawX;
                            float f9 = f7 - this.mLastRawY;
                            if (!this.isDragging) {
                                float f10 = f8;
                                float f11 = f9;
                                boolean bl = !(Math.sqrt(f10 * f10 + f11 * f11) < 2.0);
                                this.isDragging = bl;
                                if (LogUtil.LOGGABLE) {
                                    LogUtil.e(TAG, "onTouchEvent() --> isDragging = " + this.isDragging);
                                }
                                if (this.isDragging) {
                                    ImageView imageView = this.mCloseBtn;
                                    if (imageView != null) {
                                        imageView.setVisibility(8);
                                    }
                                    this.isDragged = true;
                                }
                            }
                            DraggingButton draggingButton = this;
                            float f12 = draggingButton.getX();
                            f8 = f12 + f8;
                            f9 = draggingButton.getY() + f9;
                            f12 = draggingButton.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight;
                            float f13 = draggingButton.mRootMeasuredHeight - this.getHeight() - this.attachMarginBottom;
                            if (draggingButton.isCarSystem()) {
                                f13 = this.mRootMeasuredHeight - this.getHeight();
                            }
                            int n9 = this.attachMarginLeft;
                            f8 = f8 < (float)n8 ? (float)n9 : Math.min(f8, f12);
                            int n10 = this.attachMarginTop;
                            f9 = f9 < (float)n7 ? (float)n10 : Math.min(f9, f13);
                            DraggingButton draggingButton2 = this;
                            draggingButton2.setX(f8);
                            draggingButton2.setY(f9);
                            draggingButton2.mLastRawX = f6;
                            draggingButton2.mLastRawY = f7;
                        }
                    }
                } else if (this.attachable && this.isDragging) {
                    DraggingButton draggingButton = this;
                    f6 = (float)draggingButton.mRootMeasuredWidth / 2.0f;
                    if (draggingButton.mLastRawX <= f6) {
                        this.autoLeft();
                    } else {
                        this.autoRight();
                    }
                }
            } else {
                this.isDragging = false;
                this.mLastRawX = f6;
                this.mLastRawY = f7;
                this.initParentView();
            }
        }
        return this.isDragging || super.onTouchEvent(motionEvent);
    }

    public boolean isDragged() {
        return this.draggable && this.isDragged;
    }

    public void setAttachable(boolean bl) {
        this.attachable = bl;
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public void setAttachMarginLeft(final int n5) {
        Runnable runnable;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginLeft() --> attachMarginLeft = " + n5);
        }
        this.attachMarginLeft = n5;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                3 v02 = this;
                v02.DraggingButton.this.initParentView();
                if (v02.DraggingButton.this.mRootMeasuredWidth > 0 && DraggingButton.this.isBtnAttachLeft()) {
                    DraggingButton.this.setX(n5);
                }
            }
        };
        this.post(runnable2);
    }

    public void setAttachMarginRight(final int n5) {
        Runnable runnable;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginRight() --> attachMarginRight = " + n5);
        }
        this.attachMarginRight = n5;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                4 v02 = this;
                v02.DraggingButton.this.initParentView();
                if (v02.DraggingButton.this.mRootMeasuredWidth > 0 && DraggingButton.this.isBtnAttachLeft()) {
                    DraggingButton draggingButton = DraggingButton.this;
                    draggingButton.setX(draggingButton.mRootMeasuredWidth - DraggingButton.this.getWidth() - n5);
                }
            }
        };
        this.post(runnable2);
    }

    public void setAttachMarginTop(final int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginTop() --> attachMarginTop = " + n5 + ", isDragged = " + this.isDragged);
        }
        this.attachMarginTop = n5;
        if (this.isDragged) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    DraggingButton.this.initParentView();
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(DraggingButton.TAG, "setAttachMarginTop() --> mRootMeasuredHeight = " + DraggingButton.this.mRootMeasuredHeight + ", getY = " + DraggingButton.this.getY() + ", attachMarginTop = " + n5);
                    }
                    if (DraggingButton.this.mRootMeasuredHeight > 0 && DraggingButton.this.getY() != 0.0f) {
                        int n52;
                        int n6 = n5;
                        if (DraggingButton.this.getY() < (float)n52) {
                            DraggingButton.this.setY(n6);
                        }
                    }
                }
            };
            this.post(runnable2);
        }
    }

    public void setAttachMarginBottom(final int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginBottom() --> attachMarginBottom = " + n5 + ", isDragged = " + this.isDragged);
        }
        this.attachMarginBottom = n5;
        if (this.isDragged) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    DraggingButton.this.initParentView();
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(DraggingButton.TAG, "setAttachMarginBottom() --> mRootMeasuredHeight = " + DraggingButton.this.mRootMeasuredHeight + ", getY = " + DraggingButton.this.getY() + ", getHeight = " + DraggingButton.this.getHeight() + ", attachMarginBottom = " + n5);
                    }
                    if (DraggingButton.this.mRootMeasuredHeight > 0 && DraggingButton.this.getY() != 0.0f && DraggingButton.this.getY() > (float)(DraggingButton.this.mRootMeasuredHeight - DraggingButton.this.getHeight() - n5)) {
                        DraggingButton draggingButton = DraggingButton.this;
                        draggingButton.setY(draggingButton.mRootMeasuredHeight - DraggingButton.this.getHeight() - n5);
                    }
                }
            };
            this.post(runnable2);
        }
    }

    public boolean isLandscape() {
        return ScreenUtils.isLandscape();
    }

    public boolean isTablet() {
        return ScreenUtils.isTablet((Configuration)this.getContext().getResources().getConfiguration());
    }

    public boolean isCarSystem() {
        return this.isTablet() && this.isLandscape();
    }
}

