/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.likebutton;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import androidx.annotation.ColorInt;
import com.baidu.navisdk.ui.widget.likebutton.Utils;

public class CircleView
extends View {
    public static final Property<CircleView, Float> INNER_CIRCLE_RADIUS_PROGRESS = new Property<CircleView, Float>(Float.class, "innerCircleRadiusProgress"){

        public Float get(CircleView circleView) {
            return Float.valueOf(circleView.getInnerCircleRadiusProgress());
        }

        public void set(CircleView circleView, Float f6) {
            circleView.setInnerCircleRadiusProgress(f6.floatValue());
        }
    };
    public static final Property<CircleView, Float> OUTER_CIRCLE_RADIUS_PROGRESS = new Property<CircleView, Float>(Float.class, "outerCircleRadiusProgress"){

        public Float get(CircleView circleView) {
            return Float.valueOf(circleView.getOuterCircleRadiusProgress());
        }

        public void set(CircleView circleView, Float f6) {
            circleView.setOuterCircleRadiusProgress(f6.floatValue());
        }
    };
    private int START_COLOR;
    private int END_COLOR;
    private ArgbEvaluator argbEvaluator;
    private Paint circlePaint;
    private Paint maskPaint;
    private Bitmap tempBitmap;
    private Canvas tempCanvas;
    private float outerCircleRadiusProgress;
    private float innerCircleRadiusProgress;
    private int maxCircleSize;

    public CircleView(Context context) {
        Paint paint;
        Paint paint2;
        ArgbEvaluator argbEvaluator;
        CircleView circleView = circleView2;
        super(context);
        circleView.START_COLOR = -43230;
        circleView.END_COLOR = -16121;
        CircleView circleView2 = argbEvaluator;
        argbEvaluator = new ArgbEvaluator();
        circleView.argbEvaluator = circleView2;
        circleView2 = paint2;
        paint2 = new Paint();
        circleView.circlePaint = circleView2;
        circleView2 = paint;
        paint = new Paint();
        circleView.maskPaint = circleView2;
        circleView.outerCircleRadiusProgress = 0.0f;
        circleView.innerCircleRadiusProgress = 0.0f;
        circleView.init();
    }

    public CircleView(Context context, AttributeSet attributeSet) {
        Paint paint;
        Paint paint2;
        ArgbEvaluator argbEvaluator;
        CircleView circleView = circleView2;
        super(context, attributeSet);
        circleView.START_COLOR = -43230;
        circleView.END_COLOR = -16121;
        CircleView circleView2 = argbEvaluator;
        argbEvaluator = new ArgbEvaluator();
        circleView.argbEvaluator = circleView2;
        circleView2 = paint2;
        paint2 = new Paint();
        circleView.circlePaint = circleView2;
        circleView2 = paint;
        paint = new Paint();
        circleView.maskPaint = circleView2;
        circleView.outerCircleRadiusProgress = 0.0f;
        circleView.innerCircleRadiusProgress = 0.0f;
        circleView.init();
    }

    public CircleView(Context context, AttributeSet attributeSet, int n5) {
        Paint paint;
        Paint paint2;
        ArgbEvaluator argbEvaluator;
        CircleView circleView = circleView2;
        super(context, attributeSet, n5);
        circleView.START_COLOR = -43230;
        circleView.END_COLOR = -16121;
        CircleView circleView2 = argbEvaluator;
        argbEvaluator = new ArgbEvaluator();
        circleView.argbEvaluator = circleView2;
        circleView2 = paint2;
        paint2 = new Paint();
        circleView.circlePaint = circleView2;
        circleView2 = paint;
        paint = new Paint();
        circleView.maskPaint = circleView2;
        circleView.outerCircleRadiusProgress = 0.0f;
        circleView.innerCircleRadiusProgress = 0.0f;
        circleView.init();
    }

    private void init() {
        CircleView circleView = this;
        circleView.circlePaint.setStyle(Paint.Style.FILL);
        circleView.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    private void updateCircleColor() {
        CircleView circleView = object;
        float f6 = (float)Utils.mapValueFromRangeToRange((float)Utils.clamp(circleView.outerCircleRadiusProgress, 0.5, 1.0), 0.5, 1.0, 0.0, 1.0);
        CircleView circleView2 = object;
        Object object = circleView2.START_COLOR;
        circleView.circlePaint.setColor(((Integer)object.argbEvaluator.evaluate(f6, object, (Object)circleView2.END_COLOR)).intValue());
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        super.onSizeChanged(n5, n6, n7, n8);
        this.maxCircleSize = n5 / 2;
        this.tempBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.tempCanvas = new Canvas(this.tempBitmap);
    }

    protected void onDraw(Canvas canvas) {
        CircleView circleView = this;
        super.onDraw(canvas);
        circleView.tempCanvas.drawColor(0xFFFFFF, PorterDuff.Mode.CLEAR);
        CircleView circleView2 = this;
        float f6 = circleView2.getWidth() / 2;
        float f7 = circleView2.getHeight() / 2;
        float f8 = circleView2.outerCircleRadiusProgress * (float)this.maxCircleSize;
        Paint paint = circleView2.circlePaint;
        circleView.tempCanvas.drawCircle(f6, f7, f8, paint);
        CircleView circleView3 = this;
        f6 = circleView3.getWidth() / 2;
        f7 = circleView3.getHeight() / 2;
        float f9 = circleView3.innerCircleRadiusProgress * (float)this.maxCircleSize;
        Paint paint2 = circleView3.maskPaint;
        circleView.tempCanvas.drawCircle(f6, f7, f9, paint2);
        canvas.drawBitmap(circleView.tempBitmap, 0.0f, 0.0f, null);
    }

    public void setInnerCircleRadiusProgress(float f6) {
        this.innerCircleRadiusProgress = f6;
        this.postInvalidate();
    }

    public float getInnerCircleRadiusProgress() {
        return this.innerCircleRadiusProgress;
    }

    public void setOuterCircleRadiusProgress(float f6) {
        CircleView circleView = this;
        circleView.outerCircleRadiusProgress = f6;
        circleView.updateCircleColor();
        circleView.postInvalidate();
    }

    public float getOuterCircleRadiusProgress() {
        return this.outerCircleRadiusProgress;
    }

    public void setStartColor(@ColorInt int n5) {
        this.START_COLOR = n5;
        this.invalidate();
    }

    public void setEndColor(@ColorInt int n5) {
        this.END_COLOR = n5;
        this.invalidate();
    }
}

