/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.likebutton;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import androidx.annotation.ColorInt;
import com.baidu.navisdk.ui.widget.likebutton.Utils;

public class DotsView
extends View {
    private static final int DOTS_COUNT = 8;
    private static final int OUTER_DOTS_POSITION_ANGLE = 45;
    public static final Property<DotsView, Float> DOTS_PROGRESS = new Property<DotsView, Float>(Float.class, "dotsProgress"){

        public Float get(DotsView dotsView) {
            return Float.valueOf(dotsView.getCurrentProgress());
        }

        public void set(DotsView dotsView, Float f6) {
            dotsView.setCurrentProgress(f6.floatValue());
        }
    };
    private int COLOR_1;
    private int COLOR_2;
    private int COLOR_3;
    private int COLOR_4;
    private final Paint[] circlePaints;
    private int centerX;
    private int centerY;
    private float maxOuterDotsRadius;
    private float maxDotSize;
    private float currentProgress;
    private float currentRadius1;
    private float currentDotSize1;
    private ArgbEvaluator argbEvaluator;

    public DotsView(Context context) {
        DotsView dotsView = this;
        super(context);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    public DotsView(Context context, AttributeSet attributeSet) {
        DotsView dotsView = this;
        super(context, attributeSet);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    public DotsView(Context context, AttributeSet attributeSet, int n5) {
        DotsView dotsView = this;
        super(context, attributeSet, n5);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    private void init() {
        Paint paint;
        for (int i5 = 0; i5 < ((Paint[])(paint = this.circlePaints)).length; ++i5) {
            Paint paint2;
            Paint paint3 = paint;
            paint = paint2;
            paint2 = new Paint();
            paint3[i5] = paint;
            this.circlePaints[i5].setStyle(Paint.Style.FILL);
        }
    }

    private void drawOuterDotsFrame(Canvas canvas) {
        for (int i5 = 0; i5 < 8; ++i5) {
            DotsView dotsView = this;
            double d6 = (double)(i5 * 45) * Math.PI / 180.0;
            int n5 = (int)((double)dotsView.centerX + (double)this.currentRadius1 * Math.cos(d6));
            float f6 = n5;
            float f7 = (int)((double)dotsView.centerY + (double)this.currentRadius1 * Math.sin(d6));
            float f8 = dotsView.currentDotSize1;
            Paint[] paintArray = dotsView.circlePaints;
            Paint paint = paintArray[i5 % paintArray.length];
            canvas.drawCircle(f6, f7, f8, paint);
        }
    }

    private void updateOuterDotsPosition() {
        double d6;
        float f6;
        float f7 = this.currentProgress;
        if (f6 < 0.3f) {
            d6 = this.maxOuterDotsRadius * 0.8f;
            this.currentRadius1 = (float)Utils.mapValueFromRangeToRange(f7, 0.0, 0.3f, 0.0, d6);
        } else {
            float f8 = this.maxOuterDotsRadius;
            d6 = f8 * 0.8f;
            double d7 = f8;
            this.currentRadius1 = (float)Utils.mapValueFromRangeToRange(f7, 0.3f, 1.0, d6, d7);
        }
        float f9 = this.currentProgress;
        if (f9 == 0.0f) {
            this.currentDotSize1 = 0.0f;
        } else if ((double)f9 < 0.7) {
            this.currentDotSize1 = this.maxDotSize;
        } else {
            double d8 = this.maxDotSize;
            this.currentDotSize1 = (float)Utils.mapValueFromRangeToRange(f9, 0.7f, 1.0, d8, 0.0);
        }
    }

    private void updateDotsPaints() {
        Object object;
        float f6;
        float f7 = object.currentProgress;
        if (f6 < 0.5f) {
            DotsView dotsView = object;
            f7 = (float)Utils.mapValueFromRangeToRange(f7, 0.0, 0.5, 0.0, 1.0);
            DotsView dotsView2 = object;
            Integer n5 = dotsView2.COLOR_1;
            dotsView.circlePaints[0].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n5, (Object)dotsView2.COLOR_2)).intValue());
            DotsView dotsView3 = object;
            n5 = dotsView3.COLOR_2;
            dotsView.circlePaints[1].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n5, (Object)dotsView3.COLOR_3)).intValue());
            DotsView dotsView4 = object;
            n5 = dotsView4.COLOR_3;
            dotsView.circlePaints[2].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n5, (Object)dotsView4.COLOR_4)).intValue());
            DotsView dotsView5 = object;
            object = dotsView5.COLOR_4;
            dotsView.circlePaints[3].setColor(((Integer)object.argbEvaluator.evaluate(f7, object, (Object)dotsView5.COLOR_1)).intValue());
        } else {
            DotsView dotsView = object;
            f7 = (float)Utils.mapValueFromRangeToRange(f7, 0.5, 1.0, 0.0, 1.0);
            DotsView dotsView6 = object;
            Integer n6 = dotsView6.COLOR_2;
            dotsView.circlePaints[0].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n6, (Object)dotsView6.COLOR_3)).intValue());
            DotsView dotsView7 = object;
            n6 = dotsView7.COLOR_3;
            dotsView.circlePaints[1].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n6, (Object)dotsView7.COLOR_4)).intValue());
            DotsView dotsView8 = object;
            n6 = dotsView8.COLOR_4;
            dotsView.circlePaints[2].setColor(((Integer)object.argbEvaluator.evaluate(f7, (Object)n6, (Object)dotsView8.COLOR_1)).intValue());
            DotsView dotsView9 = object;
            object = dotsView9.COLOR_1;
            dotsView.circlePaints[3].setColor(((Integer)object.argbEvaluator.evaluate(f7, object, (Object)dotsView9.COLOR_2)).intValue());
        }
    }

    private void updateDotsAlpha() {
        DotsView dotsView = this;
        int n5 = (int)Utils.mapValueFromRangeToRange((float)Utils.clamp(dotsView.currentProgress, 0.6f, 1.0), 0.6f, 1.0, 255.0, 0.0);
        dotsView.circlePaints[0].setAlpha(n5);
        dotsView.circlePaints[1].setAlpha(n5);
        dotsView.circlePaints[2].setAlpha(n5);
        dotsView.circlePaints[3].setAlpha(n5);
    }

    private float dip2px(Context context, float f6) {
        return context.getResources().getDisplayMetrics().density * f6 + 0.5f;
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        float f6;
        DotsView dotsView = this;
        super.onSizeChanged(n5, n6, n7, n8);
        this.centerX = n5 /= 2;
        dotsView.centerY = n6 / 2;
        dotsView.maxDotSize = f6 = dotsView.dip2px(dotsView.getContext(), 0.75f);
        DotsView dotsView2 = this;
        dotsView.maxOuterDotsRadius = (float)n5 - f6 * 2.0f + dotsView2.dip2px(dotsView2.getContext(), 12.0f);
    }

    protected void onDraw(Canvas canvas) {
        this.drawOuterDotsFrame(canvas);
    }

    public void setCurrentProgress(float f6) {
        DotsView dotsView = this;
        dotsView.currentProgress = f6;
        dotsView.updateOuterDotsPosition();
        dotsView.updateDotsPaints();
        dotsView.updateDotsAlpha();
        dotsView.postInvalidate();
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    public void setColors(@ColorInt int n5, @ColorInt int n6) {
        this.COLOR_1 = n5;
        this.COLOR_2 = n6;
        this.COLOR_3 = n5;
        this.COLOR_4 = n6;
        this.invalidate();
    }
}

