/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.listener;

import android.graphics.Canvas;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;

public class ItemTouchCallback
extends ItemTouchHelper.Callback {
    private final ItemTouchAdapter itemTouchAdapter;
    private OnDragListener onDragListener;

    public ItemTouchCallback(@NonNull ItemTouchAdapter itemTouchAdapter) {
        this.itemTouchAdapter = itemTouchAdapter;
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        int n5 = recyclerView.getLayoutManager() instanceof GridLayoutManager ? 15 : 3;
        if (this.itemTouchAdapter.isItemForbidMove(viewHolder)) {
            n5 = 0;
        }
        this.itemTouchAdapter.isItemForbidSwipe(viewHolder);
        return ItemTouchHelper.Callback.makeMovementFlags((int)n5, (int)0);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder viewHolder2) {
        this.itemTouchAdapter.onMove(viewHolder, viewHolder2);
        return true;
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int n5) {
        this.itemTouchAdapter.onSwiped(viewHolder);
    }

    public boolean isLongPressDragEnabled() {
        return super.isLongPressDragEnabled();
    }

    public boolean isItemViewSwipeEnabled() {
        return super.isItemViewSwipeEnabled();
    }

    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int n5) {
        if (n5 != 0) {
            Object object = this.itemTouchAdapter;
            if (object != null) {
                object.onStartDrag(viewHolder);
            }
            if ((object = this.onDragListener) != null) {
                object.onStartDrag(viewHolder);
            }
        }
        super.onSelectedChanged(viewHolder, n5);
    }

    public void clearView(@NonNull RecyclerView object, @NonNull RecyclerView.ViewHolder viewHolder) {
        ItemTouchCallback itemTouchCallback = this;
        super.clearView((RecyclerView)object, viewHolder);
        object = itemTouchCallback.itemTouchAdapter;
        if (object != null) {
            object.onFinishDrag(viewHolder);
        }
        if ((this = ((ItemTouchCallback)((Object)this)).onDragListener) != null) {
            this.onFinishDrag(viewHolder);
        }
    }

    public void onChildDraw(@NonNull Canvas canvas, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float f6, float f7, int n5, boolean bl) {
        if (n5 == 1) {
            RecyclerView.ViewHolder viewHolder2 = viewHolder;
            float f8 = 1.0f - Math.abs(f6) / (float)viewHolder.itemView.getWidth();
            viewHolder2.itemView.setAlpha(f8);
            viewHolder2.itemView.setTranslationX(f6);
        } else {
            super.onChildDraw(canvas, recyclerView, viewHolder, f6, f7, n5, bl);
        }
    }

    public ItemTouchCallback setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
        return this;
    }

    public static interface ItemTouchAdapter {
        public void onStartDrag(@Nullable RecyclerView.ViewHolder var1);

        public void onFinishDrag(@NonNull RecyclerView.ViewHolder var1);

        public void onMove(@NonNull RecyclerView.ViewHolder var1, @NonNull RecyclerView.ViewHolder var2);

        public void onSwiped(@NonNull RecyclerView.ViewHolder var1);

        public boolean isItemForbidMove(@NonNull RecyclerView.ViewHolder var1);

        public boolean isItemForbidSwipe(@NonNull RecyclerView.ViewHolder var1);
    }

    public static interface OnDragListener {
        public void onStartDrag(@Nullable RecyclerView.ViewHolder var1);

        public void onFinishDrag(@NonNull RecyclerView.ViewHolder var1);
    }
}

