/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.loadmore;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import androidx.annotation.LayoutRes;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import com.baidu.navisdk.ui.widget.loadmore.BNSwipeView;
import com.baidu.navisdk.util.common.i;

public class BNSwipeRefreshLayout
extends FrameLayout
implements NestedScrollingParent {
    public static final String TAG = "BNSwipeRefreshLayout";
    public static final int NOT_OVER_TRIGGER_POINT = 1;
    public static final int OVER_TRIGGER_POINT = 2;
    public static final int START = 3;
    private static final int GUIDANCE_VIEW_HEIGHT_DEFAULT = 80;
    private static final int ACTION_PULL_REFRESH = 0;
    private static final int ACTION_LOAD_MORE = 1;
    private NestedScrollingParentHelper parentHelper;
    private BNSwipeRefreshListener onRefreshListener;
    private final BNSwipeView headerView = new BNSwipeView(this.getContext());
    private final BNSwipeView footerView = new BNSwipeView(this.getContext());
    private View mTargetView;
    private boolean mPullRefreshEnable = true;
    private boolean mPullLoadEnable = true;
    private volatile boolean mRefreshing = false;
    private float guidanceViewHeight = 0.0f;
    private float guidanceViewFlowHeight = 0.0f;
    private int mCurrentAction = -1;
    private boolean isConfirm = false;
    private boolean isNeedTranslateTargetY = true;
    private ValueAnimator mStartLoadMoreAnimator;
    private ValueAnimator mResetFootViewValueAnimator;

    public BNSwipeRefreshLayout(Context context) {
        super(context);
        this.initView(context, null);
    }

    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context, attributeSet);
    }

    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        this.initView(context, attributeSet);
    }

    @TargetApi(value=21)
    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet, int n5, int n6) {
        super(context, attributeSet, n5, n6);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        if (this.getChildCount() <= 1) {
            this.parentHelper = new NestedScrollingParentHelper((ViewGroup)this);
            this.guidanceViewHeight = this.dipToPx(context, 80.0f);
            this.guidanceViewFlowHeight = this.guidanceViewHeight * 1.5f;
            return;
        }
        throw new RuntimeException("WXSwipeLayout should not have more than one child");
    }

    private void setGuidanceView() {
        FrameLayout.LayoutParams layoutParams;
        FrameLayout.LayoutParams layoutParams2;
        BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshLayout2;
        BNSwipeRefreshLayout bNSwipeRefreshLayout2 = layoutParams2;
        layoutParams2 = new FrameLayout.LayoutParams(-1, 0);
        bNSwipeRefreshLayout.addView((View)bNSwipeRefreshLayout.headerView, (ViewGroup.LayoutParams)bNSwipeRefreshLayout2);
        bNSwipeRefreshLayout2 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)0).gravity = 80;
        bNSwipeRefreshLayout.addView((View)bNSwipeRefreshLayout.footerView, (ViewGroup.LayoutParams)bNSwipeRefreshLayout2);
    }

    private boolean moveGuidanceView(float f6) {
        if (this.mRefreshing) {
            return false;
        }
        if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mCurrentAction == 0) {
            BNSwipeRefreshListener bNSwipeRefreshListener;
            float f7;
            FrameLayout.LayoutParams layoutParams = null;
            ViewGroup.LayoutParams layoutParams2 = this.headerView.getLayoutParams();
            if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                layoutParams = (FrameLayout.LayoutParams)layoutParams2;
            }
            if (layoutParams == null) {
                return false;
            }
            layoutParams.height = (int)((float)layoutParams.height + f6);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            f6 = this.guidanceViewFlowHeight;
            if ((float)layoutParams.height > f7) {
                layoutParams.height = (int)f6;
            }
            if ((bNSwipeRefreshListener = this.onRefreshListener) != null) {
                float f8;
                int n5;
                int n6 = layoutParams.height;
                float f9 = this.guidanceViewHeight;
                if ((float)n5 >= f8) {
                    bNSwipeRefreshListener.onRefreshPulStateChange((float)n6 / f9, 2);
                } else {
                    bNSwipeRefreshListener.onRefreshPulStateChange((float)n6 / f9, 1);
                }
            }
            if (layoutParams.height == 0) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.isConfirm = false;
                bNSwipeRefreshLayout.mCurrentAction = -1;
            }
            BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
            bNSwipeRefreshLayout.headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            bNSwipeRefreshLayout.headerView.setProgressRotation((float)layoutParams.height / this.guidanceViewFlowHeight);
            this.moveTargetView(layoutParams.height);
            return true;
        }
        if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mCurrentAction == 1) {
            BNSwipeRefreshListener bNSwipeRefreshListener;
            float f10;
            FrameLayout.LayoutParams layoutParams = null;
            ViewGroup.LayoutParams layoutParams3 = this.footerView.getLayoutParams();
            if (layoutParams3 instanceof FrameLayout.LayoutParams) {
                layoutParams = (FrameLayout.LayoutParams)layoutParams3;
            }
            if (layoutParams == null) {
                return false;
            }
            i.L.c(TAG, "--moveGuidanceView,lp.height:" + layoutParams.height + ",guidanceViewHeight:" + this.guidanceViewHeight + ",guidanceViewFlowHeight:" + this.guidanceViewFlowHeight);
            layoutParams.height = (int)((float)layoutParams.height - f6);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            f6 = this.guidanceViewFlowHeight;
            if ((float)layoutParams.height > f10) {
                layoutParams.height = (int)f6;
            }
            if ((bNSwipeRefreshListener = this.onRefreshListener) != null) {
                float f11;
                int n7;
                int n8 = layoutParams.height;
                float f12 = this.guidanceViewHeight;
                if ((float)n7 >= f11) {
                    bNSwipeRefreshListener.onLoadMorePullStateChange((float)n8 / f12, 2);
                } else {
                    bNSwipeRefreshListener.onLoadMorePullStateChange((float)n8 / f12, 1);
                }
            }
            if (layoutParams.height == 0) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.isConfirm = false;
                bNSwipeRefreshLayout.mCurrentAction = -1;
                i.L.c(TAG, "--moveGuidanceView,mCurrentAction:-1");
            }
            BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
            bNSwipeRefreshLayout.footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            bNSwipeRefreshLayout.footerView.setProgressRotation((float)layoutParams.height / this.guidanceViewFlowHeight);
            this.moveTargetView(-layoutParams.height);
            return true;
        }
        return false;
    }

    private void moveTargetView(float f6) {
        if (this.isNeedTranslateTargetY) {
            this.mTargetView.setTranslationY(f6);
        }
    }

    private void handlerAction() {
        ViewGroup.LayoutParams layoutParams;
        i.L.c(TAG, "--handlerAction,mRefreshing:" + ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mRefreshing + ",guidanceViewHeight:" + ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight + ",guidanceViewFlowHeight:" + ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewFlowHeight);
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mRefreshing) {
            return;
        }
        ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).isConfirm = false;
        FrameLayout.LayoutParams layoutParams2 = null;
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mPullRefreshEnable && ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mCurrentAction == 0 && (layoutParams = ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).headerView.getLayoutParams()) instanceof FrameLayout.LayoutParams) {
            int n5;
            layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            int n6 = layoutParams2.height;
            if ((float)n5 >= ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshListener;
                bNSwipeRefreshLayout.startRefresh(n6);
                BNSwipeRefreshListener bNSwipeRefreshListener = bNSwipeRefreshLayout.onRefreshListener;
                if (bNSwipeRefreshListener != null) {
                    bNSwipeRefreshListener.onRefreshPulStateChange(1.0f, 3);
                }
            } else if (n6 > 0) {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetHeaderView(n6);
            } else {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetRefreshState();
            }
        }
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mPullLoadEnable && ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mCurrentAction == 1) {
            ViewGroup.LayoutParams layoutParams3 = ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).footerView.getLayoutParams();
            if (layoutParams3 instanceof FrameLayout.LayoutParams) {
                layoutParams2 = (FrameLayout.LayoutParams)layoutParams3;
            }
            if (layoutParams2 != null) {
                int n7;
                i.L.c(TAG, "--handlerAction,lp.height:" + layoutParams2.height + ",guidanceViewHeight:" + ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight + ",guidanceViewFlowHeight:" + ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewFlowHeight);
                int n8 = layoutParams2.height;
                if ((float)n7 >= ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight) {
                    BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshListener;
                    bNSwipeRefreshLayout.startLoadMore(n8);
                    BNSwipeRefreshListener bNSwipeRefreshListener = bNSwipeRefreshLayout.onRefreshListener;
                    if (bNSwipeRefreshListener != null) {
                        bNSwipeRefreshListener.onLoadMorePullStateChange(1.0f, 3);
                    }
                } else if (n8 > 0) {
                    ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetFootView(n8);
                } else {
                    ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetLoadMoreState();
                }
            }
        }
    }

    private void startRefresh(int n5) {
        BNSwipeAnimatorListener bNSwipeAnimatorListener;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        this.mRefreshing = true;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n5, this.guidanceViewHeight});
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FrameLayout.LayoutParams layoutParams = null;
                ViewGroup.LayoutParams layoutParams2 = BNSwipeRefreshLayout.this.headerView.getLayoutParams();
                if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                    layoutParams = (FrameLayout.LayoutParams)layoutParams2;
                }
                if (layoutParams == null) {
                    return;
                }
                1 v02 = this;
                layoutParams.height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                v02.BNSwipeRefreshLayout.this.moveTargetView(layoutParams.height);
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        object = bNSwipeAnimatorListener;
        bNSwipeAnimatorListener = new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                2 v02 = this;
                v02.BNSwipeRefreshLayout.this.headerView.startAnimation();
                if (v02.BNSwipeRefreshLayout.this.onRefreshListener != null) {
                    BNSwipeRefreshLayout.this.onRefreshListener.onRefresh();
                }
            }
        };
        valueAnimator.addListener((Animator.AnimatorListener)object);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetHeaderView(int n5) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.headerView.stopAnimation();
        bNSwipeRefreshLayout.headerView.setStartEndTrim(0.0f, 0.75f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n5, 0.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FrameLayout.LayoutParams layoutParams = null;
                ViewGroup.LayoutParams layoutParams2 = BNSwipeRefreshLayout.this.headerView.getLayoutParams();
                if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                    layoutParams = (FrameLayout.LayoutParams)layoutParams2;
                }
                if (layoutParams == null) {
                    return;
                }
                3 v02 = this;
                layoutParams.height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                v02.BNSwipeRefreshLayout.this.moveTargetView(layoutParams.height);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                BNSwipeRefreshLayout.this.resetRefreshState();
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetRefreshState() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.mRefreshing = false;
        bNSwipeRefreshLayout.isConfirm = false;
        bNSwipeRefreshLayout.mCurrentAction = -1;
    }

    private void startLoadMore(int n5) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        i.L.c(TAG, "--startLoadMore,headerViewHeight:" + n5);
        bNSwipeRefreshLayout.mRefreshing = true;
        bNSwipeRefreshLayout.resetFootViewResetAnimImmediately();
        ValueAnimator valueAnimator = bNSwipeRefreshLayout.mStartLoadMoreAnimator;
        if (valueAnimator != null) {
            BNSwipeRefreshLayout bNSwipeRefreshLayout2 = this;
            valueAnimator.removeAllUpdateListeners();
            bNSwipeRefreshLayout2.mStartLoadMoreAnimator.removeAllListeners();
            bNSwipeRefreshLayout2.mStartLoadMoreAnimator.cancel();
            bNSwipeRefreshLayout2.mStartLoadMoreAnimator.setFloatValues(new float[]{n5, this.guidanceViewHeight});
        } else {
            this.mStartLoadMoreAnimator = ValueAnimator.ofFloat((float[])new float[]{n5, this.guidanceViewHeight});
            this.mStartLoadMoreAnimator.setDuration(300L);
        }
        BNSwipeRefreshLayout bNSwipeRefreshLayout3 = this;
        bNSwipeRefreshLayout3.mStartLoadMoreAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FrameLayout.LayoutParams layoutParams = null;
                ViewGroup.LayoutParams layoutParams2 = BNSwipeRefreshLayout.this.footerView.getLayoutParams();
                if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                    layoutParams = (FrameLayout.LayoutParams)layoutParams2;
                }
                if (layoutParams == null) {
                    return;
                }
                5 v02 = this;
                layoutParams.height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                v02.BNSwipeRefreshLayout.this.moveTargetView(-layoutParams.height);
            }
        });
        bNSwipeRefreshLayout3.mStartLoadMoreAnimator.addListener((Animator.AnimatorListener)new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                6 v02 = this;
                i.L.c(BNSwipeRefreshLayout.TAG, "--startLoadMore,onAnimationEnd,animation:" + animator);
                v02.BNSwipeRefreshLayout.this.footerView.startAnimation();
                if (v02.BNSwipeRefreshLayout.this.onRefreshListener != null) {
                    BNSwipeRefreshLayout.this.onRefreshListener.onLoading();
                }
            }
        });
        bNSwipeRefreshLayout3.mStartLoadMoreAnimator.start();
    }

    private void resetFootViewResetAnimImmediately() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        i.L.c(TAG, "--resetFootViewResetAnimImmediately,resetFootViewValueAnimatort:" + this.mResetFootViewValueAnimator);
        bNSwipeRefreshLayout.footerView.stopAnimation();
        bNSwipeRefreshLayout.footerView.setStartEndTrim(0.5f, 1.25f);
        ValueAnimator valueAnimator = bNSwipeRefreshLayout.mResetFootViewValueAnimator;
        if (valueAnimator != null) {
            BNSwipeRefreshLayout bNSwipeRefreshLayout2 = this;
            valueAnimator.removeAllListeners();
            bNSwipeRefreshLayout2.mResetFootViewValueAnimator.removeAllUpdateListeners();
            bNSwipeRefreshLayout2.mResetFootViewValueAnimator.cancel();
        }
    }

    private void resetFootView(int n5) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        i.L.c(TAG, "--resetFootView,headerViewHeight:" + n5 + ",resetFootViewValueAnimator:" + this.mResetFootViewValueAnimator);
        bNSwipeRefreshLayout.footerView.stopAnimation();
        bNSwipeRefreshLayout.footerView.setStartEndTrim(0.5f, 1.25f);
        ValueAnimator valueAnimator = bNSwipeRefreshLayout.mResetFootViewValueAnimator;
        if (valueAnimator != null) {
            BNSwipeRefreshLayout bNSwipeRefreshLayout2 = this;
            valueAnimator.removeAllUpdateListeners();
            bNSwipeRefreshLayout2.mResetFootViewValueAnimator.removeAllListeners();
            bNSwipeRefreshLayout2.mResetFootViewValueAnimator.cancel();
            bNSwipeRefreshLayout2.mResetFootViewValueAnimator.setFloatValues(new float[]{n5, 0.0f});
        } else {
            this.mResetFootViewValueAnimator = ValueAnimator.ofFloat((float[])new float[]{n5, 0.0f});
            this.mResetFootViewValueAnimator.setDuration(300L);
        }
        BNSwipeRefreshLayout bNSwipeRefreshLayout3 = this;
        bNSwipeRefreshLayout3.mResetFootViewValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FrameLayout.LayoutParams layoutParams = null;
                ViewGroup.LayoutParams layoutParams2 = BNSwipeRefreshLayout.this.footerView.getLayoutParams();
                if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                    layoutParams = (FrameLayout.LayoutParams)layoutParams2;
                }
                if (layoutParams == null) {
                    return;
                }
                7 v02 = this;
                layoutParams.height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                v02.BNSwipeRefreshLayout.this.moveTargetView(-layoutParams.height);
            }
        });
        bNSwipeRefreshLayout3.mResetFootViewValueAnimator.addListener((Animator.AnimatorListener)new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                i.L.c(BNSwipeRefreshLayout.TAG, "--resetFootView,onAnimationEnd,animation:" + animator);
                BNSwipeRefreshLayout.this.resetLoadMoreState();
            }
        });
        bNSwipeRefreshLayout3.mResetFootViewValueAnimator.start();
    }

    private void resetLoadMoreState() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        i.L.c(TAG, "--resetLoadMoreState");
        bNSwipeRefreshLayout.mRefreshing = false;
        bNSwipeRefreshLayout.isConfirm = false;
        bNSwipeRefreshLayout.mCurrentAction = -1;
    }

    protected void onAttachedToWindow() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        super.onAttachedToWindow();
        bNSwipeRefreshLayout.mTargetView = bNSwipeRefreshLayout.getChildAt(0);
        bNSwipeRefreshLayout.setGuidanceView();
    }

    protected void onDetachedFromWindow() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        super.onDetachedFromWindow();
        bNSwipeRefreshLayout.removeView((View)bNSwipeRefreshLayout.headerView);
        bNSwipeRefreshLayout.removeView((View)bNSwipeRefreshLayout.footerView);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return false;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onStartNestedScroll(View view, View view2, int n5) {
        return true;
    }

    public void onNestedScrollAccepted(View view, View view2, int n5) {
        this.parentHelper.onNestedScrollAccepted(view, view2, n5);
    }

    public void onStopNestedScroll(View view) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.parentHelper.onStopNestedScroll(view);
        bNSwipeRefreshLayout.handlerAction();
    }

    public void onNestedPreScroll(View view, int n5, int n6, int[] nArray) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return;
        }
        if (Math.abs(n6) > 200) {
            return;
        }
        if (!this.isConfirm) {
            if (n6 < 0 && !this.canChildScrollUp()) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.mCurrentAction = 0;
                bNSwipeRefreshLayout.isConfirm = true;
            } else if (n6 > 0 && !this.canChildScrollDown()) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.mCurrentAction = 1;
                bNSwipeRefreshLayout.isConfirm = true;
            }
        }
        i.L.c(TAG, "--onNestedPreScroll,mCurrentAction:" + this.mCurrentAction);
        if (this.moveGuidanceView(-n6)) {
            nArray[1] = nArray[1] + n6;
        }
    }

    public void onNestedScroll(View view, int n5, int n6, int n7, int n8) {
    }

    public int getNestedScrollAxes() {
        return this.parentHelper.getNestedScrollAxes();
    }

    public boolean onNestedPreFling(View view, float f6, float f7) {
        return false;
    }

    public boolean onNestedFling(View view, float f6, float f7, boolean bl) {
        return false;
    }

    public boolean canChildScrollUp() {
        View view = bNSwipeRefreshLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = (AbsListView)view;
                return bNSwipeRefreshLayout.getChildCount() > 0 && (bNSwipeRefreshLayout.getFirstVisiblePosition() > 0 || bNSwipeRefreshLayout.getChildAt(0).getTop() < bNSwipeRefreshLayout.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || bNSwipeRefreshLayout.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)view, (int)-1);
    }

    public boolean canChildScrollDown() {
        View view = bNSwipeRefreshLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = (AbsListView)view;
                if (bNSwipeRefreshLayout.getChildCount() > 0) {
                    BNSwipeRefreshLayout bNSwipeRefreshLayout2 = bNSwipeRefreshLayout;
                    int n5 = bNSwipeRefreshLayout2.getChildAt(bNSwipeRefreshLayout2.getChildCount() - 1).getBottom();
                    return bNSwipeRefreshLayout2.getLastVisiblePosition() == ((ListAdapter)bNSwipeRefreshLayout.getAdapter()).getCount() - 1 && n5 <= bNSwipeRefreshLayout.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)view, (int)1) || bNSwipeRefreshLayout.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)view, (int)1);
    }

    public float dipToPx(Context context, float f6) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f6, (DisplayMetrics)bNSwipeRefreshLayout);
    }

    public void setOnRefreshListener(BNSwipeRefreshListener bNSwipeRefreshListener) {
        this.onRefreshListener = bNSwipeRefreshListener;
    }

    public void finishRefresh() {
        if (this.mCurrentAction == 0) {
            BNSwipeView bNSwipeView = this.headerView;
            int n5 = bNSwipeView == null ? 0 : bNSwipeView.getMeasuredHeight();
            this.resetHeaderView(n5);
        }
    }

    public void finishLoadMore() {
        i.L.c(TAG, "--finishLoadMore,mCurrentAction:" + this.mCurrentAction + ",ACTION_LOAD_MORE:" + 1);
        if (this.mCurrentAction == 1) {
            BNSwipeView bNSwipeView = this.footerView;
            int n5 = bNSwipeView == null ? 0 : bNSwipeView.getMeasuredHeight();
            this.resetFootView(n5);
        }
    }

    public boolean isLoadMoreEnable() {
        return this.mPullLoadEnable;
    }

    public void setLoadMoreEnable(boolean bl) {
        this.mPullLoadEnable = bl;
    }

    public boolean isRefreshEnable() {
        return this.mPullRefreshEnable;
    }

    public void setRefreshEnable(boolean bl) {
        this.mPullRefreshEnable = bl;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public void setHeaderView(@LayoutRes int n5) {
        this.headerView.setGuidanceView(n5);
    }

    public void setHeaderView(View view) {
        this.headerView.setGuidanceView(view);
    }

    public void setFooterView(@LayoutRes int n5) {
        this.footerView.setGuidanceView(n5);
    }

    public void setFooterView(View view) {
        this.footerView.setGuidanceView(view);
    }

    public void setNeedTranslateTargetY(boolean bl) {
        this.isNeedTranslateTargetY = bl;
    }

    public void setGuidanceViewHeight(int n5, int n6) {
        this.guidanceViewHeight = n5;
        this.guidanceViewFlowHeight = n6;
    }

    static class BNSwipeAnimatorListener
    implements Animator.AnimatorListener {
        BNSwipeAnimatorListener() {
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }

    public static interface BNSwipeRefreshListener {
        public void onRefresh();

        public void onLoading();

        public void onRefreshPulStateChange(float var1, int var2);

        public void onLoadMorePullStateChange(float var1, int var2);
    }
}

