/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.nestedscroll;

import android.content.Context;
import android.view.ViewConfiguration;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.reflect.Field;

public class FlingHelper {
    private static final String TAG = "FlingHelper";
    private static final float INFLEXION = 0.35f;
    private static float mFlingFriction = ViewConfiguration.getScrollFriction();
    private static float mPhysicalCoeff;
    private static float DECELERATION_RATE;
    private int mTouchSlop;
    private int mMaximumVelocity;
    private int mMinimumVelocity;

    public FlingHelper(Context context) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        mPhysicalCoeff = context.getResources().getDisplayMetrics().density * 160.0f * 386.0878f * 0.84f;
    }

    private double getSplineDeceleration(int n5) {
        return Math.log((float)Math.abs(n5) * 0.35f / (mFlingFriction * mPhysicalCoeff));
    }

    private double getSplineDecelerationByDistance(double d6) {
        return ((double)DECELERATION_RATE - 1.0) * Math.log(d6 / (double)(mFlingFriction * mPhysicalCoeff)) / (double)DECELERATION_RATE;
    }

    private int getSplineFlingDuration(int n5) {
        return (int)(Math.exp(this.getSplineDeceleration(n5) / ((double)DECELERATION_RATE - 1.0)) * 1000.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Field getDeclaredField(Object clazz, String string2) {
        clazz = clazz.getClass();
        Field field = null;
        while (clazz != Object.class) {
            NoSuchFieldException noSuchFieldException2;
            block5: {
                if (clazz != null) {
                    try {
                        field = clazz.getDeclaredField(string2);
                    }
                    catch (NoSuchFieldException noSuchFieldException2) {
                        break block5;
                    }
                }
                if (field == null) return field;
                field.setAccessible(true);
                return field;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "FlingHelper getDeclareField: " + string2 + " NoSuchFieldException! e = " + noSuchFieldException2);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    static {
        DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    }

    public double getSplineFlingDistance(int n5) {
        double d6 = this.getSplineDeceleration(n5);
        float f6 = DECELERATION_RATE;
        double d7 = (double)f6 - 1.0;
        return (double)(mFlingFriction * mPhysicalCoeff) * Math.exp((double)f6 / d7 * d6);
    }

    public int getVelocityByDistance(double d6) {
        return Math.abs((int)(Math.exp(this.getSplineDecelerationByDistance(d6)) * (double)mFlingFriction * (double)mPhysicalCoeff / (double)0.35f));
    }
}

