/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.nestedscroll;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.widget.NestedScrollView;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.widget.nestedscroll.FlingHelper;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;
import java.lang.reflect.Field;

public class InnerScrollView
extends NestedScrollView {
    private static final String TAG = "InnerScrollView";
    private View mFooterView;
    private int mBoundHeight = 500;
    private ViewGroup mContainer;
    private ViewGroup mContentView;
    private VelocityTracker mVelocityTracker;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private final int[] mNestedOffsets = new int[2];
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mTouchSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private Field scrollerField;
    private Field lastScrollYField;
    private int mLastY;
    private boolean mDragging;
    private boolean isRunAnim;
    private final int mDrag;
    private int mContentHeight;
    private int mScrollViewHeight = -1;
    private FlingHelper mFlingHelper;

    public InnerScrollView(@NonNull Context context) {
        super(context);
        this.mDrag = 2;
        this.init(context);
    }

    public InnerScrollView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mDrag = 2;
        this.init(context);
    }

    public InnerScrollView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        this.mDrag = 2;
        this.init(context);
    }

    private void init(Context context) {
        InnerScrollView innerScrollView = innerScrollView3;
        InnerScrollView innerScrollView2 = innerScrollView3;
        LayoutInflater.from((Context)innerScrollView2.getContext()).inflate(R.layout.nsdk_layout_inner_scroll_view, (ViewGroup)innerScrollView3);
        innerScrollView2.setNestedScrollingEnabled(true);
        innerScrollView2.setFillViewport(true);
        InnerScrollView innerScrollView3 = ViewConfiguration.get((Context)context);
        innerScrollView.mContainer = (ViewGroup)innerScrollView.findViewById(R.id.inner_scroll_container);
        innerScrollView.mContentView = (ViewGroup)innerScrollView.findViewById(R.id.inner_scroll_content);
        innerScrollView.mTouchSlop = innerScrollView3.getScaledTouchSlop();
        innerScrollView.mMinFlingVelocity = innerScrollView3.getScaledMinimumFlingVelocity();
        innerScrollView.mMaxFlingVelocity = innerScrollView3.getScaledMaximumFlingVelocity();
        innerScrollView.mFooterView = new View(context);
        innerScrollView.mFlingHelper = new FlingHelper(context);
    }

    private void scrollByWithLimit(int n5, int n6) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "scrollByWithLimit() --> dx = " + n5 + ", dy = " + n6 + ", getScrollX() = " + this.getScrollX() + ", getScrollY() = " + this.getScrollY());
        }
        if (n5 == 0 && n6 == 0) {
            return;
        }
        InnerScrollView innerScrollView = this;
        n5 = innerScrollView.getScrollX() + n5;
        n6 = innerScrollView.getScrollY() + n6;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 > this.getMaxScrollDis()) {
            n6 = this.getMaxScrollDis();
        }
        this.scrollTo(n5, n6);
    }

    static /* synthetic */ boolean access$102(InnerScrollView innerScrollView, boolean bl) {
        innerScrollView.isRunAnim = bl;
        return bl;
    }

    protected void onFinishInflate() {
        FrameLayout.LayoutParams layoutParams;
        InnerScrollView innerScrollView = innerScrollView3;
        super.onFinishInflate();
        int n5 = innerScrollView.mBoundHeight <= 0 ? 0 : ScreenUtil.getInstance().getHeightPixels();
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, n5);
        InnerScrollView innerScrollView2 = innerScrollView3;
        InnerScrollView innerScrollView3 = innerScrollView2.mFooterView;
        innerScrollView3.mContainer.addView((View)innerScrollView3, innerScrollView2.getChildCount(), (ViewGroup.LayoutParams)layoutParams2);
    }

    protected void onMeasure(int n5, int n6) {
        InnerScrollView innerScrollView = this;
        super.onMeasure(n5, n6);
        int n7 = View.MeasureSpec.makeMeasureSpec((int)(innerScrollView.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
        innerScrollView.mContentView.measure(n7, 0);
        innerScrollView.mContentHeight = innerScrollView.mContentView.getMeasuredHeight() + this.getPaddingTop() + this.getPaddingBottom();
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onMeasure --> widthMeasureSpec = " + n5 + ", heightMeasureSpec = " + n6 + ", contentHeight = " + this.mContentView.getMeasuredHeight() + ", getPaddingLeft() = " + this.getPaddingLeft() + ", getPaddingRight() = " + this.getPaddingRight() + ", getPaddingTop() = " + this.getPaddingTop() + ", getPaddingBottom() = " + this.getPaddingBottom());
        }
        InnerScrollView innerScrollView2 = this;
        innerScrollView2.setMeasuredDimension(n5, innerScrollView2.getScrollViewHeight());
    }

    protected int getScrollViewHeight() {
        int n5 = this.mScrollViewHeight;
        if (n5 > 0) {
            return n5;
        }
        return this.mContentHeight;
    }

    protected int getScrollHeight() {
        return this.mContentHeight + this.mBoundHeight;
    }

    protected int getMaxScrollDis() {
        return this.getScrollHeight() - this.getScrollViewHeight();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onInterceptTouchEvent() --> event = " + motionEvent);
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                break;
            }
            case 3: {
                motionEvent = this.mVelocityTracker;
                if (motionEvent != null) {
                    motionEvent.clear();
                }
                this.stopNestedScroll();
                this.mDragging = false;
                break;
            }
            case 2: {
                MotionEvent motionEvent2 = motionEvent;
                motionEvent2.getX();
                int n5 = (int)(motionEvent2.getY() + 0.5f);
                if (this.mDragging) break;
                int n6 = 0;
                int n7 = this.mTouchSlop;
                if (Math.abs(n5 -= this.mInitialTouchY) > n7) {
                    int n8 = n5;
                    n5 = this.mInitialTouchY;
                    n6 = n8 < 0 ? -1 : 1;
                    this.mLastY = n5 + n7 * n6;
                    n6 = 1;
                }
                if (n6 == 0) break;
                this.mDragging = true;
                break;
            }
            case 1: {
                InnerScrollView innerScrollView = this;
                innerScrollView.mVelocityTracker.clear();
                innerScrollView.stopNestedScroll();
                break;
            }
            case 0: {
                int n9;
                InnerScrollView innerScrollView = this;
                innerScrollView.mInitialTouchY = n9 = (int)(motionEvent.getY() + 0.5f);
                innerScrollView.mLastY = n9;
                innerScrollView.mNestedOffsets[1] = 0;
                innerScrollView.mNestedOffsets[0] = 0;
                innerScrollView.startNestedScroll(2);
            }
        }
        return this.mDragging;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onTouchEvent() --> event = " + motionEvent);
        }
        int n5 = motionEvent.getAction();
        MotionEvent motionEvent2 = motionEvent;
        int n6 = (int)(motionEvent2.getY() + 0.5f);
        MotionEvent motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent2);
        if (n5 == 0) {
            innerScrollView7.mNestedOffsets[1] = 0;
            innerScrollView7.mNestedOffsets[0] = 0;
        }
        float f6 = innerScrollView7.mNestedOffsets[0];
        motionEvent3.offsetLocation(f6, (float)innerScrollView7.mNestedOffsets[1]);
        if (innerScrollView7.mVelocityTracker == null) {
            innerScrollView7.mVelocityTracker = VelocityTracker.obtain();
        }
        innerScrollView7.mVelocityTracker.addMovement(motionEvent3);
        switch (n5) {
            default: {
                break;
            }
            case 3: {
                innerScrollView7.mDragging = false;
                InnerScrollView innerScrollView7 = innerScrollView7.mVelocityTracker;
                if (innerScrollView7 == null) break;
                innerScrollView7.clear();
                break;
            }
            case 2: {
                Rect rect;
                Rect rect2;
                n5 = innerScrollView7.mLastY - n6;
                InnerScrollView innerScrollView = innerScrollView7;
                Rect rect3 = rect2;
                rect2 = new Rect();
                boolean bl = innerScrollView.mContentView.getLocalVisibleRect(rect3);
                Rect rect4 = rect;
                rect = new Rect();
                boolean bl2 = innerScrollView.mFooterView.getLocalVisibleRect(rect4);
                bl = n5 < 0 && bl && rect3.top != 0 && innerScrollView7.getScrollY() > 0;
                boolean bl3 = n5 > 0 && (!bl2 || rect4.bottom < innerScrollView7.mBoundHeight);
                boolean bl4 = bl || bl3;
                InnerScrollView innerScrollView2 = innerScrollView7;
                int[] nArray = innerScrollView2.mScrollConsumed;
                int[] nArray2 = innerScrollView2.mScrollOffset;
                if (innerScrollView2.dispatchNestedPreScroll(0, n5, nArray, nArray2)) {
                    n5 -= innerScrollView7.mScrollConsumed[1];
                    float f7 = innerScrollView7.mScrollOffset[0];
                    motionEvent3.offsetLocation(f7, (float)innerScrollView7.mScrollOffset[1]);
                    int[] nArray3 = innerScrollView7.mNestedOffsets;
                    int[] nArray4 = innerScrollView7.mScrollOffset;
                    nArray3[0] = innerScrollView7.mNestedOffsets[0] + innerScrollView7.mScrollOffset[0];
                    nArray3[1] = innerScrollView7.mNestedOffsets[1] + nArray4[1];
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "onTouchEvent --> contentViewRevealRect = " + rect3);
                    LogUtil.e(TAG, "onTouchEvent --> footViewRevealRect = " + rect4);
                    LogUtil.e(TAG, "onTouchEvent --> isFootViewReveal = " + bl2 + ", isCouldScrollTop = " + bl + ", isCouldScrollBottom = " + bl3 + ", isCouldScroll = " + bl4);
                }
                if (!innerScrollView7.mDragging) {
                    int n7 = innerScrollView7.mTouchSlop;
                    if (Math.abs(n5) > n7) {
                        n5 = n5 > 0 ? (n5 -= n7) : (n5 += n7);
                        innerScrollView7.mDragging = true;
                    }
                }
                if (!innerScrollView7.mDragging) break;
                innerScrollView7.mLastY = n6 - innerScrollView7.mScrollOffset[1];
                if (!bl4) break;
                if (bl3 && !bl2) {
                    innerScrollView7.scrollByWithLimit(0, n5);
                    break;
                }
                innerScrollView7.scrollByWithLimit(0, n5 / 2);
                break;
            }
            case 1: {
                Rect rect;
                Rect rect5;
                InnerScrollView innerScrollView = innerScrollView7;
                innerScrollView.mDragging = false;
                Rect rect6 = rect5;
                rect5 = new Rect();
                innerScrollView.mContentView.getLocalVisibleRect(rect6);
                rect6 = rect;
                rect = new Rect();
                boolean bl = innerScrollView.mFooterView.getLocalVisibleRect(rect6);
                InnerScrollView innerScrollView3 = innerScrollView7;
                innerScrollView3.mVelocityTracker.computeCurrentVelocity(1000, (float)innerScrollView7.mMaxFlingVelocity);
                int n8 = -((int)innerScrollView3.mVelocityTracker.getYVelocity());
                if (bl) {
                    InnerScrollView innerScrollView4 = innerScrollView7;
                    n8 = innerScrollView4.getScrollY() - (innerScrollView7.mContentHeight - innerScrollView7.getScrollViewHeight());
                    innerScrollView4.startAnimation(innerScrollView7.new ProgressAnimation(n8));
                } else {
                    float f8 = n8;
                    if (!innerScrollView7.dispatchNestedPreFling(0.0f, f8)) {
                        InnerScrollView innerScrollView5 = innerScrollView7;
                        innerScrollView5.dispatchNestedFling(0.0f, f8, true);
                        innerScrollView5.startNestedScroll(2);
                        int n9 = innerScrollView5.mMaxFlingVelocity;
                        innerScrollView5.fling(Math.max(-n9, Math.min(n8, n9)));
                    }
                }
                InnerScrollView innerScrollView6 = innerScrollView7;
                innerScrollView6.stopNestedScroll();
                InnerScrollView innerScrollView7 = innerScrollView6.mVelocityTracker;
                if (innerScrollView7 == null) break;
                innerScrollView7.clear();
                break;
            }
            case 0: {
                innerScrollView7.mLastY = (int)((float)n6 + 0.5f);
                innerScrollView7.startNestedScroll(2);
                return true;
            }
        }
        motionEvent3.recycle();
        return true;
    }

    protected void onLayout(boolean bl, int n5, int n6, int n7, int n8) {
        super.onLayout(bl, n5, n6, n7, n8);
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onLayout: changed = " + bl + ", l = " + n5 + ", t = " + n6 + ", r = , b = " + n8);
        }
    }

    public void scrollTo(int n5, int n6) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "scrollTo: x = " + n5 + ", y = " + n6);
        }
        super.scrollTo(0, n6);
    }

    public void setBoundHeight(int n5) {
        this.mBoundHeight = n5;
        if (n5 < 0) {
            this.mBoundHeight = 0;
        }
    }

    public void setScrollViewHeight(int n5) {
        this.mScrollViewHeight = n5;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public void fling(int n5) {
        block23: {
            block22: {
                int n6;
                int n7;
                OverScroller overScroller;
                block25: {
                    block24: {
                        overScroller = null;
                        if (this.scrollerField == null) {
                            this.scrollerField = FlingHelper.getDeclaredField((Object)this, "mScroller");
                        }
                        if (this.lastScrollYField == null) {
                            this.lastScrollYField = FlingHelper.getDeclaredField((Object)this, "mLastScrollerY");
                        }
                        Object object = null;
                        try {
                            if (this.scrollerField != null) {
                                object = this.scrollerField.get((Object)this);
                            }
                            if (object instanceof OverScroller) {
                                overScroller = (OverScroller)object;
                            }
                            if (overScroller == null || this.lastScrollYField == null) break block22;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (LogUtil.LOGGABLE) {
                                LogUtil.printException("InnerScrollView fling  IllegalAccessException!", illegalAccessException);
                            }
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "fling() --> 1 --> velocityY = " + n5);
                            }
                            super.fling(n5);
                            return;
                        }
                        if (this.getChildCount() <= 0) break block23;
                        int n8 = n5;
                        InnerScrollView innerScrollView = this;
                        InnerScrollView innerScrollView2 = innerScrollView;
                        innerScrollView.startNestedScroll(2, 1);
                        n7 = Integer.MIN_VALUE;
                        n6 = Integer.MAX_VALUE;
                        int n9 = (int)innerScrollView2.mFlingHelper.getSplineFlingDistance(n5);
                        if (n8 > 0) {
                            int n10 = this.mContentHeight - this.getScrollViewHeight();
                            if (n10 - this.getScrollY() > n9) break block24;
                            n6 = this.mContentHeight - this.getScrollViewHeight();
                            if (n6 < 0) {
                                n6 = 0;
                                n7 = 0;
                            } else {
                                n7 = n6;
                            }
                            break block25;
                        }
                    }
                    int n11 = n7;
                    n7 = n6;
                    n6 = n11;
                }
                try {
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "fling() --> getScrollX = " + this.getScrollX() + ", getScrollY = " + this.getScrollY() + ", velocityY = " + n5 + ", mContentHeight = " + this.mContentHeight + ", minY = " + n6 + ", maxY = " + n7);
                    }
                    InnerScrollView innerScrollView = this;
                    InnerScrollView innerScrollView3 = this;
                    int n12 = innerScrollView3.getScrollX();
                    overScroller.fling(n12, innerScrollView3.getScrollY(), 0, n5, 0, 0, n6, n7, 0, 0);
                    InnerScrollView innerScrollView4 = this;
                    innerScrollView.lastScrollYField.set((Object)innerScrollView4, innerScrollView4.getScrollY());
                    ViewCompat.postInvalidateOnAnimation((View)innerScrollView);
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (LogUtil.LOGGABLE) {
                        LogUtil.printException("InnerScrollView fling  IllegalAccessException!", illegalAccessException);
                    }
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "fling() --> 2 --> velocityY = " + n5);
                    }
                    super.fling(n5);
                }
                break block23;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "fling() --> 3 --> velocityY = " + n5);
            }
            super.fling(n5);
        }
    }

    public void addContentLayout(View view) {
        InnerScrollView innerScrollView = innerScrollView.mContentView;
        if (innerScrollView == null) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "addContentLayout mContentView == null ");
            }
            return;
        }
        innerScrollView.addView(view);
    }

    public ViewGroup getContentLayout() {
        return this.mContentView;
    }

    public void setContentLayoutVisibility(int n5) {
        InnerScrollView innerScrollView = innerScrollView.mContentView;
        if (innerScrollView != null) {
            innerScrollView.setVisibility(n5);
        }
    }

    private final class ProgressAnimation
    extends Animation {
        private final float startProgress;
        private final float endProgress;
        private final int boundHeight;
        private int scrolledY = 0;

        private ProgressAnimation(int n5) {
            this.startProgress = 0.0f;
            this.endProgress = 1.0f;
            InnerScrollView.access$102(InnerScrollView.this, true);
            this.boundHeight = n5;
        }

        protected void applyTransformation(float f6, Transformation transformation) {
            f6 = f6 * 1.0f + 0.0f;
            if (LogUtil.LOGGABLE) {
                LogUtil.e(InnerScrollView.TAG, "applyTransformation: progress = " + f6 + ", getScrollY() = " + InnerScrollView.this.getScrollY());
                LogUtil.e(InnerScrollView.TAG, "applyTransformation: dy = " + (int)((float)(InnerScrollView.this.getScrollY() - this.boundHeight) * f6));
            }
            int n5 = this.boundHeight;
            int n6 = this.scrolledY;
            int n7 = (int)((float)n5 * f6) - n6;
            if (f6 == 1.0f) {
                ProgressAnimation progressAnimation = this;
                progressAnimation.InnerScrollView.this.scrollByWithLimit(0, -(n5 - n6));
                InnerScrollView.access$102(progressAnimation.InnerScrollView.this, false);
            } else {
                this.scrolledY = n6 + n7;
                InnerScrollView.this.scrollByWithLimit(0, -n7);
            }
        }

        public void initialize(int n5, int n6, int n7, int n8) {
            AccelerateInterpolator accelerateInterpolator;
            ProgressAnimation progressAnimation = progressAnimation2;
            super.initialize(n5, n6, n7, n8);
            progressAnimation.setDuration(100L);
            ProgressAnimation progressAnimation2 = accelerateInterpolator;
            accelerateInterpolator = new AccelerateInterpolator();
            progressAnimation.setInterpolator((Interpolator)progressAnimation2);
        }
    }
}

