/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.nestedscroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.OverScroller;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.widget.NestedScrollView;
import com.baidu.baidumaps.common.util.ScreenUtils;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.framework.message.a;
import com.baidu.navisdk.framework.message.bean.s;
import com.baidu.navisdk.j;
import com.baidu.navisdk.model.datastruct.u;
import com.baidu.navisdk.ui.widget.nestedscroll.BlankLinearLayout;
import com.baidu.navisdk.ui.widget.nestedscroll.FlingHelper;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class OuterScrollView
extends NestedScrollView
implements a.a {
    private static final String TAG = "OuterScrollView";
    private static final int ONE_LEVEL_VEL = 1000;
    private static final int TWO_LEVEL_VEL = 10000;
    protected boolean scrollAvailable = true;
    protected VelocityTracker mVelocityTracker;
    protected FlingHelper mFlingHelper;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    protected Field scrollerField;
    protected Field lastScrollYField;
    private boolean isDownOnMap = false;
    protected BlankLinearLayout blankLayout;
    private LinearLayout contentLayout;
    protected u mStatus = u.a;
    protected int mBottomStatusContentHeight;
    protected int mSpecialStatusContentHeight;
    protected int mTopStatusContentHeight;
    protected int scroll_height = 0;
    protected int view_height = 0;
    protected int mScreenHeight;
    protected boolean isStartNestFling = false;
    protected boolean enablePageScrollStatus = true;
    protected boolean isSupport3Status = false;
    protected OnScrollChangeListener mListener;
    private OnScrollViewTouchListener mOnScrollViewTouchListener;
    protected int mOrientation = 1;

    public OuterScrollView(Context context) {
        super(context);
        this.init(context);
    }

    public OuterScrollView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public OuterScrollView(Context context, @Nullable AttributeSet attributeSet, int n5) {
        super(context, attributeSet, n5);
        this.init(context);
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean canMoveMap(MotionEvent motionEvent, View view) {
        boolean bl = this.isPointInsideView(motionEvent.getY(), view);
        if (motionEvent.getAction() == 0) {
            this.isDownOnMap = bl;
        }
        if (motionEvent.getAction() == 1) {
            this.isDownOnMap = false;
        }
        return this.isDownOnMap && bl && motionEvent.getAction() != 1;
    }

    private boolean isPointInsideView(float f6, View view) {
        Rect rect;
        View view2 = view;
        view = rect;
        view2.getHitRect(new Rect());
        return f6 > (float)view.top && f6 < (float)(view.bottom - this.getScrollY());
    }

    private int getBottomToTopMidValue() {
        return this.getScrollToBottomValue() + (this.getScrollToTopValue() - this.getScrollToBottomValue()) / 2;
    }

    private int getBottomToSpecialMidValue() {
        return this.getScrollToBottomValue() + (this.getScrollToSpecialValue() - this.getScrollToBottomValue()) / 2;
    }

    private int getSpecialToTopMidValue() {
        return this.getScrollToSpecialValue() + (this.getScrollToTopValue() - this.getScrollToSpecialValue()) / 2;
    }

    public void init(Context context) {
        LinearLayout linearLayout;
        OuterScrollView outerScrollView = this;
        outerScrollView.mOrientation = context.getResources().getConfiguration().orientation;
        LayoutInflater.from((Context)outerScrollView.getContext()).inflate(R.layout.nsdk_layout_out_scroll_view, (ViewGroup)this);
        outerScrollView.blankLayout = (BlankLinearLayout)outerScrollView.findViewById(R.id.ll_blank);
        this.contentLayout = linearLayout = (LinearLayout)outerScrollView.findViewById(R.id.ll_content);
        linearLayout.setMinimumHeight(this.getScreenHeight());
        outerScrollView.mFlingHelper = new FlingHelper(context);
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
    }

    protected void onMeasure(int n5, int n6) {
        OuterScrollView outerScrollView = this;
        OuterScrollView outerScrollView2 = this;
        int n7 = outerScrollView2.getScreenHeight();
        int n8 = outerScrollView2.mBottomStatusContentHeight;
        outerScrollView2.blankLayout.setMinHeight(n7 - n8);
        super.onMeasure(n5, n6);
        int n9 = outerScrollView.mBottomStatusContentHeight;
        if (n9 != n8) {
            this.blankLayout.setMinHeight(n7 - n9);
            super.onMeasure(n5, n6);
        }
    }

    protected int getScreenHeight() {
        if (j.e()) {
            return this.mOrientation == 1 ? ScreenUtils.getViewScreenHeight((Context)this.getContext()) : this.mScreenHeight;
        }
        return this.mOrientation == 1 ? ScreenUtil.getInstance().getHeightPixels() : this.mScreenHeight;
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mOrientation = configuration.orientation;
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        OuterScrollView outerScrollView = this;
        super.onSizeChanged(n5, n6, n7, n8);
        outerScrollView.mScreenHeight = n6;
        outerScrollView.blankLayout.setMinHeight(n6 - this.mBottomStatusContentHeight);
        outerScrollView.contentLayout.setMinimumHeight(n6);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        BlankLinearLayout blankLinearLayout;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onTouchEvent() --> scrollAvailable = " + this.scrollAvailable + ", event = " + motionEvent);
        }
        if (!this.scrollAvailable) {
            return false;
        }
        int n5 = motionEvent.getAction();
        if (this.mOnScrollViewTouchListener != null) {
            int n6 = motionEvent.getAction();
            if (n6 != 0) {
                if (n6 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewTouchDown();
            }
        }
        if ((blankLinearLayout = this.blankLayout) == null ? false : this.canMoveMap(motionEvent, (View)blankLinearLayout)) {
            return false;
        }
        if (this.mOnScrollViewTouchListener != null) {
            int n7 = motionEvent.getAction();
            if (n7 != 0) {
                if (n7 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewContentTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewContentTouchDown();
            }
        }
        OuterScrollView outerScrollView = this;
        outerScrollView.initVelocityTrackerIfNotExists();
        outerScrollView.mVelocityTracker.addMovement(motionEvent);
        if (n5 != 1) {
            if (n5 == 3) {
                this.recycleVelocityTracker();
            }
        } else {
            if (this.enablePageScrollStatus) {
                OuterScrollView outerScrollView2 = this;
                outerScrollView2.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n8 = (int)outerScrollView2.mVelocityTracker.getYVelocity();
                u u5 = outerScrollView2.calculateNextStatus(n8, outerScrollView2.getScrollY());
                if (u5 != u.d) {
                    this.updateStatus(u5, true, n8);
                }
                this.recycleVelocityTracker();
                return true;
            }
            this.recycleVelocityTracker();
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        BlankLinearLayout blankLinearLayout;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onInterceptTouchEvent() --> event = " + motionEvent);
        }
        if (!((blankLinearLayout = this.blankLayout) == null ? false : this.canMoveMap(motionEvent, (View)blankLinearLayout)) && this.mOnScrollViewTouchListener != null) {
            int n5 = motionEvent.getAction();
            if (n5 != 0) {
                if (n5 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewContentTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewContentTouchDown();
            }
        }
        if (this.mOnScrollViewTouchListener != null) {
            int n6 = motionEvent.getAction();
            if (n6 != 0) {
                if (n6 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewTouchDown();
            }
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onStartNestedScroll(@NonNull View view, @NonNull View view2, int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStartNestedScroll() --> child = " + view + ", target = " + view2 + ", axes = " + n5 + ", scrollAvailable = " + this.scrollAvailable);
        }
        if (!this.scrollAvailable) {
            return false;
        }
        if (this.getScrollY() != this.getMaxScrollVal()) {
            return false;
        }
        return super.onStartNestedScroll(view, view2, n5);
    }

    public boolean onStartNestedScroll(@NonNull View view, @NonNull View view2, int n5, int n6) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStartNestedScroll() --> child = " + view + ", target = " + view2 + ", axes = " + n5 + ", scrollAvailable = " + this.scrollAvailable);
        }
        if (n6 != 0) {
            return false;
        }
        if (!this.scrollAvailable) {
            return false;
        }
        if (this.getScrollY() != this.getMaxScrollVal()) {
            return false;
        }
        return super.onStartNestedScroll(view, view2, n5, n6);
    }

    public void onNestedScrollAccepted(@NonNull View view, @NonNull View view2, int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedScrollAccepted() --> child = " + view + ", target = " + view2 + ", axes = " + n5);
        }
        super.onNestedScrollAccepted(view, view2, n5);
    }

    public void onStopNestedScroll(@NonNull View view) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStopNestedScroll() --> target = " + view + ", isStartNestFling = " + this.isStartNestFling);
        }
        if (this.isStartNestFling) {
            this.isStartNestFling = false;
        } else if (this.enablePageScrollStatus) {
            OuterScrollView outerScrollView = this;
            u u5 = outerScrollView.calculateNextStatus(0, outerScrollView.getScrollY());
            if (u5 != u.d) {
                this.updateStatus(u5, true);
            }
        }
        super.onStopNestedScroll(view);
    }

    public void onStopNestedScroll(@NonNull View view, int n5) {
        if (n5 != 0) {
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStopNestedScroll() --> target = " + view + ", isStartNestFling = " + this.isStartNestFling);
        }
        if (this.isStartNestFling) {
            this.isStartNestFling = false;
        } else if (this.enablePageScrollStatus) {
            OuterScrollView outerScrollView = this;
            u u5 = outerScrollView.calculateNextStatus(0, outerScrollView.getScrollY());
            if (u5 != u.d) {
                this.updateStatus(u5, true);
            }
        }
        super.onStopNestedScroll(view, n5);
    }

    public void onNestedScroll(@NonNull View view, int n5, int n6, int n7, int n8) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedScroll() --> target = " + view + ", dxConsumed = " + n5 + ", dyConsumed = " + n6 + ", dxUnconsumed = " + n7 + ", dyUnconsumed = " + n8);
        }
        super.onNestedScroll(view, n5, n6, n7, n8);
    }

    public void onNestedScroll(@NonNull View view, int n5, int n6, int n7, int n8, int n9, @NonNull int[] nArray) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedScroll() --> target = " + view + ", dxConsumed = " + n5 + ", dyConsumed = " + n6 + ", dxUnconsumed = " + n7 + ", dyUnconsumed = " + n8);
        }
        int[] nArray2 = nArray;
        nArray2[0] = nArray[0] + n7;
        nArray2[1] = nArray[1] + n8;
        super.onNestedScroll(view, n5, n6, n7, n9, n8);
    }

    public void onNestedPreScroll(@NonNull View view, int n5, int n6, @NonNull int[] nArray) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedPreScroll() --> target = " + view + ", dx = " + n5 + ", dy = " + n6 + ", consumed = " + Arrays.toString(nArray));
        }
        boolean bl = n6 > 0 && this.getScrollY() < this.getScrollToTopValue();
        boolean bl2 = n6 < 0 && this.getScrollY() >= 0 && !view.canScrollVertically(-1);
        if (bl || bl2) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onNestedPreScroll() --> scroll scrollview!");
            }
            this.scrollBy(0, n6);
            nArray[1] = n6;
        }
        super.onNestedPreScroll(view, n5, n6, nArray);
    }

    public void onNestedPreScroll(@NonNull View view, int n5, int n6, @NonNull int[] nArray, int n7) {
        if (n7 != 0) {
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedPreScroll() --> target = " + view + ", dx = " + n5 + ", dy = " + n6 + ", consumed = " + Arrays.toString(nArray));
        }
        boolean bl = n6 > 0 && this.getScrollY() < this.getScrollToTopValue();
        boolean bl2 = n6 < 0 && this.getScrollY() >= 0 && !view.canScrollVertically(-1);
        if (!bl && !bl2) {
            super.onNestedPreScroll(view, n5, n6, nArray, n7);
        } else {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onNestedPreScroll() --> scroll scrollview!");
            }
            this.scrollBy(0, n6);
            nArray[1] = n6;
        }
    }

    public boolean onNestedFling(@NonNull View view, float f6, float f7, boolean bl) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedFling() --> target = " + view + ", velocityX = " + f6 + ", velocityY = " + f7 + ", consumed = " + bl);
        }
        return super.onNestedFling(view, f6, f7, bl);
    }

    public boolean onNestedPreFling(@NonNull View view, float f6, float f7) {
        u u5;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedPreFling() --> target = " + view + ", velocityX = " + f6 + ", velocityY = " + f7);
        }
        if (this.mStatus != u.b) {
            if (f7 > 0.0f && view.canScrollVertically(1)) {
                return false;
            }
            if (f7 < 0.0f && view.canScrollVertically(-1)) {
                return false;
            }
        }
        this.isStartNestFling = true;
        if (view.getScrollY() != 0 && (u5 = this.mStatus) != u.a && u5 != u.b) {
            return super.onNestedPreFling(view, f6, f7);
        }
        if (this.enablePageScrollStatus) {
            OuterScrollView outerScrollView = this;
            int n5 = -((int)f7);
            u u6 = outerScrollView.calculateNextStatus(n5, outerScrollView.getScrollY());
            if (u6 != u.d) {
                this.updateStatus(u6, true, n5);
            }
        } else {
            float f8 = f7 - 0.0f;
            float f9 = f8 == 0.0f ? 0 : (f8 < 0.0f ? -1 : 1);
            int n6 = f9 < 0 ? this.getScrollY() : this.getMaxScrollVal() - this.getScrollY();
            float f10 = f9;
            f9 = this.mFlingHelper.getVelocityByDistance(n6);
            f9 = (int)Math.max(Math.abs(f7), (float)Math.abs((int)f9)) + 500;
            if (f10 < 0) {
                f9 = -f9;
            }
            this.fling((int)f9);
        }
        return true;
    }

    public int getNestedScrollAxes() {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "getNestedScrollAxes");
        }
        return super.getNestedScrollAxes();
    }

    protected void onScrollChanged(int n5, int n6, int n7, int n8) {
        OnScrollChangeListener onScrollChangeListener = this.mListener;
        if (onScrollChangeListener != null) {
            onScrollChangeListener.onScroll(n6);
            int n9 = this.getMaxScrollVal();
            OnScrollChangeListener onScrollChangeListener2 = this.mListener;
            float f6 = n9 == 0 ? 0.0f : (float)n6 * 1.0f / ((float)n9 * 1.0f);
            onScrollChangeListener2.onScrollProgress(f6);
        }
        boolean bl = this.isNeedStopScroll(n6);
        if (n6 == 0 || bl) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onScrollChanged abortAnimation " + n6 + ",scroll_height: " + this.scroll_height + ", view_height:" + this.view_height);
            }
            this.abortAnimation();
        }
        super.onScrollChanged(n5, n6, n7, n8);
    }

    protected boolean isNeedStopScroll(int n5) {
        return this.scroll_height - this.view_height == n5;
    }

    @SuppressLint(value={"RestrictedApi"})
    public int computeVerticalScrollRange() {
        int n5 = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (this.getChildCount() == 0) {
            return n5;
        }
        OuterScrollView outerScrollView = this;
        int n6 = outerScrollView.getChildAt(0).getBottom();
        int n7 = outerScrollView.getScrollY();
        n5 = Math.max(0, n6 - n5);
        if (n7 < 0) {
            n6 -= n7;
        } else if (n7 > n5) {
            n6 += n7 - n5;
        }
        this.scroll_height = n6;
        n5 = 0;
        BlankLinearLayout blankLinearLayout = this.blankLayout;
        if (blankLinearLayout != null) {
            n5 = blankLinearLayout.getMeasuredHeight() + n5;
            blankLinearLayout = this.contentLayout;
            if (blankLinearLayout != null && blankLinearLayout.getChildAt(1) != null) {
                n5 += this.contentLayout.getChildAt(1).getMeasuredHeight();
            }
        }
        if (n5 > 0) {
            this.scroll_height = n5;
        }
        return this.scroll_height;
    }

    protected void onLayout(boolean bl, int n5, int n6, int n7, int n8) {
        super.onLayout(bl, n5, n6, n7, n8);
        if (bl) {
            this.view_height = n8 - n6;
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        a.a().a(this, s.class, new Class[0]);
    }

    public void onDetachedFromWindow() {
        OuterScrollView outerScrollView = this;
        super.onDetachedFromWindow();
        a.a().a(this);
        outerScrollView.recycleVelocityTracker();
    }

    /*
     * Unable to fully structure code
     */
    public void fling(int var1_1) {
        block31: {
            block33: {
                block32: {
                    block30: {
                        block29: {
                            if (!this.enablePageScrollStatus) {
                                if (LogUtil.LOGGABLE) {
                                    LogUtil.e("OuterScrollView", "fling() --> 1 --> velocityY = " + var1_1);
                                }
                                super.fling(var1_1);
                                return;
                            }
                            var2_2 = null;
                            if (this.scrollerField == null) {
                                this.scrollerField = FlingHelper.getDeclaredField(this, "mScroller");
                            }
                            if (this.lastScrollYField == null) {
                                this.lastScrollYField = FlingHelper.getDeclaredField(this, "mLastScrollerY");
                            }
                            var3_6 = null;
                            if (this.scrollerField == null) break block29;
                            var3_6 = this.scrollerField.get(this);
                        }
                        if (!(var3_6 instanceof OverScroller)) break block30;
                        var2_2 = (OverScroller)var3_6;
                    }
                    if (var2_2 == null || this.lastScrollYField == null) break block33;
                    if (this.getChildCount() <= 0) break block31;
                    v0 = this;
                    v1 = v0;
                    v0.startNestedScroll(2, 1);
                    var3_7 = -2147483648;
                    var4_8 = 0x7FFFFFFF;
                    if (!v1.enablePageScrollStatus) ** GOTO lbl63
                    if (this.mStatus != u.c) break block32;
                    v2 = this;
                    v3 = v2;
                    var3_7 = v2.getScrollToTopValue();
                    v4 = v3.getScrollToTopValue();
lbl42:
                    // 3 sources

                    while (true) {
                        var4_8 = v4;
                        ** GOTO lbl63
                        break;
                    }
                }
                if (!this.isSupport3Status) ** GOTO lbl57
                if (this.mStatus != u.b) ** GOTO lbl57
                v5 = this;
                v6 = v5;
                var3_7 = v5.getScrollToSpecialValue();
                v4 = v6.getScrollToSpecialValue();
                ** GOTO lbl42
lbl57:
                // 2 sources

                v7 = this;
                v8 = v7;
                var3_7 = v7.getScrollToBottomValue();
                v4 = v8.getScrollToBottomValue();
                ** continue;
lbl63:
                // 2 sources

                if (!LogUtil.LOGGABLE) ** GOTO lbl66
                LogUtil.e("OuterScrollView", "fling() --> getScrollX = " + this.getScrollX() + ", getScrollY = " + this.getScrollY() + " velocityY = " + var1_1 + ", minY = " + var3_7 + ", maxY = " + var4_8);
lbl66:
                // 2 sources

                v9 = this;
                v10 = v9;
                v11 = v9;
                v12 = var2_2;
                v13 = this;
                v14 = v13;
                var2_3 = v13.getScrollX();
                try {
                    v12.fling(var2_3, v14.getScrollY(), 0, var1_1, 0, 0, var3_7, var4_8, 0, 0);
                    v15 = this;
                    v10.lastScrollYField.set(v15, v15.getScrollY());
                    ViewCompat.postInvalidateOnAnimation((View)v11);
                }
                catch (IllegalAccessException var2_4) {
                    if (LogUtil.LOGGABLE) {
                        LogUtil.printException("OuterScrollView fling  IllegalAccessException!", var2_4);
                    }
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e("OuterScrollView", "fling() --> 3 --> velocityY = " + var1_1);
                    }
                    super.fling(var1_1);
                }
                break block31;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e("OuterScrollView", "fling() --> 4 --> velocityY = " + var1_1);
            }
            super.fling(var1_1);
        }
        return;
        catch (IllegalAccessException var2_5) {
            if (LogUtil.LOGGABLE) {
                LogUtil.printException("OuterScrollView fling  IllegalAccessException!", var2_5);
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e("OuterScrollView", "fling() --> 2 --> velocityY = " + var1_1);
            }
            super.fling(var1_1);
            return;
        }
    }

    protected u calculateNextStatus(int n5, int n6) {
        if (this.isSupport3Status) {
            return this.calculateNextWhen3Status(n5, n6);
        }
        return this.calculateNextWhen2Status(n5, n6);
    }

    protected u calculateNextWhen2Status(int n5, int n6) {
        int n7;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "calculateNextStatus() --> velocityY = " + n5 + ", scrollY = " + n6 + ", bottomToTopMidValue = " + this.getBottomToTopMidValue() + ", mStatus = " + (Object)((Object)this.mStatus));
        }
        if ((n7 = 2.$SwitchMap$com$baidu$navisdk$model$datastruct$ScrollStatus[this.mStatus.ordinal()]) != 1) {
            if (n7 != 2) {
                return u.a;
            }
            if (n5 <= 1000 && n6 >= this.getBottomToTopMidValue()) {
                if (n6 > this.getScrollToTopValue()) {
                    return u.c;
                }
                return u.c;
            }
            return u.a;
        }
        if (n5 < 0 && Math.abs(n5) > 1000 || n6 > this.getBottomToTopMidValue()) {
            return u.c;
        }
        return u.a;
    }

    protected u calculateNextWhen3Status(int n5, int n6) {
        int n7;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "calculateNextStatus() --> velocityY = " + n5 + ", scrollY = " + n6 + ", bottomToSpecialMidValue = " + this.getBottomToSpecialMidValue() + ", specialToTopMidValue = " + this.getSpecialToTopMidValue() + ", mStatus = " + (Object)((Object)this.mStatus));
        }
        if ((n7 = 2.$SwitchMap$com$baidu$navisdk$model$datastruct$ScrollStatus[this.mStatus.ordinal()]) != 1) {
            if (n7 != 2) {
                if (n7 != 3) {
                    return u.a;
                }
                if (n5 <= 1000 && n6 >= this.getBottomToSpecialMidValue()) {
                    if (n5 < 0 && Math.abs(n5) > 1000 || n6 > this.getSpecialToTopMidValue()) {
                        return u.c;
                    }
                    return u.b;
                }
                return u.a;
            }
            if (n5 <= 10000 && n6 >= this.getBottomToSpecialMidValue()) {
                if (n5 <= 1000 && n6 >= this.getSpecialToTopMidValue()) {
                    return u.c;
                }
                return u.b;
            }
            return u.a;
        }
        if (n5 < 0 && Math.abs(n5) > 10000 || n6 > this.getSpecialToTopMidValue()) {
            return u.c;
        }
        if (n5 < 0 && Math.abs(n5) > 1000 || n6 > this.getBottomToSpecialMidValue()) {
            return u.b;
        }
        return u.a;
    }

    public void updateStatus(u u5, boolean bl) {
        this.updateStatus(u5, bl, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateStatus(u u5, boolean n5, int n6) {
        OnScrollChangeListener onScrollChangeListener;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateStatus() --> status = " + (Object)((Object)u5) + ", smooth = " + (n5 != 0) + ", velocityY = " + n6);
        }
        if ((onScrollChangeListener = this.mListener) != null) {
            onScrollChangeListener.onStatusChanged(this.mStatus, u5);
        }
        this.mStatus = u5;
        int n7 = 2.$SwitchMap$com$baidu$navisdk$model$datastruct$ScrollStatus[u5.ordinal()];
        if (n7 != 1) {
            if (n7 != 2) {
                if (n7 != 3) {
                    return;
                }
                if (n5 == 0) {
                    OuterScrollView outerScrollView = this;
                    outerScrollView.scrollTo(0, outerScrollView.getScrollToSpecialValue());
                    return;
                }
                n7 = this.getScrollY() - this.getScrollToSpecialValue();
                n5 = Math.abs(n7);
                if (n7 >= 0 && n6 < 0 || n7 < 0 && n6 > 0) {
                    n6 = 0;
                }
                int n8 = n7;
                n7 = this.mFlingHelper.getVelocityByDistance(n5);
                int n9 = Math.max(Math.abs(n6), Math.abs(n7 + 500));
                if (n8 >= 0) {
                    n9 = -n9;
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "updateSpecialStatus --> velocityY = " + n6 + ", scrollDistance = " + n5 + ", needVelocity = " + n7 + ", finalVelocity = " + n9);
                }
                if (n7 <= 0) return;
                this.fling(n9);
                return;
            }
            if (n5 == 0) {
                OuterScrollView outerScrollView = this;
                outerScrollView.scrollTo(0, outerScrollView.getScrollToTopValue());
                return;
            }
            n7 = this.getScrollToTopValue() - this.getScrollY();
            if (n6 < 0) {
                n6 = 0;
            }
            n5 = this.mFlingHelper.getVelocityByDistance(n7);
            int n10 = Math.max(Math.abs(n6), Math.abs(n5 + 500));
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "updateTopStatus --> velocityY = " + n6 + ", scrollDistance = " + n7 + ", needVelocity = " + n5 + ", finalVelocity = " + n10);
            }
            if (n5 <= 0) return;
            this.fling(n10);
            return;
        }
        if (n5 == 0) {
            OuterScrollView outerScrollView = this;
            outerScrollView.scrollTo(0, outerScrollView.getScrollToBottomValue());
            return;
        }
        n7 = this.getScrollY() - this.getScrollToBottomValue();
        if (n6 < 0) {
            n6 = 0;
        }
        n5 = this.mFlingHelper.getVelocityByDistance(n7);
        int n11 = -Math.max(Math.abs(n6), Math.abs(n5 + 500));
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateBottomStatus --> velocityY = " + n6 + ", scrollDistance = " + n7 + ", needVelocity = " + n5 + ", finalVelocity = " + n11);
        }
        if (n5 <= 0) return;
        this.fling(n11);
    }

    protected int getScrollToTopValue() {
        return this.mTopStatusContentHeight - this.mBottomStatusContentHeight;
    }

    protected int getScrollToSpecialValue() {
        int n5 = this.mSpecialStatusContentHeight;
        if (n5 == 0) {
            return this.getMaxScrollVal() / 2;
        }
        return n5 - this.mBottomStatusContentHeight;
    }

    protected int getScrollToBottomValue() {
        return 0;
    }

    public void setBottomStatusContentHeight(int n5) {
        this.mBottomStatusContentHeight = n5;
    }

    public void setSpecialStatusContentHeight(int n5) {
        this.mSpecialStatusContentHeight = n5;
    }

    public void setTopStatusContentHeight(int n5) {
        this.mTopStatusContentHeight = n5;
    }

    public float getSpecialStatusPercent() {
        int n5 = this.getMaxScrollVal();
        return n5 == 0 ? 0.5f : (float)this.getScrollToSpecialValue() * 1.0f / ((float)n5 * 1.0f);
    }

    public void scrollTo(int n5, int n6) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "scrollTo --> x = " + n5 + ", y = " + n6 + ", getScrollToBottomValue() = " + this.getScrollToBottomValue() + ", getScrollToTopValue() = " + this.getScrollToTopValue());
        }
        if (n6 < this.getScrollToBottomValue()) {
            n6 = this.getScrollToBottomValue();
        }
        if (n6 > this.getScrollToTopValue()) {
            n6 = this.getScrollToTopValue();
        }
        super.scrollTo(n5, n6);
    }

    protected void abortAnimation() {
        block14: {
            Object object;
            block13: {
                block12: {
                    if (this.scrollerField != null) break block12;
                    this.scrollerField = FlingHelper.getDeclaredField(this, "mScroller");
                }
                object = null;
                if (this.scrollerField == null) break block13;
                object = this.scrollerField.get(this);
            }
            if (object == null) {
                return;
            }
            Class<?> clazz = object.getClass();
            try {
                clazz.getMethod("abortAnimation", new Class[0]).invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView abortAnimation InvocationTargetException!", invocationTargetException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView abortAnimation NoSuchMethodException!", noSuchMethodException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LogUtil.LOGGABLE) break block14;
                LogUtil.printException("OuterScrollView abortAnimation IllegalAccessException!", illegalAccessException);
            }
        }
    }

    public void setScrollChangeListener(OnScrollChangeListener onScrollChangeListener) {
        this.mListener = onScrollChangeListener;
    }

    public void setScrollViewTouchListener(OnScrollViewTouchListener onScrollViewTouchListener) {
        this.mOnScrollViewTouchListener = onScrollViewTouchListener;
    }

    public int getMaxScrollVal() {
        return this.getScrollToTopValue() - this.getScrollToBottomValue();
    }

    public void setStatus(u u5) {
        this.mStatus = u5;
    }

    public LinearLayout getContentLayout() {
        return this.contentLayout;
    }

    public u getStatus() {
        return this.mStatus;
    }

    public void setBlankViewClickListener(View.OnClickListener onClickListener) {
        BlankLinearLayout blankLinearLayout = object.blankLayout;
        if (blankLinearLayout != null) {
            blankLinearLayout.setOnClickListener(onClickListener);
            Object object = object.blankLayout;
            boolean bl = onClickListener != null;
            object.setClickable(bl);
        }
    }

    public void removeBlankViewClickListener() {
        Object object = object.blankLayout;
        if (object != null) {
            object.setClickable(false);
        }
    }

    public void setScrollAvailable(boolean bl) {
        this.scrollAvailable = bl;
    }

    public void setEnablePageScrollStatus(boolean bl) {
        this.enablePageScrollStatus = bl;
    }

    public void setSupport3Status(boolean bl) {
        this.isSupport3Status = bl;
    }

    @Override
    public void onEvent(Object object) {
        if (object instanceof s) {
            object = this.blankLayout;
            if (object != null) {
                object.requestLayout();
            }
            if ((object = this.contentLayout) != null && (object = object.getChildAt(1)) != null) {
                object.requestLayout();
            }
            if (this.mStatus == u.c) {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        OuterScrollView outerScrollView = outerScrollView.OuterScrollView.this;
                        if (outerScrollView.mStatus == u.c) {
                            OuterScrollView outerScrollView2 = outerScrollView;
                            outerScrollView2.scrollTo(0, outerScrollView2.getScrollToTopValue());
                        }
                    }
                };
                this.post((Runnable)object);
            }
        }
    }

    public String getName() {
        return "OuterScrollView-OnEvent";
    }

    public static abstract class OnScrollViewTouchListener {
        public void onScrollViewTouchDown() {
        }

        public void onScrollViewTouchUp() {
        }

        public void onScrollViewContentTouchDown() {
        }

        public void onScrollViewContentTouchUp() {
        }
    }

    public static abstract class OnScrollChangeListener {
        public void onStatusChanged(u u5, u u6) {
        }

        public void onScroll(int n5) {
        }

        public void onScrollProgress(@FloatRange(from=0.0, to=1.0) float f6) {
        }

        public void onScrollEnd() {
        }

        public void onScrollStart() {
        }
    }
}

