/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baidu.navisdk.model.datastruct.u;
import com.baidu.navisdk.ui.widget.nestedscroll.OuterScrollView;
import com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager.IServiceManager;
import com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager.InnerViewPager;
import com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager.InnerViewPagerAdapter;
import com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager.ScrollContentView;
import com.baidu.navisdk.ui.widget.nestedscroll.scrollableviewpager.ViewPageCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScrollableViewPagerFrame
implements IServiceManager {
    private final ArrayList<Object> mDataList;
    @NonNull
    private final Context mContext;
    @NonNull
    private final OuterScrollView mScrollView;
    private final Map<Class<?>, Object> mServices;
    private ScrollContentView mScrollContentView;
    private InnerViewPager mViewPager;
    private InnerViewPagerAdapter mPageAdapter;
    private ViewPager.OnPageChangeListener mPageChangeListener;
    private OnViewPagerListener mViewPagerListener;

    public ScrollableViewPagerFrame(@NonNull Context context, @NonNull OuterScrollView outerScrollView) {
        ArrayMap arrayMap;
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.mDataList = object;
        object = arrayMap;
        arrayMap = new ArrayMap();
        v1.mServices = object;
        v1.mContext = context;
        v1.mScrollView = outerScrollView;
    }

    private void init() {
        this.mScrollContentView = new ScrollContentView(this.mContext);
        this.mScrollView.getContentLayout().addView((View)this.mScrollContentView);
        this.mPageChangeListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int n5, float f6, int n6) {
                if (ScrollableViewPagerFrame.this.mViewPagerListener != null) {
                    ScrollableViewPagerFrame.this.mViewPagerListener.onPageScrolled(n5, f6, n6);
                }
            }

            public void onPageSelected(int n5) {
                if (ScrollableViewPagerFrame.this.mViewPagerListener != null) {
                    Object var2_2 = null;
                    if (n5 >= 0 && n5 < ScrollableViewPagerFrame.this.mDataList.size()) {
                        var2_2 = ScrollableViewPagerFrame.this.mDataList.get(n5);
                    }
                    ScrollableViewPagerFrame.this.mViewPagerListener.onPageSelected(n5, var2_2);
                }
            }

            public void onPageScrollStateChanged(int n5) {
                if (ScrollableViewPagerFrame.this.mViewPagerListener != null) {
                    ScrollableViewPagerFrame.this.mViewPagerListener.onPageScrollStateChanged(n5);
                }
            }
        };
    }

    public void create() {
        ViewPageCallback viewPageCallback;
        ScrollableViewPagerFrame scrollableViewPagerFrame = this;
        Object object = viewPageCallback;
        viewPageCallback = new ViewPageCallback(){

            @Override
            public View createPage(Object object) {
                if (ScrollableViewPagerFrame.this.mViewPagerListener != null) {
                    return ScrollableViewPagerFrame.this.mViewPagerListener.createPage(object, ScrollableViewPagerFrame.this);
                }
                return null;
            }
        };
        scrollableViewPagerFrame.register(ViewPageCallback.class, object);
        this.mViewPager = (InnerViewPager)scrollableViewPagerFrame.mScrollContentView.findViewWithTag(InnerViewPager.TAG);
        if (this.mViewPager != null) {
            InnerViewPagerAdapter innerViewPagerAdapter;
            ScrollableViewPagerFrame scrollableViewPagerFrame2 = this;
            object = innerViewPagerAdapter;
            scrollableViewPagerFrame2.mPageAdapter = new InnerViewPagerAdapter(this.mContext, this);
            scrollableViewPagerFrame2.mViewPager.setAdapter((PagerAdapter)object);
            scrollableViewPagerFrame2.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        }
        this.mScrollView.setOverScrollMode(2);
    }

    public void destroy() {
        ScrollableViewPagerFrame scrollableViewPagerFrame = this;
        scrollableViewPagerFrame.mServices.clear();
        InnerViewPager innerViewPager = scrollableViewPagerFrame.mViewPager;
        if (innerViewPager != null) {
            innerViewPager.removeOnPageChangeListener(this.mPageChangeListener);
        }
    }

    public void updateViewPager(List<?> list) {
        Object object = object.mPageAdapter;
        if (object != null) {
            ((InnerViewPagerAdapter)((Object)object)).setDataList(list);
        }
    }

    public void setScrollAvailable(boolean bl) {
        ScrollableViewPagerFrame scrollableViewPagerFrame = innerViewPager;
        scrollableViewPagerFrame.mScrollView.setScrollAvailable(bl);
        InnerViewPager innerViewPager = scrollableViewPagerFrame.mViewPager;
        if (innerViewPager != null) {
            innerViewPager.setScrollAvailable(bl);
        }
    }

    public void setBlankViewClickListener(View.OnClickListener onClickListener) {
        this.mScrollView.setBlankViewClickListener(onClickListener);
    }

    public void removeBlankViewClickListener() {
        this.mScrollView.removeBlankViewClickListener();
    }

    public void setSupport3Status(boolean bl) {
        this.mScrollView.setSupport3Status(bl);
    }

    public void setBottomStatusContentHeight(int n5) {
        this.mScrollView.setBottomStatusContentHeight(n5);
    }

    public void setSpecialStatusContentHeight(int n5) {
        this.mScrollView.setSpecialStatusContentHeight(n5);
    }

    public void setTopStatusContentHeight(int n5) {
        ScrollContentView scrollContentView = this.mScrollContentView;
        if (scrollContentView != null) {
            scrollContentView.setHeight(n5);
        }
        this.mScrollView.setTopStatusContentHeight(n5);
    }

    public void setScrollChangeListener(OuterScrollView.OnScrollChangeListener onScrollChangeListener) {
        this.mScrollView.setScrollChangeListener(onScrollChangeListener);
    }

    public void setScrollViewTouchListener(OuterScrollView.OnScrollViewTouchListener onScrollViewTouchListener) {
        this.mScrollView.setScrollViewTouchListener(onScrollViewTouchListener);
    }

    public void setScrollViewBackground(int n5) {
        this.mScrollView.setBackgroundColor(n5);
    }

    public void setViewPagerListener(OnViewPagerListener onViewPagerListener) {
        this.mViewPagerListener = onViewPagerListener;
    }

    public void addHeadView(View view, FrameLayout.LayoutParams layoutParams) {
        this.mScrollContentView.addHead(view, layoutParams);
    }

    public void addContentView(View view, FrameLayout.LayoutParams layoutParams) {
        this.mScrollContentView.addContent(view, layoutParams);
    }

    public void addTailView(View view, FrameLayout.LayoutParams layoutParams) {
        this.mScrollContentView.addTail(view, layoutParams);
    }

    public void updateStatus(u u5, boolean bl) {
        this.mScrollView.updateStatus(u5, bl);
    }

    public float getSpecialStatusPercent() {
        return this.mScrollView.getSpecialStatusPercent();
    }

    public void changeToPage(int n5, boolean bl) {
        Object object = object.mViewPager;
        if (object != null) {
            object.setCurrentItem(n5, bl);
        }
    }

    public View getCurShowPage() {
        Object object = object.mPageAdapter;
        if (object != null) {
            return ((InnerViewPagerAdapter)((Object)object)).getCurPager();
        }
        return null;
    }

    @Override
    public <T> void register(@NonNull Class<T> clazz, @NonNull T t5) {
        if ((t5 = clazz.cast(t5)) != null) {
            this.mServices.put(clazz, t5);
        }
    }

    @Override
    public <T> T getService(@NonNull Class<T> clazz) {
        Object object = ((ScrollableViewPagerFrame)object).mServices.get(clazz);
        if (object == null) {
            return null;
        }
        return clazz.cast(object);
    }

    public static final class Builder {
        private final Context mContext;
        private final OuterScrollView mScrollView;
        private boolean scrollAvailable;
        private boolean isSupport3Status;
        private int mBottomStatusContentHeight;
        private int mSpecialStatusContentHeight;
        private int mTopStatusContentHeight;
        private OuterScrollView.OnScrollChangeListener mScrollChangeListener;
        private OuterScrollView.OnScrollViewTouchListener mScrollViewTouchListener;
        private OnViewPagerListener mViewPagerListener;
        private View mHeadView;
        private FrameLayout.LayoutParams mHeadViewLp;
        private View mContentView;
        private FrameLayout.LayoutParams mContentViewLp;
        private View mTailView;
        private FrameLayout.LayoutParams mTailViewLp;

        public Builder(Context context, OuterScrollView outerScrollView) {
            this.mContext = context;
            this.mScrollView = outerScrollView;
        }

        public Builder setScrollAvailable(boolean bl) {
            this.scrollAvailable = bl;
            return this;
        }

        public Builder setSupport3Status(boolean bl) {
            this.isSupport3Status = bl;
            return this;
        }

        public Builder setBottomStatusContentHeight(int n5) {
            this.mBottomStatusContentHeight = n5;
            return this;
        }

        public Builder setSpecialStatusContentHeight(int n5) {
            this.mSpecialStatusContentHeight = n5;
            return this;
        }

        public Builder setTopStatusContentHeight(int n5) {
            this.mTopStatusContentHeight = n5;
            return this;
        }

        public Builder setScrollChangeListener(OuterScrollView.OnScrollChangeListener onScrollChangeListener) {
            this.mScrollChangeListener = onScrollChangeListener;
            return this;
        }

        public Builder setScrollViewTouchListener(OuterScrollView.OnScrollViewTouchListener onScrollViewTouchListener) {
            this.mScrollViewTouchListener = onScrollViewTouchListener;
            return this;
        }

        public Builder setViewPagerListener(OnViewPagerListener onViewPagerListener) {
            this.mViewPagerListener = onViewPagerListener;
            return this;
        }

        public Builder addHeadView(View view, FrameLayout.LayoutParams layoutParams) {
            this.mHeadView = view;
            this.mHeadViewLp = layoutParams;
            return this;
        }

        public Builder addHeadView(View view) {
            this.mHeadView = view;
            return this;
        }

        public Builder addContentView(View view, FrameLayout.LayoutParams layoutParams) {
            this.mContentView = view;
            this.mContentViewLp = layoutParams;
            return this;
        }

        public Builder addContentView(View view) {
            this.mContentView = view;
            return this;
        }

        public Builder addTailView(View view, FrameLayout.LayoutParams layoutParams) {
            this.mTailView = view;
            this.mTailViewLp = layoutParams;
            return this;
        }

        public Builder addTailView(View view) {
            this.mTailView = view;
            return this;
        }

        public ScrollableViewPagerFrame build() {
            Builder builder = builder2;
            Builder builder2 = builder.mContext;
            ScrollableViewPagerFrame scrollableViewPagerFrame = new ScrollableViewPagerFrame((Context)builder2, builder.mScrollView);
            scrollableViewPagerFrame.init();
            return scrollableViewPagerFrame;
        }

        public ScrollableViewPagerFrame create() {
            ScrollableViewPagerFrame scrollableViewPagerFrame = builder4.build();
            Builder builder = builder4;
            Builder builder2 = builder4;
            Builder builder3 = builder4;
            scrollableViewPagerFrame.setScrollAvailable(builder4.scrollAvailable);
            scrollableViewPagerFrame.setSupport3Status(builder4.isSupport3Status);
            scrollableViewPagerFrame.setBottomStatusContentHeight(builder4.mBottomStatusContentHeight);
            scrollableViewPagerFrame.setSpecialStatusContentHeight(builder4.mSpecialStatusContentHeight);
            scrollableViewPagerFrame.setTopStatusContentHeight(builder4.mTopStatusContentHeight);
            scrollableViewPagerFrame.setScrollChangeListener(builder4.mScrollChangeListener);
            scrollableViewPagerFrame.setScrollViewTouchListener(builder4.mScrollViewTouchListener);
            scrollableViewPagerFrame.setViewPagerListener(builder4.mViewPagerListener);
            Builder builder4 = builder3.mHeadView;
            scrollableViewPagerFrame.addHeadView((View)builder4, builder3.mHeadViewLp);
            builder4 = builder2.mContentView;
            scrollableViewPagerFrame.addContentView((View)builder4, builder2.mContentViewLp);
            builder4 = builder.mTailView;
            scrollableViewPagerFrame.addTailView((View)builder4, builder.mTailViewLp);
            scrollableViewPagerFrame.create();
            return scrollableViewPagerFrame;
        }
    }

    public static abstract class OnViewPagerListener {
        protected View createPage(Object object, IServiceManager iServiceManager) {
            return null;
        }

        protected void onPageScrolled(int n5, float f6, int n6) {
        }

        protected void onPageSelected(int n5, Object object) {
        }

        protected void onPageScrollStateChanged(int n5) {
        }
    }
}

