/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.util.b;

public class RecycleViewDivider
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Paint mPaint;
    private ColorDrawable mDivider;
    private int mDividerHeight = 2;
    private int mRectHeight = 2;
    private int mOrientation;

    public RecycleViewDivider(Context context, int n5) {
        if (n5 != 1 && n5 != 0) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570\uff01");
        }
        this.mOrientation = n5;
        this.mDivider = new ColorDrawable(b.b(R.color.nsdk_transparent));
        context.obtainStyledAttributes(ATTRS).recycle();
    }

    public RecycleViewDivider(Context context, int n5, int n6) {
        recycleViewDivider(context, n5);
        ColorDrawable colorDrawable;
        RecycleViewDivider recycleViewDivider = colorDrawable;
        v1.mDivider = new ColorDrawable(b.b(R.color.nsdk_transparent));
        v1.mDividerHeight = recycleViewDivider.getIntrinsicHeight();
    }

    public RecycleViewDivider(Context context, int n5, int n6, int n7) {
        this(context, n5, n6, n7, n6);
    }

    public RecycleViewDivider(Context context, int n5, int n6, int n7, int n8) {
        this(context, n5);
        Paint paint;
        this.mDividerHeight = n6;
        this.mRectHeight = n8;
        Context context2 = context = paint;
        super(1);
        this.mPaint = context2;
        paint.setColor(n7);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        super.getItemOffsets(rect, view, recyclerView, state);
        if (this.shouAddDivider(recyclerView.getChildAdapterPosition(view))) {
            if (this.mOrientation == 1) {
                int n5 = this.mRectHeight;
                rect.set(0, 0, 0, n5);
            } else {
                int n6 = this.mRectHeight;
                rect.set(0, 0, n6, 0);
            }
        }
    }

    public boolean shouAddDivider(int n5) {
        return true;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        RecycleViewDivider recycleViewDivider = this;
        super.onDraw(canvas, recyclerView, state);
        if (recycleViewDivider.mOrientation == 1) {
            this.drawVertical(canvas, recyclerView);
        } else {
            this.drawHorizontal(canvas, recyclerView);
        }
    }

    protected void drawVertical(Canvas canvas, RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        int n5 = recyclerView2.getPaddingLeft();
        int n6 = recyclerView2.getMeasuredWidth() - recyclerView.getPaddingRight();
        int n7 = recyclerView2.getChildCount();
        for (int i5 = 0; i5 < n7; ++i5) {
            RecyclerView recyclerView3 = recyclerView;
            View view = recyclerView3.getChildAt(i5);
            if (!this.shouAddDivider(recyclerView3.getChildAdapterPosition(view))) continue;
            View view2 = view;
            view = (RecyclerView.LayoutParams)view2.getLayoutParams();
            int n8 = this.mDividerHeight;
            int n9 = view2.getBottom() + view.bottomMargin + (this.mRectHeight - n8) / 2;
            n8 = n9 + n8;
            ColorDrawable colorDrawable = this.mDivider;
            if (colorDrawable != null) {
                colorDrawable.setBounds(n5, n9, n6, n8);
                this.mDivider.draw(canvas);
            }
            if ((colorDrawable = this.mPaint) == null) continue;
            float f6 = n5;
            float f7 = n9;
            float f8 = n6;
            float f9 = n8;
            canvas.drawRect(f6, f7, f8, f9, (Paint)colorDrawable);
        }
    }

    protected void drawHorizontal(Canvas canvas, RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        int n5 = recyclerView2.getPaddingTop();
        int n6 = recyclerView2.getMeasuredHeight() - recyclerView.getPaddingBottom();
        int n7 = recyclerView2.getChildCount();
        for (int i5 = 0; i5 < n7; ++i5) {
            RecyclerView recyclerView3 = recyclerView;
            View view = recyclerView3.getChildAt(i5);
            if (!this.shouAddDivider(recyclerView3.getChildAdapterPosition(view))) continue;
            View view2 = view;
            view = (RecyclerView.LayoutParams)view2.getLayoutParams();
            int n8 = this.mDividerHeight;
            int n9 = view2.getRight() + view.rightMargin + (this.mRectHeight - n8) / 2;
            n8 = n9 + n8;
            ColorDrawable colorDrawable = this.mDivider;
            if (colorDrawable != null) {
                colorDrawable.setBounds(n9, n5, n8, n6);
                this.mDivider.draw(canvas);
            }
            if ((colorDrawable = this.mPaint) == null) continue;
            float f6 = n9;
            float f7 = n5;
            float f8 = n8;
            float f9 = n6;
            canvas.drawRect(f6, f7, f8, f9, (Paint)colorDrawable);
        }
    }
}

