/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.util.common;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.i;
import com.baidu.navisdk.util.i.a;

public class ScreenUtil
implements a {
    private static final String TAG = "ScreenUtil";
    public static final int DENSITY_DEFAULT = 160;
    public static final int DEFAULT_WIDTH = 1080;
    public static final int DEFAULT_HEIGHT = 1920;
    public static final int SCREEN_SIZE_Y_LARGE = 640;
    private static ScreenUtil mInstance;
    public static final int ROTATION_INVALID = -1;
    public static final int ROTATION_TOP = 0;
    public static final int ROTATION_RIGHT = 1;
    public static final int ROTATION_BOTTOM = 2;
    public static final int ROTATION_LEFT = 3;
    private Display mDefaultDisplay;
    private DisplayMetrics mDM;
    private float mDensity = 0.0f;
    private int mWidthPixels = 0;
    private int mHeightPixels = 0;
    private int mAbsoluteWidth = 0;
    private int mAbsoluteHeight = 0;
    private int mStatusBarHeight = 0;
    private int mDPI = 0;
    private boolean isNavibarShown = false;
    private int mDensityDpi;
    private int mOldLayoutWidth;
    private int mOldLayoutHeight;

    private ScreenUtil() {
    }

    public static ScreenUtil getInstance() {
        if (mInstance == null) {
            mInstance = new ScreenUtil();
        }
        return mInstance;
    }

    private int getStatusBarHeightForLowApi(Context context) {
        if (context instanceof Activity) {
            Rect rect;
            ScreenUtil screenUtil = rect;
            rect = new Rect();
            if ((context = ((Activity)context).getWindow()) != null && context.getDecorView() != null) {
                context.getDecorView().getWindowVisibleDisplayFrame((Rect)screenUtil);
            }
            return ((Rect)screenUtil).top;
        }
        return (int)Math.ceil(context.getResources().getDisplayMetrics().density * 25.0f);
    }

    private Display getDefaultDisplay(Context context) {
        if (this.mDefaultDisplay == null && context != null && (context = (WindowManager)context.getSystemService("window")) != null) {
            this.mDefaultDisplay = context.getDefaultDisplay();
        }
        return this.mDefaultDisplay;
    }

    public static int getBottomBarHeight(Context context) {
        block4: {
            if (context.getResources().getIdentifier("config_showNavigationBar", "bool", "android") == 0) break block4;
            Context context2 = context;
            Context context3 = context2;
            int n5 = context2.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
            try {
                return context3.getResources().getDimensionPixelSize(n5);
            }
            catch (Exception exception) {
                LogUtil.e(TAG, "getBottomBarHeight" + exception.getMessage());
            }
        }
        return 0;
    }

    public static boolean isTablet(Configuration configuration) {
        return (configuration.screenLayout & 0xF) >= 3;
    }

    public static boolean isLandscape(Configuration configuration) {
        return configuration.orientation == 2;
    }

    @Override
    public void init(Activity activity, int n5) {
        this.init((Context)activity);
    }

    public void init(Context context) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return;
        }
        this.mDM = displayMetrics = context.getResources().getDisplayMetrics();
        int n5 = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        ScreenUtil screenUtil = this;
        DisplayMetrics displayMetrics2 = screenUtil.mDM;
        int n6 = Math.max(displayMetrics2.widthPixels, displayMetrics2.heightPixels);
        if (n5 == screenUtil.mWidthPixels && n6 == this.mHeightPixels) {
            return;
        }
        if (i.L.d()) {
            i.L.e(TAG, "init: ");
        }
        this.mWidthPixels = n5;
        this.mHeightPixels = n6;
        DisplayMetrics displayMetrics3 = this.mDM;
        this.mDensity = displayMetrics3.density;
        this.mDensityDpi = displayMetrics3.densityDpi;
        if (Build.VERSION.SDK_INT >= 17) {
            int n7;
            DisplayMetrics displayMetrics4;
            Context context2 = context;
            context = displayMetrics4;
            displayMetrics4 = new DisplayMetrics();
            ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getRealMetrics((DisplayMetrics)context);
            this.mAbsoluteWidth = Math.min(context.widthPixels, context.heightPixels);
            this.mAbsoluteHeight = n7 = Math.max(context.widthPixels, context.heightPixels);
            n7 = n7 > this.mHeightPixels ? 1 : 0;
            this.isNavibarShown = n7;
        } else {
            ScreenUtil screenUtil2 = this;
            screenUtil2.mAbsoluteWidth = n5;
            screenUtil2.mAbsoluteHeight = n6;
        }
        this.mDPI = this.mDM.densityDpi;
        if (this.mDPI == 0) {
            this.mDPI = 160;
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDM;
    }

    public float getDensity() {
        return this.mDensity;
    }

    public int getDPI() {
        return this.mDPI;
    }

    @Override
    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    @Override
    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public int getStatusBarHeight(Activity activity) {
        if (this.mStatusBarHeight == 0) {
            if (activity == null) {
                return 0;
            }
            this.resetStatusBarHeight(activity);
        }
        return this.mStatusBarHeight;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetStatusBarHeight(Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            int n5 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (n5 > 0) {
                screenUtil2.mStatusBarHeight = activity.getResources().getDimensionPixelSize(n5);
                return;
            }
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object obj = clazz.newInstance();
            int n6 = Integer.parseInt(clazz.getField("status_bar_height").get(obj).toString());
            screenUtil2.mStatusBarHeight = activity.getResources().getDimensionPixelSize(n6);
            return;
        }
        catch (Exception exception) {
            Rect rect;
            ScreenUtil screenUtil = screenUtil2;
            Log.e((String)TAG, (String)"an error occurred when getField status_bar_height ", (Throwable)exception);
            ScreenUtil screenUtil2 = rect;
            screenUtil2();
            activity.getWindow().getDecorView().getWindowVisibleDisplayFrame((Rect)screenUtil2);
            screenUtil.mStatusBarHeight = rect.top;
        }
    }

    public int dip2px(int n5) {
        return (int)(this.mDensity * (float)n5 + 0.5f);
    }

    public int px2dip(int n5) {
        return (int)((float)n5 / this.mDensity + 0.5f);
    }

    public int dip2px(float f6) {
        return (int)(this.mDensity * f6 + 0.5f);
    }

    public int px2dip(float f6) {
        return (int)(f6 / this.mDensity + 0.5f);
    }

    public int getDp(Context context, int n5) {
        if (context != null && context.getResources() != null) {
            return this.px2dip(context.getResources().getDimensionPixelSize(n5));
        }
        return 0;
    }

    public int percentHeight(float f6) {
        return (int)(f6 * (float)this.getHeightPixels());
    }

    public int percentWidth(float f6) {
        return (int)(f6 * (float)this.getWidthPixels());
    }

    public int getStatusBarHeightFullScreen(Context context) {
        if (context == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return this.getStatusBarHeightForLowApi(context);
        }
        int n5 = 0;
        int n6 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = context.getResources().getDimensionPixelSize(n6);
        }
        if (n5 <= 0) {
            n5 = this.dip2px(25);
        }
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getDisplayRotation(Activity activity) {
        if (activity == null) {
            return 0;
        }
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: 
        }
        return 0;
    }

    public int getAbsoluteWidth() {
        return this.mAbsoluteWidth;
    }

    public int getAbsoluteHeight() {
        return this.mAbsoluteHeight;
    }

    public boolean isNaviBarShown() {
        return this.isNavibarShown;
    }

    public void setNavibarShown(boolean bl) {
        LogUtil.e("setUIViewBound", "setNavibarShown - " + bl);
        this.isNavibarShown = bl;
    }

    public int getNaviBarHeight() {
        return this.getAbsoluteHeight() - this.mHeightPixels;
    }

    public int getDensityDpi() {
        return this.mDensityDpi;
    }

    public void keepScreenOn(boolean bl, Activity activity) {
        if (activity != null && !activity.isFinishing()) {
            if (bl) {
                activity.getWindow().addFlags(128);
            } else {
                activity.getWindow().clearFlags(128);
            }
            return;
        }
    }

    public int getScreenOrientation(Activity activity) {
        if (activity == null) {
            return -1;
        }
        ScreenUtil screenUtil = activity.getResources();
        screenUtil = screenUtil == null ? null : screenUtil.getConfiguration();
        return screenUtil == null ? -1 : ((Configuration)screenUtil).orientation;
    }

    public void setScreenOrientation(Activity activity, int n5) {
        if (activity != null) {
            activity.setRequestedOrientation(n5);
        }
    }

    public int getDefaultWidth(Context context) {
        if ((this = this.getDefaultDisplay(context)) != null) {
            return this.getWidth();
        }
        return 1080;
    }

    public int getDefaultHeight(Context context) {
        if ((this = this.getDefaultDisplay(context)) != null) {
            return this.getHeight();
        }
        return 1920;
    }
}

