/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.util.jar.style;

import android.content.Context;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.baidu.navisdk.ui.util.b;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.jar.JarUtils;
import com.baidu.navisdk.util.jar.style.StyleAttr;
import com.baidu.navisdk.util.jar.style.StyleCommonView;
import com.baidu.navisdk.util.jar.style.StyleImageView;
import com.baidu.navisdk.util.jar.style.StyleTextView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BNInflaterFactory
implements LayoutInflater.Factory2 {
    private static final String TAG = "BNInflaterFactory";
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.view.", "android.app."};
    public static final int ID_NULL = 0;
    protected static long mLastReleaseTime = 0L;
    private static final HashMap<String, Constructor<? extends View>> mConstructorMap = new HashMap();
    private static volatile BNInflaterFactory mInstance = null;
    private final ConcurrentHashMap<Integer, StyleCommonView> mStyleCommonViewMap;

    public BNInflaterFactory() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.mStyleCommonViewMap = concurrentHashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BNInflaterFactory getInstance() {
        if (mInstance != null) return mInstance;
        Class<BNInflaterFactory> clazz = BNInflaterFactory.class;
        synchronized (BNInflaterFactory.class) {
            if (mInstance != null) return mInstance;
            mInstance = new BNInflaterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private View handleCreateView(String string2, String object, Context context, AttributeSet attributeSet) throws ClassNotFoundException {
        block12: {
            Constructor<? extends View> constructor;
            block11: {
                ClassLoader classLoader = context.getClassLoader();
                constructor = mConstructorMap.get(string2);
                if (constructor == null) {
                    object = object == null ? string2 : (String)object + string2;
                    if ((object = classLoader.loadClass((String)object).asSubclass(View.class)) == null) {
                        LogUtil.e(TAG, "handleCreateView fail c is null name=" + string2);
                        return null;
                    }
                    constructor = this.getConstructor((Class<? extends View>)object);
                    try {
                        mConstructorMap.put(string2, constructor);
                    }
                    catch (Exception exception) {
                        if (!LogUtil.LOGGABLE) break block11;
                        exception.printStackTrace();
                        LogUtil.printException(TAG, exception);
                    }
                }
            }
            try {
                string2 = this.createView(constructor, attributeSet, context);
            }
            catch (Exception exception) {
                if (LogUtil.LOGGABLE) {
                    exception.printStackTrace();
                    LogUtil.printException(TAG, exception);
                }
                return null;
            }
            if (!(string2 instanceof ViewStub)) break block12;
            object = (ViewStub)string2;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)object.getContext()).cloneInContext(object.getContext());
            layoutInflater.setFactory((LayoutInflater.Factory)this.getFactory2());
            object.setLayoutInflater(layoutInflater);
        }
        return string2;
    }

    private synchronized void addToCache(StyleCommonView styleCommonView) {
        this.mStyleCommonViewMap.put(styleCommonView.mKey, styleCommonView);
    }

    private synchronized void removeFromCache(StyleCommonView styleCommonView) {
        this.mStyleCommonViewMap.remove(styleCommonView.mKey);
    }

    private synchronized StyleCommonView getStyleView(View view) {
        StyleCommonView styleCommonView = this.mStyleCommonViewMap.get(view.hashCode());
        if (styleCommonView == null) {
            BNInflaterFactory bNInflaterFactory = this;
            styleCommonView = bNInflaterFactory.createStyleCommonView(view);
            bNInflaterFactory.addToCache(styleCommonView);
        }
        return styleCommonView;
    }

    private StyleCommonView createStyleCommonView(View view) {
        Object object;
        if (view instanceof TextView) {
            StyleTextView styleTextView;
            object = styleTextView;
            styleTextView = new StyleTextView(view);
        } else if (view instanceof ImageView) {
            StyleImageView styleImageView;
            object = styleImageView;
            styleImageView = new StyleImageView(view);
        } else {
            StyleCommonView styleCommonView;
            object = styleCommonView;
            styleCommonView = new StyleCommonView(view);
        }
        return object;
    }

    private StyleAttr createAttr(String string2, String string3, Resources resources) {
        if (string3 != null && string3.startsWith("@")) {
            int n5 = Integer.parseInt(string3.substring(1));
            if (n5 == 0) {
                return null;
            }
            return this.createAttr(string2, n5, resources);
        }
        return null;
    }

    private StyleAttr createAttr(String string2, int n5, Resources object) {
        StyleAttr styleAttr;
        Object object2 = styleAttr;
        Resources resources = object;
        ((StyleAttr)object2)();
        object2 = resources.getResourceEntryName(n5);
        object = resources.getResourceTypeName(n5);
        styleAttr.mAttrName = string2;
        styleAttr.mId = n5;
        styleAttr.mEntryName = object2;
        styleAttr.mEntryType = object;
        return styleAttr;
    }

    public View onCreateView(@androidx.annotation.Nullable @Nullable View view, @NonNull @NotNull String string2, @NonNull @NotNull Context context, @NonNull @NotNull AttributeSet attributeSet) {
        view = this.handleCreateView(string2, context, attributeSet);
        if (view == null) {
            LogUtil.e(TAG, "view is null name:" + string2);
        } else {
            this.parseAttrs(context, attributeSet, view);
        }
        return view;
    }

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        View view = this.handleCreateView(string2, context, attributeSet);
        if (view == null) {
            LogUtil.e(TAG, "view is null name:" + string2);
        } else {
            this.parseAttrs(context, attributeSet, view);
        }
        return view;
    }

    protected View handleCreateView(String string2, Context context, AttributeSet attributeSet) {
        View view = null;
        if (-1 == string2.indexOf(46)) {
            String[] stringArray = sClassPrefixList;
            int n5 = sClassPrefixList.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                try {
                    view = this.handleCreateView(string2, stringArray[i5], context, attributeSet);
                    if (view == null) continue;
                    return view;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            try {
                view = this.handleCreateView(string2, null, context, attributeSet);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return view;
    }

    protected Constructor<? extends View> getConstructor(Class<? extends View> clazz) throws NoSuchMethodException {
        return clazz.getConstructor(Context.class, AttributeSet.class);
    }

    protected View createView(Constructor<? extends View> constructor, AttributeSet attributeSet, Context context) throws Exception {
        return constructor.newInstance(context, attributeSet);
    }

    protected BNInflaterFactory getFactory2() {
        return BNInflaterFactory.getInstance();
    }

    protected void parseAttrs(Context object, AttributeSet attributeSet, View view) {
        if (view == null) {
            LogUtil.e(TAG, "parseAttrs fail view is null");
            return;
        }
        Resources resources = object.getResources();
        StyleAttr styleAttr = null;
        StyleAttr styleAttr2 = null;
        StyleAttr[] styleAttrArray = null;
        StyleAttr styleAttr3 = null;
        StyleAttr styleAttr4 = null;
        int n5 = attributeSet.getAttributeCount();
        for (int i5 = 0; i5 < n5; ++i5) {
            String string2 = attributeSet.getAttributeName(i5);
            String string3 = attributeSet.getAttributeValue(i5);
            if ("background".equals(string2)) {
                styleAttr = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("textColor".equals(string2)) {
                styleAttr2 = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableLeft".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[0] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableTop".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[1] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableRight".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[2] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableBottom".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[3] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("src".equals(string2) && view instanceof ImageView) {
                styleAttr3 = this.createAttr(string2, string3, resources);
                continue;
            }
            if (!"style".equals(string2)) continue;
            styleAttr4 = this.createAttr(string2, string3, resources);
        }
        if (styleAttr4 != null && (styleAttr == null || styleAttr2 == null)) {
            int n6;
            int n7;
            Context context = object;
            int[] nArray = new int[2];
            object = nArray;
            nArray[0] = 16842904;
            nArray[1] = 16842964;
            object = context.obtainStyledAttributes(styleAttr4.mId, (int[])object);
            if (styleAttr2 == null && object.hasValue(0) && (n7 = object.getResourceId(0, 0)) != 0) {
                styleAttr2 = this.createAttr("textColor", n7, resources);
            }
            if (styleAttr == null && object.hasValue(1) && (n6 = object.getResourceId(1, 0)) != 0) {
                styleAttr = this.createAttr("background", n6, resources);
            }
            object.recycle();
        }
        if (styleAttr != null || styleAttr2 != null || styleAttrArray != null || styleAttr3 != null) {
            object = this.createStyleCommonView(view);
            ((StyleCommonView)object).mBackGroundAttr = styleAttr;
            if (object instanceof StyleTextView) {
                StyleTextView styleTextView = (StyleTextView)object;
                styleTextView.mTextColorAttr = styleAttr2;
                styleTextView.mComponentDrawableAttr = styleAttrArray;
            }
            if (object instanceof StyleImageView) {
                ((StyleImageView)object).mImageResourceAttr = styleAttr3;
            }
            ((StyleCommonView)object).updateStyle();
            this.addToCache((StyleCommonView)object);
        }
    }

    public synchronized void removeFromCache(View view) {
        this.mStyleCommonViewMap.remove(view.hashCode());
    }

    public void updateStyle(boolean bl) {
        if (bl == b.b()) {
            return;
        }
        b.b(bl);
        this.handleUpdateStyle();
    }

    protected void handleUpdateStyle() {
        Iterator<Map.Entry<Integer, StyleCommonView>> iterator = ((BNInflaterFactory)((Object)iterator)).mStyleCommonViewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            WeakReference<View> weakReference;
            StyleCommonView styleCommonView = (StyleCommonView)((Map.Entry)iterator.next()).getValue();
            if (styleCommonView != null && (weakReference = styleCommonView.mView) != null && weakReference.get() != null) {
                styleCommonView.updateStyle();
                continue;
            }
            iterator.remove();
        }
    }

    public void releaseNullStyle() {
        long l5 = SystemClock.elapsedRealtime();
        if (l5 - mLastReleaseTime > 5000L) {
            return;
        }
        Iterator<Map.Entry<Integer, StyleCommonView>> iterator = ((BNInflaterFactory)((Object)iterator)).mStyleCommonViewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = (StyleCommonView)((Map.Entry)iterator.next()).getValue();
            if (object != null && (object = ((StyleCommonView)object).mView) != null && ((Reference)object).get() != null) continue;
            iterator.remove();
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "releaseNullStyle cost time:" + (SystemClock.elapsedRealtime() - l5));
        }
    }

    public void setBackground(View object, int n5) {
        object = bNInflaterFactory2.getStyleView((View)object);
        if (n5 == 0) {
            ((StyleCommonView)object).mBackGroundAttr = null;
        } else {
            BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
            BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
            ((StyleCommonView)object).mBackGroundAttr = bNInflaterFactory.createAttr("background", n5, (Resources)bNInflaterFactory2);
        }
        ((StyleCommonView)object).updateStyle();
    }

    public void setTextColor(TextView textView, int n5) {
        StyleCommonView styleCommonView = bNInflaterFactory2.getStyleView((View)textView);
        if (!(styleCommonView instanceof StyleTextView)) {
            bNInflaterFactory2.removeFromCache(styleCommonView);
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "setTextColor error StyleTextView error");
            }
        }
        StyleTextView styleTextView = (StyleTextView)bNInflaterFactory2.getStyleView((View)textView);
        BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
        BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
        styleTextView.mTextColorAttr = bNInflaterFactory.createAttr("textColor", n5, (Resources)bNInflaterFactory2);
        styleTextView.updateStyle();
    }

    public void setCompoundDrawables(TextView object, int n5, int n6, int n7, int n8) {
        object = (StyleTextView)bNInflaterFactory2.getStyleView((View)object);
        Resources resources = new StyleAttr[4];
        v0.mComponentDrawableAttr = resources;
        if (n5 > 0) {
            Resources resources2 = resources;
            resources = JarUtils.getResources();
            resources2[0] = bNInflaterFactory2.createAttr("drawableLeft", n5, resources);
        }
        if (n6 > 0) {
            Resources resources3 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[1] = bNInflaterFactory2.createAttr("drawableTop", n6, resources3);
        }
        if (n7 > 0) {
            Resources resources4 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[2] = bNInflaterFactory2.createAttr("drawableRight", n6, resources4);
        }
        if (n8 > 0) {
            BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
            BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[3] = bNInflaterFactory.createAttr("drawableBottom", n6, (Resources)bNInflaterFactory2);
        }
        ((StyleTextView)object).updateStyle();
    }

    public void setImageResource(View view, int n5) {
        StyleImageView styleImageView = (StyleImageView)bNInflaterFactory2.getStyleView(view);
        BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
        BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
        styleImageView.mImageResourceAttr = bNInflaterFactory.createAttr("background", n5, (Resources)bNInflaterFactory2);
        styleImageView.updateStyle();
    }
}

