/*
 * Decompiled with CFR 0.152.
 */
package com.leansoft.bigqueue.page;

import com.leansoft.bigqueue.cache.ILRUCache;
import com.leansoft.bigqueue.cache.LRUCacheImpl;
import com.leansoft.bigqueue.page.IMappedPage;
import com.leansoft.bigqueue.page.IMappedPageFactory;
import com.leansoft.bigqueue.page.MappedPageImpl;
import com.leansoft.bigqueue.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedPageFactoryImpl
implements IMappedPageFactory {
    private static final Logger logger = LoggerFactory.getLogger(MappedPageFactoryImpl.class);
    private int pageSize;
    private String pageDir;
    private File pageDirFile;
    private String pageFile;
    private long ttl;
    private final Object mapLock = new Object();
    private final Map<Long, Object> pageCreationLockMap = new HashMap<Long, Object>();
    public static final String PAGE_FILE_NAME = "page";
    public static final String PAGE_FILE_SUFFIX = ".dat";
    private ILRUCache<Long, MappedPageImpl> cache;

    public MappedPageFactoryImpl(int pageSize, String pageDir, long cacheTTL) {
        this.pageSize = pageSize;
        this.pageDir = pageDir;
        this.ttl = cacheTTL;
        this.pageDirFile = new File(this.pageDir);
        if (!this.pageDirFile.exists()) {
            this.pageDirFile.mkdirs();
        }
        if (!this.pageDir.endsWith(File.separator)) {
            this.pageDir = this.pageDir + File.separator;
        }
        this.pageFile = this.pageDir + PAGE_FILE_NAME + "-";
        this.cache = new LRUCacheImpl<Long, MappedPageImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMappedPage acquirePage(long index) throws IOException {
        MappedPageImpl mpi;
        block26: {
            mpi = this.cache.get(index);
            if (mpi == null) {
                try {
                    Object lock = null;
                    Object object = this.mapLock;
                    synchronized (object) {
                        if (!this.pageCreationLockMap.containsKey(index)) {
                            this.pageCreationLockMap.put(index, new Object());
                        }
                        lock = this.pageCreationLockMap.get(index);
                    }
                    object = lock;
                    synchronized (object) {
                        mpi = this.cache.get(index);
                        if (mpi == null) {
                            RandomAccessFile raf = null;
                            AbstractInterruptibleChannel channel = null;
                            try {
                                String fileName = this.getFileNameByIndex(index);
                                raf = new RandomAccessFile(fileName, "rw");
                                channel = raf.getChannel();
                                MappedByteBuffer mbb = ((FileChannel)channel).map(FileChannel.MapMode.READ_WRITE, 0L, this.pageSize);
                                mpi = new MappedPageImpl(mbb, fileName, index);
                                this.cache.put(index, mpi, this.ttl);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Mapped page for " + fileName + " was just created and cached.");
                                }
                            }
                            finally {
                                if (channel != null) {
                                    channel.close();
                                }
                                if (raf != null) {
                                    raf.close();
                                }
                            }
                        }
                        break block26;
                    }
                }
                finally {
                    Object object = this.mapLock;
                    synchronized (object) {
                        this.pageCreationLockMap.remove(index);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Hit mapped page " + mpi.getPageFile() + " in cache.");
            }
        }
        return mpi;
    }

    private String getFileNameByIndex(long index) {
        return this.pageFile + index + PAGE_FILE_SUFFIX;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getPageDir() {
        return this.pageDir;
    }

    @Override
    public void releasePage(long index) {
        this.cache.release(index);
    }

    @Override
    public void releaseCachedPages() throws IOException {
        this.cache.removeAll();
    }

    @Override
    public void deleteAllPages() throws IOException {
        this.cache.removeAll();
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug("All page files in dir " + this.pageDir + " have been deleted.");
        }
    }

    @Override
    public void deletePages(Set<Long> indexes) throws IOException {
        if (indexes == null) {
            return;
        }
        for (long index : indexes) {
            this.deletePage(index);
        }
    }

    @Override
    public void deletePage(long index) throws IOException {
        this.cache.remove(index);
        String fileName = this.getFileNameByIndex(index);
        int maxRound = 10;
        boolean deleted = false;
        for (int count = 0; count < maxRound; ++count) {
            try {
                FileUtil.deleteFile(new File(fileName));
                deleted = true;
                break;
            }
            catch (IllegalStateException ex) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!logger.isDebugEnabled()) continue;
                logger.warn("fail to delete file " + fileName + ", tried round = " + count);
                continue;
            }
        }
        if (deleted) {
            logger.info("Page file " + fileName + " was just deleted.");
        } else {
            logger.warn("fail to delete file " + fileName + " after max " + maxRound + " rounds of try, you may delete it manually.");
        }
    }

    @Override
    public Set<Long> getPageIndexSetBefore(long timestamp) {
        HashSet<Long> beforeIndexSet = new HashSet<Long>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName;
                if (pageFile.lastModified() >= timestamp || !(fileName = pageFile.getName()).endsWith(PAGE_FILE_SUFFIX)) continue;
                long index = this.getIndexByFileName(fileName);
                beforeIndexSet.add(index);
            }
        }
        return beforeIndexSet;
    }

    private long getIndexByFileName(String fileName) {
        int beginIndex = fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf(PAGE_FILE_SUFFIX);
        String sIndex = fileName.substring(++beginIndex, endIndex);
        long index = Long.parseLong(sIndex);
        return index;
    }

    @Override
    public void deletePagesBefore(long timestamp) throws IOException {
        Set<Long> indexSet = this.getPageIndexSetBefore(timestamp);
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug("All page files in dir [" + this.pageDir + "], before [" + timestamp + "] have been deleted.");
        }
    }

    @Override
    public void deletePagesBeforePageIndex(long pageIndex) throws IOException {
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        for (Long index : indexSet) {
            if (index >= pageIndex) continue;
            this.deletePage(index);
        }
    }

    @Override
    public Set<Long> getExistingBackFileIndexSet() {
        HashSet<Long> indexSet = new HashSet<Long>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                long index = this.getIndexByFileName(fileName);
                indexSet.add(index);
            }
        }
        return indexSet;
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    int getLockMapSize() {
        return this.pageCreationLockMap.size();
    }

    @Override
    public long getPageFileLastModifiedTime(long index) {
        String pageFileName = this.getFileNameByIndex(index);
        File pageFile = new File(pageFileName);
        if (!pageFile.exists()) {
            return -1L;
        }
        return pageFile.lastModified();
    }

    @Override
    public long getFirstPageIndexBefore(long timestamp) {
        Set<Long> beforeIndexSet = this.getPageIndexSetBefore(timestamp);
        if (beforeIndexSet.size() == 0) {
            return -1L;
        }
        TreeSet<Long> sortedIndexSet = new TreeSet<Long>(beforeIndexSet);
        Long largestIndex = sortedIndexSet.last();
        return largestIndex;
    }

    @Override
    public void flush() {
        Collection<MappedPageImpl> cachedPages = this.cache.getValues();
        for (IMappedPage iMappedPage : cachedPages) {
            iMappedPage.flush();
        }
    }

    @Override
    public Set<String> getBackPageFileSet() {
        HashSet<String> fileSet = new HashSet<String>();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                fileSet.add(fileName);
            }
        }
        return fileSet;
    }

    @Override
    public long getBackPageFileSize() {
        long totalSize = 0L;
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith(PAGE_FILE_SUFFIX)) continue;
                totalSize += pageFile.length();
            }
        }
        return totalSize;
    }
}

