/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.maven.jmh;

import com.baidu.maven.jmh.AbstractExecMojo;
import com.baidu.maven.jmh.ExecutableDependency;
import com.baidu.maven.jmh.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.ExBenchmarkList;
import org.openjdk.jmh.runner.ExtendedRunner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.WarmupMode;

@Mojo(name="jmh", threadSafe=true, defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JMHBeachmarkMojo
extends AbstractExecMojo {
    private static final String SKIP_BENCHMARK = "skipBenchmark";
    private static final Map<String, TimeUnit> timeUnitMap = new HashMap<String, TimeUnit>();
    @Parameter
    private ExecutableDependency executableDependency;
    @Deprecated
    @Parameter(property="jprotobuf.killAfter", defaultValue="-1")
    private long killAfter;
    private Properties originalSystemProperties;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputParentDirectory;
    @Parameter
    private List<String> additionalClasspathElements;
    @Parameter(property="jmh.forks", defaultValue="1")
    private int forks = 1;
    @Parameter(property="jmh.warmupForks", defaultValue="1")
    private int warmupForks = 1;
    @Parameter(property="jmh.threads", defaultValue="1")
    private int threads = 1;
    @Parameter(property="jmh.warmupMode", defaultValue="1")
    private int warmupMode = 1;
    @Parameter(property="jmh.warmupIterations", defaultValue="3")
    private int warmupIterations = 3;
    @Parameter(property="jmh.measurementIterations", defaultValue="5")
    private int measurementIterations = 5;
    @Parameter(property="jmh.timeUnit", defaultValue="ms")
    private String timeUnit;
    @Parameter(property="jmh.measurementTime", defaultValue="1s")
    private String measurementTime;
    @Parameter(property="jmh.warmupTime", defaultValue="1s")
    private String warmupTime;
    @Parameter(property="jmh.timeout", defaultValue="10s")
    private String timeout;
    @Parameter(property="jmh.resultFormat", defaultValue="JSON")
    private String resultFormat;
    @Parameter(property="jmh.result", defaultValue="jmh_benchmark_result")
    private String resultFile;
    @Parameter(property="jmh.mode", defaultValue="thrpt")
    private String mode;
    @Parameter(property="jmh.multiResultFileOutput", defaultValue="false")
    private boolean multiResultFileOutput;
    @Parameter(property="jmh.benchmarkIncludes")
    private String benchmarkIncludes;
    @Parameter(property="jmh.warmUpBenchmarkIncludes")
    private String warmUpBenchmarkIncludes;

    static {
        timeUnitMap.put("ms", TimeUnit.MILLISECONDS);
        timeUnitMap.put("s", TimeUnit.SECONDS);
        timeUnitMap.put("us", TimeUnit.MICROSECONDS);
        timeUnitMap.put("ns", TimeUnit.NANOSECONDS);
        timeUnitMap.put("m", TimeUnit.MINUTES);
    }

    private TimeUnit toTimeUnit(String timeUnit) {
        TimeUnit unit = timeUnitMap.get(timeUnit);
        if (unit == null) {
            unit = TimeUnit.MILLISECONDS;
        }
        return unit;
    }

    private Mode toMode(String mode) {
        try {
            Mode retMode = Mode.deepValueOf((String)mode);
            return retMode;
        }
        catch (Exception e) {
            return Mode.Throughput;
        }
    }

    private ResultFormatType toResultFormat(String resultFormat) {
        if (resultFormat == null) {
            return ResultFormatType.JSON;
        }
        resultFormat = resultFormat.toUpperCase();
        try {
            return ResultFormatType.valueOf((String)resultFormat);
        }
        catch (Exception e) {
            return ResultFormatType.JSON;
        }
    }

    private WarmupMode toWarmupMode(int warmupMode) {
        if (warmupMode == 1) {
            return WarmupMode.INDI;
        }
        if (warmupMode == 2) {
            return WarmupMode.BULK;
        }
        if (warmupMode == 3) {
            return WarmupMode.BULK_INDI;
        }
        return WarmupMode.INDI;
    }

    private TimeValue toTimeValue(String measurementTime) {
        try {
            TimeValue timeValue = TimeValue.valueOf((String)measurementTime);
            return timeValue;
        }
        catch (Exception e) {
            return TimeValue.seconds((long)1L);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String property = System.getProperty(SKIP_BENCHMARK);
        if (property != null) {
            this.getLog().info((CharSequence)"jmh-maven-plugin skipped by -DskipBenchmark");
            return;
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("error parameter value of 'project.build.outputDirectory' is null.");
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<File> theClasspathFiles = new ArrayList<File>();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        String targetPath = this.outputDirectory.getAbsolutePath();
        String targetClassPath = String.valueOf(targetPath) + "/";
        String benchMarkResultPath = String.valueOf(this.outputDirectory.getParentFile().getAbsolutePath()) + "/benchmark/";
        new File(benchMarkResultPath).mkdirs();
        String benchmarkList = String.valueOf(targetClassPath) + "/META-INF/BenchmarkList";
        String hintPath = String.valueOf(targetClassPath) + "/META-INF/CompilerHints";
        HashSet<String> classPaths = new HashSet<String>();
        for (File f : theClasspathFiles) {
            classPaths.add(f.getAbsolutePath());
        }
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            classPaths.add(artifact.getFile().getAbsolutePath());
        }
        Set<String> benchmarkIncludeSet = this.parseBenchmarkIncludes(this.benchmarkIncludes);
        String[] includes = null;
        if (!benchmarkIncludeSet.isEmpty()) {
            includes = benchmarkIncludeSet.toArray(new String[benchmarkIncludeSet.size()]);
            if (this.multiResultFileOutput) {
                String[] stringArray = includes;
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    String include = stringArray[n2];
                    String resultFilePath = String.valueOf(benchMarkResultPath) + this.resultFile + "_" + include;
                    String[] eachInclude = new String[]{include};
                    this.doBenchmarkRun(benchmarkList, hintPath, resultFilePath, classPaths, eachInclude);
                    ++n2;
                }
                return;
            }
        }
        String resultFilePath = String.valueOf(benchMarkResultPath) + this.resultFile;
        this.doBenchmarkRun(benchmarkList, hintPath, resultFilePath, classPaths, includes);
    }

    protected void doBenchmarkRun(String benchmarkList, String hintPath, String resultFile, Set<String> classPaths, String ... includes) {
        int n;
        ChainedOptionsBuilder options = new OptionsBuilder().forks(this.forks).warmupForks(this.warmupForks).threads(this.threads).warmupMode(this.toWarmupMode(this.warmupMode)).warmupIterations(this.warmupIterations).timeUnit(this.toTimeUnit(this.timeUnit)).measurementIterations(this.measurementIterations).resultFormat(this.toResultFormat(this.resultFormat)).result(resultFile).mode(this.toMode(this.mode)).measurementTime(this.toTimeValue(this.measurementTime)).warmupTime(this.toTimeValue(this.warmupTime)).timeout(this.toTimeValue(this.timeout)).detectJvmArgs();
        if (includes != null) {
            String[] stringArray = includes;
            n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                options.include(string);
                ++n2;
            }
        }
        if (!StringUtils.isEmpty(this.warmUpBenchmarkIncludes)) {
            String[] strings;
            String[] stringArray = strings = StringUtils.split(this.warmUpBenchmarkIncludes, ";");
            int n3 = strings.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                options.includeWarmup(string);
                ++n;
            }
        }
        Options opt = options.build();
        try {
            ExtendedRunner extendedRunner = new ExtendedRunner(opt, ExBenchmarkList.fromFile(benchmarkList), hintPath);
            extendedRunner.setClassPaths(classPaths);
            extendedRunner.run();
        }
        catch (RunnerException e) {
            e.printStackTrace();
        }
    }

    private Set<String> parseBenchmarkIncludes(String benchmarkIncludes) {
        String[] strings;
        if (StringUtils.isEmpty(benchmarkIncludes)) {
            return Collections.emptySet();
        }
        HashSet<String> ret = new HashSet<String>();
        String[] stringArray = strings = StringUtils.split(benchmarkIncludes, ";");
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ret.add(string);
            ++n2;
        }
        return ret;
    }
}

