/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.openjdk.jmh.runner.AbstractResourceReader;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.util.FileUtils;

public class ExBenchmarkList
extends AbstractResourceReader {
    public static final String BENCHMARK_LIST = "/META-INF/BenchmarkList";

    public static ExBenchmarkList defaultList() {
        return ExBenchmarkList.fromResource(BENCHMARK_LIST);
    }

    public static ExBenchmarkList fromFile(String file) {
        return new ExBenchmarkList(file, null, null);
    }

    public static ExBenchmarkList fromResource(String resource) {
        return new ExBenchmarkList(null, resource, null);
    }

    public static ExBenchmarkList fromString(String strings) {
        return new ExBenchmarkList(null, null, strings);
    }

    public static Collection<BenchmarkListEntry> readBenchmarkList(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            ArrayList<BenchmarkListEntry> entries = new ArrayList<BenchmarkListEntry>();
            for (String line : FileUtils.readAllLines((Reader)reader)) {
                BenchmarkListEntry ble = new BenchmarkListEntry(line);
                entries.add(ble);
            }
            return entries;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeBenchmarkList(OutputStream stream, Collection<BenchmarkListEntry> entries) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            for (BenchmarkListEntry entry : entries) {
                writer.println(entry.toLine());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ExBenchmarkList(String file, String resource, String strings) {
        super(file, resource, strings);
    }

    public Set<BenchmarkListEntry> getAll(OutputFormat out, List<String> excludes) {
        return this.find(out, Collections.singletonList(".*"), excludes);
    }

    public SortedSet<BenchmarkListEntry> find(OutputFormat out, List<String> includes, List<String> excludes) {
        ArrayList<String> regexps = new ArrayList<String>(includes);
        if (regexps.isEmpty()) {
            regexps.add(".*");
        }
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>(regexps.size());
        for (String regexp : regexps) {
            includePatterns.add(Pattern.compile(regexp));
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>(excludes.size());
        for (String regexp : excludes) {
            excludePatterns.add(Pattern.compile(regexp));
        }
        TreeSet<BenchmarkListEntry> result = new TreeSet<BenchmarkListEntry>();
        try {
            for (Reader r : this.getReaders()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(r);
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && !line.trim().isEmpty()) {
                            BenchmarkListEntry br = new BenchmarkListEntry(line);
                            for (Pattern pattern : includePatterns) {
                                if (pattern.matcher(br.getUsername()).find()) {
                                    boolean exclude = false;
                                    for (Pattern excludePattern : excludePatterns) {
                                        if (!excludePattern.matcher(br.getUsername()).find()) continue;
                                        out.verbosePrintln("Excluding " + br.getUsername() + ", matches " + excludePattern);
                                        exclude = true;
                                        break;
                                    }
                                    if (exclude) break;
                                    result.add(br);
                                    break;
                                }
                                out.verbosePrintln("Excluding: " + br.getUsername() + ", does not match " + pattern);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading benchmark list", ex);
        }
        return result;
    }
}

