/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openjdk.jmh.runner.AbstractResourceReader;
import org.openjdk.jmh.util.FileUtils;

public class ExCompilerHints
extends AbstractResourceReader {
    public static final String LIST = "/META-INF/CompilerHints";
    static final String[] HINT_COMPATIBLE_JVMS = new String[]{"OpenJDK", "HotSpot", "GraalVM"};
    static final String JVM_ZING = "Zing";
    private static volatile ExCompilerHints defaultList;
    private static volatile String hintsFile;
    private final Set<String> hints = Collections.unmodifiableSet(this.read());
    static final String XX_COMPILE_COMMAND_FILE = "-XX:CompileCommandFile=";

    public static ExCompilerHints defaultList() {
        if (defaultList == null) {
            defaultList = ExCompilerHints.fromResource(LIST);
        }
        return defaultList;
    }

    public static String hintsFile(String path) {
        if (hintsFile == null) {
            try {
                Set<String> defaultHints = ExCompilerHints.fromFile(path).get();
                ArrayList<String> hints = new ArrayList<String>(defaultHints.size() + 2);
                hints.add("quiet");
                if (Boolean.getBoolean("jmh.blackhole.forceInline")) {
                    hints.add("inline,org/openjdk/jmh/infra/Blackhole.*");
                } else {
                    hints.add("dontinline,org/openjdk/jmh/infra/Blackhole.*");
                }
                hints.addAll(defaultHints);
                hintsFile = FileUtils.createTempFileWithLines((String)"compilecommand", hints);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error creating compiler hints file", e);
            }
        }
        return hintsFile;
    }

    public static ExCompilerHints fromResource(String resource) {
        return new ExCompilerHints(null, resource);
    }

    public static ExCompilerHints fromFile(String file) {
        return new ExCompilerHints(file, null);
    }

    private ExCompilerHints(String file, String resource) {
        super(file, resource, null);
    }

    private static boolean isHintCompatibleVM() {
        String name = System.getProperty("java.vm.name");
        String[] stringArray = HINT_COMPATIBLE_JVMS;
        int n = HINT_COMPATIBLE_JVMS.length;
        int n2 = 0;
        while (n2 < n) {
            String vmName = stringArray[n2];
            if (name.contains(vmName)) {
                return true;
            }
            ++n2;
        }
        if (name.contains(JVM_ZING)) {
            String[] versionDigits;
            block7: {
                String version = System.getProperty("java.version");
                versionDigits = version.substring(version.indexOf(95) + 1).split("\\.");
                if (Integer.valueOf(versionDigits[0]) <= 5) break block7;
                return true;
            }
            try {
                if (Integer.valueOf(versionDigits[0]) == 5 && Integer.valueOf(versionDigits[1]) >= 10) {
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                System.err.println("ERROR: Zing version format does not match 1.*.0-zing_*.*.*.*");
            }
        }
        return false;
    }

    public Set<String> get() {
        return this.hints;
    }

    private Set<String> read() {
        TreeSet<String> result = new TreeSet<String>();
        try {
            for (Reader r : this.getReaders()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(r);
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && !line.trim().isEmpty()) {
                            result.add(line);
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading compiler hints", ex);
        }
        return result;
    }

    public static List<String> getCompileCommandFiles(List<String> command) {
        ArrayList<String> compileCommandFiles = new ArrayList<String>();
        for (String cmdLineWord : command) {
            if (!cmdLineWord.startsWith(XX_COMPILE_COMMAND_FILE)) continue;
            compileCommandFiles.add(cmdLineWord.substring(XX_COMPILE_COMMAND_FILE.length()));
        }
        return compileCommandFiles;
    }

    public static void addCompilerHints(List<String> command, String path) {
        File hotspotCompilerFile;
        if (!ExCompilerHints.isHintCompatibleVM()) {
            System.err.println("WARNING: Not a HotSpot compiler command compatible VM (\"" + System.getProperty("java.vm.name") + "-" + System.getProperty("java.version") + "\"), compilerHints are disabled.");
            return;
        }
        ArrayList<String> hintFiles = new ArrayList<String>();
        hintFiles.add(ExCompilerHints.hintsFile(path));
        ExCompilerHints.removeCompileCommandFiles(command, hintFiles);
        if (hintFiles.size() == 1 && (hotspotCompilerFile = new File(".hotspot_compiler")).exists()) {
            hintFiles.add(hotspotCompilerFile.getAbsolutePath());
        }
        command.add(XX_COMPILE_COMMAND_FILE + ExCompilerHints.mergeHintFiles(hintFiles));
    }

    private static void removeCompileCommandFiles(List<String> command, List<String> compileCommandFiles) {
        Iterator<String> iterator = command.iterator();
        while (iterator.hasNext()) {
            String cmdLineWord = iterator.next();
            if (!cmdLineWord.startsWith(XX_COMPILE_COMMAND_FILE)) continue;
            compileCommandFiles.add(cmdLineWord.substring(XX_COMPILE_COMMAND_FILE.length()));
            iterator.remove();
        }
    }

    private static String mergeHintFiles(List<String> compileCommandFiles) {
        if (compileCommandFiles.size() == 1) {
            return compileCommandFiles.get(0);
        }
        try {
            TreeSet<String> hints = new TreeSet<String>();
            for (String file : compileCommandFiles) {
                hints.addAll(ExCompilerHints.fromFile(file).get());
            }
            return FileUtils.createTempFileWithLines((String)"compilecommand", hints);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error merging compiler hints files", e);
        }
    }
}

