/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.ActionType;
import org.openjdk.jmh.runner.BaseRunner;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.ExBenchmarkList;
import org.openjdk.jmh.runner.ExCompilerHints;
import org.openjdk.jmh.runner.ForkedMain;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.NoBenchmarksException;
import org.openjdk.jmh.runner.OutputFormatAdapter;
import org.openjdk.jmh.runner.PrintPropertiesMain;
import org.openjdk.jmh.runner.ProfilersFailedException;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.WorkloadParams;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.format.OutputFormatFactory;
import org.openjdk.jmh.runner.link.BinaryLinkServer;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.ProfilerConfig;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.TempFile;
import org.openjdk.jmh.util.TreeMultimap;
import org.openjdk.jmh.util.UnCloseablePrintStream;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.util.Version;

public class ExtendedRunner
extends BaseRunner {
    private static final int TAIL_LINES_ON_ERROR = Integer.getInteger("jmh.tailLines", 20);
    private static final String JMH_LOCK_FILE = String.valueOf(System.getProperty("java.io.tmpdir")) + "/jmh.lock";
    private static final Boolean JMH_LOCK_IGNORE = Boolean.getBoolean("jmh.ignoreLock");
    private final ExBenchmarkList list;
    private int cpuCount;
    private String hintFilePath;
    private Set<String> classPaths = new HashSet<String>();

    public void setClassPaths(Set<String> classPaths) {
        this.classPaths = classPaths;
    }

    public ExtendedRunner(Options options, OutputFormat format, ExBenchmarkList list, String path) {
        super(options, format);
        this.list = list;
        this.hintFilePath = path;
    }

    public ExtendedRunner(Options options, ExBenchmarkList list, String path) {
        super(options, ExtendedRunner.createOutputFormat(options));
        this.list = list;
        this.hintFilePath = path;
    }

    public ExtendedRunner(Options options) {
        this(options, ExtendedRunner.createOutputFormat(options), ExBenchmarkList.defaultList(), null);
    }

    private static OutputFormat createOutputFormat(Options options) {
        Object out;
        if (options == null) {
            throw new IllegalArgumentException("Options not allowed to be null.");
        }
        if (options.getOutput().hasValue()) {
            try {
                out = new PrintStream((String)options.getOutput().get());
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            out = new UnCloseablePrintStream((OutputStream)System.out, Utils.guessConsoleEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return OutputFormatFactory.createFormatInstance((PrintStream)out, (VerboseMode)((VerboseMode)options.verbosity().orElse((Object)Defaults.VERBOSITY)));
    }

    public void list() {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        this.out.println("Benchmarks: ");
        for (BenchmarkListEntry benchmark : benchmarks) {
            this.out.println(benchmark.getUsername());
        }
    }

    public void listWithParams(CommandLineOptions options) {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, options.getIncludes(), options.getExcludes());
        this.out.println("Benchmarks: ");
        for (BenchmarkListEntry benchmark : benchmarks) {
            this.out.println(benchmark.getUsername());
            Optional params = benchmark.getParams();
            if (!params.hasValue()) continue;
            for (Map.Entry e : ((Map)params.get()).entrySet()) {
                String param = (String)e.getKey();
                Collection values = (Collection)options.getParameter(param).orElse(Arrays.asList((String[])e.getValue()));
                this.out.println("  param \"" + param + "\" = {" + Utils.join((Collection)values, (String)", ") + "}");
            }
        }
    }

    public RunResult runSingle() throws RunnerException {
        SortedSet<BenchmarkListEntry> benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes());
        if (benchmarks.size() == 1) {
            Collection<RunResult> values = this.run();
            if (values.size() == 1) {
                return values.iterator().next();
            }
            throw new RunnerException("No results returned");
        }
        if (benchmarks.size() > 1) {
            throw new RunnerException("More than single benchmark are matching the options: " + benchmarks);
        }
        throw new NoBenchmarksException();
    }

    /*
     * Loose catch block
     */
    public Collection<RunResult> run() throws RunnerException {
        FileChannel channel = null;
        FileLock lock = null;
        File file = new File(JMH_LOCK_FILE);
        file.createNewFile();
        file.setWritable(true, false);
        channel = new RandomAccessFile(file, "rw").getChannel();
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            // empty catch block
        }
        if (lock == null) {
            String msg = "Unable to acquire the JMH lock (" + JMH_LOCK_FILE + "): already taken by another JMH instance";
            if (JMH_LOCK_IGNORE.booleanValue()) {
                this.out.println("# WARNING: " + msg + ", ignored by user's request.");
            } else {
                throw new RunnerException("ERROR: " + msg + ", exiting. Use -Djmh.ignoreLock=true to forcefully continue.");
            }
        }
        Collection<RunResult> collection = this.internalRun();
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.safelyClose((Closeable)channel);
        return collection;
        catch (IOException e) {
            String msg;
            block19: {
                Collection<RunResult> collection2;
                try {
                    msg = "Exception while trying to acquire the JMH lock (" + JMH_LOCK_FILE + "): " + e.getMessage();
                    if (!JMH_LOCK_IGNORE.booleanValue()) break block19;
                    this.out.println("# WARNING: " + msg + ", ignored by user's request.");
                    collection2 = this.internalRun();
                }
                catch (Throwable throwable) {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileUtils.safelyClose(channel);
                    throw throwable;
                }
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileUtils.safelyClose((Closeable)channel);
                return collection2;
            }
            throw new RunnerException("ERROR: " + msg + ", exiting. Use -Djmh.ignoreLock=true to forcefully continue.");
        }
    }

    private Collection<RunResult> internalRun() throws RunnerException {
        ArrayList<BenchmarkListEntry> newBenchmarks;
        SortedSet<BenchmarkListEntry> benchmarks;
        HashSet<String> profilerClasses = new HashSet<String>();
        boolean someProfilersFail = false;
        for (ProfilerConfig p : this.options.getProfilers()) {
            if (!profilerClasses.add(p.getKlass())) {
                throw new RunnerException("Cannot instantiate the same profiler more than once: " + p.getKlass());
            }
            try {
                ProfilerFactory.getProfilerOrException((ProfilerConfig)p);
            }
            catch (ProfilerException e) {
                this.out.println(e.getMessage());
                someProfilersFail = true;
            }
            if (!someProfilersFail) continue;
            throw new ProfilersFailedException();
        }
        String resultFile = null;
        if (this.options.getResult().hasValue() || this.options.getResultFormat().hasValue()) {
            resultFile = (String)this.options.getResult().orElse((Object)("jmh-result." + ((ResultFormatType)this.options.getResultFormat().orElse((Object)Defaults.RESULT_FORMAT)).toString().toLowerCase()));
            try {
                FileUtils.touch((String)resultFile);
            }
            catch (IOException e) {
                throw new RunnerException("Can not touch the result file: " + resultFile);
            }
        }
        if ((benchmarks = this.list.find(this.out, this.options.getIncludes(), this.options.getExcludes())).isEmpty()) {
            this.out.flush();
            this.out.close();
            throw new NoBenchmarksException();
        }
        if (!this.options.getBenchModes().isEmpty()) {
            newBenchmarks = new ArrayList<BenchmarkListEntry>();
            for (BenchmarkListEntry br : benchmarks) {
                for (Mode m : this.options.getBenchModes()) {
                    newBenchmarks.add(br.cloneWith(m));
                }
            }
            benchmarks.clear();
            benchmarks.addAll(newBenchmarks);
        }
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getMode() == Mode.All) {
                Mode[] modeArray = Mode.values();
                int n = modeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Mode mode = modeArray[n2];
                    if (mode != Mode.All) {
                        newBenchmarks.add(br.cloneWith(mode));
                    }
                    ++n2;
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        newBenchmarks = new ArrayList();
        for (BenchmarkListEntry br : benchmarks) {
            if (br.getParams().hasValue()) {
                for (WorkloadParams p : this.explodeAllParams(br)) {
                    newBenchmarks.add(br.cloneWith(p));
                }
                continue;
            }
            newBenchmarks.add(br);
        }
        benchmarks.clear();
        benchmarks.addAll(newBenchmarks);
        Collection<RunResult> results = this.runBenchmarks(benchmarks);
        if (resultFile != null) {
            ResultFormatFactory.getInstance((ResultFormatType)((ResultFormatType)this.options.getResultFormat().orElse((Object)Defaults.RESULT_FORMAT)), (String)resultFile).writeOut(results);
            this.out.println("");
            this.out.println("Benchmark result is saved to " + resultFile);
        }
        this.out.flush();
        this.out.close();
        return results;
    }

    private List<ActionPlan> getActionPlans(Set<BenchmarkListEntry> benchmarks) {
        ActionPlan base = new ActionPlan(ActionType.FORKED);
        LinkedHashSet<BenchmarkListEntry> warmupBenches = new LinkedHashSet<BenchmarkListEntry>();
        List warmupMicrosRegexp = this.options.getWarmupIncludes();
        if (warmupMicrosRegexp != null && !warmupMicrosRegexp.isEmpty()) {
            warmupBenches.addAll(this.list.find(this.out, warmupMicrosRegexp, Collections.emptyList()));
        }
        if (((WarmupMode)this.options.getWarmupMode().orElse((Object)Defaults.WARMUP_MODE)).isBulk()) {
            warmupBenches.addAll(benchmarks);
        }
        for (BenchmarkListEntry wr : warmupBenches) {
            base.add(this.newAction(wr, ActionMode.WARMUP));
        }
        ActionPlan embeddedPlan = new ActionPlan(ActionType.EMBEDDED);
        embeddedPlan.mixIn(base);
        boolean addEmbedded = false;
        ArrayList<ActionPlan> result = new ArrayList<ActionPlan>();
        for (BenchmarkListEntry br : benchmarks) {
            BenchmarkParams params = this.newBenchmarkParams(br, ActionMode.UNDEF);
            if (params.getForks() <= 0) {
                if (((WarmupMode)this.options.getWarmupMode().orElse((Object)Defaults.WARMUP_MODE)).isIndi()) {
                    embeddedPlan.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
                } else {
                    embeddedPlan.add(this.newAction(br, ActionMode.MEASUREMENT));
                }
                addEmbedded = true;
            }
            if (params.getForks() <= 0) continue;
            ActionPlan r = new ActionPlan(ActionType.FORKED);
            r.mixIn(base);
            if (((WarmupMode)this.options.getWarmupMode().orElse((Object)Defaults.WARMUP_MODE)).isIndi()) {
                r.add(this.newAction(br, ActionMode.WARMUP_MEASUREMENT));
            } else {
                r.add(this.newAction(br, ActionMode.MEASUREMENT));
            }
            result.add(r);
        }
        if (addEmbedded) {
            result.add(embeddedPlan);
        }
        return result;
    }

    private Action newAction(BenchmarkListEntry br, ActionMode mode) {
        return new Action(this.newBenchmarkParams(br, mode), mode);
    }

    private BenchmarkParams newBenchmarkParams(BenchmarkListEntry benchmark, ActionMode mode) {
        IterationParams measurement;
        boolean synchIterations;
        int[] threadGroups = (int[])this.options.getThreadGroups().orElse((Object)benchmark.getThreadGroups());
        int threads = (Integer)this.options.getThreads().orElse((Object)((Integer)benchmark.getThreads().orElse((Object)1)));
        if (threads == -1) {
            if (this.cpuCount == 0) {
                this.out.print("# Detecting actual CPU count: ");
                this.cpuCount = Utils.figureOutHotCPUs();
                this.out.println(String.valueOf(this.cpuCount) + " detected");
            }
            threads = this.cpuCount;
        }
        threads = Utils.roundUp((int)threads, (int)Utils.sum((int[])threadGroups));
        boolean bl = synchIterations = benchmark.getMode() != Mode.SingleShotTime && (Boolean)this.options.shouldSyncIterations().orElse((Object)true) != false;
        IterationParams iterationParams = mode.doMeasurement() ? new IterationParams(IterationType.MEASUREMENT, ((Integer)this.options.getMeasurementIterations().orElse((Object)((Integer)benchmark.getMeasurementIterations().orElse((Object)(benchmark.getMode() == Mode.SingleShotTime ? 1 : 5))))).intValue(), (TimeValue)this.options.getMeasurementTime().orElse((Object)((TimeValue)benchmark.getMeasurementTime().orElse((Object)(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.MEASUREMENT_TIME)))), ((Integer)this.options.getMeasurementBatchSize().orElse((Object)((Integer)benchmark.getMeasurementBatchSize().orElse((Object)1)))).intValue()) : (measurement = new IterationParams(IterationType.MEASUREMENT, 0, TimeValue.NONE, 1));
        IterationParams warmup = mode.doWarmup() ? new IterationParams(IterationType.WARMUP, ((Integer)this.options.getWarmupIterations().orElse((Object)((Integer)benchmark.getWarmupIterations().orElse((Object)(benchmark.getMode() == Mode.SingleShotTime ? 0 : 5))))).intValue(), (TimeValue)this.options.getWarmupTime().orElse((Object)((TimeValue)benchmark.getWarmupTime().orElse((Object)(benchmark.getMode() == Mode.SingleShotTime ? TimeValue.NONE : Defaults.WARMUP_TIME)))), ((Integer)this.options.getWarmupBatchSize().orElse((Object)((Integer)benchmark.getWarmupBatchSize().orElse((Object)1)))).intValue()) : new IterationParams(IterationType.WARMUP, 0, TimeValue.NONE, 1);
        int forks = (Integer)this.options.getForkCount().orElse((Object)((Integer)benchmark.getForks().orElse((Object)5)));
        int warmupForks = (Integer)this.options.getWarmupForkCount().orElse((Object)((Integer)benchmark.getWarmupForks().orElse((Object)0)));
        TimeUnit timeUnit = (TimeUnit)((Object)this.options.getTimeUnit().orElse((Object)((TimeUnit)((Object)benchmark.getTimeUnit().orElse((Object)Defaults.OUTPUT_TIMEUNIT)))));
        int opsPerInvocation = (Integer)this.options.getOperationsPerInvocation().orElse((Object)((Integer)benchmark.getOperationsPerInvocation().orElse((Object)Defaults.OPS_PER_INVOCATION)));
        String jvm = (String)this.options.getJvm().orElse((Object)((String)benchmark.getJvm().orElse((Object)Utils.getCurrentJvm())));
        Properties targetProperties = jvm.equals(Utils.getCurrentJvm()) ? Utils.getRecordedSystemProperties() : Utils.readPropertiesFromCommand(this.getPrintPropertiesCommand(jvm));
        ArrayList jvmArgs = new ArrayList();
        jvmArgs.addAll((Collection)this.options.getJvmArgsPrepend().orElse((Object)((Collection)benchmark.getJvmArgsPrepend().orElse(Collections.emptyList()))));
        jvmArgs.addAll((Collection)this.options.getJvmArgs().orElse((Object)((Collection)benchmark.getJvmArgs().orElse(ManagementFactory.getRuntimeMXBean().getInputArguments()))));
        jvmArgs.addAll((Collection)this.options.getJvmArgsAppend().orElse((Object)((Collection)benchmark.getJvmArgsAppend().orElse(Collections.emptyList()))));
        TimeValue timeout = (TimeValue)this.options.getTimeout().orElse((Object)((TimeValue)benchmark.getTimeout().orElse((Object)Defaults.TIMEOUT)));
        String jdkVersion = targetProperties.getProperty("java.version");
        String vmVersion = targetProperties.getProperty("java.vm.version");
        String vmName = targetProperties.getProperty("java.vm.name");
        return new BenchmarkParams(benchmark.getUsername(), benchmark.generatedTarget(), synchIterations, threads, threadGroups, (Collection)benchmark.getThreadGroupLabels().orElse(Collections.emptyList()), forks, warmupForks, warmup, measurement, benchmark.getMode(), benchmark.getWorkloadParams(), timeUnit, opsPerInvocation, jvm, jvmArgs, jdkVersion, vmName, vmVersion, Version.getPlainVersion(), timeout);
    }

    private List<WorkloadParams> explodeAllParams(BenchmarkListEntry br) throws RunnerException {
        Map benchParams = (Map)br.getParams().orElse(Collections.emptyMap());
        ArrayList<Object> ps = new ArrayList<WorkloadParams>();
        for (Map.Entry e : benchParams.entrySet()) {
            String k = (String)e.getKey();
            String[] vals = (String[])e.getValue();
            Collection values = (Collection)this.options.getParameter(k).orElse(Arrays.asList(vals));
            if (values.isEmpty()) {
                throw new RunnerException("Benchmark \"" + br.getUsername() + "\" defines the parameter \"" + k + "\", but no default values.\n" + "Define the default values within the annotation, or provide the parameter values at runtime.");
            }
            if (ps.isEmpty()) {
                int idx = 0;
                for (String string : values) {
                    WorkloadParams al = new WorkloadParams();
                    al.put(k, string, idx);
                    ps.add(al);
                    ++idx;
                }
                continue;
            }
            ArrayList<WorkloadParams> newPs = new ArrayList<WorkloadParams>();
            for (WorkloadParams workloadParams : ps) {
                int idx = 0;
                for (String v : values) {
                    WorkloadParams al = workloadParams.copy();
                    al.put(k, v, idx);
                    newPs.add(al);
                    ++idx;
                }
            }
            ps = newPs;
        }
        return ps;
    }

    private Collection<RunResult> runBenchmarks(SortedSet<BenchmarkListEntry> benchmarks) throws RunnerException {
        this.out.startRun();
        TreeMultimap results = new TreeMultimap();
        List<ActionPlan> plan = this.getActionPlans(benchmarks);
        this.etaBeforeBenchmarks(plan);
        try {
            for (ActionPlan r : plan) {
                Multimap<BenchmarkParams, BenchmarkResult> res;
                switch (r.getType()) {
                    case EMBEDDED: {
                        res = this.runBenchmarksEmbedded(r);
                        break;
                    }
                    case FORKED: {
                        res = this.runSeparate(r);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown action plan type: " + r.getType());
                    }
                }
                for (BenchmarkParams br : res.keys()) {
                    results.putAll((Object)br, res.get((Object)br));
                }
            }
            this.etaAfterBenchmarks();
            SortedSet<RunResult> runResults = this.mergeRunResults((Multimap<BenchmarkParams, BenchmarkResult>)results);
            this.out.endRun(runResults);
            return runResults;
        }
        catch (BenchmarkException be) {
            throw new RunnerException("Benchmark caught the exception", (Throwable)be);
        }
    }

    private SortedSet<RunResult> mergeRunResults(Multimap<BenchmarkParams, BenchmarkResult> results) {
        TreeSet<RunResult> result = new TreeSet<RunResult>(RunResult.DEFAULT_SORT_COMPARATOR);
        for (BenchmarkParams key : results.keys()) {
            result.add(new RunResult(key, results.get((Object)key)));
        }
        return result;
    }

    private Multimap<BenchmarkParams, BenchmarkResult> runSeparate(ActionPlan actionPlan) {
        HashMultimap results = new HashMultimap();
        if (actionPlan.getMeasurementActions().size() != 1) {
            throw new IllegalStateException("Expect only single benchmark in the action plan, but was " + actionPlan.getMeasurementActions().size());
        }
        BinaryLinkServer server = null;
        try {
            try {
                server = new BinaryLinkServer(this.options, this.out);
                server.setPlan(actionPlan);
                BenchmarkParams params = ((Action)actionPlan.getMeasurementActions().get(0)).getParams();
                List profilers = ProfilerFactory.getSupportedExternal((Collection)this.options.getProfilers());
                boolean printOut = true;
                boolean printErr = true;
                for (ExternalProfiler prof : profilers) {
                    printOut &= prof.allowPrintOut();
                    printErr &= prof.allowPrintErr();
                }
                ArrayList profilersRev = new ArrayList(profilers);
                Collections.reverse(profilersRev);
                boolean forcePrint = ((VerboseMode)this.options.verbosity().orElse((Object)Defaults.VERBOSITY)).equalsOrHigherThan(VerboseMode.EXTRA);
                printOut = forcePrint || printOut;
                printErr = forcePrint || printErr;
                this.out.startBenchmark(params);
                this.out.println("");
                int forkCount = params.getForks();
                int warmupForkCount = params.getWarmupForks();
                int totalForks = warmupForkCount + forkCount;
                int i = 0;
                while (i < totalForks) {
                    boolean warmupFork = i < warmupForkCount;
                    List<String> forkedString = this.getForkedMainCommand(params, profilers, server.getHost(), server.getPort());
                    this.etaBeforeBenchmark();
                    if (warmupFork) {
                        this.out.verbosePrintln("Warmup forking using command: " + forkedString);
                        this.out.println("# Warmup Fork: " + (i + 1) + " of " + warmupForkCount);
                    } else {
                        this.out.verbosePrintln("Forking using command: " + forkedString);
                        this.out.println("# Fork: " + (i + 1 - warmupForkCount) + " of " + forkCount);
                    }
                    TempFile stdErr = FileUtils.weakTempFile((String)"stderr");
                    TempFile stdOut = FileUtils.weakTempFile((String)"stdout");
                    if (!profilers.isEmpty()) {
                        this.out.print("# Preparing profilers: ");
                        for (ExternalProfiler profiler : profilers) {
                            this.out.print(String.valueOf(profiler.getClass().getSimpleName()) + " ");
                            profiler.beforeTrial(params);
                        }
                        this.out.println("");
                        ArrayList<String> consumed = new ArrayList<String>();
                        if (!printOut) {
                            consumed.add("stdout");
                        }
                        if (!printErr) {
                            consumed.add("stderr");
                        }
                        if (!consumed.isEmpty()) {
                            this.out.println("# Profilers consume " + Utils.join(consumed, (String)" and ") + " from target VM, use -v " + VerboseMode.EXTRA + " to copy to console");
                        }
                    }
                    long startTime = System.currentTimeMillis();
                    List<IterationResult> result = this.doFork(server, forkedString, stdOut.file(), stdErr.file(), printOut, printErr);
                    if (!result.isEmpty()) {
                        long pid = server.getClientPid();
                        BenchmarkResultMetaData md = server.getMetadata();
                        if (md != null) {
                            md.adjustStart(startTime);
                        }
                        BenchmarkResult br = new BenchmarkResult(params, result, md);
                        if (!profilersRev.isEmpty()) {
                            this.out.print("# Processing profiler results: ");
                            for (ExternalProfiler profiler : profilersRev) {
                                this.out.print(String.valueOf(profiler.getClass().getSimpleName()) + " ");
                                for (Result profR : profiler.afterTrial(br, pid, stdOut.file(), stdErr.file())) {
                                    br.addBenchmarkResult(profR);
                                }
                            }
                            this.out.println("");
                        }
                        if (!warmupFork) {
                            results.put((Object)params, (Object)br);
                        }
                    }
                    this.etaAfterBenchmark(params);
                    this.out.println("");
                    stdOut.delete();
                    stdErr.delete();
                    ++i;
                }
                this.out.endBenchmark(new RunResult(params, results.get((Object)params)).getAggregatedResult());
            }
            catch (IOException e) {
                results.clear();
                throw new BenchmarkException((Throwable)e);
            }
            catch (BenchmarkException e) {
                results.clear();
                if (((Boolean)this.options.shouldFailOnError().orElse((Object)false)).booleanValue()) {
                    this.out.println("Benchmark had encountered error, and fail on error was requested");
                    throw e;
                }
                if (server != null) {
                    server.terminate();
                }
                FileUtils.purgeTemps();
            }
        }
        finally {
            if (server != null) {
                server.terminate();
            }
            FileUtils.purgeTemps();
        }
        return results;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<IterationResult> doFork(BinaryLinkServer reader, List<String> commandString, File stdOut, File stdErr, boolean printOut, boolean printErr) {
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try {
                int ecode;
                FileOutputStream fosOut;
                FileOutputStream fosErr;
                block21: {
                    List list;
                    block22: {
                        BenchmarkException exception;
                        fosErr = new FileOutputStream(stdErr);
                        fosOut = new FileOutputStream(stdOut);
                        ProcessBuilder pb = new ProcessBuilder(commandString);
                        Process p = pb.start();
                        InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), (OutputStream)fosErr);
                        InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), (OutputStream)fosOut);
                        if (printErr) {
                            errDrainer.addOutputStream((OutputStream)new OutputFormatAdapter(this.out));
                        }
                        if (printOut) {
                            outDrainer.addOutputStream((OutputStream)new OutputFormatAdapter(this.out));
                        }
                        errDrainer.start();
                        outDrainer.start();
                        ecode = p.waitFor();
                        errDrainer.join();
                        outDrainer.join();
                        reader.waitFinish();
                        if (ecode != 0) {
                            this.out.println("<forked VM failed with exit code " + ecode + ">");
                            this.out.println("<stdout last='" + TAIL_LINES_ON_ERROR + " lines'>");
                            for (String l : FileUtils.tail((File)stdOut, (int)TAIL_LINES_ON_ERROR)) {
                                this.out.println(l);
                            }
                            this.out.println("</stdout>");
                            this.out.println("<stderr last='" + TAIL_LINES_ON_ERROR + " lines'>");
                            for (String l : FileUtils.tail((File)stdErr, (int)TAIL_LINES_ON_ERROR)) {
                                this.out.println(l);
                            }
                            this.out.println("</stderr>");
                            this.out.println("");
                        }
                        if ((exception = reader.getException()) != null) throw exception;
                        if (ecode != 0) break block21;
                        list = reader.getResults();
                        if (fosOut == null) break block22;
                        fosOut.close();
                    }
                    if (fosErr == null) return list;
                    fosErr.close();
                    return list;
                }
                try {
                    throw new BenchmarkException((Throwable)new IllegalStateException("Forked VM failed with exit code " + ecode));
                    {
                        catch (Throwable throwable2) {
                            if (fosOut == null) throw throwable2;
                            fosOut.close();
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fosErr == null) throw throwable;
                    fosErr.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.out.println("<failed to invoke the VM, caught IOException: " + ex.getMessage() + ">");
            this.out.println("");
            throw new BenchmarkException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            this.out.println("<host VM has been interrupted waiting for forked VM: " + ex.getMessage() + ">");
            this.out.println("");
            throw new BenchmarkException((Throwable)ex);
        }
    }

    List<String> getForkedMainCommand(BenchmarkParams benchmark, List<ExternalProfiler> profilers, String host, int port) {
        ArrayList javaInvokeOptions = new ArrayList();
        ArrayList javaOptions = new ArrayList();
        for (ExternalProfiler prof : profilers) {
            javaInvokeOptions.addAll(prof.addJVMInvokeOptions(benchmark));
            javaOptions.addAll(prof.addJVMOptions(benchmark));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(javaInvokeOptions);
        command.add(benchmark.getJvm());
        command.addAll(benchmark.getJvmArgs());
        command.addAll(javaOptions);
        ExCompilerHints.addCompilerHints(command, this.hintFilePath);
        this.addClasspath(command);
        command.add(ForkedMain.class.getName());
        command.add(host);
        command.add(String.valueOf(port));
        return command;
    }

    private List<String> getPrintPropertiesCommand(String jvm) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        this.addClasspath(command);
        command.add(PrintPropertiesMain.class.getName());
        return command;
    }

    private void addClasspath(List<String> command) {
        command.add("-cp");
        String cpProp = System.getProperty("java.class.path");
        File tmpFile = null;
        String jvmargs = "" + this.options.getJvmArgs().orElse(Collections.emptyList()) + this.options.getJvmArgsPrepend().orElse(Collections.emptyList()) + this.options.getJvmArgsAppend().orElse(Collections.emptyList());
        if (Boolean.getBoolean("jmh.separateClasspathJAR") || jvmargs.contains("jmh.separateClasspathJAR=true")) {
            try {
                tmpFile = FileUtils.tempFile((String)"classpath.jar");
                Path tmpFileDir = tmpFile.toPath().getParent();
                StringBuilder sb = new StringBuilder();
                Object object = cpProp.split(File.pathSeparator);
                int n = ((String[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    String cp = object[n2];
                    String rel = tmpFileDir.relativize(new File(cp).getAbsoluteFile().toPath()).toString();
                    sb.append(rel.replace('\\', '/').replace(" ", "%20"));
                    if (!cp.endsWith(".jar")) {
                        sb.append('/');
                    }
                    sb.append(" ");
                    ++n2;
                }
                String classPath = sb.toString().trim();
                Manifest manifest = new Manifest();
                Attributes attrs = manifest.getMainAttributes();
                attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                attrs.putValue("Class-Path", classPath);
                object = null;
                Object var11_15 = null;
                try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(tmpFile), manifest);){
                    jos.putNextEntry(new ZipEntry("META-INF/"));
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (IOException ex) {
                tmpFile = null;
            }
        }
        StringBuilder sbuilder = new StringBuilder();
        if (this.classPaths != null) {
            for (String classPath : this.classPaths) {
                if (Utils.isWindows()) {
                    sbuilder.append(";").append(classPath);
                    continue;
                }
                sbuilder.append(":").append(classPath);
            }
        }
        if (tmpFile != null) {
            if (Utils.isWindows()) {
                command.add("\"" + tmpFile.getAbsolutePath() + sbuilder.toString() + "\"");
            } else {
                command.add(String.valueOf(tmpFile.getAbsolutePath()) + sbuilder.toString());
            }
        } else if (Utils.isWindows()) {
            command.add(String.valueOf('\"') + cpProp + sbuilder.toString() + '\"');
        } else {
            command.add(String.valueOf(cpProp) + sbuilder.toString());
        }
    }
}

