/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobstat.util;

import android.text.TextUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public class OkHttpRequestManager {

    public class GzipRequestInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (request.body() == null) {
                Request request2 = request.newBuilder().header("Content-Encoding", "gzip").build();
                return chain.proceed(request2);
            }
            if (request.header("Content-Encoding") != null) {
                return chain.proceed(request);
            }
            Request request3 = request.newBuilder().header("Content-Encoding", "gzip").method(request.method(), this.forceContentLength(this.gzip(request.body(), request.url().toString()))).build();
            return chain.proceed(request3);
        }

        private RequestBody forceContentLength(final RequestBody requestBody) throws IOException {
            final Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return new RequestBody(){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return buffer.size();
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    bufferedSink.write(buffer.snapshot());
                }
            };
        }

        private RequestBody gzip(final RequestBody requestBody, final String string) {
            return new RequestBody(){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return -1L;
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    BufferedSink bufferedSink2 = Okio.buffer((Sink)new GzipSink((Sink)bufferedSink));
                    if (!TextUtils.isEmpty((CharSequence)string) && string.contains("bplus.gif")) {
                        bufferedSink2.write(new byte[]{72, 77, 48, 49});
                        bufferedSink2.write(new byte[]{0, 0, 0, 1});
                        bufferedSink2.write(new byte[]{0, 0, 3, -14});
                        bufferedSink2.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                        bufferedSink2.write(new byte[]{0, 2});
                        bufferedSink2.write(new byte[]{0, 0});
                        bufferedSink2.write(new byte[]{72, 77, 48, 49});
                    }
                    requestBody.writeTo(bufferedSink2);
                    bufferedSink2.close();
                }
            };
        }
    }
}

