/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.logging;

import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import com.baidu.android.common.logging.SimpleFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Log {
    private static boolean sLogEnabled = true;
    private static boolean sLog2File = false;
    private static Logger sFilelogger;
    public static final int FILE_LIMETE = 0xA00000;
    public static final int FILE_NUMBER = 2;

    private Log() {
    }

    public static void v(String string, String string2) {
        if (sLogEnabled) {
            if (sLog2File && sFilelogger != null) {
                sFilelogger.log(Level.INFO, string + ": " + string2);
            } else {
                android.util.Log.v((String)string, (String)string2);
            }
        }
    }

    public static void v(String string, String string2, Throwable throwable) {
        Log.v(string, string2 + '\n' + Log.getStackTraceString(throwable));
    }

    public static void i(String string, String string2) {
        if (sLogEnabled) {
            if (sLog2File && sFilelogger != null) {
                sFilelogger.log(Level.INFO, string + ": " + string2);
            } else {
                android.util.Log.i((String)string, (String)string2);
            }
        }
    }

    public static void i(String string, String string2, Throwable throwable) {
        Log.i(string, string2 + '\n' + Log.getStackTraceString(throwable));
    }

    public static void d(String string, String string2) {
        if (sLogEnabled) {
            if (sLog2File && sFilelogger != null) {
                sFilelogger.log(Level.INFO, string + ": " + string2);
            } else {
                android.util.Log.d((String)string, (String)string2);
            }
        }
    }

    public static void d(String string, String string2, Throwable throwable) {
        Log.d(string, string2 + '\n' + Log.getStackTraceString(throwable));
    }

    public static void w(String string, String string2) {
        if (sLogEnabled) {
            if (sLog2File && sFilelogger != null) {
                sFilelogger.log(Level.WARNING, string + ": " + string2);
            } else {
                android.util.Log.w((String)string, (String)string2);
            }
        }
    }

    public static void w(String string, String string2, Throwable throwable) {
        Log.w(string, string2 + '\n' + Log.getStackTraceString(throwable));
    }

    public static void e(String string, String string2) {
        if (sLogEnabled) {
            if (sLog2File && sFilelogger != null) {
                sFilelogger.log(Level.SEVERE, string + ": " + string2);
            } else {
                android.util.Log.e((String)string, (String)string2);
            }
        }
    }

    public static void e(String string, Throwable throwable) {
        String string2 = Log.getStackTraceString(throwable);
        Log.e(string, string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        string2 = string2 + '\n' + Log.getStackTraceString(throwable);
        Log.e(string, string2);
    }

    public static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static String getLogFileName() {
        int n2 = Process.myPid();
        String string = Log.getProcessNameForPid(n2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "BaiduFileLog";
        }
        string = string.replace(':', '_');
        return string;
    }

    private static String getProcessNameForPid(int n2) {
        String string = "/proc/" + n2 + "/cmdline";
        String string2 = "/proc/" + n2 + "/status";
        String string3 = "";
        try {
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = null;
            string4 = bufferedReader.readLine();
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                int n3 = string4.indexOf(0);
                string3 = string4.substring(0, n3);
            } else {
                file = new File(string2);
                bufferedReader = new BufferedReader(new FileReader(file));
                string4 = bufferedReader.readLine();
                while (string4 != null) {
                    if (string4.startsWith("Name:")) {
                        int n4 = string4.indexOf("\t");
                        if (n4 < 0) break;
                        string3 = string4.substring(n4 + 1);
                        break;
                    }
                    string4 = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static void setLogEnabled(boolean bl2) {
        sLogEnabled = bl2;
    }

    public static void setLog2File(boolean bl2) {
        sLog2File = bl2;
        if (sLog2File && sFilelogger == null) {
            String string = Log.getLogFileName();
            String string2 = new File(Environment.getExternalStorageDirectory(), string).getAbsolutePath();
            try {
                FileHandler fileHandler = new FileHandler(string2 + "_%g.log", 0xA00000, 2, true);
                fileHandler.setFormatter(new SimpleFormatter());
                sFilelogger = Logger.getLogger(string);
                sFilelogger.setLevel(Level.ALL);
                sFilelogger.addHandler(fileHandler);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

