/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;

public class ConnectManager {
    private static final String TAG = ConnectManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private String mApn;
    private String mProxy;
    private String mPort;
    private boolean mUseWap;
    private String mNetType;
    private int mSubType;
    private String mSubTypeName;

    public ConnectManager(Context context) {
        this.checkNetworkType(context);
    }

    private void checkApn(Context context, NetworkInfo networkInfo) {
        String string;
        if (networkInfo.getExtraInfo() != null && (string = networkInfo.getExtraInfo().toLowerCase()) != null) {
            if (string.startsWith("cmwap") || string.startsWith("uniwap") || string.startsWith("3gwap")) {
                this.mUseWap = true;
                this.mApn = string;
                this.mProxy = "10.0.0.172";
                this.mPort = "80";
                return;
            }
            if (string.startsWith("ctwap")) {
                this.mUseWap = true;
                this.mApn = string;
                this.mProxy = "10.0.0.200";
                this.mPort = "80";
                return;
            }
            if (string.startsWith("cmnet") || string.startsWith("uninet") || string.startsWith("ctnet") || string.startsWith("3gnet")) {
                this.mUseWap = false;
                this.mApn = string;
                return;
            }
        }
        string = Proxy.getDefaultHost();
        int n2 = Proxy.getDefaultPort();
        if (string != null && string.length() > 0) {
            this.mProxy = string;
            if ("10.0.0.172".equals(this.mProxy.trim())) {
                this.mUseWap = true;
                this.mPort = "80";
            } else if ("10.0.0.200".equals(this.mProxy.trim())) {
                this.mUseWap = true;
                this.mPort = "80";
            } else {
                this.mUseWap = false;
                this.mPort = Integer.toString(n2);
            }
        } else {
            this.mUseWap = false;
        }
    }

    private void checkNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (networkInfo != null) {
            if ("wifi".equals(networkInfo.getTypeName().toLowerCase())) {
                this.mNetType = "wifi";
                this.mUseWap = false;
            } else {
                this.checkApn(context, networkInfo);
                this.mNetType = this.mApn;
            }
            this.mSubType = networkInfo.getSubtype();
            this.mSubTypeName = networkInfo.getSubtypeName();
        }
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.isConnectedOrConnecting();
        }
        return false;
    }

    public boolean isWapNetwork() {
        return this.mUseWap;
    }

    public String getApn() {
        return this.mApn;
    }

    public String getProxy() {
        return this.mProxy;
    }

    public String getSubTypeName() {
        return this.mSubTypeName;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String getProxyPort() {
        return this.mPort;
    }

    public String getNetType() {
        return this.mNetType;
    }
}

