/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mobstat;

import android.content.Context;
import com.baidu.mobstat.ExceptionAnalysis;
import java.io.File;

public final class NativeCrashHandler {
    private static boolean a = false;
    private static Context b;

    private NativeCrashHandler() {
    }

    public static void doNativeCrash() {
        if (a) {
            try {
                NativeCrashHandler.nativeException();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void init(Context context) {
        File file;
        if (context == null) {
            return;
        }
        b = context;
        if (a && (file = context.getCacheDir()).exists() && file.isDirectory()) {
            try {
                NativeCrashHandler.nativeInit(file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void uninit() {
        if (a) {
            try {
                NativeCrashHandler.nativeUnint();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void process(String string) {
        File file;
        if (string == null || string.length() == 0) {
            return;
        }
        if (a && (file = new File(string)).exists() && file.isFile()) {
            try {
                NativeCrashHandler.nativeProcess(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void onCrashCallbackFromNative(String string) {
        long l2 = System.currentTimeMillis();
        ExceptionAnalysis.getInstance().saveCrashInfo(b, l2, string, "NativeException", 1, 0);
    }

    private static native void nativeInit(String var0);

    private static native void nativeUnint();

    private static native void nativeProcess(String var0);

    private static native void nativeException();

    static {
        try {
            System.loadLibrary("crash_analysis");
            a = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

