/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp;

import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class RequestEntity {
    public static final String DEFAULT_TAG = "default";
    private String mUrl;
    private String mTag;
    private String mCharset;
    private HttpMethod mMethod;
    private boolean mShouldCache;
    private boolean mNeedEncode;
    private int mTimeout;
    private int mRetries;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private Map mParams;
    private Map<String, String> mHeaders;
    public ConcurrentHashMap<String, FileWrapper> mFileParams;
    private String mContentType;
    private ByteArrayOutputStream mBody;

    public RequestEntity() {
    }

    private RequestEntity(Builder builder) {
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mCharset = builder.mCharset;
        this.mMethod = builder.mMethod;
        this.mShouldCache = builder.mShouldCache;
        this.mNeedEncode = builder.mNeedEncode;
        this.mTimeout = builder.mTimeout;
        this.mRetries = builder.mRetries;
        this.mParams = builder.mParams;
        this.mFileParams = builder.mFileParams;
        this.mContentType = builder.mContentType;
        this.mHeaders = builder.mHeaders;
        this.mBitmapWidth = builder.mBitmapWidth;
        this.mBitmapHeight = builder.mBitmapHeight;
        this.mBody = builder.out;
    }

    public /* synthetic */ RequestEntity(Builder builder, 1 var2_2) {
        this(builder);
    }

    public byte[] getBody() {
        return this.mBody.toByteArray();
    }

    public void setmTag(String string) {
        this.mTag = string;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String string) {
        this.mUrl = string;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getCharset() {
        return this.mCharset;
    }

    public HttpMethod getMethod() {
        return this.mMethod;
    }

    public boolean useCache() {
        return this.mShouldCache;
    }

    public boolean isNeedEncode() {
        return this.mNeedEncode;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public int getRetries() {
        return this.mRetries;
    }

    public Map getParams() {
        return this.mParams;
    }

    public Map getFileParams() {
        return this.mFileParams;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public int getBitmapHeight() {
        return this.mBitmapHeight;
    }

    public int getBitmapWidth() {
        return this.mBitmapWidth;
    }

    public static class FileWrapper {
        public InputStream inputStream;
        public String fileName;
        public String contentType;

        public FileWrapper(InputStream inputStream, String string, String string2) {
            this.inputStream = inputStream;
            this.fileName = string;
            this.contentType = string2;
        }

        public String getFileName() {
            String string = ((FileWrapper)((Object)string)).fileName;
            if (string != null) {
                return string;
            }
            return "";
        }
    }

    public static class Builder {
        public static final String DEFAULT_TAG = "MultipartRequestEntity";
        private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        private String mUrl;
        private String mTag;
        private String mCharset;
        private HttpMethod mMethod;
        private boolean mShouldCache;
        private boolean mNeedEncode;
        private int mTimeout;
        private int mRetries;
        private int mBitmapHeight;
        private int mBitmapWidth;
        private Map mParams;
        private ConcurrentHashMap<String, FileWrapper> mFileParams;
        private String mContentType;
        private Map<String, String> mHeaders;
        private String boundary;
        private ByteArrayOutputStream out;

        public Builder(String string) {
            Builder builder = this;
            this.boundary = null;
            this.out = new ByteArrayOutputStream();
            builder.mUrl = string;
            builder.mTag = DEFAULT_TAG;
            builder.mCharset = "UTF-8";
            builder.mMethod = HttpMethod.GET;
            builder.mShouldCache = false;
            builder.mNeedEncode = false;
            builder.mTimeout = -1;
            builder.mRetries = -1;
            builder.mBitmapHeight = 0;
            builder.mBitmapWidth = 0;
        }

        private void setBoundary() {
            Random random;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer();
            Random random2 = random;
            random = new Random();
            for (int i2 = 0; i2 < 30; ++i2) {
                stringBuffer2.append(MULTIPART_CHARS[random2.nextInt(MULTIPART_CHARS.length)]);
            }
            this.boundary = stringBuffer2.toString();
        }

        private void addMultiPart(ConcurrentHashMap<String, FileWrapper> concurrentHashMap) {
            if (concurrentHashMap != null && concurrentHashMap.size() > 0) {
                Builder builder = this;
                builder.contentType("multipart/form-data;boundary=" + this.boundary);
                try {
                    builder.out.write(("--" + this.boundary + "\r\n").getBytes());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Iterator iterator = ((HashMap)this.mParams).entrySet().iterator();
                while (iterator.hasNext()) {
                    Builder builder2 = this;
                    Map.Entry entry = iterator.next();
                    try {
                        builder2.out.write(("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"\r\n\r\n").getBytes());
                        builder2.out.write(((String)entry.getValue()).getBytes());
                        builder2.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                ConcurrentHashMap<String, FileWrapper> concurrentHashMap2 = concurrentHashMap;
                int n2 = 0;
                int n3 = concurrentHashMap2.entrySet().size() - 1;
                for (Map.Entry entry : concurrentHashMap2.entrySet()) {
                    Object object = (FileWrapper)entry.getValue();
                    boolean bl = n2 == n3;
                    if (object != null) {
                        FileWrapper fileWrapper = object;
                        String string = (String)entry.getKey();
                        object = fileWrapper.getFileName();
                        InputStream inputStream = fileWrapper.inputStream;
                        String string2 = fileWrapper.contentType;
                        this.addPart(string, (String)object, inputStream, string2, bl);
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addPart(String object, String string, InputStream inputStream, String string2, boolean bl) {
            Throwable throwable222222;
            block13: {
                int n2;
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? "Content-Type: " + string2 + "\r\n" : "Content-Type: application/octet-stream\r\n";
                Builder builder = this;
                builder.out.write(("Content-Disposition: form-data; name=\"" + (String)object + "\"; filename=\"" + string + "\"\r\n").getBytes());
                builder.out.write(string2.getBytes());
                builder.out.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes());
                object = new byte[4096];
                while ((n2 = inputStream.read((byte[])object)) != -1) {
                    this.out.write((byte[])object, 0, n2);
                }
                if (!bl) {
                    this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
                } else {
                    this.out.write(("\r\n--" + this.boundary + "--\r\n").getBytes());
                }
                InputStream inputStream2 = inputStream;
                this.out.flush();
                inputStream2.close();
                return;
                {
                    catch (Throwable throwable222222) {
                        break block13;
                    }
                    catch (IOException iOException) {}
                    {
                        iOException.printStackTrace();
                    }
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return;
            }
            try {
                inputStream.close();
                throw throwable222222;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable222222;
        }

        public Builder tag(String string) {
            this.mTag = string;
            return this;
        }

        public Builder charSet(String string) {
            this.mCharset = string;
            return this;
        }

        public Builder method(HttpMethod httpMethod) {
            this.mMethod = httpMethod;
            return this;
        }

        public Builder shouldCache(boolean bl) {
            this.mShouldCache = bl;
            return this;
        }

        public Builder encode(boolean bl) {
            this.mNeedEncode = bl;
            return this;
        }

        public Builder timeout(int n2) {
            this.mTimeout = n2;
            return this;
        }

        public Builder retries(int n2) {
            this.mRetries = n2;
            return this;
        }

        public Builder params(Map map) {
            this.mParams = map;
            return this;
        }

        public Builder fileParams(ConcurrentHashMap<String, FileWrapper> concurrentHashMap) {
            this.setBoundary();
            if (concurrentHashMap != null && concurrentHashMap.size() > 0) {
                ConcurrentHashMap<String, FileWrapper> concurrentHashMap2;
                ConcurrentHashMap<String, FileWrapper> concurrentHashMap3;
                Builder builder = this;
                ConcurrentHashMap<String, FileWrapper> concurrentHashMap4 = concurrentHashMap3 = concurrentHashMap2;
                concurrentHashMap4();
                this.mFileParams = concurrentHashMap4;
                concurrentHashMap2.putAll(concurrentHashMap);
                builder.addMultiPart(builder.mFileParams);
            }
            return this;
        }

        public Builder contentType(String string) {
            this.mContentType = string;
            return this;
        }

        public Builder headers(Map<String, String> map) {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap2();
            this.mHeaders = hashMap2;
            hashMap.putAll(map);
            return this;
        }

        public Builder bitmapHeight(int n2) {
            this.mBitmapHeight = n2;
            return this;
        }

        public Builder bitmapWidth(int n2) {
            this.mBitmapWidth = n2;
            return this;
        }

        public RequestEntity build() {
            return new RequestEntity(this, null);
        }
    }

    public static final class HttpMethod
    extends Enum<HttpMethod> {
        public static final /* enum */ HttpMethod GET;
        public static final /* enum */ HttpMethod POST;
        public static final /* enum */ HttpMethod DELETE;
        private static final /* synthetic */ HttpMethod[] $VALUES;

        public static HttpMethod[] values() {
            return (HttpMethod[])$VALUES.clone();
        }

        public static HttpMethod valueOf(String string) {
            return Enum.valueOf(HttpMethod.class, string);
        }

        static {
            HttpMethod httpMethod;
            HttpMethod httpMethod2;
            HttpMethod httpMethod3;
            HttpMethod httpMethod4 = httpMethod3;
            GET = new HttpMethod();
            HttpMethod httpMethod5 = httpMethod2;
            POST = new HttpMethod();
            HttpMethod httpMethod6 = httpMethod;
            DELETE = new HttpMethod();
            $VALUES = new HttpMethod[]{httpMethod4, httpMethod5, httpMethod6};
        }
    }
}

