/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp.log;

import android.annotation.SuppressLint;
import android.util.Log;
import com.baidu.naviapi.okhttp.log.SDKDebugFileUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public class BNLogUtil {
    private static final String TAG = "BNLogUtil";
    private static String logPath;
    private static boolean debug = false;
    private static boolean writable = false;

    public static void setLogable(boolean bl) {
        debug = bl;
    }

    public static void printStack(String string) {
        if (writable && debug) {
            AtomicReference<StringBuffer> atomicReference;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            AtomicReference<StringBuffer> atomicReference2 = atomicReference;
            new AtomicReference<StringBuffer>(new StringBuffer()).get().append(string);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                atomicReference2.get().append(stackTraceElement.toString());
            }
            BNLogUtil.logE(TAG, atomicReference2.get().toString());
        }
    }

    public static void logI(String string) {
        if (!debug) {
            return;
        }
        Log.i((String)TAG, (String)string);
        if (writable) {
            BNLogUtil.saveLog("i BNLogUtil", string);
        }
    }

    public static void logI(String string, String string2) {
        if (!debug) {
            return;
        }
        Log.i((String)string, (String)string2);
        if (writable) {
            BNLogUtil.saveLog("i " + string, string2);
        }
    }

    public static void logE(String string, Throwable throwable) {
        if (!debug) {
            return;
        }
        Log.e((String)TAG, (String)string, (Throwable)throwable);
        if (writable) {
            if (throwable != null) {
                BNLogUtil.saveLog("e BNLogUtil", string + throwable);
            } else {
                BNLogUtil.saveLog("e BNLogUtil", string);
            }
        }
    }

    public static void logE(String string, String string2) {
        if (!debug) {
            return;
        }
        Log.e((String)TAG, (String)string);
        if (writable) {
            if (string2 != null) {
                BNLogUtil.saveLog("e BNLogUtil", string + " " + string2);
            } else {
                BNLogUtil.saveLog("e BNLogUtil", string);
            }
        }
    }

    public static void logE(String string, String string2, Throwable throwable) {
        if (!debug) {
            return;
        }
        Log.e((String)string, (String)string2, (Throwable)throwable);
        if (writable) {
            if (throwable != null) {
                BNLogUtil.saveLog("e " + string, string2 + throwable);
            } else {
                BNLogUtil.saveLog("e " + string, string2);
            }
        }
    }

    public static void setLogPath(String string) {
        logPath = string + "/bnalog";
    }

    public static void setWritable(boolean bl) {
        writable = bl;
    }

    private static void saveLog(String string, String string2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        long l2 = Thread.currentThread().getId();
        new StringBuilder().append(BNLogUtil.getDateStr("yyyy-MM-dd HH:mm:ss.SSS")).append(" ").append(l2).append(" ").append(string).append(" ").append(string2);
        SDKDebugFileUtil.get(logPath, BNLogUtil.getDateStr("yyyy-MM-dd-HH"), false, false).asyncAdd(stringBuilder2.toString());
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static String getDateStr(String string) {
        return new SimpleDateFormat(string).format(new Date(System.currentTimeMillis()));
    }

    public static boolean isWritable() {
        return writable;
    }
}

