/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp.log;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DebugFileHandlerThread {
    public static final int MSG_DEBUG_FILE_ADD = 300;
    public static final int MSG_NAVI_DEBUG_FILE_ADD = 303;
    public static final int MSG_CORE_FILE_ADD = 304;
    public static final int MSG_CORE_FILE_CHECK = 305;
    public static final int MSG_DEL_ALL_LOG_FILES = 306;
    public static final String DEFAULT_NAME = "DebugFileHandlerThread";
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private List<Callback> mCallbacks;

    public DebugFileHandlerThread(String string) {
        ArrayList arrayList;
        DebugFileHandlerThread debugFileHandlerThread = arrayList2;
        debugFileHandlerThread.mHandlerThread = null;
        debugFileHandlerThread.mHandler = null;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        debugFileHandlerThread.mCallbacks = arrayList2;
        debugFileHandlerThread.init(string);
    }

    private void init(String string) {
        if (this.mHandlerThread != null) {
            return;
        }
        this.mHandlerThread = new HandlerThread(string);
        this.mHandlerThread.start();
        DebugFileHandlerThread debugFileHandlerThread = this;
        this.mHandler = new Handler(debugFileHandlerThread.mHandlerThread.getLooper()){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            public void handleMessage(Message message) {
                int n2;
                try {
                    n2 = DebugFileHandlerThread.this.mCallbacks.size() - 1;
                }
                catch (Exception exception) {}
                while (n2 >= 0) {
                    if (n2 >= DebugFileHandlerThread.this.mCallbacks.size()) return;
                    if (DebugFileHandlerThread.this.mCallbacks.get(n2) == null) return;
                    Callback callback = (Callback)DebugFileHandlerThread.this.mCallbacks.get(n2);
                    if (callback.isCareAbout(message.what)) {
                        callback.execute(message);
                    }
                    --n2;
                }
                return;
            }
        };
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public Looper getLooper() {
        DebugFileHandlerThread debugFileHandlerThread = debugFileHandlerThread.mHandlerThread;
        if (debugFileHandlerThread == null) {
            return null;
        }
        return debugFileHandlerThread.getLooper();
    }

    public void removeMessage(int n2) {
        Handler handler = this.mHandler;
        if (handler != null && handler.hasMessages(n2)) {
            this.mHandler.removeMessages(n2);
        }
    }

    public boolean sendMessage(int n2) {
        return this.sendMessage(n2, 0, 0, null, 0L);
    }

    public boolean sendMessage(int n2, int n3, int n4, Object object, long l2) {
        Handler handler = this.mHandler;
        if (handler == null) {
            return false;
        }
        Message message = handler.obtainMessage(n2);
        handler.obtainMessage(n2).arg1 = n3;
        handler.obtainMessage(n2).arg2 = n4;
        if (object != null) {
            message.obj = object;
        }
        if (l2 <= 0L) {
            this.mHandler.sendMessage(message);
        } else {
            this.mHandler.sendMessageDelayed(message, l2);
        }
        return true;
    }

    public void registerCallback(Callback callback) {
        if (callback != null && !this.mCallbacks.contains(callback)) {
            callback.careAbouts();
            this.mCallbacks.add(callback);
        }
    }

    public void unregisterCallback(Callback callback) {
        if (callback != null && this.mCallbacks.contains(callback)) {
            this.mCallbacks.remove(callback);
        }
    }

    public static abstract class Callback {
        private Set<Integer> mCareMsgs;

        public Callback() {
            HashSet hashSet;
            HashSet hashSet2 = hashSet;
            hashSet = new HashSet();
            v1.mCareMsgs = hashSet2;
        }

        public abstract void careAbouts();

        public abstract void execute(Message var1);

        public final void careAbout(int n2) {
            this.mCareMsgs.add(n2);
        }

        public final boolean isCareAbout(int n2) {
            return this.mCareMsgs.contains(n2);
        }

        public String getName() {
            return "default";
        }
    }
}

