/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp.log;

import android.annotation.SuppressLint;
import android.util.Log;
import com.baidu.naviapi.okhttp.log.SDKDebugFileUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public class BNLogUtil {
    private static final String TAG = "BNLogUtil";
    private static String logPath;
    private static boolean debug = false;
    private static boolean writable = false;

    public static void setLogable(boolean b2) {
        debug = b2;
    }

    public static void printStack(String msg) {
        if (writable && debug) {
            String string;
            AtomicReference<StringBuffer> atomicReference;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            AtomicReference<StringBuffer> atomicReference2 = atomicReference;
            new AtomicReference<StringBuffer>(new StringBuffer()).get().append(string);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                atomicReference2.get().append(stackTraceElement.toString());
            }
            BNLogUtil.logE(TAG, atomicReference2.get().toString());
        }
    }

    public static void logI(String msg) {
        String string;
        if (!debug) {
            return;
        }
        Log.i((String)TAG, (String)string);
        if (writable) {
            BNLogUtil.saveLog("i BNLogUtil", string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void logI(String tag, String msg) {
        void var1_1;
        String string;
        if (!debug) {
            return;
        }
        Log.i((String)string, (String)var1_1);
        if (writable) {
            BNLogUtil.saveLog("i " + string, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void logE(String s, Throwable e2) {
        void var1_1;
        String string;
        if (!debug) {
            return;
        }
        Log.e((String)TAG, (String)string, (Throwable)var1_1);
        if (writable) {
            if (var1_1 != null) {
                BNLogUtil.saveLog("e BNLogUtil", string + var1_1);
            } else {
                BNLogUtil.saveLog("e BNLogUtil", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void logE(String s, String e2) {
        String string;
        if (!debug) {
            return;
        }
        Log.e((String)TAG, (String)string);
        if (writable) {
            void var1_1;
            if (var1_1 != null) {
                BNLogUtil.saveLog("e BNLogUtil", string + " " + (String)var1_1);
            } else {
                BNLogUtil.saveLog("e BNLogUtil", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void logE(String tag, String s, Throwable e2) {
        void var2_2;
        void var1_1;
        String string;
        if (!debug) {
            return;
        }
        Log.e((String)string, (String)var1_1, (Throwable)var2_2);
        if (writable) {
            if (var2_2 != null) {
                BNLogUtil.saveLog("e " + string, (String)var1_1 + var2_2);
            } else {
                BNLogUtil.saveLog("e " + string, (String)var1_1);
            }
        }
    }

    public static void setLogPath(String rootPath) {
        String string;
        logPath = string + "/bnalog";
    }

    public static void setWritable(boolean enable) {
        writable = enable;
    }

    /*
     * WARNING - void declaration
     */
    private static void saveLog(String tag, String msg) {
        void var1_1;
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        long l = Thread.currentThread().getId();
        new StringBuilder().append(BNLogUtil.getDateStr("yyyy-MM-dd HH:mm:ss.SSS")).append(" ").append(l).append(" ").append(string).append(" ").append((String)var1_1);
        SDKDebugFileUtil.get(logPath, BNLogUtil.getDateStr("yyyy-MM-dd-HH"), false, false).asyncAdd(stringBuilder2.toString());
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static String getDateStr(String patten) {
        String string;
        return new SimpleDateFormat(string).format(new Date(System.currentTimeMillis()));
    }

    public static boolean isWritable() {
        return writable;
    }
}

