/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TaskExecutor {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    private TaskExecutor() {
        throw new UnsupportedOperationException();
    }

    public static void ui(Runnable task) {
        Runnable runnable;
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    /*
     * WARNING - void declaration
     */
    public static void ui(Runnable task, long delayMillis) {
        void var1_1;
        Runnable runnable;
        new Handler(Looper.getMainLooper()).postDelayed(runnable, (long)var1_1);
    }

    public static void ensureUI(Runnable task) {
        Runnable runnable;
        if (task == null) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            TaskExecutor.ui(runnable);
        }
    }

    public static void io(Runnable task) {
        Runnable runnable;
        Pool.IO.execute(runnable);
    }

    public static <T> Future<T> io(Callable<T> task) {
        Callable<T> callable;
        return Pool.IO.submit(callable);
    }

    public static void cpu(Runnable task) {
        Runnable runnable;
        Pool.CPU.execute(runnable);
    }

    public static void single(Runnable task) {
        Runnable runnable;
        Pool.SINGLE.execute(runnable);
    }

    /*
     * WARNING - void declaration
     */
    public static void schedule(Runnable task, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable = object;
        object = TimeUnit.MILLISECONDS;
        Pool.SCHEDULED.schedule(runnable, (long)var1_1, (TimeUnit)((Object)object));
    }

    public static final class Pool {
        private static final ExecutorService IO;
        private static final ExecutorService CPU;
        private static final ExecutorService SINGLE;
        private static final ScheduledExecutorService SCHEDULED;

        private Pool() {
        }

        static {
            NamedThreadFactory namedThreadFactory;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue;
            NamedThreadFactory namedThreadFactory2;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue2;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            LinkedBlockingQueue<Runnable> linkedBlockingQueue3 = linkedBlockingQueue2;
            linkedBlockingQueue2 = new LinkedBlockingQueue<Runnable>();
            NamedThreadFactory namedThreadFactory3 = namedThreadFactory2;
            namedThreadFactory2 = new NamedThreadFactory("ex-io-pool");
            IO = new ThreadPoolExecutor(CPU_COUNT, CPU_COUNT * 2 + 1, 5L, timeUnit, linkedBlockingQueue3, namedThreadFactory3);
            linkedBlockingQueue3 = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(128);
            namedThreadFactory3 = namedThreadFactory;
            namedThreadFactory = new NamedThreadFactory("ex-cpu-pool");
            CPU = new ThreadPoolExecutor(CPU_COUNT, CPU_COUNT + 1, 5L, timeUnit, linkedBlockingQueue3, namedThreadFactory3);
            SINGLE = Executors.newSingleThreadExecutor(new NamedThreadFactory("ex-single-pool"));
            SCHEDULED = new ScheduledThreadPoolExecutor(CPU_COUNT, new NamedThreadFactory("ex-scheduled-pool"));
        }

        public static class NamedThreadFactory
        implements ThreadFactory {
            private final String name;
            private final AtomicInteger mCount;

            /*
             * WARNING - void declaration
             */
            public NamedThreadFactory(String name) {
                void var1_1;
                AtomicInteger atomicInteger;
                AtomicInteger this_ = atomicInteger;
                atomicInteger = new AtomicInteger(1);
                v1.mCount = this_;
                v1.name = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable runnable) {
                void var1_1;
                return new Thread((Runnable)var1_1, this.name + "#" + this.mCount.getAndIncrement());
            }
        }
    }
}

