/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.naviapi.okhttp;

import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class RequestEntity {
    public static final String DEFAULT_TAG = "default";
    private String mUrl;
    private String mTag;
    private String mCharset;
    private HttpMethod mMethod;
    private boolean mShouldCache;
    private boolean mNeedEncode;
    private int mTimeout;
    private int mRetries;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private Map mParams;
    private Map<String, String> mHeaders;
    public ConcurrentHashMap<String, FileWrapper> mFileParams;
    private String mContentType;
    private ByteArrayOutputStream mBody;

    public RequestEntity() {
    }

    /*
     * WARNING - void declaration
     */
    private RequestEntity(Builder builder) {
        void var1_1;
        this.mUrl = ((Builder)var1_1).mUrl;
        this.mTag = ((Builder)var1_1).mTag;
        this.mCharset = ((Builder)var1_1).mCharset;
        this.mMethod = ((Builder)var1_1).mMethod;
        this.mShouldCache = ((Builder)var1_1).mShouldCache;
        this.mNeedEncode = ((Builder)var1_1).mNeedEncode;
        this.mTimeout = ((Builder)var1_1).mTimeout;
        this.mRetries = ((Builder)var1_1).mRetries;
        this.mParams = ((Builder)var1_1).mParams;
        this.mFileParams = ((Builder)var1_1).mFileParams;
        this.mContentType = ((Builder)var1_1).mContentType;
        this.mHeaders = ((Builder)var1_1).mHeaders;
        this.mBitmapWidth = ((Builder)var1_1).mBitmapWidth;
        this.mBitmapHeight = ((Builder)var1_1).mBitmapHeight;
        this.mBody = ((Builder)var1_1).out;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ RequestEntity(Builder x0, 1 x1) {
        this((Builder)var1_1);
        void var1_1;
    }

    public byte[] getBody() {
        return this.mBody.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public void setmTag(String mTag) {
        void var1_1;
        this.mTag = var1_1;
    }

    public String getUrl() {
        return this.mUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void setUrl(String url) {
        void var1_1;
        this.mUrl = var1_1;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getCharset() {
        return this.mCharset;
    }

    public HttpMethod getMethod() {
        return this.mMethod;
    }

    public boolean useCache() {
        return this.mShouldCache;
    }

    public boolean isNeedEncode() {
        return this.mNeedEncode;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public int getRetries() {
        return this.mRetries;
    }

    public Map getParams() {
        return this.mParams;
    }

    public Map getFileParams() {
        return this.mFileParams;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public int getBitmapHeight() {
        return this.mBitmapHeight;
    }

    public int getBitmapWidth() {
        return this.mBitmapWidth;
    }

    public static class FileWrapper {
        public InputStream inputStream;
        public String fileName;
        public String contentType;

        /*
         * WARNING - void declaration
         */
        public FileWrapper(InputStream inputStream, String fileName, String contentType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.inputStream = var1_1;
            this.fileName = var2_2;
            this.contentType = var3_3;
        }

        public String getFileName() {
            String this_ = ((FileWrapper)((Object)this_)).fileName;
            if (this_ != null) {
                return this_;
            }
            return "";
        }
    }

    public static class Builder {
        public static final String DEFAULT_TAG = "MultipartRequestEntity";
        private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        private String mUrl;
        private String mTag;
        private String mCharset;
        private HttpMethod mMethod;
        private boolean mShouldCache;
        private boolean mNeedEncode;
        private int mTimeout;
        private int mRetries;
        private int mBitmapHeight;
        private int mBitmapWidth;
        private Map mParams;
        private ConcurrentHashMap<String, FileWrapper> mFileParams;
        private String mContentType;
        private Map<String, String> mHeaders;
        private String boundary;
        private ByteArrayOutputStream out;

        /*
         * WARNING - void declaration
         */
        public Builder(String url) {
            void var1_1;
            Builder builder = this;
            this.boundary = null;
            this.out = new ByteArrayOutputStream();
            builder.mUrl = var1_1;
            builder.mTag = DEFAULT_TAG;
            builder.mCharset = "UTF-8";
            builder.mMethod = HttpMethod.GET;
            builder.mShouldCache = false;
            builder.mNeedEncode = false;
            builder.mTimeout = -1;
            builder.mRetries = -1;
            builder.mBitmapHeight = 0;
            builder.mBitmapWidth = 0;
        }

        private void setBoundary() {
            Random random;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer();
            Random random2 = random;
            random = new Random();
            for (int k = 0; k < 30; ++k) {
                stringBuffer2.append(MULTIPART_CHARS[random2.nextInt(MULTIPART_CHARS.length)]);
            }
            this.boundary = stringBuffer2.toString();
        }

        /*
         * WARNING - void declaration
         */
        private void addMultiPart(ConcurrentHashMap<String, FileWrapper> fileParams) {
            void var1_1;
            if (fileParams != null && var1_1.size() > 0) {
                Builder builder = this;
                builder.contentType("multipart/form-data;boundary=" + this.boundary);
                try {
                    builder.out.write(("--" + this.boundary + "\r\n").getBytes());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Iterator iterator = ((HashMap)this.mParams).entrySet().iterator();
                while (iterator.hasNext()) {
                    Builder builder2 = this;
                    Map.Entry entry = iterator.next();
                    try {
                        builder2.out.write(("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"\r\n\r\n").getBytes());
                        builder2.out.write(((String)entry.getValue()).getBytes());
                        builder2.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                void v4 = var1_1;
                int n = 0;
                int n2 = v4.entrySet().size() - 1;
                for (Map.Entry entry : v4.entrySet()) {
                    Object object = (FileWrapper)entry.getValue();
                    boolean bl = n == n2;
                    if (object != null) {
                        FileWrapper fileWrapper = object;
                        String string = (String)entry.getKey();
                        object = fileWrapper.getFileName();
                        InputStream inputStream = fileWrapper.inputStream;
                        String string2 = fileWrapper.contentType;
                        this.addPart(string, (String)object, inputStream, string2, bl);
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addPart(String key, String fileName, InputStream fin, String type, boolean isLast) {
            Throwable throwable222222;
            void var3_5;
            block13: {
                void var5_7;
                int n;
                void var2_3;
                byte[] byArray;
                String string;
                string = !TextUtils.isEmpty((CharSequence)type) ? "Content-Type: " + string + "\r\n" : "Content-Type: application/octet-stream\r\n";
                Builder builder = this;
                builder.out.write(("Content-Disposition: form-data; name=\"" + (String)byArray + "\"; filename=\"" + (String)var2_3 + "\"\r\n").getBytes());
                builder.out.write(string.getBytes());
                builder.out.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes());
                byArray = new byte[4096];
                while ((n = var3_5.read(byArray)) != -1) {
                    this.out.write(byArray, 0, n);
                }
                if (var5_7 == false) {
                    this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
                } else {
                    this.out.write(("\r\n--" + this.boundary + "--\r\n").getBytes());
                }
                void v1 = var3_5;
                this.out.flush();
                v1.close();
                return;
                {
                    catch (Throwable throwable222222) {
                        break block13;
                    }
                    catch (IOException iOException) {}
                    {
                        iOException.printStackTrace();
                    }
                    try {
                        var3_5.close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return;
            }
            try {
                var3_5.close();
                throw throwable222222;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable222222;
        }

        /*
         * WARNING - void declaration
         */
        public Builder tag(String tag) {
            void var1_1;
            this.mTag = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder charSet(String charset) {
            void var1_1;
            this.mCharset = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder method(HttpMethod method) {
            void var1_1;
            this.mMethod = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder shouldCache(boolean souldCache) {
            void var1_1;
            this.mShouldCache = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder encode(boolean encode) {
            void var1_1;
            this.mNeedEncode = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder timeout(int timeout) {
            void var1_1;
            this.mTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder retries(int retries) {
            void var1_1;
            this.mRetries = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder params(Map params) {
            void var1_1;
            this.mParams = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileParams(ConcurrentHashMap<String, FileWrapper> fileParams) {
            void var1_1;
            this.setBoundary();
            if (fileParams != null && var1_1.size() > 0) {
                ConcurrentHashMap concurrentHashMap;
                ConcurrentHashMap concurrentHashMap2;
                Builder builder = this;
                ConcurrentHashMap concurrentHashMap3 = concurrentHashMap2 = concurrentHashMap;
                concurrentHashMap3();
                this.mFileParams = concurrentHashMap3;
                concurrentHashMap.putAll(var1_1);
                builder.addMultiPart(builder.mFileParams);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder contentType(String contentType) {
            void var1_1;
            this.mContentType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder headers(Map<String, String> headers) {
            void var1_1;
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap2();
            this.mHeaders = hashMap2;
            hashMap.putAll((Map<String, String>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder bitmapHeight(int height) {
            void var1_1;
            this.mBitmapHeight = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder bitmapWidth(int width) {
            void var1_1;
            this.mBitmapWidth = var1_1;
            return this;
        }

        public RequestEntity build() {
            return new RequestEntity(this, null);
        }
    }

    public static final class HttpMethod
    extends Enum<HttpMethod> {
        public static final /* enum */ HttpMethod GET;
        public static final /* enum */ HttpMethod POST;
        public static final /* enum */ HttpMethod DELETE;
        private static final /* synthetic */ HttpMethod[] $VALUES;

        public static HttpMethod[] values() {
            return (HttpMethod[])$VALUES.clone();
        }

        public static HttpMethod valueOf(String name) {
            String string;
            return Enum.valueOf(HttpMethod.class, string);
        }

        static {
            HttpMethod httpMethod;
            HttpMethod httpMethod2;
            HttpMethod httpMethod3;
            HttpMethod httpMethod4 = httpMethod3;
            GET = new HttpMethod();
            HttpMethod httpMethod5 = httpMethod2;
            POST = new HttpMethod();
            HttpMethod httpMethod6 = httpMethod;
            DELETE = new HttpMethod();
            $VALUES = new HttpMethod[]{httpMethod4, httpMethod5, httpMethod6};
        }
    }
}

