/*
 * Decompiled with CFR 0.152.
 */
package com.fuxi.javaagent.contentobjects.jnotify;

import com.fuxi.javaagent.contentobjects.jnotify.IJNotify;
import com.fuxi.javaagent.contentobjects.jnotify.JNotifyException;
import com.fuxi.javaagent.contentobjects.jnotify.JNotifyListener;
import com.fuxi.javaagent.contentobjects.jnotify.LibraryLoader;
import com.fuxi.javaagent.contentobjects.jnotify.Observer;
import com.fuxi.javaagent.contentobjects.jnotify.linux.JNotify_linux;
import com.fuxi.javaagent.contentobjects.jnotify.macosx.JNotify_macosx;
import com.fuxi.javaagent.contentobjects.jnotify.win32.JNotify_win32;

public class JNotify {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_RENAMED = 8;
    public static final int FILE_ANY = 15;
    private static IJNotify _instance;
    private static boolean nativeLibraryLoaded;
    private static Object lock;
    private static Error nativeLoadError;
    private static Exception nativeLoadException;

    public static void init(String releasePath, Observer observer) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.equals("linux")) {
            try {
                String libFullName = System.getProperty("os.arch").contains("64") ? "libjnotify_64bit.so" : "libjnotify_32bit.so";
                JNotify.load(releasePath, libFullName);
                _instance = (IJNotify)Class.forName("com.fuxi.javaagent.contentobjects.jnotify.linux.JNotifyAdapterLinux").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            JNotify_linux.registerObserver(observer);
        } else if (osName.startsWith("windows")) {
            try {
                String libFullName = System.getProperty("os.arch").contains("64") ? "jnotify_64bit.dll" : "jnotify.dll";
                JNotify.load(releasePath, libFullName);
                _instance = (IJNotify)Class.forName("com.fuxi.javaagent.contentobjects.jnotify.win32.JNotifyAdapterWin32").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            JNotify_win32.registerObserver(observer);
        } else if (osName.startsWith("mac os x")) {
            try {
                JNotify.load(releasePath, "libjnotify.dylib");
                _instance = (IJNotify)Class.forName("com.fuxi.javaagent.contentobjects.jnotify.macosx.JNotifyAdapterMacOSX").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            JNotify_macosx.registerObserver(observer);
        } else {
            throw new RuntimeException("Unsupported OS : " + osName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void load(String tmpDirectory, String libFullName) {
        if (!nativeLibraryLoaded) {
            Object object = lock;
            synchronized (object) {
                if (!nativeLibraryLoaded) {
                    try {
                        LibraryLoader.loadLibrary(tmpDirectory, libFullName);
                        nativeLibraryLoaded = true;
                        JNotify.checkNativeLibraryLoaded();
                    }
                    catch (Error e) {
                        nativeLoadError = e;
                    }
                    catch (Exception e) {
                        nativeLoadException = e;
                    }
                }
            }
        }
    }

    private static void checkNativeLibraryLoaded() {
        if (!nativeLibraryLoaded) {
            if (nativeLoadError != null) {
                throw new IllegalStateException("Jnotify native library not loaded", nativeLoadError);
            }
            if (nativeLoadException != null) {
                throw new IllegalStateException("Jnotify native library not loaded", nativeLoadException);
            }
            throw new IllegalStateException("Jnotify native library not loaded");
        }
    }

    public static int addWatch(String path, int mask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        return _instance.addWatch(path, mask, watchSubtree, listener);
    }

    public static boolean removeWatch(int watchId) throws JNotifyException {
        return _instance.removeWatch(watchId);
    }

    static {
        lock = new Object();
        nativeLoadError = null;
        nativeLoadException = null;
    }
}

