/*
 * Decompiled with CFR 0.152.
 */
package com.fuxi.javaagent.contentobjects.jnotify;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class LibraryLoader {
    static final String SEPARATOR;
    static final String DELIMITER;

    LibraryLoader() {
    }

    static void loadLibrary(String tempDirectory, String libFullName) {
        StringBuffer message = new StringBuffer();
        String path = null;
        path = tempDirectory != null ? tempDirectory : System.getProperty("user.home");
        if (LibraryLoader.extract(path + SEPARATOR + libFullName, libFullName, message)) {
            return;
        }
        throw new UnsatisfiedLinkError("Could not load Jnotify library. Reasons: " + message.toString());
    }

    static boolean load(String libName, StringBuffer message) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (message.length() == 0) {
                message.append(DELIMITER);
            }
            message.append('\t');
            message.append(e.getMessage());
            message.append(DELIMITER);
            e.printStackTrace();
            return false;
        }
    }

    static boolean extract(String fileName, String mappedName, StringBuffer message) {
        FileOutputStream os = null;
        InputStream is = null;
        File file = new File(fileName);
        boolean extracted = false;
        try {
            if (file.exists()) {
                file.delete();
            }
            if ((is = LibraryLoader.class.getResourceAsStream("/" + mappedName)) != null) {
                int read;
                extracted = true;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(fileName);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
                LibraryLoader.chmod("755", fileName);
                if (LibraryLoader.load(fileName, message)) {
                    return true;
                }
            }
        }
        catch (Throwable e) {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (extracted && file.exists()) {
                file.delete();
            }
            System.out.println("Unable to extract jnotify library (" + fileName + "):");
            System.out.println(e.getMessage());
        }
        return false;
    }

    static void chmod(String permision, String path) throws Throwable {
        if (LibraryLoader.isWindows()) {
            return;
        }
        Runtime.getRuntime().exec(new String[]{"chmod", permision, path}).waitFor();
    }

    static String getOsName() {
        return System.getProperty("os.name") + System.getProperty("java.specification.vendor");
    }

    static boolean isWindows() {
        return LibraryLoader.getOsName().startsWith("Windows");
    }

    static {
        DELIMITER = System.getProperty("line.separator");
        SEPARATOR = System.getProperty("file.separator");
    }
}

