/*
 * Decompiled with CFR 0.152.
 */
package com.fuxi.javaagent.contentobjects.jnotify.linux;

import com.fuxi.javaagent.contentobjects.jnotify.JNotifyException;
import com.fuxi.javaagent.contentobjects.jnotify.Observer;
import com.fuxi.javaagent.contentobjects.jnotify.linux.INotifyListener;
import com.fuxi.javaagent.contentobjects.jnotify.linux.JNotifyException_linux;
import java.util.ArrayList;
import java.util.List;

public class JNotify_linux {
    static final boolean DEBUG = false;
    public static boolean WARN = true;
    public static List<Observer> list = new ArrayList<Observer>();
    public static String msg;
    public static final int IN_ACCESS = 1;
    public static final int IN_MODIFY = 2;
    public static final int IN_ATTRIB = 4;
    public static final int IN_CLOSE_WRITE = 8;
    public static final int IN_CLOSE_NOWRITE = 16;
    public static final int IN_OPEN = 32;
    public static final int IN_MOVED_FROM = 64;
    public static final int IN_MOVED_TO = 128;
    public static final int IN_CREATE = 256;
    public static final int IN_DELETE = 512;
    public static final int IN_DELETE_SELF = 1024;
    public static final int IN_MOVE_SELF = 2048;
    public static final int IN_UNMOUNT = 8192;
    public static final int IN_Q_OVERFLOW = 16384;
    public static final int IN_IGNORED = 32768;
    public static final int IN_CLOSE = 24;
    public static final int IN_MOVE = 192;
    public static final int IN_ISDIR = 0x40000000;
    public static final int IN_ONESHOT = Integer.MIN_VALUE;
    public static final int IN_ALL_EVENT = 2047;
    private static INotifyListener _notifyListener;

    private static native int nativeInit();

    private static native int nativeAddWatch(String var0, int var1);

    private static native int nativeRemoveWatch(int var0);

    private static native int nativeNotifyLoop();

    private static native String getErrorDesc(long var0);

    public static void registerObserver(Observer o) {
        list.add(o);
    }

    public static void notifyObserver() {
        for (Observer o : list) {
            o.update(msg);
        }
    }

    public static void setInfomation(String s) {
        msg = s;
        JNotify_linux.notifyObserver();
    }

    public static int addWatch(String path, int mask) throws JNotifyException {
        int wd = JNotify_linux.nativeAddWatch(path, mask);
        if (wd < 0) {
            throw new JNotifyException_linux("Error watching " + path + " : " + JNotify_linux.getErrorDesc(-wd), -wd);
        }
        JNotify_linux.debug(wd + " = JNotify_linux.addWatch(" + path + "," + JNotify_linux.getMaskDesc(mask) + ")");
        return wd;
    }

    public static void removeWatch(int wd) throws JNotifyException {
        int ret = JNotify_linux.nativeRemoveWatch(wd);
        JNotify_linux.debug(ret + " = JNotify_linux.removeWatch(" + wd + ")");
        if (ret != 0) {
            throw new JNotifyException_linux("Error removing watch " + wd, ret);
        }
    }

    private static void init() {
        Thread thread = new Thread("INotify thread"){

            @Override
            public void run() {
                try {
                    JNotify_linux.nativeNotifyLoop();
                }
                catch (Throwable e) {
                    String exception = e.getMessage();
                    JNotify_linux.setInfomation(exception);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    static void callbackProcessEvent(String name, int wd, int mask, int cookie) {
        JNotify_linux.debug("JNotify.event(name=" + name + ", wd=" + wd + ", " + JNotify_linux.getMaskDesc(mask) + (cookie != 0 ? ", cookie=" + cookie : "") + ")");
        if (_notifyListener != null) {
            _notifyListener.notify(name, wd, mask, cookie);
        }
    }

    public static void setNotifyListener(INotifyListener notifyListener) {
        if (_notifyListener != null) {
            throw new RuntimeException("Notify listener is already set. multiple notify listeners are not supported.");
        }
        _notifyListener = notifyListener;
    }

    private static String getMaskDesc(int linuxMask) {
        boolean lIN_ACCESS = (linuxMask & 1) != 0;
        boolean lIN_MODIFY = (linuxMask & 2) != 0;
        boolean lIN_ATTRIB = (linuxMask & 4) != 0;
        boolean lIN_CLOSE_WRITE = (linuxMask & 8) != 0;
        boolean lIN_CLOSE_NOWRITE = (linuxMask & 0x10) != 0;
        boolean lIN_OPEN = (linuxMask & 0x20) != 0;
        boolean lIN_MOVED_FROM = (linuxMask & 0x40) != 0;
        boolean lIN_MOVED_TO = (linuxMask & 0x80) != 0;
        boolean lIN_CREATE = (linuxMask & 0x100) != 0;
        boolean lIN_DELETE = (linuxMask & 0x200) != 0;
        boolean lIN_DELETE_SELF = (linuxMask & 0x400) != 0;
        boolean lIN_MOVE_SELF = (linuxMask & 0x800) != 0;
        boolean lIN_UNMOUNT = (linuxMask & 0x2000) != 0;
        boolean lIN_Q_OVERFLOW = (linuxMask & 0x4000) != 0;
        boolean lIN_IGNORED = (linuxMask & 0x8000) != 0;
        String s = "";
        if (lIN_ACCESS) {
            s = s + "IN_ACCESS|";
        }
        if (lIN_MODIFY) {
            s = s + "IN_MODIFY|";
        }
        if (lIN_ATTRIB) {
            s = s + "IN_ATTRIB|";
        }
        if (lIN_CLOSE_WRITE) {
            s = s + "IN_CLOSE_WRITE|";
        }
        if (lIN_CLOSE_NOWRITE) {
            s = s + "IN_CLOSE_NOWRITE|";
        }
        if (lIN_OPEN) {
            s = s + "IN_OPEN|";
        }
        if (lIN_MOVED_FROM) {
            s = s + "IN_MOVED_FROM|";
        }
        if (lIN_MOVED_TO) {
            s = s + "IN_MOVED_TO|";
        }
        if (lIN_CREATE) {
            s = s + "IN_CREATE|";
        }
        if (lIN_DELETE) {
            s = s + "IN_DELETE|";
        }
        if (lIN_DELETE_SELF) {
            s = s + "IN_DELETE_SELF|";
        }
        if (lIN_MOVE_SELF) {
            s = s + "IN_MOVE_SELF|";
        }
        if (lIN_UNMOUNT) {
            s = s + "IN_UNMOUNT|";
        }
        if (lIN_Q_OVERFLOW) {
            s = s + "IN_Q_OVERFLOW|";
        }
        if (lIN_IGNORED) {
            s = s + "IN_IGNORED|";
        }
        return s;
    }

    static void debug(String msg) {
    }

    public static void warn(String warning) {
        if (WARN) {
            System.err.println(warning);
        }
    }

    static {
        int res = JNotify_linux.nativeInit();
        if (res != 0) {
            throw new RuntimeException("Error initializing fshook_inotify library. linux error code #" + res + ", man errno for more info");
        }
        JNotify_linux.init();
    }
}

