/*
 * Decompiled with CFR 0.152.
 */
package com.fuxi.javaagent.contentobjects.jnotify.macosx;

import com.fuxi.javaagent.contentobjects.jnotify.IJNotify;
import com.fuxi.javaagent.contentobjects.jnotify.JNotifyException;
import com.fuxi.javaagent.contentobjects.jnotify.JNotifyListener;
import com.fuxi.javaagent.contentobjects.jnotify.macosx.FSEventListener;
import com.fuxi.javaagent.contentobjects.jnotify.macosx.JNotifyException_macosx;
import com.fuxi.javaagent.contentobjects.jnotify.macosx.JNotify_macosx;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class JNotifyAdapterMacOSX
implements IJNotify {
    private Hashtable<Integer, WatchData> _id2Data;

    public JNotifyAdapterMacOSX() {
        JNotify_macosx.setNotifyListener(new FSEventListener(){

            @Override
            public void notifyChange(int wd, String rootPath, String filePath, boolean recurse) {
                JNotifyAdapterMacOSX.this.notifyChangeEvent(wd, rootPath, filePath, recurse);
            }

            @Override
            public void batchStart(int wd) {
                JNotifyAdapterMacOSX.this.batchStartEvent(wd);
            }

            @Override
            public void batchEnd(int wd) {
                JNotifyAdapterMacOSX.this.batchEndEvent(wd);
            }
        });
        this._id2Data = new Hashtable();
    }

    @Override
    public int addWatch(String path, int mask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        File f;
        try {
            f = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new JNotifyException_macosx("Could not resolve canonical path for " + path);
        }
        int wd = JNotify_macosx.addWatch(f.getPath());
        this._id2Data.put(wd, new WatchData(wd, mask, listener, path, f, watchSubtree));
        return wd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int wd) throws JNotifyException {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            boolean removed;
            boolean bl = removed = this._id2Data.remove(wd) != null;
            if (removed) {
                JNotify_macosx.removeWatch(wd);
            }
            return removed;
        }
    }

    private static <T> T pollFirst(TreeSet<T> set) {
        T result = set.first();
        if (result != null) {
            set.remove(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChangeEvent(int wd, String rootPath, String filePath, boolean recurse) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            WatchData watchData = this._id2Data.get(wd);
            if (watchData != null) {
                watchData.toScan.add(new ScanJob(filePath, recurse));
            }
        }
    }

    void batchStartEvent(int wd) {
        WatchData watchData = this._id2Data.get(wd);
        if (watchData != null) {
            watchData.toScan.clear();
        }
    }

    void batchEndEvent(int wd) {
        WatchData watchData = this._id2Data.get(wd);
        if (watchData != null) {
            ScanJob job;
            JNEvents e = new JNEvents(watchData._mask);
            while ((job = watchData.toScan.poll()) != null) {
                if (!watchData.watchSubtree && !watchData.fullpath.equals(job.path)) continue;
                watchData.scan(job, e);
            }
            if (e.created != null && e.deleted != null && e.renamed != null) {
                Iterator<Map.Entry<JNFile, TreeSet<String>>> createdIt = e.created.entrySet().iterator();
                Iterator<Map.Entry<JNFile, TreeSet<String>>> iterator = e.deleted.entrySet().iterator();
                Map.Entry<JNFile, TreeSet<String>> created = null;
                if (createdIt.hasNext()) {
                    created = createdIt.next();
                }
                Map.Entry<JNFile, TreeSet<String>> deleted = null;
                if (iterator.hasNext()) {
                    deleted = iterator.next();
                }
                while (created != null && deleted != null) {
                    int compare = created.getKey().compareTo(deleted.getKey());
                    if (compare < 0) {
                        if (!createdIt.hasNext()) break;
                        created = createdIt.next();
                        continue;
                    }
                    if (compare > 0) {
                        if (!iterator.hasNext()) break;
                        deleted = iterator.next();
                        continue;
                    }
                    String newpath = JNotifyAdapterMacOSX.pollFirst(created.getValue());
                    String oldpath = JNotifyAdapterMacOSX.pollFirst(deleted.getValue());
                    e.renamed.put(oldpath, newpath);
                    if (created.getValue().size() == 0) {
                        createdIt.remove();
                        created = null;
                    }
                    if (deleted.getValue().size() == 0) {
                        iterator.remove();
                        deleted = null;
                    }
                    if (created == null) {
                        if (!createdIt.hasNext()) break;
                        created = createdIt.next();
                    }
                    if (deleted != null) continue;
                    if (!iterator.hasNext()) break;
                    deleted = iterator.next();
                }
            }
            if ((watchData._mask & 1) != 0) {
                for (TreeSet<String> treeSet : e.created.values()) {
                    for (String path : treeSet) {
                        watchData._notifyListener.fileCreated(wd, watchData.path, path.substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 2) != 0) {
                for (TreeSet<String> treeSet : e.deleted.values()) {
                    for (String path : treeSet) {
                        watchData._notifyListener.fileDeleted(wd, watchData.path, path.substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 4) != 0) {
                for (String string : e.modified) {
                    watchData._notifyListener.fileModified(wd, watchData.path, string.substring(watchData.fullpath.length()));
                }
            }
            if ((watchData._mask & 8) != 0) {
                for (Map.Entry entry : e.renamed.entrySet()) {
                    watchData._notifyListener.fileRenamed(wd, watchData.path, ((String)entry.getKey()).substring(watchData.fullpath.length()), ((String)entry.getValue()).substring(watchData.fullpath.length()));
                }
            }
        }
    }

    private static class WatchData {
        int _wd;
        int _mask;
        JNotifyListener _notifyListener;
        TreeMap<JNFile, TreeSet<String>> paths;
        TreeMap<String, JNFile> jnfiles;
        LinkedList<ScanJob> toScan;
        String path;
        String fullpath;
        boolean watchSubtree;

        WatchData(int wd, int mask, JNotifyListener listener, String path, File pathFile, boolean watchSubtree) {
            this._wd = wd;
            this._mask = mask;
            this._notifyListener = listener;
            this.path = path;
            this.fullpath = pathFile.getPath() + "/";
            this.watchSubtree = watchSubtree;
            this.paths = new TreeMap();
            this.jnfiles = new TreeMap();
            this.scan(pathFile, true, null);
            this.toScan = new LinkedList();
        }

        public String toString() {
            return "wd=" + this._wd;
        }

        private void scan(ScanJob job, JNEvents events) {
            this.scan(new File(job.path), job.recursive, events);
        }

        private static TreeMap<String, TreeMap<String, JNFile>> groupByNextComponent(File root, Map<String, JNFile> input) {
            TreeMap<String, TreeMap<String, JNFile>> grouped = new TreeMap<String, TreeMap<String, JNFile>>();
            String lastDir = null;
            TreeMap<String, JNFile> lastGroup = null;
            String rootPath = root.getAbsolutePath() + "/";
            for (Map.Entry<String, JNFile> entry : input.entrySet()) {
                if (!entry.getKey().startsWith(rootPath)) continue;
                String dir = entry.getKey().substring(rootPath.length());
                int slashIndex = dir.indexOf(47);
                if (slashIndex != -1) {
                    dir = dir.substring(0, slashIndex);
                }
                if (lastDir == null || !lastDir.equals(dir)) {
                    lastDir = dir;
                    lastGroup = grouped.get(dir);
                    if (lastGroup == null) {
                        lastGroup = new TreeMap();
                        grouped.put(dir, lastGroup);
                    }
                }
                lastGroup.put(entry.getKey(), entry.getValue());
            }
            return grouped;
        }

        private static <K, V> Map.Entry<K, V> floorEntry(TreeMap<K, V> map, K target) {
            Map.Entry<K, V> result = null;
            Comparator<K> compare = map.comparator();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (compare == null ? ((Comparable)target).compareTo(entry.getKey()) < 0 : compare.compare(target, entry.getKey()) < 0) break;
                result = entry;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private void scan(File root, boolean recursive, JNEvents events) {
            File[] files = root.listFiles();
            SortedMap<String, JNFile> existingfiles = this.jnfiles.tailMap(root.getAbsolutePath());
            TreeSet<String> stillAlive = null;
            String rootPath = root.getAbsolutePath() + "/";
            if (files != null) {
                stillAlive = new TreeSet<String>();
                for (int i = 0; i < files.length; ++i) {
                    String filePath = files[i].getAbsolutePath();
                    int slashindex = (filePath = filePath.substring(rootPath.length())).indexOf("/");
                    if (slashindex >= 0) {
                        filePath = filePath.substring(0, slashindex);
                    }
                    stillAlive.add(filePath);
                    try {
                        boolean recurse;
                        JNFile jNFile;
                        boolean isNewPath;
                        TreeSet<Object> plist;
                        JNFile jnf = new JNFile(files[i]);
                        Map.Entry<JNFile, TreeSet<String>> oldEntry = WatchData.floorEntry(this.paths, jnf);
                        if (oldEntry == null || !jnf.equals(oldEntry.getKey())) {
                            plist = new TreeSet();
                            this.paths.put(jnf, plist);
                        } else {
                            plist = oldEntry.getValue();
                            JNFile oldKey = oldEntry.getKey();
                            if (oldKey.mtime != jnf.mtime) {
                                oldKey.mtime = jnf.mtime;
                                if (events != null && events.modified != null && !files[i].isDirectory()) {
                                    for (String string : plist) {
                                        events.modified.add(string);
                                    }
                                }
                            }
                        }
                        String path = files[i].getAbsolutePath();
                        boolean bl = isNewPath = !plist.contains(path);
                        if (isNewPath) {
                            plist.add(path);
                            if (events != null && events.created != null) {
                                void var16_29;
                                TreeSet<String> treeSet = events.created.get(jnf);
                                if (treeSet == null) {
                                    TreeSet treeSet2 = new TreeSet();
                                    events.created.put(jnf, treeSet2);
                                }
                                var16_29.add(path);
                            }
                        }
                        if ((jNFile = this.jnfiles.put(path, jnf)) != null && !jnf.equals(jNFile)) {
                            TreeSet<String> oldPaths = this.paths.get(jNFile);
                            if (oldPaths != null) {
                                if (!oldPaths.remove(path)) {
                                    // empty if block
                                }
                                if (oldPaths.size() == 0) {
                                    this.paths.remove(jNFile);
                                }
                            }
                            if (events != null && events.deleted != null) {
                                TreeSet<String> eplist = events.deleted.get(jNFile);
                                if (eplist == null) {
                                    eplist = new TreeSet();
                                    events.deleted.put(jNFile, eplist);
                                }
                                eplist.add(path);
                            }
                        }
                        boolean bl2 = recurse = isNewPath || recursive;
                        if (!this.watchSubtree || !recurse || !files[i].isDirectory()) continue;
                        this.scan(files[i], recurse, events);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            TreeMap<String, TreeMap<String, JNFile>> grouped = WatchData.groupByNextComponent(root, existingfiles);
            Iterator stillAliveit = null;
            String lastAlive = null;
            if (stillAlive != null && (stillAliveit = stillAlive.iterator()).hasNext()) {
                lastAlive = (String)stillAliveit.next();
            }
            for (Map.Entry<String, TreeMap<String, JNFile>> entry : grouped.entrySet()) {
                String jnp = entry.getKey();
                if (lastAlive != null) {
                    int compare = -1;
                    while (lastAlive != null && (compare = jnp.compareTo(lastAlive)) > 0) {
                        if (stillAliveit.hasNext()) {
                            lastAlive = (String)stillAliveit.next();
                            continue;
                        }
                        lastAlive = null;
                    }
                    if (compare == 0 && lastAlive != null) continue;
                }
                for (Map.Entry<String, JNFile> jnf : entry.getValue().entrySet()) {
                    TreeSet<String> treeSet = this.paths.get(jnf.getValue());
                    if (treeSet != null) {
                        if (!treeSet.remove(jnf.getKey())) {
                            // empty if block
                        }
                        if (treeSet.size() == 0) {
                            this.paths.remove(jnf.getValue());
                        }
                    }
                    existingfiles.remove(jnf.getKey());
                    if (events == null || events.deleted == null) continue;
                    TreeSet<String> eplist = events.deleted.get(jnf.getValue());
                    if (eplist == null) {
                        eplist = new TreeSet();
                        events.deleted.put(jnf.getValue(), eplist);
                    }
                    eplist.add(jnf.getKey());
                }
            }
        }
    }

    private static class JNEvents {
        TreeMap<JNFile, TreeSet<String>> created;
        TreeSet<String> modified;
        TreeMap<JNFile, TreeSet<String>> deleted;
        TreeMap<String, String> renamed;

        JNEvents(int mask) {
            if ((mask & 4) != 0) {
                this.modified = new TreeSet();
            }
            if ((mask & 0xB) != 0) {
                this.created = new TreeMap();
                this.deleted = new TreeMap();
                this.renamed = new TreeMap();
            }
        }
    }

    private static class ScanJob {
        String path;
        boolean recursive;

        ScanJob(String path, boolean recursive) {
            this.path = path;
            this.recursive = recursive;
        }

        public String toString() {
            return this.path + " " + this.recursive;
        }
    }

    private static class JNFile
    implements Comparable<JNFile> {
        long mtime;
        int deviceid;
        long inode;

        JNFile(File f) throws IOException {
            this.mtime = f.lastModified();
            this.stat(f.getAbsolutePath());
        }

        private native void stat(String var1) throws IOException;

        @Override
        public int compareTo(JNFile o) {
            if (o.deviceid != this.deviceid) {
                return this.deviceid - o.deviceid;
            }
            if (this.inode < o.inode) {
                return -1;
            }
            if (this.inode == o.inode) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JNFile)) {
                return false;
            }
            JNFile j = (JNFile)o;
            return j.inode == this.inode && j.deviceid == this.deviceid;
        }

        public int hashCode() {
            return (this.inode + "," + this.deviceid).hashCode();
        }

        public String toString() {
            return String.format("%08x.%016x - %d", this.deviceid, this.inode, this.mtime);
        }
    }
}

