/*
 * Decompiled with CFR 0.152.
 */
package com.fuxi.javaagent.contentobjects.jnotify.win32;

import com.fuxi.javaagent.contentobjects.jnotify.JNotifyException;
import com.fuxi.javaagent.contentobjects.jnotify.Observer;
import com.fuxi.javaagent.contentobjects.jnotify.win32.IWin32NotifyListener;
import com.fuxi.javaagent.contentobjects.jnotify.win32.JNotifyException_win32;
import java.util.ArrayList;
import java.util.List;

public class JNotify_win32 {
    public static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    public static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    public static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    public static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    public static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    public static final int FILE_NOTIFY_CHANGE_LAST_ACCESS = 32;
    public static final int FILE_NOTIFY_CHANGE_CREATION = 64;
    public static final int FILE_NOTIFY_CHANGE_SECURITY = 256;
    public static final int FILE_ACTION_ADDED = 1;
    public static final int FILE_ACTION_REMOVED = 2;
    public static final int FILE_ACTION_MODIFIED = 3;
    public static final int FILE_ACTION_RENAMED_OLD_NAME = 4;
    public static final int FILE_ACTION_RENAMED_NEW_NAME = 5;
    public static List<Observer> list;
    public static String msg;
    private static IWin32NotifyListener _notifyListener;

    private static native int nativeInit();

    private static native int nativeAddWatch(String var0, long var1, boolean var3);

    private static native String getErrorDesc(long var0);

    private static native void nativeRemoveWatch(int var0);

    public static void registerObserver(Observer o) {
        list.add(o);
    }

    public static void notifyObserver() {
        for (Observer o : list) {
            o.update(msg);
        }
    }

    public static void setInfomation(int error) {
        msg = JNotify_win32.getErrorDesc(error);
        JNotify_win32.notifyObserver();
    }

    public static int addWatch(String path, long mask, boolean watchSubtree) throws JNotifyException {
        int wd = JNotify_win32.nativeAddWatch(path, mask, watchSubtree);
        if (wd < 0) {
            throw new JNotifyException_win32(JNotify_win32.getErrorDesc(-wd) + " : " + path, -wd);
        }
        return wd;
    }

    public static void removeWatch(int wd) {
        JNotify_win32.nativeRemoveWatch(wd);
    }

    public static void callbackProcessEvent(int wd, int action, String rootPath, String filePath) {
        if (_notifyListener != null) {
            _notifyListener.notifyChange(wd, action, rootPath, filePath);
        }
    }

    public static void setNotifyListener(IWin32NotifyListener notifyListener) {
        if (_notifyListener != null) {
            throw new RuntimeException("Notify listener is already set. multiple notify listeners are not supported.");
        }
        _notifyListener = notifyListener;
    }

    static {
        int res = JNotify_win32.nativeInit();
        if (res != 0) {
            throw new RuntimeException("Error initialiing native library. (#" + res + ")");
        }
        list = new ArrayList<Observer>();
    }
}

