/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper;

import com.baidu.unbiz.easymapper.ClassMapBuilder;
import com.baidu.unbiz.easymapper.Mapper;
import com.baidu.unbiz.easymapper.codegen.AtoBMapping;
import com.baidu.unbiz.easymapper.codegen.MappingCodeGenerator;
import com.baidu.unbiz.easymapper.exception.MappingException;
import com.baidu.unbiz.easymapper.metadata.ClassMap;
import com.baidu.unbiz.easymapper.metadata.MapperKey;
import com.baidu.unbiz.easymapper.metadata.TypeFactory;
import com.baidu.unbiz.easymapper.util.Computable;
import com.baidu.unbiz.easymapper.util.Memoizer;
import com.baidu.unbiz.easymapper.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyByRefMapper
implements Mapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyByRefMapper.class);
    private Memoizer<MapperKey, ClassMap<Object, Object>> classMapCache = new Memoizer();
    private Memoizer<MapperKey, AtoBMapping<Object, Object>> mapperCache = new Memoizer();
    private MappingCodeGenerator codeGenerator = new MappingCodeGenerator();

    @Override
    public void clear() {
        if (this.classMapCache != null) {
            this.classMapCache.clear();
        }
        if (this.mapperCache != null) {
            this.mapperCache.clear();
        }
    }

    @Override
    public <A, B> ClassMap<A, B> registerClassMap(MapperKey key, final ClassMapBuilder<A, B> builder) {
        try {
            ClassMap<Object, Object> classMap = this.classMapCache.compute(key, new Computable<MapperKey, ClassMap<Object, Object>>(){

                @Override
                public ClassMap<Object, Object> compute(MapperKey arg) throws Exception {
                    return builder.build();
                }
            });
            return classMap;
        }
        catch (InterruptedException e) {
            throw new MappingException("Memoizer has been interrupted", e);
        }
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> mapClass(Class<A> aType, Class<B> bType) {
        return new ClassMapBuilder<A, B>(TypeFactory.valueOf(aType), TypeFactory.valueOf(bType), this);
    }

    @Override
    public <A, B> B map(A sourceObject, Class<B> targetClass) throws MappingException {
        return this.map(sourceObject, null, targetClass);
    }

    @Override
    public <A, B> B map(A sourceObject, B targetObject) throws MappingException {
        return this.map(sourceObject, targetObject, targetObject.getClass());
    }

    private <A, B> B map(A sourceObject, B b, Class<B> targetClass) {
        try {
            MapperKey key;
            ClassMap<Object, Object> classMap;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Mapping {} to {}", TypeFactory.valueOf(sourceObject.getClass()), TypeFactory.valueOf(targetClass));
            }
            if ((classMap = this.classMapCache.get(key = new MapperKey(TypeFactory.valueOf(sourceObject.getClass()), TypeFactory.valueOf(targetClass)))) == null) {
                throw new MappingException("No class map found for " + key + ", make sure type or nested type is registered beforehand");
            }
            AtoBMapping<Object, Object> mapper = this.mapperCache.compute(key, new Computable<MapperKey, AtoBMapping<Object, Object>>(){

                @Override
                public AtoBMapping<Object, Object> compute(MapperKey arg) throws Exception {
                    return CopyByRefMapper.this.codeGenerator.build(classMap, CopyByRefMapper.this.self());
                }
            });
            if (mapper == MappingCodeGenerator.ABSENT_MAPPING) {
                this.mapperCache.remove(key);
                throw new MappingException("Generating mapping code failed for " + classMap + ", this should not " + "happen, probably the framework could not handle mapping correctly based on your bean");
            }
            if (b == null) {
                b = ReflectionUtil.newInstance(targetClass);
            }
            mapper.map(sourceObject, b);
            return b;
        }
        catch (InterruptedException e) {
            throw new MappingException("Memoizer has been interrupted", e);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    private Mapper self() {
        return this;
    }
}

