/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.codegen;

import com.baidu.unbiz.easymapper.transformer.Transformer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class SourceCodeContext {
    private static final AtomicInteger UNIQUE_CLASS_INDEX = new AtomicInteger();
    public static final char LF = '\n';
    private StringBuilder sourceBuilder = new StringBuilder();
    private String classSimpleName;
    private String packageName;
    private String className;
    private Class<?> superClass;
    private List<String> methods;
    private List<String> fields;
    private List<Transformer<Object, Object>> transformers;
    private int transformerIndices = 0;

    public SourceCodeContext(String baseClassName, Class<?> superClass) {
        String safeBaseClassName = baseClassName.replace("[]", "$Array");
        this.superClass = superClass;
        this.packageName = "com.baidu.unbiz.generated";
        this.classSimpleName = safeBaseClassName;
        this.methods = new ArrayList<String>();
        this.fields = new ArrayList<String>();
        this.classSimpleName = this.getUniqueClassName(this.classSimpleName);
        this.className = this.packageName + "." + this.classSimpleName;
        this.sourceBuilder.append("package ");
        this.sourceBuilder.append(this.packageName);
        this.sourceBuilder.append('\n');
        this.sourceBuilder.append('\n');
        this.sourceBuilder.append("public class ");
        this.sourceBuilder.append(this.classSimpleName);
        this.sourceBuilder.append(" extends GeneratedMapperBase {");
    }

    private String getUniqueClassName(String name) {
        return name + System.nanoTime() + "$" + UNIQUE_CLASS_INDEX.getAndIncrement();
    }

    public String toSourceFile() {
        return this.sourceBuilder.toString() + '\n' + "}";
    }

    public void addMethod(String methodSource) {
        this.sourceBuilder.append('\n');
        this.sourceBuilder.append(methodSource);
        this.sourceBuilder.append('\n');
        this.methods.add(methodSource);
    }

    public String getMapper() {
        return "mapper";
    }

    public Transformer<Object, Object>[] getTransformers() {
        if (this.transformers == null) {
            return null;
        }
        return this.transformers.toArray(new Transformer[0]);
    }

    public String getTransformer(Transformer<Object, Object> transformer) {
        if (this.transformers == null) {
            this.transformers = new ArrayList<Transformer<Object, Object>>(8);
        }
        this.transformers.add(transformer);
        return "(transformers[" + this.transformerIndices++ + "])";
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }
}

