/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.codegen.bytecode;

import com.baidu.unbiz.easymapper.codegen.SourceCodeContext;
import com.baidu.unbiz.easymapper.codegen.bytecode.ByteCodeManipulator;
import com.baidu.unbiz.easymapper.exception.MappingCodeGenerationException;
import com.baidu.unbiz.easymapper.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistByteCodeManipulator
implements ByteCodeManipulator {
    private static Logger LOGGER = LoggerFactory.getLogger(JavassistByteCodeManipulator.class);
    private ClassPool classPool;
    protected final boolean enableWriteSourceFile = Boolean.valueOf(SystemPropertyUtil.getSystemProperty("com.baidu.unbiz.easymapper.enableWriteSourceFile", "false"));
    protected final boolean enableWriteClassFile = Boolean.valueOf(SystemPropertyUtil.getSystemProperty("com.baidu.unbiz.easymapper.enableWriteClassFile", "false"));
    protected final String pathToWriteSourceFile = SystemPropertyUtil.getSystemProperty("com.baidu.unbiz.easymapper.writeSourceFileAbsolutePath", "classpath:/");
    protected final String pathToWriteClassFile = SystemPropertyUtil.getSystemProperty("com.baidu.unbiz.easymapper.writeClassFileAbsolutePath", "classpath:/");
    protected static final String CLASS_PATH = "classpath:/";

    public JavassistByteCodeManipulator() {
        this.classPool = new ClassPool();
        this.classPool.appendSystemPath();
        this.classPool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        LOGGER.debug("Initialize {} done, enableWriteSourceFile={}, enableWriteClassFile={}, pathToWriteSourceFile={}, pathToWriteClassFile={}", new Object[]{this.getClass().getSimpleName(), this.enableWriteSourceFile, this.enableWriteClassFile, this.pathToWriteSourceFile, this.pathToWriteClassFile});
    }

    @Override
    public Class<?> compileClass(SourceCodeContext sourceCode) throws MappingCodeGenerationException {
        Class compiledClass;
        StringBuilder className = new StringBuilder(sourceCode.getClassName());
        CtClass byteCodeClass = this.classPool.makeClass(className.toString());
        try {
            this.writeSourceFile(sourceCode);
            CtClass abstractMapperClass = this.classPool.get(sourceCode.getSuperClass().getCanonicalName());
            byteCodeClass.setSuperclass(abstractMapperClass);
            for (String fieldDef : sourceCode.getFields()) {
                try {
                    byteCodeClass.addField(CtField.make((String)fieldDef, (CtClass)byteCodeClass));
                }
                catch (CannotCompileException e) {
                    LOGGER.error("An exception occurred while compiling: " + fieldDef + " for " + sourceCode.getClassName(), (Throwable)e);
                    throw e;
                }
            }
            for (String methodDef : sourceCode.getMethods()) {
                try {
                    byteCodeClass.addMethod(CtNewMethod.make((String)methodDef, (CtClass)byteCodeClass));
                }
                catch (CannotCompileException e) {
                    LOGGER.error("An exception occurred while compiling the following method:\n\n " + methodDef + "\n\n for " + sourceCode.getClassName() + "\n", (Throwable)e);
                    throw e;
                }
            }
            compiledClass = byteCodeClass.toClass(Thread.currentThread().getContextClassLoader(), this.getClass().getProtectionDomain());
            this.writeClassFile(byteCodeClass);
        }
        catch (CannotCompileException e) {
            throw new MappingCodeGenerationException(String.format("Failed to compile class %s, reason is %s", className, e.getMessage()), e);
        }
        catch (NotFoundException e) {
            throw new MappingCodeGenerationException(String.format("Failed to compile class %s, reason is %s", className, e.getMessage()), e);
        }
        return compiledClass;
    }

    protected void writeClassFile(CtClass byteCodeClass) {
        if (byteCodeClass == null) {
            return;
        }
        if (this.enableWriteClassFile) {
            try {
                File parentDir = this.preparePackageOutputPath(this.pathToWriteClassFile, "");
                byteCodeClass.writeFile(parentDir.getAbsolutePath());
            }
            catch (CannotCompileException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write class file " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSourceFile(SourceCodeContext sourceCode) {
        if (sourceCode == null) {
            return;
        }
        if (this.enableWriteSourceFile) {
            OutputStreamWriter fw = null;
            try {
                File parentDir = this.preparePackageOutputPath(this.pathToWriteSourceFile, sourceCode.getPackageName());
                File sourceFile = new File(parentDir, sourceCode.getClassSimpleName() + ".java");
                fw = new FileWriter(sourceFile);
                fw.append(sourceCode.toSourceFile());
            }
            catch (IOException e) {
                LOGGER.error("Failed to write source file " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to close source file " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected File preparePackageOutputPath(String basePath, String packageName) throws IOException {
        String path;
        String packagePath = packageName.replaceAll("\\.", "/");
        if (basePath.startsWith(CLASS_PATH)) {
            path = this.getClass().getResource(basePath.substring(CLASS_PATH.length())).getFile().toString();
        } else {
            path = basePath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        File parentDir = new File(path + packagePath);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Could not create package directory for " + packageName);
        }
        return parentDir;
    }
}

