/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ClassUtil {
    private static final Set<Class<?>> PRIMITIVE_WRAPPER_TYPES = ClassUtil.getWrapperTypes();

    private ClassUtil() {
    }

    private static Set<Class<?>> getWrapperTypes() {
        return new HashSet(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Boolean.class, Character.class, Float.class, Double.class));
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return PRIMITIVE_WRAPPER_TYPES.contains(type);
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        if (Boolean.class.equals(wrapperType)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(wrapperType)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(wrapperType)) {
            return Character.TYPE;
        }
        if (Short.class.equals(wrapperType)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(wrapperType)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(wrapperType)) {
            return Long.TYPE;
        }
        if (Float.class.equals(wrapperType)) {
            return Float.TYPE;
        }
        if (Double.class.equals(wrapperType)) {
            return Double.TYPE;
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return false;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return (byte)0;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.valueOf('\u0000');
        }
        if (Short.TYPE.equals(primitiveType)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return 0;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return 0L;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(primitiveType)) {
            return 0.0;
        }
        return null;
    }
}

