/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.util;

import com.baidu.unbiz.easymapper.util.Computable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memoizer<K, V> {
    private static Logger LOGGER = LoggerFactory.getLogger(Memoizer.class);
    private final ConcurrentHashMap<K, Future<V>> cache = new ConcurrentHashMap();

    public V get(K arg) {
        Future<V> future = this.cache.get(arg);
        if (future != null) {
            try {
                return future.get();
            }
            catch (Exception e) {
                this.cache.remove(arg);
            }
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public V compute(final K arg, final Computable<K, V> c) throws InterruptedException {
        FutureTask futureTask;
        FutureTask future = this.cache.get(arg);
        if (future == null && (future = (FutureTask)this.cache.putIfAbsent(arg, futureTask = new FutureTask(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return c.compute(arg);
            }
        }))) == null) {
            future = futureTask;
            futureTask.run();
        }
        try {
            return future.get();
        }
        catch (Exception e) {
            LOGGER.error("Get computed result with error - " + e.getMessage(), (Throwable)e);
            this.cache.remove(arg);
            return null;
        }
    }
}

